/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.logic;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class TimestampSelector
extends Task {
    private static final String AGE_ELDEST = "eldest";
    private static final String AGE_YOUNGEST = "youngest";
    private String property;
    private Path path;
    private String outputSetId;
    private int count = 1;
    private char pathSep = (char)44;
    private String age = "youngest";

    public void doFileSetExecute(String[] paths) throws BuildException {
    }

    public void sort(Vector array) {
        this.sort(array, 0, array.size() - 1);
    }

    protected void sort(Vector array, int start, int end) {
        if (end > start) {
            int p2 = this.partition(array, start, end);
            this.sort(array, start, p2 - 1);
            this.sort(array, p2 + 1, end);
        }
    }

    protected int compare(File a2, File b2) {
        if (this.age.equalsIgnoreCase(AGE_ELDEST)) {
            return new Long(a2.lastModified()).compareTo(new Long(b2.lastModified()));
        }
        return new Long(b2.lastModified()).compareTo(new Long(a2.lastModified()));
    }

    protected int partition(Vector array, int start, int end) {
        File partitionElement = (File)array.elementAt(end);
        int left = start - 1;
        int right = end;
        while (true) {
            if (this.compare(partitionElement, (File)array.elementAt(++left)) == 1 && left != end) {
                continue;
            }
            while (this.compare(partitionElement, (File)array.elementAt(--right)) == -1 && right != start) {
            }
            if (left >= right) break;
            this.swap(array, left, right);
        }
        this.swap(array, left, end);
        return left;
    }

    protected void swap(Vector array, int i2, int j2) {
        Object temp = array.elementAt(i2);
        array.setElementAt(array.elementAt(j2), i2);
        array.setElementAt(temp, j2);
    }

    public void execute() throws BuildException {
        if (this.property == null && this.outputSetId == null) {
            throw new BuildException("Property or OutputSetId must be specified.");
        }
        if (this.path == null) {
            throw new BuildException("A path element or pathref attribute must be specified.");
        }
        String[] s2 = this.path.list();
        Vector<File> v2 = new Vector<File>();
        for (int i2 = 0; i2 < s2.length; ++i2) {
            File f2 = new File(s2[i2]);
            if (!f2.exists()) continue;
            v2.addElement(f2);
        }
        this.sort(v2);
        Vector v22 = new Vector();
        int sz = v2.size();
        for (int i3 = 0; i3 < sz && i3 < this.count; ++i3) {
            v22.add(v2.elementAt(i3));
        }
        Path path = new Path(this.getProject());
        sz = v22.size();
        for (int i4 = 0; i4 < sz; ++i4) {
            File f3 = (File)v2.elementAt(i4);
            Path p2 = new Path(this.getProject(), f3.getAbsolutePath());
            path.addExisting(p2);
        }
        if (this.outputSetId != null) {
            this.getProject().addReference(this.outputSetId, path);
        } else {
            String[] paths = path.list();
            StringBuffer sb = new StringBuffer();
            for (int i5 = 0; i5 < paths.length; ++i5) {
                if (i5 != 0) {
                    sb.append(this.pathSep);
                }
                sb.append(paths[i5]);
            }
            if (paths.length != 0) {
                this.getProject().setProperty(this.property, sb.toString());
            }
        }
    }

    public void setProperty(String property) {
        if (this.outputSetId != null) {
            throw new BuildException("Cannot set both Property and OutputSetId.");
        }
        this.property = property;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setAge(String age) {
        if (!age.equalsIgnoreCase(AGE_ELDEST) && !age.equalsIgnoreCase(AGE_YOUNGEST)) {
            throw new BuildException("Invalid age: " + age);
        }
        this.age = age;
    }

    public void setPathSep(char pathSep) {
        this.pathSep = pathSep;
    }

    public void setOutputSetId(String outputSetId) {
        if (this.property != null) {
            throw new BuildException("Cannot set both Property and OutputSetId.");
        }
        this.outputSetId = outputSetId;
    }

    public void setPathRef(Reference ref) throws BuildException {
        if (this.path != null) {
            throw new BuildException("Path element already specified.");
        }
        this.path = new Path(this.getProject());
        this.path.setRefid(ref);
    }

    public Path createPath() throws BuildException {
        if (this.path != null) {
            throw new BuildException("Path element already specified.");
        }
        this.path = new Path(this.getProject());
        return this.path;
    }
}

