/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.logic;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Sequential;

public class TryCatchTask
extends Task {
    private Sequential tryTasks = null;
    private Vector catchBlocks = new Vector();
    private Sequential finallyTasks = null;
    private String property = null;
    private String reference = null;
    static /* synthetic */ Class class$org$apache$tools$ant$BuildException;

    public void addTry(Sequential seq) throws BuildException {
        if (this.tryTasks != null) {
            throw new BuildException("You must not specify more than one <try>");
        }
        this.tryTasks = seq;
    }

    public void addCatch(CatchBlock cb2) {
        this.catchBlocks.add(cb2);
    }

    public void addFinally(Sequential seq) throws BuildException {
        if (this.finallyTasks != null) {
            throw new BuildException("You must not specify more than one <finally>");
        }
        this.finallyTasks = seq;
    }

    public void setProperty(String p2) {
        this.property = p2;
    }

    public void setReference(String r2) {
        this.reference = r2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        Throwable thrown = null;
        if (this.tryTasks == null) {
            throw new BuildException("A nested <try> element is required");
        }
        try {
            this.tryTasks.perform();
        }
        catch (Throwable e2) {
            if (this.property != null) {
                this.getProject().setProperty(this.property, e2.getMessage());
            }
            if (this.reference != null) {
                this.getProject().addReference(this.reference, e2);
            }
            boolean executed = false;
            Enumeration blocks = this.catchBlocks.elements();
            while (blocks.hasMoreElements() && !executed) {
                CatchBlock cb2 = (CatchBlock)blocks.nextElement();
                executed = cb2.execute(e2);
            }
            if (!executed) {
                thrown = e2;
            }
        }
        finally {
            if (this.finallyTasks != null) {
                this.finallyTasks.perform();
            }
        }
        if (thrown != null) {
            throw new BuildException(thrown);
        }
    }

    public static final class CatchBlock
    extends Sequential {
        private String throwable = (class$org$apache$tools$ant$BuildException == null ? (class$org$apache$tools$ant$BuildException = TryCatchTask.class$("org.apache.tools.ant.BuildException")) : class$org$apache$tools$ant$BuildException).getName();

        public void setThrowable(String throwable) {
            this.throwable = throwable;
        }

        public boolean execute(Throwable t2) throws BuildException {
            try {
                Class<?> c2 = Thread.currentThread().getContextClassLoader().loadClass(this.throwable);
                if (c2.isAssignableFrom(t2.getClass())) {
                    this.execute();
                    return true;
                }
                return false;
            }
            catch (ClassNotFoundException e2) {
                throw new BuildException(e2);
            }
        }
    }
}

