/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.math;

import net.sf.antcontrib.math.Math;
import net.sf.antcontrib.math.Operation;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicConfigurator;
import org.apache.tools.ant.Task;

public class MathTask
extends Task
implements DynamicConfigurator {
    private String result = null;
    private Operation operation = null;
    private Operation locOperation = null;
    private String datatype = null;
    private boolean strict = false;

    public void execute() throws BuildException {
        Operation op = this.locOperation;
        if (op == null) {
            op = this.operation;
        }
        Number res = op.evaluate();
        if (this.datatype != null) {
            res = Math.convert(res, this.datatype);
        }
        this.getProject().setUserProperty(this.result, res.toString());
    }

    public void setDynamicAttribute(String s2, String s1) throws BuildException {
        throw new BuildException("No dynamic attributes for this task");
    }

    public Object createDynamicElement(String name) throws BuildException {
        Operation op = new Operation();
        op.setOperation(name);
        this.operation = op;
        return op;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public void setDatatype(String datatype) {
        this.datatype = datatype;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    private Operation getLocalOperation() {
        if (this.locOperation == null) {
            this.locOperation = new Operation();
            this.locOperation.setDatatype(this.datatype);
            this.locOperation.setStrict(this.strict);
        }
        return this.locOperation;
    }

    public void setOperation(String operation) {
        this.getLocalOperation().setOperation(operation);
    }

    public void setDataType(String dataType) {
        this.getLocalOperation().setDatatype(dataType);
    }

    public void setOperand1(String operand1) {
        this.getLocalOperation().setArg1(operand1);
    }

    public void setOperand2(String operand2) {
        this.getLocalOperation().setArg2(operand2);
    }

    public Operation createOperation() {
        if (this.locOperation != null || this.operation != null) {
            throw new BuildException("Only 1 operation can be specified");
        }
        this.operation = new Operation();
        this.operation.setStrict(this.strict);
        this.operation.setDatatype(this.datatype);
        return this.operation;
    }

    public Operation createOp() {
        return this.createOperation();
    }
}

