/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.math;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import net.sf.antcontrib.math.Evaluateable;
import net.sf.antcontrib.math.Math;
import net.sf.antcontrib.math.Numeric;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicConfigurator;

public class Operation
implements Evaluateable,
DynamicConfigurator {
    private String operation = "add";
    private Vector operands = new Vector();
    private String datatype = "double";
    private boolean strict = false;
    private boolean hasLocalOperands = false;
    private Numeric[] localOperands = new Numeric[5];

    public void setDynamicAttribute(String s2, String s1) throws BuildException {
        throw new BuildException("no dynamic attributes for this element");
    }

    public Object createDynamicElement(String name) throws BuildException {
        Operation op = new Operation();
        op.setOperation(name);
        this.operands.add(op);
        return op;
    }

    private void setLocalOperand(String value, int index) {
        this.hasLocalOperands = true;
        this.localOperands[index - 1] = new Numeric();
        this.localOperands[index - 1].setValue(value);
    }

    public void setArg1(String value) {
        this.setLocalOperand(value, 1);
    }

    public void setArg2(String value) {
        this.setLocalOperand(value, 2);
    }

    public void setArg3(String value) {
        this.setLocalOperand(value, 3);
    }

    public void setArg4(String value) {
        this.setLocalOperand(value, 4);
    }

    public void setArg5(String value) {
        this.setLocalOperand(value, 5);
    }

    public void addConfiguredNumeric(Numeric numeric) {
        if (this.hasLocalOperands) {
            throw new BuildException("Cannot combine operand attributes with subelements");
        }
        this.operands.add(numeric);
    }

    public void addConfiguredOperation(Operation operation) {
        if (this.hasLocalOperands) {
            throw new BuildException("Cannot combine operand attributes with subelements");
        }
        this.operands.add(operation);
    }

    public void addConfiguredNum(Numeric numeric) {
        if (this.hasLocalOperands) {
            throw new BuildException("Cannot combine operand attributes with subelements");
        }
        this.operands.add(numeric);
    }

    public void addConfiguredOp(Operation operation) {
        if (this.hasLocalOperands) {
            throw new BuildException("Cannot combine operand attributes with subelements");
        }
        this.operands.add(operation);
    }

    public void setOp(String operation) {
        this.setOperation(operation);
    }

    public void setOperation(String operation) {
        this.operation = operation.equals("+") ? "add" : (operation.equals("-") ? "subtract" : (operation.equals("*") ? "multiply" : (operation.equals("/") ? "divide" : (operation.equals("%") ? "mod" : operation))));
    }

    public void setDatatype(String datatype) {
        this.datatype = datatype;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public Number evaluate() {
        Evaluateable[] ops = null;
        if (this.hasLocalOperands) {
            ArrayList<Numeric> localOps = new ArrayList<Numeric>();
            for (int i2 = 0; i2 < this.localOperands.length; ++i2) {
                if (this.localOperands[i2] == null) continue;
                localOps.add(this.localOperands[i2]);
            }
            ops = localOps.toArray(new Evaluateable[localOps.size()]);
        } else {
            ops = this.operands.toArray(new Evaluateable[this.operands.size()]);
        }
        return Math.evaluate(this.operation, this.datatype, this.strict, ops);
    }

    public String toString() {
        return "Operation[operation=" + this.operation + ";datatype=" + this.datatype + ";strict=" + this.strict + ";localoperands=" + Arrays.asList(this.localOperands) + ";operands=" + this.operands + "]";
    }
}

