/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.net;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import net.sf.antcontrib.net.Prop;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;

public class PostTask
extends Task {
    private Hashtable props = new Hashtable();
    private URL to = null;
    private File propsFile = null;
    private String textProps = null;
    private String encoding = "UTF-8";
    private File log = null;
    private boolean append = true;
    private boolean verbose = true;
    private boolean wantResponse = true;
    private String property = null;
    private long maxwait = 180000L;
    private boolean failOnError = false;
    private static Hashtable cookieStorage = new Hashtable();
    private URLConnection connection = null;
    private Thread currentRunner = null;

    public void setTo(URL name) {
        this.to = name;
    }

    public void setFile(File f2) {
        this.propsFile = f2;
    }

    public void setLogfile(File f2) {
        this.log = f2;
    }

    public void setAppend(boolean b2) {
        this.append = b2;
    }

    public void setVerbose(boolean b2) {
        this.verbose = b2;
    }

    public void setWantresponse(boolean b2) {
        this.wantResponse = b2;
    }

    public void setProperty(String name) {
        this.property = name;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setMaxwait(int wait) {
        this.maxwait = wait * 1000;
    }

    public void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    public void addConfiguredProp(Prop p2) throws BuildException {
        String name = p2.getName();
        if (name == null) {
            throw new BuildException("name is null", this.getLocation());
        }
        String value = p2.getValue();
        if (value == null) {
            value = this.getProject().getProperty(name);
        }
        if (value == null) {
            throw new BuildException("value is null", this.getLocation());
        }
        this.props.put(name, value);
    }

    public void addText(String text) {
        this.textProps = text;
    }

    public void execute() throws BuildException {
        block11: {
            if (this.to == null) {
                throw new BuildException("'to' attribute is required", this.getLocation());
            }
            final String content = this.getContent();
            try {
                if (this.verbose) {
                    this.log("Opening connection for post to " + this.to.toString() + "...");
                }
                Thread runner = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        FilterOutputStream out = null;
                        try {
                            PostTask.this.connection = PostTask.this.to.openConnection();
                            PostTask.this.connection.setDoInput(true);
                            PostTask.this.connection.setDoOutput(true);
                            PostTask.this.connection.setUseCaches(false);
                            PostTask.this.connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                            Iterator it = cookieStorage.keySet().iterator();
                            while (it.hasNext()) {
                                StringBuffer sb = new StringBuffer();
                                Object name = it.next();
                                if (name == null) continue;
                                String key = name.toString();
                                Cookie cookie = (Cookie)cookieStorage.get(name);
                                if (!PostTask.this.to.getPath().startsWith(cookie.getPath())) continue;
                                PostTask.this.connection.addRequestProperty("Cookie", cookie.toString());
                            }
                            if (PostTask.this.verbose) {
                                PostTask.this.log("Connected, sending data...");
                            }
                            out = new DataOutputStream(PostTask.this.connection.getOutputStream());
                            if (PostTask.this.verbose) {
                                PostTask.this.log(content);
                            }
                            ((DataOutputStream)out).writeBytes(content);
                            ((DataOutputStream)out).flush();
                            if (PostTask.this.verbose) {
                                PostTask.this.log("Data sent.");
                            }
                        }
                        catch (Exception e2) {
                            if (PostTask.this.failOnError) {
                                throw new BuildException(e2, PostTask.this.getLocation());
                            }
                        }
                        finally {
                            try {
                                out.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                };
                runner.start();
                runner.join(this.maxwait);
                if (runner.isAlive()) {
                    runner.interrupt();
                    if (this.failOnError) {
                        throw new BuildException("maxwait exceeded, unable to send data", this.getLocation());
                    }
                    return;
                }
                if (this.wantResponse) {
                    if (this.verbose) {
                        this.log("Waiting for response...");
                    }
                    this.currentRunner = runner = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            PrintWriter fw2 = null;
                            StringWriter sw = null;
                            PrintWriter pw = null;
                            BufferedReader in = null;
                            try {
                                String line;
                                if (PostTask.this.connection instanceof HttpURLConnection) {
                                    Map<String, List<String>> map = ((HttpURLConnection)PostTask.this.connection).getHeaderFields();
                                    Iterator<String> it = map.keySet().iterator();
                                    while (it.hasNext()) {
                                        String name = it.next();
                                        if (name == null || !name.equals("Set-Cookie")) continue;
                                        List<String> cookies = map.get(name);
                                        Iterator<String> c2 = cookies.iterator();
                                        while (c2.hasNext()) {
                                            String raw = c2.next();
                                            Cookie cookie = new Cookie(raw);
                                            cookieStorage.put(cookie.getId(), cookie);
                                        }
                                    }
                                    if (PostTask.this.verbose) {
                                        PostTask.this.log(String.valueOf(((HttpURLConnection)PostTask.this.connection).getResponseCode()));
                                        PostTask.this.log(((HttpURLConnection)PostTask.this.connection).getResponseMessage());
                                        StringBuffer sb = new StringBuffer();
                                        map = ((HttpURLConnection)PostTask.this.connection).getHeaderFields();
                                        Iterator<String> it2 = map.keySet().iterator();
                                        while (it2.hasNext()) {
                                            String name = it2.next();
                                            sb.append(name).append("=");
                                            List<String> values = map.get(name);
                                            if (values != null) {
                                                if (values.size() == 1) {
                                                    sb.append((Object)values.get(0));
                                                } else if (values.size() > 1) {
                                                    sb.append("[");
                                                    Iterator<String> v2 = values.iterator();
                                                    while (v2.hasNext()) {
                                                        sb.append((Object)v2.next()).append(",");
                                                    }
                                                    sb.append("]");
                                                }
                                            }
                                            sb.append("\n");
                                            PostTask.this.log(sb.toString());
                                        }
                                    }
                                }
                                in = new BufferedReader(new InputStreamReader(PostTask.this.connection.getInputStream()));
                                if (PostTask.this.log != null) {
                                    fw2 = new PrintWriter(new FileWriter(PostTask.this.log, PostTask.this.append));
                                }
                                if (PostTask.this.property != null) {
                                    sw = new StringWriter();
                                    pw = new PrintWriter(sw);
                                }
                                while (null != (line = in.readLine())) {
                                    if (PostTask.this.currentRunner != this) {
                                        break;
                                    }
                                    if (PostTask.this.verbose) {
                                        PostTask.this.log(line);
                                    }
                                    if (fw2 != null) {
                                        fw2.println(line);
                                    }
                                    if (pw == null) continue;
                                    pw.println(line);
                                }
                            }
                            catch (Exception e2) {
                                if (PostTask.this.failOnError) {
                                    throw new BuildException(e2, PostTask.this.getLocation());
                                }
                            }
                            finally {
                                try {
                                    in.close();
                                }
                                catch (Exception e3) {}
                                try {
                                    if (fw2 != null) {
                                        fw2.flush();
                                        fw2.close();
                                    }
                                }
                                catch (Exception e4) {}
                            }
                            if (PostTask.this.property != null && sw != null) {
                                PostTask.this.getProject().setProperty(PostTask.this.property, sw.toString());
                            }
                        }
                    };
                    runner.start();
                    runner.join(this.maxwait);
                    if (runner.isAlive()) {
                        this.currentRunner = null;
                        runner.interrupt();
                        if (this.failOnError) {
                            throw new BuildException("maxwait exceeded, unable to receive data", this.getLocation());
                        }
                    }
                }
                if (this.verbose) {
                    this.log("Post complete.");
                }
            }
            catch (Exception e2) {
                if (!this.failOnError) break block11;
                throw new BuildException(e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFile(File file) throws BuildException {
        block9: {
            Properties fileprops = new Properties();
            try {
                if (file.exists()) {
                    FileInputStream fis = new FileInputStream(file);
                    try {
                        fileprops.load(fis);
                    }
                    finally {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    this.addProperties(fileprops);
                } else {
                    this.log("Unable to find property file: " + file.getAbsolutePath(), 3);
                }
                this.log("Post complete.");
            }
            catch (Exception e2) {
                if (!this.failOnError) break block9;
                throw new BuildException(e2);
            }
        }
    }

    private String getContent() {
        StringBuffer content;
        block5: {
            if (this.propsFile != null) {
                this.loadFile(this.propsFile);
            }
            if (this.textProps != null) {
                this.loadTextProps(this.textProps);
            }
            content = new StringBuffer();
            try {
                Enumeration en2 = this.props.keys();
                while (en2.hasMoreElements()) {
                    String name = (String)en2.nextElement();
                    String value = (String)this.props.get(name);
                    content.append(URLEncoder.encode(name, this.encoding));
                    content.append("=");
                    content.append(URLEncoder.encode(value, this.encoding));
                    if (!en2.hasMoreElements()) continue;
                    content.append("&");
                }
            }
            catch (IOException ex2) {
                if (!this.failOnError) break block5;
                throw new BuildException(ex2, this.getLocation());
            }
        }
        return content.toString();
    }

    private void loadTextProps(String tp) {
        Properties p2 = new Properties();
        Project project = this.getProject();
        StringTokenizer st = new StringTokenizer(tp, "$");
        while (st.hasMoreTokens()) {
            String name;
            String value;
            String token = st.nextToken();
            int start = token.indexOf("{");
            int end = token.indexOf("}");
            if (start <= -1 || end <= -1 || end <= start || (value = project.getProperty(name = token.substring(start + 1, end - start))) == null) continue;
            p2.setProperty(name, value);
        }
        this.addProperties(p2);
    }

    private void addProperties(Properties fileprops) {
        this.resolveAllProperties(fileprops);
        Enumeration<Object> e2 = fileprops.keys();
        while (e2.hasMoreElements()) {
            String name = (String)e2.nextElement();
            String value = fileprops.getProperty(name);
            this.props.put(name, value);
        }
    }

    private void resolveAllProperties(Properties fileprops) throws BuildException {
        Enumeration<Object> e2 = fileprops.keys();
        while (e2.hasMoreElements()) {
            String name = (String)e2.nextElement();
            String value = fileprops.getProperty(name);
            boolean resolved = false;
            while (!resolved) {
                Vector fragments = new Vector();
                Vector propertyRefs = new Vector();
                ProjectHelper.parsePropertyString(value, fragments, propertyRefs);
                resolved = true;
                if (propertyRefs.size() == 0) continue;
                StringBuffer sb = new StringBuffer();
                Enumeration i2 = fragments.elements();
                Enumeration j2 = propertyRefs.elements();
                while (i2.hasMoreElements()) {
                    String fragment = (String)i2.nextElement();
                    if (fragment == null) {
                        String propertyName = (String)j2.nextElement();
                        if (propertyName.equals(name)) {
                            throw new BuildException("Property " + name + " was circularly " + "defined.");
                        }
                        fragment = this.getProject().getProperty(propertyName);
                        if (fragment == null) {
                            if (fileprops.containsKey(propertyName)) {
                                fragment = fileprops.getProperty(propertyName);
                                resolved = false;
                            } else {
                                fragment = "${" + propertyName + "}";
                            }
                        }
                    }
                    sb.append(fragment);
                }
                value = sb.toString();
                fileprops.put(name, value);
            }
        }
    }

    public class Cookie {
        private String name;
        private String value;
        private String domain;
        private String path = "/";
        private String id;

        public Cookie(String raw) {
            String[] args = raw.split("[;]");
            for (int i2 = 0; i2 < args.length; ++i2) {
                String part = args[i2];
                int eq_index = part.indexOf("=");
                if (eq_index == -1) continue;
                String first_part = part.substring(0, eq_index).trim();
                String second_part = part.substring(eq_index + 1);
                if (i2 == 0) {
                    this.name = first_part;
                    this.value = second_part;
                    continue;
                }
                if (first_part.equalsIgnoreCase("Path")) {
                    this.path = second_part;
                    continue;
                }
                if (!first_part.equalsIgnoreCase("Domain")) continue;
                this.domain = second_part;
            }
            if (this.name == null) {
                throw new IllegalArgumentException("Raw cookie does not contain a cookie name.");
            }
            if (this.path == null) {
                this.path = "/";
            }
            this.setId(this.path, this.name);
        }

        public Cookie(String name, String value) {
            if (name == null) {
                throw new IllegalArgumentException("Cookie name may not be null.");
            }
            this.name = name;
            this.value = value;
            this.setId(name);
        }

        public String getId() {
            if (this.id == null) {
                this.setId(this.path, this.name);
            }
            return this.id.toString();
        }

        private void setId(String name) {
            this.setId(this.path, name);
        }

        private void setId(String path, String name) {
            if (name == null) {
                name = "";
            }
            this.id = path + name;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public String getDomain() {
            return this.domain;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.name).append("=").append(this.value).append(";");
            if (this.domain != null) {
                sb.append("Domain=").append(this.domain).append(";");
            }
            if (this.path != null) {
                sb.append("Path=").append(this.path).append(";");
            }
            sb.append("Version=\"1\";");
            return sb.toString();
        }
    }
}

