/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.net.httpclient;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.antcontrib.net.httpclient.HttpClientType;
import net.sf.antcontrib.net.httpclient.MethodParams;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.util.FileUtils;

public abstract class AbstractMethodTask
extends Task {
    private HttpMethodBase method;
    private File responseDataFile;
    private String responseDataProperty;
    private String statusCodeProperty;
    private HttpClient httpClient;
    private List responseHeaders = new ArrayList();

    protected abstract HttpMethodBase createNewMethod();

    protected void configureMethod(HttpMethodBase method) {
    }

    protected void cleanupResources(HttpMethodBase method) {
    }

    public void addConfiguredResponseHeader(ResponseHeader responseHeader) {
        this.responseHeaders.add(responseHeader);
    }

    public void addConfiguredHttpClient(HttpClientType httpClientType) {
        this.httpClient = httpClientType.getClient();
    }

    protected HttpMethodBase createMethodIfNecessary() {
        if (this.method == null) {
            this.method = this.createNewMethod();
        }
        return this.method;
    }

    public void setResponseDataFile(File responseDataFile) {
        this.responseDataFile = responseDataFile;
    }

    public void setResponseDataProperty(String responseDataProperty) {
        this.responseDataProperty = responseDataProperty;
    }

    public void setStatusCodeProperty(String statusCodeProperty) {
        this.statusCodeProperty = statusCodeProperty;
    }

    public void setClientRefId(String clientRefId) {
        Object clientRef = this.getProject().getReference(clientRefId);
        if (clientRef == null) {
            throw new BuildException("Reference '" + clientRefId + "' does not exist.");
        }
        if (!(clientRef instanceof HttpClientType)) {
            throw new BuildException("Reference '" + clientRefId + "' is of the wrong type.");
        }
        this.httpClient = ((HttpClientType)clientRef).getClient();
    }

    public void setDoAuthentication(boolean doAuthentication) {
        this.createMethodIfNecessary().setDoAuthentication(doAuthentication);
    }

    public void setFollowRedirects(boolean doFollowRedirects) {
        this.createMethodIfNecessary().setFollowRedirects(doFollowRedirects);
    }

    public void addConfiguredParams(MethodParams params) {
        this.createMethodIfNecessary().setParams((HttpMethodParams)params);
    }

    public void setPath(String path) {
        this.createMethodIfNecessary().setPath(path);
    }

    public void setURL(String url) {
        try {
            this.createMethodIfNecessary().setURI(new URI(url, false));
        }
        catch (URIException e2) {
            throw new BuildException(e2);
        }
    }

    public void setQueryString(String queryString) {
        this.createMethodIfNecessary().setQueryString(queryString);
    }

    public void addConfiguredHeader(Header header) {
        this.createMethodIfNecessary().setRequestHeader(header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        block12: {
            if (this.httpClient == null) {
                this.httpClient = new HttpClient();
            }
            HttpMethodBase method = this.createMethodIfNecessary();
            this.configureMethod(method);
            try {
                int statusCode = this.httpClient.executeMethod((HttpMethod)method);
                if (this.statusCodeProperty != null) {
                    Property p2 = (Property)this.getProject().createTask("property");
                    p2.setName(this.statusCodeProperty);
                    p2.setValue(String.valueOf(statusCode));
                    p2.perform();
                }
                Iterator it = this.responseHeaders.iterator();
                while (it.hasNext()) {
                    ResponseHeader header = (ResponseHeader)it.next();
                    Property p3 = (Property)this.getProject().createTask("property");
                    p3.setName(header.getProperty());
                    Header h2 = method.getResponseHeader(header.getName());
                    if (h2 == null || h2.getValue() == null) continue;
                    p3.setValue(h2.getValue());
                    p3.perform();
                }
                if (this.responseDataProperty != null) {
                    Property p4 = (Property)this.getProject().createTask("property");
                    p4.setName(this.responseDataProperty);
                    p4.setValue(method.getResponseBodyAsString());
                    p4.perform();
                    break block12;
                }
                if (this.responseDataFile == null) break block12;
                FileOutputStream fos = null;
                InputStream is = null;
                try {
                    is = method.getResponseBodyAsStream();
                    fos = new FileOutputStream(this.responseDataFile);
                    byte[] buf = new byte[10240];
                    int read = 0;
                    while ((read = is.read(buf, 0, 10240)) != -1) {
                        fos.write(buf, 0, read);
                    }
                }
                catch (Throwable throwable) {
                    FileUtils.close(fos);
                    FileUtils.close(is);
                    throw throwable;
                }
                FileUtils.close(fos);
                FileUtils.close(is);
            }
            catch (IOException e2) {
                throw new BuildException(e2);
            }
            finally {
                this.cleanupResources(method);
            }
        }
    }

    public static class ResponseHeader {
        private String name;
        private String property;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }
    }
}

