/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.net.httpclient;

import net.sf.antcontrib.net.httpclient.AbstractHttpStateTypeTask;
import net.sf.antcontrib.net.httpclient.HttpStateType;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.cookie.CookieSpec;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Property;

public class GetCookieTask
extends AbstractHttpStateTypeTask {
    private String property;
    private String prefix;
    private String cookiePolicy = "default";
    private String realm = null;
    private int port = 80;
    private String path = null;
    private boolean secure = false;
    private String name = null;

    public void setName(String name) {
        this.name = name;
    }

    public void setCookiePolicy(String cookiePolicy) {
        this.cookiePolicy = cookiePolicy;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    private Cookie findCookie(Cookie[] cookies, String name) {
        for (int i2 = 0; i2 < cookies.length; ++i2) {
            if (!cookies[i2].getName().equals(name)) continue;
            return cookies[i2];
        }
        return null;
    }

    protected void execute(HttpStateType stateType) throws BuildException {
        if (this.realm == null || this.path == null) {
            throw new BuildException("'realm' and 'path' attributes are required");
        }
        HttpState state = stateType.getState();
        CookieSpec spec = CookiePolicy.getCookieSpec((String)this.cookiePolicy);
        Cookie[] cookies = state.getCookies();
        Cookie[] matches = spec.match(this.realm, this.port, this.path, this.secure, cookies);
        if (this.name != null) {
            Cookie c2 = this.findCookie(matches, this.name);
            matches = c2 != null ? new Cookie[]{c2} : new Cookie[]{};
        }
        if (this.property != null) {
            if (matches != null && matches.length > 0) {
                Property p2 = (Property)this.getProject().createTask("property");
                p2.setName(this.property);
                p2.setValue(matches[0].getValue());
                p2.perform();
            }
        } else if (this.prefix != null) {
            if (matches != null && matches.length > 0) {
                for (int i2 = 0; i2 < matches.length; ++i2) {
                    String propName = this.prefix + matches[i2].getName();
                    Property p3 = (Property)this.getProject().createTask("property");
                    p3.setName(propName);
                    p3.setValue(matches[i2].getValue());
                    p3.perform();
                }
            }
        } else {
            throw new BuildException("Nothing to set");
        }
    }
}

