/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.net.httpclient;

import net.sf.antcontrib.net.httpclient.AbstractHttpStateTypeTask;
import net.sf.antcontrib.net.httpclient.ClientParams;
import net.sf.antcontrib.net.httpclient.HostConfig;
import net.sf.antcontrib.net.httpclient.HttpStateType;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;

public class HttpClientType
extends DataType {
    private HttpClient client;

    public HttpClientType(Project p2) {
        this.setProject(p2);
        this.client = new HttpClient();
    }

    public HttpClient getClient() {
        if (this.isReference()) {
            return this.getRef().getClient();
        }
        return this.client;
    }

    public void setStateRefId(String stateRefId) {
        if (this.isReference()) {
            this.tooManyAttributes();
        }
        HttpStateType stateType = AbstractHttpStateTypeTask.getStateType(this.getProject(), stateRefId);
        this.getClient().setState(stateType.getState());
    }

    protected HttpClientType getRef() {
        return (HttpClientType)super.getCheckedRef(HttpClientType.class, "http-client");
    }

    public ClientParams createClientParams() {
        if (this.isReference()) {
            this.tooManyAttributes();
        }
        ClientParams clientParams = new ClientParams();
        this.client.setParams((HttpClientParams)clientParams);
        return clientParams;
    }

    public HttpStateType createHttpState() {
        if (this.isReference()) {
            this.tooManyAttributes();
        }
        HttpStateType state = new HttpStateType(this.getProject());
        this.getClient().setState(state.getState());
        return state;
    }

    public HostConfig createHostConfig() {
        if (this.isReference()) {
            this.tooManyAttributes();
        }
        HostConfig config = new HostConfig();
        this.client.setHostConfiguration((HostConfiguration)config);
        return config;
    }
}

