/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.perf;

public class StopWatch {
    private String name = "";
    private long startTime = 0L;
    private long stopTime = 0L;
    private long totalTime = 0L;
    private boolean running = false;

    public StopWatch() {
        this("");
    }

    public StopWatch(String name) {
        this.name = name;
        this.start();
    }

    public long start() {
        if (!this.running) {
            this.startTime = System.currentTimeMillis();
        }
        this.running = true;
        return this.startTime;
    }

    public long stop() {
        this.stopTime = System.currentTimeMillis();
        if (this.running) {
            this.totalTime += this.stopTime - this.startTime;
        }
        this.startTime = this.stopTime;
        this.running = false;
        return this.stopTime;
    }

    public long total() {
        this.stop();
        long rtn = this.totalTime;
        this.totalTime = 0L;
        return rtn;
    }

    public long elapsed() {
        return System.currentTimeMillis() - this.startTime;
    }

    public String getName() {
        return this.name;
    }

    public String format(long ms) {
        String total = String.valueOf(ms);
        String frontpad = "000";
        int pad_length = 3 - total.length();
        if (pad_length >= 0) {
            total = "0." + frontpad.substring(0, pad_length) + total;
        } else {
            String dec = total.substring(total.length() - 3);
            total = "";
            int min = 0;
            int sec = 0;
            min = (int)(ms / 60000L);
            int n2 = sec = min > 0 ? (int)((ms - (long)(min * 60000)) / 1000L) : (int)(ms / 1000L);
            total = min > 0 ? String.valueOf(min) + ":" + (sec < 10 ? "0" : "") + String.valueOf(sec) + "." + dec : String.valueOf(sec) + "." + dec;
        }
        return total + " sec";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        if (this.name != null) {
            sb.append(this.name).append(": ");
        }
        sb.append(this.format(this.totalTime));
        sb.append("]");
        return sb.toString();
    }

    public static void main(String[] args) {
        StopWatch sw = new StopWatch("test");
        System.out.println(sw.format(1L));
        System.out.println(sw.format(10L));
        System.out.println(sw.format(100L));
        System.out.println(sw.format(1000L));
        System.out.println(sw.format(100000L));
        System.out.println(sw.format(1000000L));
        try {
            System.out.println("StopWatch: " + sw.getName());
            Thread.currentThread();
            Thread.sleep(2000L);
            sw.stop();
            System.out.println(sw.toString());
            sw.start();
            Thread.currentThread();
            Thread.sleep(2000L);
            sw.stop();
            System.out.println("elapsed: " + sw.format(sw.elapsed()));
            System.out.println("total: " + sw.format(sw.total()));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

