/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.platform;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.taskdefs.Execute;

public class Platform {
    public static final int FAMILY_NONE = 0;
    public static final int FAMILY_UNIX = 1;
    public static final int FAMILY_WINDOWS = 2;
    public static final int FAMILY_OS2 = 3;
    public static final int FAMILY_ZOS = 4;
    public static final int FAMILY_OS400 = 5;
    public static final int FAMILY_DOS = 6;
    public static final int FAMILY_MAC = 7;
    public static final int FAMILY_MACOSX = 8;
    public static final int FAMILY_TANDEM = 9;
    public static final int FAMILY_OPENVMS = 10;
    public static final String FAMILY_NAME_UNIX = "unix";
    public static final String FAMILY_NAME_WINDOWS = "windows";
    public static final String FAMILY_NAME_OS2 = "os/2";
    public static final String FAMILY_NAME_ZOS = "z/os";
    public static final String FAMILY_NAME_OS400 = "os/400";
    public static final String FAMILY_NAME_DOS = "dos";
    public static final String FAMILY_NAME_MAC = "mac";
    public static final String FAMILY_NAME_TANDEM = "tandem";
    public static final String FAMILY_NAME_OPENVMS = "openvms";
    private static final Hashtable familyNames = new Hashtable();

    public static final int getOsFamily() {
        String osName = System.getProperty("os.name").toLowerCase();
        String pathSep = System.getProperty("path.separator");
        int family = 0;
        if (osName.indexOf(FAMILY_NAME_WINDOWS) != -1) {
            family = 2;
        } else if (osName.indexOf(FAMILY_NAME_OS2) != -1) {
            family = 3;
        } else if (osName.indexOf(FAMILY_NAME_ZOS) != -1 || osName.indexOf("os/390") != -1) {
            family = 4;
        } else if (osName.indexOf(FAMILY_NAME_OS400) != -1) {
            family = 5;
        } else if (pathSep.equals(";")) {
            family = 6;
        } else if (osName.indexOf(FAMILY_NAME_MAC) != -1) {
            family = osName.endsWith("x") ? 1 : 7;
        } else if (osName.indexOf("nonstop_kernel") != -1) {
            family = 9;
        } else if (osName.indexOf(FAMILY_NAME_OPENVMS) != -1) {
            family = 10;
        } else if (pathSep.equals(":")) {
            family = 1;
        }
        return family;
    }

    public static final String getOsFamilyName() {
        int family = Platform.getOsFamily();
        return (String)familyNames.get(new Integer(family));
    }

    public static final Properties getEnv() {
        Properties env = new Properties();
        Vector osEnv = Execute.getProcEnvironment();
        Enumeration e2 = osEnv.elements();
        while (e2.hasMoreElements()) {
            String entry = (String)e2.nextElement();
            int pos = entry.indexOf(61);
            if (pos == -1) continue;
            env.setProperty(entry.substring(0, pos), entry.substring(pos + 1));
        }
        return env;
    }

    public static final String getDefaultShell() {
        String shell = Platform.getEnv().getProperty("SHELL");
        if (shell == null) {
            int family = Platform.getOsFamily();
            switch (family) {
                case 2: 
                case 6: {
                    shell = "CMD.EXE";
                    break;
                }
                default: {
                    shell = "bash";
                }
            }
        }
        return shell;
    }

    public static final String getDefaultScriptSuffix() {
        int family = Platform.getOsFamily();
        String suffix = null;
        switch (family) {
            case 2: 
            case 6: {
                suffix = ".bat";
                break;
            }
            default: {
                suffix = null;
            }
        }
        return suffix;
    }

    public static final String[] getDefaultShellArguments() {
        int family = Platform.getOsFamily();
        String[] args = null;
        switch (family) {
            case 2: 
            case 6: {
                args = new String[]{"/c", "call"};
                break;
            }
            default: {
                args = new String[]{};
            }
        }
        return args;
    }

    static {
        familyNames.put(new Integer(2), FAMILY_NAME_WINDOWS);
        familyNames.put(new Integer(3), FAMILY_NAME_OS2);
        familyNames.put(new Integer(4), FAMILY_NAME_ZOS);
        familyNames.put(new Integer(5), FAMILY_NAME_OS400);
        familyNames.put(new Integer(6), FAMILY_NAME_DOS);
        familyNames.put(new Integer(7), FAMILY_NAME_MAC);
        familyNames.put(new Integer(8), FAMILY_NAME_UNIX);
        familyNames.put(new Integer(9), FAMILY_NAME_TANDEM);
        familyNames.put(new Integer(1), FAMILY_NAME_UNIX);
        familyNames.put(new Integer(10), FAMILY_NAME_OPENVMS);
    }
}

