/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.process;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class Limit
extends Task
implements TaskContainer {
    private Vector tasks = new Vector();
    private long maxwait = 180L;
    protected TimeUnit unit = TimeUnit.SECOND_UNIT;
    private String timeoutProperty = null;
    private String timeoutValue = "true";
    private Task currentTask = null;
    private Thread taskRunner = null;
    private boolean failOnError = false;
    private Exception exception = null;

    public void addTask(Task task) throws BuildException {
        this.tasks.addElement(task);
    }

    public void setMaxwait(int wait) {
        this.maxwait = wait;
    }

    public void setUnit(String unit) {
        if (unit == null) {
            return;
        }
        if (unit.equals("second")) {
            this.setMaxWaitUnit(TimeUnit.SECOND_UNIT);
            return;
        }
        if (unit.equals("millisecond")) {
            this.setMaxWaitUnit(TimeUnit.MILLISECOND_UNIT);
            return;
        }
        if (unit.equals("minute")) {
            this.setMaxWaitUnit(TimeUnit.MINUTE_UNIT);
            return;
        }
        if (unit.equals("hour")) {
            this.setMaxWaitUnit(TimeUnit.HOUR_UNIT);
            return;
        }
        if (unit.equals("day")) {
            this.setMaxWaitUnit(TimeUnit.DAY_UNIT);
            return;
        }
        if (unit.equals("week")) {
            this.setMaxWaitUnit(TimeUnit.WEEK_UNIT);
            return;
        }
    }

    public void setMilliseconds(int value) {
        this.setMaxwait(value);
        this.setMaxWaitUnit(TimeUnit.MILLISECOND_UNIT);
    }

    public void setSeconds(int value) {
        this.setMaxwait(value);
        this.setMaxWaitUnit(TimeUnit.SECOND_UNIT);
    }

    public void setMinutes(int value) {
        this.setMaxwait(value);
        this.setMaxWaitUnit(TimeUnit.MINUTE_UNIT);
    }

    public void setHours(int value) {
        this.setMaxwait(value);
        this.setMaxWaitUnit(TimeUnit.HOUR_UNIT);
    }

    public void setDays(int value) {
        this.setMaxwait(value);
        this.setMaxWaitUnit(TimeUnit.DAY_UNIT);
    }

    public void setWeeks(int value) {
        this.setMaxwait(value);
        this.setMaxWaitUnit(TimeUnit.WEEK_UNIT);
    }

    public void setMaxWaitUnit(TimeUnit unit) {
        this.unit = unit;
    }

    public void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    public void setProperty(String p2) {
        this.timeoutProperty = p2;
    }

    public void setValue(String v2) {
        this.timeoutValue = v2;
    }

    public void execute() throws BuildException {
        try {
            Thread runner;
            this.taskRunner = runner = new Thread(){

                public void run() {
                    Enumeration e2 = Limit.this.tasks.elements();
                    while (e2.hasMoreElements() && Limit.this.taskRunner == this) {
                        Limit.this.currentTask = (Task)e2.nextElement();
                        try {
                            Limit.this.currentTask.perform();
                        }
                        catch (Exception ex2) {
                            if (Limit.this.failOnError) {
                                Limit.this.exception = ex2;
                                return;
                            }
                            Limit.this.exception = ex2;
                        }
                    }
                }
            };
            runner.start();
            runner.join(this.unit.toMillis(this.maxwait));
            if (runner.isAlive()) {
                this.taskRunner = null;
                runner.interrupt();
                int index = this.tasks.indexOf(this.currentTask);
                StringBuffer not_ran = new StringBuffer();
                for (int i2 = index + 1; i2 < this.tasks.size(); ++i2) {
                    not_ran.append('<').append(((Task)this.tasks.get(i2)).getTaskName()).append('>');
                    if (i2 >= this.tasks.size() - 1) continue;
                    not_ran.append(", ");
                }
                if (this.timeoutProperty != null) {
                    this.getProject().setNewProperty(this.timeoutProperty, this.timeoutValue);
                }
                StringBuffer msg = new StringBuffer();
                msg.append("Interrupted task <").append(this.currentTask.getTaskName()).append(">. Waited ").append(this.maxwait).append(" ").append(this.unit.getValue()).append(", but this task did not complete.").append(not_ran.length() > 0 ? " The following tasks did not execute: " + not_ran.toString() + "." : "");
                if (this.failOnError) {
                    throw new BuildException(msg.toString());
                }
                this.log(msg.toString());
            } else if (this.failOnError && this.exception != null) {
                throw new BuildException(this.exception);
            }
        }
        catch (Exception e2) {
            throw new BuildException(e2);
        }
    }

    public static class TimeUnit
    extends EnumeratedAttribute {
        public static final String MILLISECOND = "millisecond";
        public static final String SECOND = "second";
        public static final String MINUTE = "minute";
        public static final String HOUR = "hour";
        public static final String DAY = "day";
        public static final String WEEK = "week";
        public static final TimeUnit MILLISECOND_UNIT = new TimeUnit("millisecond");
        public static final TimeUnit SECOND_UNIT = new TimeUnit("second");
        public static final TimeUnit MINUTE_UNIT = new TimeUnit("minute");
        public static final TimeUnit HOUR_UNIT = new TimeUnit("hour");
        public static final TimeUnit DAY_UNIT = new TimeUnit("day");
        public static final TimeUnit WEEK_UNIT = new TimeUnit("week");
        private static final String[] units = new String[]{"millisecond", "second", "minute", "hour", "day", "week"};
        private Hashtable timeTable = new Hashtable();

        public TimeUnit() {
            this.timeTable.put(MILLISECOND, new Long(1L));
            this.timeTable.put(SECOND, new Long(1000L));
            this.timeTable.put(MINUTE, new Long(60000L));
            this.timeTable.put(HOUR, new Long(3600000L));
            this.timeTable.put(DAY, new Long(86400000L));
            this.timeTable.put(WEEK, new Long(604800000L));
        }

        private TimeUnit(String value) {
            this();
            this.setValueProgrammatically(value);
        }

        protected void setValueProgrammatically(String value) {
            this.value = value;
        }

        public long getMultiplier() {
            String key = this.getValue().toLowerCase();
            Long l2 = (Long)this.timeTable.get(key);
            return l2;
        }

        public String[] getValues() {
            return units;
        }

        public long toMillis(long numberOfUnits) {
            return numberOfUnits * this.getMultiplier();
        }
    }
}

