/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.property;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import net.sf.antcontrib.property.AbstractPropertySetterTask;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Reference;

public class SortList
extends AbstractPropertySetterTask {
    private String value;
    private Reference ref;
    private boolean casesensitive = true;
    private boolean numeric = false;
    private String delimiter = ",";
    private File orderPropertyFile;
    private String orderPropertyFilePrefix;

    public void setNumeric(boolean numeric) {
        this.numeric = numeric;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setRefid(Reference ref) {
        this.ref = ref;
    }

    public void setCasesensitive(boolean casesenstive) {
        this.casesensitive = casesenstive;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setOrderPropertyFile(File orderPropertyFile) {
        this.orderPropertyFile = orderPropertyFile;
    }

    public void setOrderPropertyFilePrefix(String orderPropertyFilePrefix) {
        this.orderPropertyFilePrefix = orderPropertyFilePrefix;
    }

    private static void mergeSort(String[] src, String[] dest, int low, int high, boolean caseSensitive, boolean numeric) {
        int length = high - low;
        if (length < 7) {
            for (int i2 = low; i2 < high; ++i2) {
                for (int j2 = i2; j2 > low && SortList.compare(dest[j2 - 1], dest[j2], caseSensitive, numeric) > 0; --j2) {
                    SortList.swap(dest, j2, j2 - 1);
                }
            }
            return;
        }
        int mid = (low + high) / 2;
        SortList.mergeSort(dest, src, low, mid, caseSensitive, numeric);
        SortList.mergeSort(dest, src, mid, high, caseSensitive, numeric);
        if (SortList.compare(src[mid - 1], src[mid], caseSensitive, numeric) <= 0) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int p2 = low;
        int q2 = mid;
        for (int i3 = low; i3 < high; ++i3) {
            dest[i3] = q2 >= high || p2 < mid && SortList.compare(src[p2], src[q2], caseSensitive, numeric) <= 0 ? src[p2++] : src[q2++];
        }
    }

    private static int compare(String s1, String s2, boolean casesensitive, boolean numeric) {
        int res = 0;
        if (numeric) {
            double d2;
            double d1 = new Double(s1);
            res = d1 < (d2 = new Double(s2).doubleValue()) ? -1 : (d1 == d2 ? 0 : 1);
        } else if (casesensitive) {
            res = s1.compareTo(s2);
        } else {
            Locale l2 = Locale.getDefault();
            res = s1.toLowerCase(l2).compareTo(s2.toLowerCase(l2));
        }
        return res;
    }

    private static void swap(Object[] x2, int a2, int b2) {
        Object t2 = x2[a2];
        x2[a2] = x2[b2];
        x2[b2] = t2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector sortByOrderPropertyFile(Vector props) throws IOException {
        FileReader fr2 = null;
        Vector<String> orderedProps = new Vector<String>();
        try {
            fr2 = new FileReader(this.orderPropertyFile);
            BufferedReader br2 = new BufferedReader(fr2);
            String line = "";
            String pname = "";
            int pos = 0;
            while ((line = br2.readLine()) != null) {
                pos = line.indexOf(35);
                if (pos != -1) {
                    line = line.substring(0, pos).trim();
                }
                if (line.length() <= 0) continue;
                pos = line.indexOf(61);
                pname = pos != -1 ? line.substring(0, pos).trim() : line.trim();
                String prefPname = pname;
                if (this.orderPropertyFilePrefix != null) {
                    prefPname = this.orderPropertyFilePrefix + "." + prefPname;
                }
                if (!props.contains(prefPname) || orderedProps.contains(prefPname)) continue;
                orderedProps.addElement(prefPname);
            }
            Enumeration e2 = props.elements();
            while (e2.hasMoreElements()) {
                String prop = (String)e2.nextElement();
                if (orderedProps.contains(prop)) continue;
                orderedProps.addElement(prop);
            }
            Vector<String> vector = orderedProps;
            return vector;
        }
        finally {
            try {
                if (fr2 != null) {
                    fr2.close();
                }
            }
            catch (IOException e3) {}
        }
    }

    protected void validate() {
        super.validate();
    }

    public void execute() {
        this.validate();
        String val = this.value;
        if (val == null && this.ref != null) {
            val = this.ref.getReferencedObject(this.project).toString();
        }
        if (val == null) {
            throw new BuildException("Either the 'Value' or 'Refid' attribute must be set.");
        }
        StringTokenizer st = new StringTokenizer(val, this.delimiter);
        Vector<String> vec = new Vector<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            vec.addElement(st.nextToken());
        }
        Object[] propList = null;
        if (this.orderPropertyFile != null) {
            try {
                Vector sorted = this.sortByOrderPropertyFile(vec);
                propList = new String[sorted.size()];
                sorted.copyInto(propList);
            }
            catch (IOException e2) {
                throw new BuildException(e2);
            }
        } else {
            String[] s2 = vec.toArray(new String[vec.size()]);
            propList = new String[s2.length];
            System.arraycopy(s2, 0, propList, 0, s2.length);
            SortList.mergeSort(s2, (String[])propList, 0, s2.length, this.casesensitive, this.numeric);
        }
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < propList.length; ++i2) {
            if (i2 != 0) {
                sb.append(this.delimiter);
            }
            sb.append((String)propList[i2]);
        }
        this.setPropertyValue(sb.toString());
    }
}

