/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.property;

import java.io.File;
import java.net.URLEncoder;
import net.sf.antcontrib.property.AbstractPropertySetterTask;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Reference;

public class URLEncodeTask
extends AbstractPropertySetterTask {
    private String value;
    private Reference ref;

    public void setName(String name) {
        this.setProperty(name);
    }

    public void setValue(String value) {
        this.value = URLEncoder.encode(value);
    }

    public String getValue(Project p2) {
        String val = this.value;
        if (this.ref != null) {
            val = this.ref.getReferencedObject(p2).toString();
        }
        return val;
    }

    public void setLocation(File location) {
        this.setValue(location.getAbsolutePath());
    }

    public void setRefid(Reference ref) {
        this.ref = ref;
    }

    public String toString() {
        return this.value == null ? "" : this.value;
    }

    protected void validate() {
        super.validate();
        if (this.value == null && this.ref == null) {
            throw new BuildException("You must specify value, location or refid with the name attribute", this.getLocation());
        }
    }

    public void execute() {
        this.validate();
        String val = this.getValue(this.getProject());
        this.setPropertyValue(val);
    }
}

