/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.walls;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.antcontrib.walls.Package;
import net.sf.antcontrib.walls.SilentCopy;
import net.sf.antcontrib.walls.SilentMove;
import net.sf.antcontrib.walls.Walls;
import net.sf.antcontrib.walls.WallsFileHandler;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.JAXPUtils;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class CompileWithWalls
extends Task {
    private boolean setWallsTwice = false;
    private boolean setJavacTwice = false;
    private Walls walls;
    private Javac javac;
    private File wallsFile;
    private File tempBuildDir;
    private Map packagesNeedingCompiling = new HashMap();
    private SAXException cachedSAXException = null;
    private IOException cachedIOException = null;

    public void setIntermediaryBuildDir(File f2) {
        this.tempBuildDir = f2;
    }

    public File getIntermediaryBuildDir() {
        return this.tempBuildDir;
    }

    public void setWalls(File f2) {
        this.wallsFile = f2;
        Parser parser = JAXPUtils.getParser();
        WallsFileHandler hb2 = new WallsFileHandler(this, this.wallsFile);
        parser.setDocumentHandler(hb2);
        parser.setEntityResolver(hb2);
        parser.setErrorHandler(hb2);
        parser.setDTDHandler(hb2);
        try {
            this.log("about to start parsing walls file", 2);
            parser.parse(this.wallsFile.toURL().toExternalForm());
        }
        catch (SAXException e2) {
            this.cachedSAXException = e2;
            throw new ParsingWallsException("Problem parsing walls file attached:", e2);
        }
        catch (IOException e3) {
            this.cachedIOException = e3;
            throw new ParsingWallsException("IOException on walls file attached:", e3);
        }
    }

    public File getWalls() {
        return this.wallsFile;
    }

    public Walls createWalls() {
        if (this.walls != null) {
            this.setWallsTwice = true;
        }
        this.walls = new Walls();
        return this.walls;
    }

    public Javac createJavac() {
        if (this.javac != null) {
            this.setJavacTwice = true;
        }
        this.javac = new Javac();
        return this.javac;
    }

    public void execute() throws BuildException {
        if (this.cachedIOException != null) {
            throw new BuildException(this.cachedIOException, this.getLocation());
        }
        if (this.cachedSAXException != null) {
            throw new BuildException(this.cachedSAXException, this.getLocation());
        }
        if (this.tempBuildDir == null) {
            throw new BuildException("intermediaryBuildDir attribute must be specified on the compilewithwalls element", this.getLocation());
        }
        if (this.javac == null) {
            throw new BuildException("There must be a nested javac element", this.getLocation());
        }
        if (this.walls == null) {
            throw new BuildException("There must be a nested walls element", this.getLocation());
        }
        if (this.setWallsTwice) {
            throw new BuildException("compilewithwalls task only supports one nested walls element or one walls attribute", this.getLocation());
        }
        if (this.setJavacTwice) {
            throw new BuildException("compilewithwalls task only supports one nested javac element", this.getLocation());
        }
        this.getProject().addTaskDefinition("SilentMove", SilentMove.class);
        this.getProject().addTaskDefinition("SilentCopy", SilentCopy.class);
        File destDir = this.javac.getDestdir();
        Path src = this.javac.getSrcdir();
        if (src == null) {
            throw new BuildException("Javac inside compilewithwalls must have a srcdir specified");
        }
        String[] list = src.list();
        File[] tempSrcDirs1 = new File[list.length];
        for (int i2 = 0; i2 < list.length; ++i2) {
            tempSrcDirs1[i2] = this.getProject().resolveFile(list[i2]);
        }
        String[] classpaths = new String[]{};
        if (this.javac.getClasspath() != null) {
            classpaths = this.javac.getClasspath().list();
        }
        File temp = null;
        for (int i3 = 0; i3 < classpaths.length; ++i3) {
            temp = new File(classpaths[i3]);
            if (!temp.isDirectory()) continue;
            for (int n2 = 0; n2 < tempSrcDirs1.length; ++n2) {
                if (tempSrcDirs1[n2].compareTo(temp) != 0) continue;
                throw new BuildException("The classpath cannot contain any of the\nsrc directories, but it does.\nsrcdir=" + tempSrcDirs1[n2]);
            }
        }
        ArrayList<File> srcDirs2 = new ArrayList<File>();
        for (int i4 = 0; i4 < tempSrcDirs1.length; ++i4) {
            if (!tempSrcDirs1[i4].exists()) continue;
            srcDirs2.add(tempSrcDirs1[i4]);
        }
        if (destDir == null) {
            throw new BuildException("destdir was not specified in nested javac task", this.getLocation());
        }
        if (this.file1IsChildOfFile2(this.tempBuildDir, destDir)) {
            throw new BuildException("intermediaryBuildDir attribute cannot be specified\nto be the same as destdir or inside desdir of the javac task.\nThis is an intermediary build directory only used by the\ncompilewithwalls task, not the class file output directory.\nThe class file output directory is specified in javac's destdir attribute", this.getLocation());
        }
        if (!this.tempBuildDir.exists()) {
            this.tempBuildDir.mkdirs();
            this.log("created direction=" + this.tempBuildDir, 3);
        }
        Iterator iter = this.walls.getPackagesToCompile();
        while (iter.hasNext()) {
            Package toCompile = (Package)iter.next();
            File buildSpace = toCompile.getBuildSpace(this.tempBuildDir);
            if (!buildSpace.exists()) {
                buildSpace.mkdir();
                this.log("created directory=" + buildSpace, 3);
            }
            FileSet javaIncludes2 = toCompile.getJavaCopyFileSet(this.getProject(), this.getLocation());
            for (int i5 = 0; i5 < srcDirs2.size(); ++i5) {
                File srcDir = (File)srcDirs2.get(i5);
                javaIncludes2.setDir(srcDir);
                this.log(toCompile.getPackage() + ": sourceDir[" + i5 + "]=" + srcDir + " destDir=" + buildSpace, 3);
                this.copyFiles(srcDir, buildSpace, javaIncludes2);
            }
            Path srcDir2 = toCompile.getSrcPath(this.tempBuildDir, this.getProject());
            Path classPath = toCompile.getClasspath(this.tempBuildDir, this.getProject());
            if (this.javac.getClasspath() != null) {
                classPath.addExisting(this.javac.getClasspath());
            }
            Javac buildSpaceJavac = new Javac();
            buildSpaceJavac.setProject(this.getProject());
            buildSpaceJavac.setOwningTarget(this.getOwningTarget());
            buildSpaceJavac.setTaskName(this.getTaskName());
            this.log(toCompile.getPackage() + ": Compiling");
            this.log(toCompile.getPackage() + ": sourceDir=" + srcDir2, 3);
            this.log(toCompile.getPackage() + ": classPath=" + classPath, 3);
            this.log(toCompile.getPackage() + ": destDir=" + buildSpace, 3);
            buildSpaceJavac.setSrcdir(srcDir2);
            buildSpaceJavac.setDestdir(buildSpace);
            buildSpaceJavac.setClasspath(classPath);
            buildSpaceJavac.setBootclasspath(this.javac.getBootclasspath());
            buildSpaceJavac.setExtdirs(this.javac.getExtdirs());
            buildSpaceJavac.setEncoding(this.javac.getEncoding());
            buildSpaceJavac.setNowarn(this.javac.getNowarn());
            buildSpaceJavac.setDebug(this.javac.getDebug());
            buildSpaceJavac.setDebugLevel(this.javac.getDebugLevel());
            buildSpaceJavac.setOptimize(this.javac.getOptimize());
            buildSpaceJavac.setDeprecation(this.javac.getDeprecation());
            buildSpaceJavac.setTarget(this.javac.getTarget());
            buildSpaceJavac.setVerbose(this.javac.getVerbose());
            buildSpaceJavac.setDepend(this.javac.getDepend());
            buildSpaceJavac.setIncludeantruntime(this.javac.getIncludeantruntime());
            buildSpaceJavac.setIncludejavaruntime(this.javac.getIncludejavaruntime());
            buildSpaceJavac.setFork(this.javac.isForkedJavac());
            buildSpaceJavac.setExecutable(this.javac.getJavacExecutable());
            buildSpaceJavac.setMemoryInitialSize(this.javac.getMemoryInitialSize());
            buildSpaceJavac.setMemoryMaximumSize(this.javac.getMemoryMaximumSize());
            buildSpaceJavac.setFailonerror(this.javac.getFailonerror());
            buildSpaceJavac.setSource(this.javac.getSource());
            buildSpaceJavac.setCompiler(this.javac.getCompiler());
            String[] args = this.javac.getCurrentCompilerArgs();
            if (args != null) {
                for (int i6 = 0; i6 < args.length; ++i6) {
                    Javac.ImplementationSpecificArgument arg = buildSpaceJavac.createCompilerArg();
                    arg.setValue(args[i6]);
                }
            }
            buildSpaceJavac.setProject(this.getProject());
            buildSpaceJavac.perform();
            this.copyFiles(buildSpace, destDir, toCompile.getClassCopyFileSet(this.getProject(), this.getLocation()));
        }
    }

    private boolean file1IsChildOfFile2(File tempBuildDir, File destDir) {
        File parent = tempBuildDir;
        for (int i2 = 0; i2 < 1000; ++i2) {
            if (parent.compareTo(destDir) == 0) {
                return true;
            }
            if ((parent = parent.getParentFile()) != null) continue;
            return false;
        }
        throw new RuntimeException("You either have more than 1000 directories in\nyour heirarchy or this is a bug, please report. parent=" + parent + "  destDir=" + destDir);
    }

    private void copyFiles(File srcDir, File destDir, FileSet fileset) {
        fileset.setDir(srcDir);
        if (!srcDir.exists()) {
            throw new BuildException("Directory=" + srcDir + " does not exist", this.getLocation());
        }
        Copy move = (Copy)this.getProject().createTask("SilentCopy");
        move.setProject(this.getProject());
        move.setOwningTarget(this.getOwningTarget());
        move.setTaskName(this.getTaskName());
        move.setLocation(this.getLocation());
        move.setTodir(destDir);
        move.addFileset(fileset);
        move.perform();
    }

    public void log(String msg, int level) {
        super.log(msg, level);
    }

    private class ParsingWallsException
    extends RuntimeException {
        private String message;

        public ParsingWallsException(String message, Throwable cause) {
            super(message);
            this.message = message + "\n";
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            cause.printStackTrace(pw);
            this.message = this.message + sw;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return this.getMessage();
        }
    }
}

