/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.walls;

import java.io.File;
import net.sf.antcontrib.walls.CompileWithWalls;
import net.sf.antcontrib.walls.Package;
import net.sf.antcontrib.walls.Walls;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

class WallsFileHandler
extends HandlerBase {
    private final CompileWithWalls compilewithwalls;
    private File file = null;
    private Walls walls = null;
    private Locator locator = null;

    WallsFileHandler(CompileWithWalls walls, File file) {
        this.compilewithwalls = walls;
        this.file = file;
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        this.compilewithwalls.log("publicId=" + publicId + " systemId=" + systemId, 3);
        return null;
    }

    public void startElement(String name, AttributeList attrs) throws SAXParseException {
        if (name.equals("walls")) {
            if (attrs.getLength() > 0) {
                throw new SAXParseException("Error in file=" + this.file.getAbsolutePath() + ", no attributes allowed for walls element", this.locator);
            }
            this.walls = this.compilewithwalls.createWalls();
        } else if (name.equals("package")) {
            this.handlePackage(attrs);
        } else {
            throw new SAXParseException("Error in file=" + this.file.getAbsolutePath() + ", Unexpected element \"" + name + "\"", this.locator);
        }
    }

    private void handlePackage(AttributeList attrs) throws SAXParseException {
        if (this.walls == null) {
            throw new SAXParseException("Error in file=" + this.file.getAbsolutePath() + ", package element must be nested in a walls element", this.locator);
        }
        String name = attrs.getValue("name");
        String thePackage = attrs.getValue("package");
        String depends = attrs.getValue("depends");
        if (name == null) {
            throw new SAXParseException("Error in file=" + this.file.getAbsolutePath() + ", package element must contain the 'name' attribute", this.locator);
        }
        if (thePackage == null) {
            throw new SAXParseException("Error in file=" + this.file.getAbsolutePath() + ", package element must contain the 'package' attribute", this.locator);
        }
        Package p2 = new Package();
        p2.setName(name);
        p2.setPackage(thePackage);
        if (depends != null) {
            p2.setDepends(depends);
        }
        this.walls.addConfiguredPackage(p2);
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }
}

