/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;

public class Hex
implements BinaryEncoder,
BinaryDecoder {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static byte[] decodeHex(char[] data) throws DecoderException {
        int len = data.length;
        if ((len & 1) != 0) {
            throw new DecoderException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i2 = 0;
        int j2 = 0;
        while (j2 < len) {
            int f2 = Hex.toDigit(data[j2], j2) << 4;
            f2 |= Hex.toDigit(data[++j2], j2);
            ++j2;
            out[i2] = (byte)(f2 & 0xFF);
            ++i2;
        }
        return out;
    }

    protected static int toDigit(char ch2, int index) throws DecoderException {
        int digit = Character.digit(ch2, 16);
        if (digit == -1) {
            throw new DecoderException("Illegal hexadecimal charcter " + ch2 + " at index " + index);
        }
        return digit;
    }

    public static char[] encodeHex(byte[] data) {
        int l2 = data.length;
        char[] out = new char[l2 << 1];
        int j2 = 0;
        for (int i2 = 0; i2 < l2; ++i2) {
            out[j2++] = DIGITS[(0xF0 & data[i2]) >>> 4];
            out[j2++] = DIGITS[0xF & data[i2]];
        }
        return out;
    }

    public byte[] decode(byte[] array) throws DecoderException {
        return Hex.decodeHex(new String(array).toCharArray());
    }

    public Object decode(Object object) throws DecoderException {
        try {
            char[] charArray = object instanceof String ? ((String)object).toCharArray() : (char[])object;
            return Hex.decodeHex(charArray);
        }
        catch (ClassCastException e2) {
            throw new DecoderException(e2.getMessage());
        }
    }

    public byte[] encode(byte[] array) {
        return new String(Hex.encodeHex(array)).getBytes();
    }

    public Object encode(Object object) throws EncoderException {
        try {
            byte[] byteArray = object instanceof String ? ((String)object).getBytes() : (byte[])object;
            return Hex.encodeHex(byteArray);
        }
        catch (ClassCastException e2) {
            throw new EncoderException(e2.getMessage());
        }
    }
}

