/*
 * Decompiled with CFR 0.152.
 */
package org.apache.regexp;

import java.io.Serializable;
import java.util.Vector;
import org.apache.regexp.CharacterIterator;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;
import org.apache.regexp.RESyntaxException;
import org.apache.regexp.StringCharacterIterator;

public class RE
implements Serializable {
    public static final int MATCH_NORMAL = 0;
    public static final int MATCH_CASEINDEPENDENT = 1;
    public static final int MATCH_MULTILINE = 2;
    public static final int MATCH_SINGLELINE = 4;
    static final char OP_END = 'E';
    static final char OP_BOL = '^';
    static final char OP_EOL = '$';
    static final char OP_ANY = '.';
    static final char OP_ANYOF = '[';
    static final char OP_BRANCH = '|';
    static final char OP_ATOM = 'A';
    static final char OP_STAR = '*';
    static final char OP_PLUS = '+';
    static final char OP_MAYBE = '?';
    static final char OP_ESCAPE = '\\';
    static final char OP_OPEN = '(';
    static final char OP_OPEN_CLUSTER = '<';
    static final char OP_CLOSE = ')';
    static final char OP_CLOSE_CLUSTER = '>';
    static final char OP_BACKREF = '#';
    static final char OP_GOTO = 'G';
    static final char OP_NOTHING = 'N';
    static final char OP_RELUCTANTSTAR = '8';
    static final char OP_RELUCTANTPLUS = '=';
    static final char OP_RELUCTANTMAYBE = '/';
    static final char OP_POSIXCLASS = 'P';
    static final char E_ALNUM = 'w';
    static final char E_NALNUM = 'W';
    static final char E_BOUND = 'b';
    static final char E_NBOUND = 'B';
    static final char E_SPACE = 's';
    static final char E_NSPACE = 'S';
    static final char E_DIGIT = 'd';
    static final char E_NDIGIT = 'D';
    static final char POSIX_CLASS_ALNUM = 'w';
    static final char POSIX_CLASS_ALPHA = 'a';
    static final char POSIX_CLASS_BLANK = 'b';
    static final char POSIX_CLASS_CNTRL = 'c';
    static final char POSIX_CLASS_DIGIT = 'd';
    static final char POSIX_CLASS_GRAPH = 'g';
    static final char POSIX_CLASS_LOWER = 'l';
    static final char POSIX_CLASS_PRINT = 'p';
    static final char POSIX_CLASS_PUNCT = '!';
    static final char POSIX_CLASS_SPACE = 's';
    static final char POSIX_CLASS_UPPER = 'u';
    static final char POSIX_CLASS_XDIGIT = 'x';
    static final char POSIX_CLASS_JSTART = 'j';
    static final char POSIX_CLASS_JPART = 'k';
    static final int maxNode = 65536;
    static final int MAX_PAREN = 16;
    static final int offsetOpcode = 0;
    static final int offsetOpdata = 1;
    static final int offsetNext = 2;
    static final int nodeSize = 3;
    static final String NEWLINE = System.getProperty("line.separator");
    REProgram program;
    transient CharacterIterator search;
    int matchFlags;
    int maxParen = 16;
    transient int parenCount;
    transient int start0;
    transient int end0;
    transient int start1;
    transient int end1;
    transient int start2;
    transient int end2;
    transient int[] startn;
    transient int[] endn;
    transient int[] startBackref;
    transient int[] endBackref;
    public static final int REPLACE_ALL = 0;
    public static final int REPLACE_FIRSTONLY = 1;
    public static final int REPLACE_BACKREFERENCES = 2;

    public RE(String string) throws RESyntaxException {
        this(string, 0);
    }

    public RE(String string, int n2) throws RESyntaxException {
        this(new RECompiler().compile(string));
        this.setMatchFlags(n2);
    }

    public RE(REProgram rEProgram, int n2) {
        this.setProgram(rEProgram);
        this.setMatchFlags(n2);
    }

    public RE(REProgram rEProgram) {
        this(rEProgram, 0);
    }

    public RE() {
        this((REProgram)null, 0);
    }

    public static String simplePatternToFullRegularExpression(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            switch (c2) {
                case '*': {
                    stringBuffer.append(".*");
                    break;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    stringBuffer.append('\\');
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public void setMatchFlags(int n2) {
        this.matchFlags = n2;
    }

    public int getMatchFlags() {
        return this.matchFlags;
    }

    public void setProgram(REProgram rEProgram) {
        this.program = rEProgram;
        this.maxParen = rEProgram != null && rEProgram.maxParens != -1 ? rEProgram.maxParens : 16;
    }

    public REProgram getProgram() {
        return this.program;
    }

    public int getParenCount() {
        return this.parenCount;
    }

    public String getParen(int n2) {
        int n3;
        if (n2 < this.parenCount && (n3 = this.getParenStart(n2)) >= 0) {
            return this.search.substring(n3, this.getParenEnd(n2));
        }
        return null;
    }

    public final int getParenStart(int n2) {
        if (n2 < this.parenCount) {
            switch (n2) {
                case 0: {
                    return this.start0;
                }
                case 1: {
                    return this.start1;
                }
                case 2: {
                    return this.start2;
                }
            }
            if (this.startn == null) {
                this.allocParens();
            }
            return this.startn[n2];
        }
        return -1;
    }

    public final int getParenEnd(int n2) {
        if (n2 < this.parenCount) {
            switch (n2) {
                case 0: {
                    return this.end0;
                }
                case 1: {
                    return this.end1;
                }
                case 2: {
                    return this.end2;
                }
            }
            if (this.endn == null) {
                this.allocParens();
            }
            return this.endn[n2];
        }
        return -1;
    }

    public final int getParenLength(int n2) {
        if (n2 < this.parenCount) {
            return this.getParenEnd(n2) - this.getParenStart(n2);
        }
        return -1;
    }

    protected final void setParenStart(int n2, int n3) {
        if (n2 < this.parenCount) {
            switch (n2) {
                case 0: {
                    this.start0 = n3;
                    break;
                }
                case 1: {
                    this.start1 = n3;
                    break;
                }
                case 2: {
                    this.start2 = n3;
                    break;
                }
                default: {
                    if (this.startn == null) {
                        this.allocParens();
                    }
                    this.startn[n2] = n3;
                }
            }
        }
    }

    protected final void setParenEnd(int n2, int n3) {
        if (n2 < this.parenCount) {
            switch (n2) {
                case 0: {
                    this.end0 = n3;
                    break;
                }
                case 1: {
                    this.end1 = n3;
                    break;
                }
                case 2: {
                    this.end2 = n3;
                    break;
                }
                default: {
                    if (this.endn == null) {
                        this.allocParens();
                    }
                    this.endn[n2] = n3;
                }
            }
        }
    }

    protected void internalError(String string) throws Error {
        throw new Error("RE internal error: " + string);
    }

    private final void allocParens() {
        this.startn = new int[this.maxParen];
        this.endn = new int[this.maxParen];
        int n2 = 0;
        while (n2 < this.maxParen) {
            this.startn[n2] = -1;
            this.endn[n2] = -1;
            ++n2;
        }
    }

    protected int matchNodes(int n2, int n3, int n4) {
        int n5 = n4;
        char[] cArray = this.program.instruction;
        int n6 = n2;
        block50: while (n6 < n3) {
            char c2 = cArray[n6 + 0];
            int n7 = n6 + (short)cArray[n6 + 2];
            short s2 = cArray[n6 + 1];
            block0 : switch (c2) {
                case '/': {
                    char c3 = '\u0000';
                    do {
                        int n8;
                        if ((n8 = this.matchNodes(n7, 65536, n5)) == -1) continue;
                        return n8;
                    } while (c3++ == '\u0000' && (n5 = this.matchNodes(n6 + 3, n7, n5)) != -1);
                    return -1;
                }
                case '=': {
                    while ((n5 = this.matchNodes(n6 + 3, n7, n5)) != -1) {
                        int n9 = this.matchNodes(n7, 65536, n5);
                        if (n9 == -1) continue;
                        return n9;
                    }
                    return -1;
                }
                case '8': {
                    do {
                        int n10;
                        if ((n10 = this.matchNodes(n7, 65536, n5)) == -1) continue;
                        return n10;
                    } while ((n5 = this.matchNodes(n6 + 3, n7, n5)) != -1);
                    return -1;
                }
                case '(': {
                    int n11;
                    if ((this.program.flags & 1) != 0) {
                        this.startBackref[s2] = n5;
                    }
                    if ((n11 = this.matchNodes(n7, 65536, n5)) != -1) {
                        if (s2 + 1 > this.parenCount) {
                            this.parenCount = s2 + '\u0001';
                        }
                        if (this.getParenStart(s2) == -1) {
                            this.setParenStart(s2, n5);
                        }
                    }
                    return n11;
                }
                case ')': {
                    int n12;
                    if ((this.program.flags & 1) != 0) {
                        this.endBackref[s2] = n5;
                    }
                    if ((n12 = this.matchNodes(n7, 65536, n5)) != -1) {
                        if (s2 + 1 > this.parenCount) {
                            this.parenCount = s2 + '\u0001';
                        }
                        if (this.getParenEnd(s2) == -1) {
                            this.setParenEnd(s2, n5);
                        }
                    }
                    return n12;
                }
                case '<': 
                case '>': {
                    return this.matchNodes(n7, 65536, n5);
                }
                case '#': {
                    int n13;
                    char c3 = this.startBackref[s2];
                    short s3 = this.endBackref[s2];
                    if (c3 == '\uffffffff' || s3 == -1) {
                        return -1;
                    }
                    if (c3 == s3) break;
                    int n14 = s3 - c3;
                    if (this.search.isEnd(n5 + n14 - 1)) {
                        return -1;
                    }
                    if ((this.matchFlags & 1) != 0) {
                        n13 = 0;
                        while (n13 < n14) {
                            if (Character.toLowerCase(this.search.charAt(n5++)) != Character.toLowerCase(this.search.charAt(c3 + n13))) {
                                return -1;
                            }
                            ++n13;
                        }
                    } else {
                        n13 = 0;
                        while (n13 < n14) {
                            if (this.search.charAt(n5++) != this.search.charAt(c3 + n13)) {
                                return -1;
                            }
                            ++n13;
                        }
                    }
                    break;
                }
                case '^': {
                    if (n5 == 0) break;
                    if ((this.matchFlags & 2) == 2) {
                        if (n5 > 0 && this.isNewline(n5 - 1)) break;
                        return -1;
                    }
                    return -1;
                }
                case '$': {
                    if (this.search.isEnd(0) || this.search.isEnd(n5)) break;
                    if ((this.matchFlags & 2) == 2) {
                        if (this.isNewline(n5)) break;
                        return -1;
                    }
                    return -1;
                }
                case '\\': {
                    short s3;
                    char c3;
                    switch (s2) {
                        case 66: 
                        case 98: {
                            c3 = n5 == 0 ? (char)'\n' : (char)this.search.charAt(n5 - 1);
                            s3 = this.search.isEnd(n5) ? (short)10 : (short)this.search.charAt(n5);
                            if (Character.isLetterOrDigit(c3) == Character.isLetterOrDigit((char)s3) != (s2 == 98)) break block0;
                            return -1;
                        }
                        case 68: 
                        case 83: 
                        case 87: 
                        case 100: 
                        case 115: 
                        case 119: {
                            if (this.search.isEnd(n5)) {
                                return -1;
                            }
                            c3 = this.search.charAt(n5);
                            switch (s2) {
                                case 87: 
                                case 119: {
                                    if ((Character.isLetterOrDigit(c3) || c3 == '_') == (s2 == 119)) break;
                                    return -1;
                                }
                                case 68: 
                                case 100: {
                                    if (Character.isDigit(c3) == (s2 == 100)) break;
                                    return -1;
                                }
                                case 83: 
                                case 115: {
                                    if (Character.isWhitespace(c3) == (s2 == 115)) break;
                                    return -1;
                                }
                            }
                            ++n5;
                            break;
                        }
                        default: {
                            this.internalError("Unrecognized escape '" + s2 + "'");
                            break;
                        }
                    }
                    break;
                }
                case '.': {
                    if ((this.matchFlags & 4) == 4) {
                        if (this.search.isEnd(n5)) {
                            return -1;
                        }
                        ++n5;
                        break;
                    }
                    if (!this.search.isEnd(n5) && this.search.charAt(n5++) != '\n') break;
                    return -1;
                }
                case 'A': {
                    int n13;
                    if (this.search.isEnd(n5)) {
                        return -1;
                    }
                    short s3 = s2;
                    int n14 = n6 + 3;
                    if (this.search.isEnd(s3 + n5 - 1)) {
                        return -1;
                    }
                    if ((this.matchFlags & 1) != 0) {
                        n13 = 0;
                        while (n13 < s3) {
                            if (Character.toLowerCase(this.search.charAt(n5++)) != Character.toLowerCase(cArray[n14 + n13])) {
                                return -1;
                            }
                            ++n13;
                        }
                    } else {
                        n13 = 0;
                        while (n13 < s3) {
                            if (this.search.charAt(n5++) != cArray[n14 + n13]) {
                                return -1;
                            }
                            ++n13;
                        }
                    }
                    break;
                }
                case 'P': {
                    short s3;
                    if (this.search.isEnd(n5)) {
                        return -1;
                    }
                    block28 : switch (s2) {
                        case 119: {
                            if (Character.isLetterOrDigit(this.search.charAt(n5))) break;
                            return -1;
                        }
                        case 97: {
                            if (Character.isLetter(this.search.charAt(n5))) break;
                            return -1;
                        }
                        case 100: {
                            if (Character.isDigit(this.search.charAt(n5))) break;
                            return -1;
                        }
                        case 98: {
                            if (Character.isSpaceChar(this.search.charAt(n5))) break;
                            return -1;
                        }
                        case 115: {
                            if (Character.isWhitespace(this.search.charAt(n5))) break;
                            return -1;
                        }
                        case 99: {
                            if (Character.getType(this.search.charAt(n5)) == 15) break;
                            return -1;
                        }
                        case 103: {
                            switch (Character.getType(this.search.charAt(n5))) {
                                case 25: 
                                case 26: 
                                case 27: 
                                case 28: {
                                    break block28;
                                }
                            }
                            return -1;
                        }
                        case 108: {
                            if (Character.getType(this.search.charAt(n5)) == 2) break;
                            return -1;
                        }
                        case 117: {
                            if (Character.getType(this.search.charAt(n5)) == 1) break;
                            return -1;
                        }
                        case 112: {
                            if (Character.getType(this.search.charAt(n5)) != 15) break;
                            return -1;
                        }
                        case 33: {
                            s3 = Character.getType(this.search.charAt(n5));
                            switch (s3) {
                                case 20: 
                                case 21: 
                                case 22: 
                                case 23: 
                                case 24: {
                                    break block28;
                                }
                            }
                            return -1;
                        }
                        case 120: {
                            short s4 = s3 = this.search.charAt(n5) >= '0' && this.search.charAt(n5) <= '9' || this.search.charAt(n5) >= 'a' && this.search.charAt(n5) <= 'f' || this.search.charAt(n5) >= 'A' && this.search.charAt(n5) <= 'F' ? (short)1 : 0;
                            if (s3 != 0) break;
                            return -1;
                        }
                        case 106: {
                            if (Character.isJavaIdentifierStart(this.search.charAt(n5))) break;
                            return -1;
                        }
                        case 107: {
                            if (Character.isJavaIdentifierPart(this.search.charAt(n5))) break;
                            return -1;
                        }
                        default: {
                            this.internalError("Bad posix class");
                        }
                    }
                    ++n5;
                    break;
                }
                case '[': {
                    int n14;
                    if (this.search.isEnd(n5)) {
                        return -1;
                    }
                    short s3 = (short)this.search.charAt(n5);
                    int n15 = n14 = (this.matchFlags & 1) != 0 ? 1 : 0;
                    if (n14 != 0) {
                        s3 = Character.toLowerCase((char)s3);
                    }
                    int n13 = n6 + 3;
                    int n16 = n13 + s2 * 2;
                    boolean bl2 = false;
                    int n17 = n13;
                    while (n17 < n16) {
                        char c4 = cArray[n17++];
                        char c5 = cArray[n17++];
                        if (n14 != 0) {
                            c4 = Character.toLowerCase(c4);
                            c5 = Character.toLowerCase(c5);
                        }
                        if (s3 < c4 || s3 > c5) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        return -1;
                    }
                    ++n5;
                    break;
                }
                case '|': {
                    short s3;
                    if (cArray[n7 + 0] != '|') {
                        n6 += 3;
                        continue block50;
                    }
                    do {
                        int n18;
                        if ((n18 = this.matchNodes(n6 + 3, 65536, n5)) == -1) continue;
                        return n18;
                    } while ((s3 = (short)cArray[n6 + 2]) != 0 && cArray[(n6 += s3) + 0] == '|');
                    return -1;
                }
                case 'G': 
                case 'N': {
                    break;
                }
                case 'E': {
                    this.setParenEnd(0, n5);
                    return n5;
                }
                default: {
                    this.internalError("Invalid opcode '" + c2 + "'");
                }
            }
            n6 = n7;
        }
        this.internalError("Corrupt program");
        return -1;
    }

    protected boolean matchAt(int n2) {
        int n3;
        this.start0 = -1;
        this.end0 = -1;
        this.start1 = -1;
        this.end1 = -1;
        this.start2 = -1;
        this.end2 = -1;
        this.startn = null;
        this.endn = null;
        this.parenCount = 1;
        this.setParenStart(0, n2);
        if ((this.program.flags & 1) != 0) {
            this.startBackref = new int[this.maxParen];
            this.endBackref = new int[this.maxParen];
        }
        if ((n3 = this.matchNodes(0, 65536, n2)) != -1) {
            this.setParenEnd(0, n3);
            return true;
        }
        this.parenCount = 0;
        return false;
    }

    public boolean match(String string, int n2) {
        return this.match(new StringCharacterIterator(string), n2);
    }

    public boolean match(CharacterIterator characterIterator, int n2) {
        if (this.program == null) {
            this.internalError("No RE program to run!");
        }
        this.search = characterIterator;
        if (this.program.prefix == null) {
            while (!characterIterator.isEnd(n2 - 1)) {
                if (this.matchAt(n2)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        boolean bl2 = (this.matchFlags & 1) != 0;
        char[] cArray = this.program.prefix;
        while (!characterIterator.isEnd(n2 + cArray.length - 1)) {
            boolean bl3 = false;
            if (bl2) {
                bl3 = Character.toLowerCase(characterIterator.charAt(n2)) == Character.toLowerCase(cArray[0]);
            } else {
                boolean bl4 = bl3 = characterIterator.charAt(n2) == cArray[0];
            }
            if (bl3) {
                int n3 = n2++;
                int n4 = 1;
                while (n4 < cArray.length) {
                    if (bl2) {
                        bl3 = Character.toLowerCase(characterIterator.charAt(n2++)) == Character.toLowerCase(cArray[n4++]);
                    } else {
                        boolean bl5 = bl3 = characterIterator.charAt(n2++) == cArray[n4++];
                    }
                    if (!bl3) break;
                }
                if (n4 == cArray.length && this.matchAt(n3)) {
                    return true;
                }
                n2 = n3;
            }
            ++n2;
        }
        return false;
    }

    public boolean match(String string) {
        return this.match(string, 0);
    }

    public String[] split(String string) {
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3 && this.match(string, n2)) {
            int n4 = this.getParenStart(0);
            int n5 = this.getParenEnd(0);
            if (n5 == n2) {
                vector.addElement(string.substring(n2, n4 + 1));
            } else {
                vector.addElement(string.substring(n2, n4));
            }
            n2 = ++n5;
        }
        String string2 = string.substring(n2);
        if (string2.length() != 0) {
            vector.addElement(string2);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String subst(String string, String string2) {
        return this.subst(string, string2, 0);
    }

    public String subst(String string, String string2, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        int n4 = string.length();
        while (n3 < n4 && this.match(string, n3)) {
            int n5;
            stringBuffer.append(string.substring(n3, this.getParenStart(0)));
            if ((n2 & 2) != 0) {
                n5 = 0;
                int n6 = 0;
                int n7 = string2.length();
                while ((n5 = string2.indexOf("$", n5)) >= 0) {
                    char c2;
                    if ((n5 == 0 || string2.charAt(n5 - 1) != '\\') && n5 + 1 < n7 && (c2 = string2.charAt(n5 + 1)) >= '0' && c2 <= '9') {
                        stringBuffer.append(string2.substring(n6 + 2, n5));
                        stringBuffer.append(this.getParen(c2 - 48));
                        n6 = n5;
                    }
                    ++n5;
                }
                stringBuffer.append(string2.substring(n6 + 2, n7));
            } else {
                stringBuffer.append(string2);
            }
            n5 = this.getParenEnd(0);
            if (n5 == n3) {
                // empty if block
            }
            n3 = ++n5;
            if ((n2 & 1) != 0) break;
        }
        if (n3 < n4) {
            stringBuffer.append(string.substring(n3));
        }
        return stringBuffer.toString();
    }

    public String[] grep(Object[] objectArray) {
        Object object;
        Vector<Object[]> vector = new Vector<Object[]>();
        int n2 = 0;
        while (n2 < objectArray.length) {
            object = objectArray[n2].toString();
            if (this.match((String)object)) {
                vector.addElement((Object[])object);
            }
            ++n2;
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    private boolean isNewline(int n2) {
        if (n2 < NEWLINE.length() - 1) {
            return false;
        }
        if (this.search.charAt(n2) == '\n') {
            return true;
        }
        int n3 = NEWLINE.length() - 1;
        while (n3 >= 0) {
            if (NEWLINE.charAt(n3) != this.search.charAt(n2)) {
                return false;
            }
            --n3;
            --n2;
        }
        return true;
    }
}

