/*
 * Decompiled with CFR 0.152.
 */
package org.apache.regexp;

import java.util.Hashtable;
import org.apache.regexp.REProgram;
import org.apache.regexp.RESyntaxException;

public class RECompiler {
    char[] instruction = new char[128];
    int lenInstruction = 0;
    String pattern;
    int len;
    int idx;
    int parens;
    static final int NODE_NORMAL = 0;
    static final int NODE_NULLABLE = 1;
    static final int NODE_TOPLEVEL = 2;
    static final char ESC_MASK = '\ufff0';
    static final char ESC_BACKREF = '\uffff';
    static final char ESC_COMPLEX = '\ufffe';
    static final char ESC_CLASS = '\ufffd';
    int maxBrackets = 10;
    static final int bracketUnbounded = -1;
    int brackets = 0;
    int[] bracketStart = null;
    int[] bracketEnd = null;
    int[] bracketMin = null;
    int[] bracketOpt = null;
    static Hashtable hashPOSIX = new Hashtable();

    void ensure(int n2) {
        int n3 = this.instruction.length;
        if (this.lenInstruction + n2 >= n3) {
            while (this.lenInstruction + n2 >= n3) {
                n3 *= 2;
            }
            char[] cArray = new char[n3];
            System.arraycopy(this.instruction, 0, cArray, 0, this.lenInstruction);
            this.instruction = cArray;
        }
    }

    void emit(char c2) {
        this.ensure(1);
        this.instruction[this.lenInstruction++] = c2;
    }

    void nodeInsert(char c2, int n2, int n3) {
        this.ensure(3);
        System.arraycopy(this.instruction, n3, this.instruction, n3 + 3, this.lenInstruction - n3);
        this.instruction[n3 + 0] = c2;
        this.instruction[n3 + 1] = (char)n2;
        this.instruction[n3 + 2] = '\u0000';
        this.lenInstruction += 3;
    }

    void setNextOfEnd(int n2, int n3) {
        char c2 = this.instruction[n2 + 2];
        while (c2 != '\u0000' && n2 < this.lenInstruction) {
            if (n2 == n3) {
                n3 = this.lenInstruction;
            }
            c2 = this.instruction[(n2 += c2) + 2];
        }
        if (n2 < this.lenInstruction) {
            this.instruction[n2 + 2] = (char)(n3 - n2);
        }
    }

    int node(char c2, int n2) {
        this.ensure(3);
        this.instruction[this.lenInstruction + 0] = c2;
        this.instruction[this.lenInstruction + 1] = (char)n2;
        this.instruction[this.lenInstruction + 2] = '\u0000';
        this.lenInstruction += 3;
        return this.lenInstruction - 3;
    }

    void internalError() throws Error {
        throw new Error("Internal error!");
    }

    void syntaxError(String string) throws RESyntaxException {
        throw new RESyntaxException(string);
    }

    void allocBrackets() {
        if (this.bracketStart == null) {
            this.bracketStart = new int[this.maxBrackets];
            this.bracketEnd = new int[this.maxBrackets];
            this.bracketMin = new int[this.maxBrackets];
            this.bracketOpt = new int[this.maxBrackets];
            int n2 = 0;
            while (n2 < this.maxBrackets) {
                this.bracketOpt[n2] = -1;
                this.bracketMin[n2] = -1;
                this.bracketEnd[n2] = -1;
                this.bracketStart[n2] = -1;
                ++n2;
            }
        }
    }

    synchronized void reallocBrackets() {
        if (this.bracketStart == null) {
            this.allocBrackets();
        }
        int n2 = this.maxBrackets * 2;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[n2];
        int n3 = this.brackets;
        while (n3 < n2) {
            nArray4[n3] = -1;
            nArray3[n3] = -1;
            nArray2[n3] = -1;
            nArray[n3] = -1;
            ++n3;
        }
        System.arraycopy(this.bracketStart, 0, nArray, 0, this.brackets);
        System.arraycopy(this.bracketEnd, 0, nArray2, 0, this.brackets);
        System.arraycopy(this.bracketMin, 0, nArray3, 0, this.brackets);
        System.arraycopy(this.bracketOpt, 0, nArray4, 0, this.brackets);
        this.bracketStart = nArray;
        this.bracketEnd = nArray2;
        this.bracketMin = nArray3;
        this.bracketOpt = nArray4;
        this.maxBrackets = n2;
    }

    void bracket() throws RESyntaxException {
        if (this.idx >= this.len || this.pattern.charAt(this.idx++) != '{') {
            this.internalError();
        }
        if (this.idx >= this.len || !Character.isDigit(this.pattern.charAt(this.idx))) {
            this.syntaxError("Expected digit");
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (this.idx < this.len && Character.isDigit(this.pattern.charAt(this.idx))) {
            stringBuffer.append(this.pattern.charAt(this.idx++));
        }
        try {
            this.bracketMin[this.brackets] = Integer.parseInt(stringBuffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            this.syntaxError("Expected valid number");
        }
        if (this.idx >= this.len) {
            this.syntaxError("Expected comma or right bracket");
        }
        if (this.pattern.charAt(this.idx) == '}') {
            ++this.idx;
            this.bracketOpt[this.brackets] = 0;
            return;
        }
        if (this.idx >= this.len || this.pattern.charAt(this.idx++) != ',') {
            this.syntaxError("Expected comma");
        }
        if (this.idx >= this.len) {
            this.syntaxError("Expected comma or right bracket");
        }
        if (this.pattern.charAt(this.idx) == '}') {
            ++this.idx;
            this.bracketOpt[this.brackets] = -1;
            return;
        }
        if (this.idx >= this.len || !Character.isDigit(this.pattern.charAt(this.idx))) {
            this.syntaxError("Expected digit");
        }
        stringBuffer.setLength(0);
        while (this.idx < this.len && Character.isDigit(this.pattern.charAt(this.idx))) {
            stringBuffer.append(this.pattern.charAt(this.idx++));
        }
        try {
            this.bracketOpt[this.brackets] = Integer.parseInt(stringBuffer.toString()) - this.bracketMin[this.brackets];
        }
        catch (NumberFormatException numberFormatException) {
            this.syntaxError("Expected valid number");
        }
        if (this.bracketOpt[this.brackets] < 0) {
            this.syntaxError("Bad range");
        }
        if (this.idx >= this.len || this.pattern.charAt(this.idx++) != '}') {
            this.syntaxError("Missing close brace");
        }
    }

    char escape() throws RESyntaxException {
        if (this.pattern.charAt(this.idx) != '\\') {
            this.internalError();
        }
        if (this.idx + 1 == this.len) {
            this.syntaxError("Escape terminates string");
        }
        this.idx += 2;
        char c2 = this.pattern.charAt(this.idx - 1);
        switch (c2) {
            case 'B': 
            case 'b': {
                return '\ufffe';
            }
            case 'D': 
            case 'S': 
            case 'W': 
            case 'd': 
            case 's': 
            case 'w': {
                return '\ufffd';
            }
            case 'u': 
            case 'x': {
                int n2 = c2 == 'u' ? 4 : 2;
                int n3 = 0;
                while (this.idx < this.len && n2-- > 0) {
                    char c3 = this.pattern.charAt(this.idx);
                    if (c3 >= '0' && c3 <= '9') {
                        n3 = (n3 << 4) + c3 - 48;
                    } else if ((c3 = Character.toLowerCase(c3)) >= 'a' && c3 <= 'f') {
                        n3 = (n3 << 4) + (c3 - 97) + 10;
                    } else {
                        this.syntaxError("Expected " + n2 + " hexadecimal digits after \\" + c2);
                    }
                    ++this.idx;
                }
                return (char)n3;
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                if (this.idx < this.len && Character.isDigit(this.pattern.charAt(this.idx)) || c2 == '0') {
                    int n4 = c2 - 48;
                    if (this.idx < this.len && Character.isDigit(this.pattern.charAt(this.idx))) {
                        n4 = (n4 << 3) + (this.pattern.charAt(this.idx++) - 48);
                        if (this.idx < this.len && Character.isDigit(this.pattern.charAt(this.idx))) {
                            n4 = (n4 << 3) + (this.pattern.charAt(this.idx++) - 48);
                        }
                    }
                    return (char)n4;
                }
                return '\uffff';
            }
        }
        return c2;
    }

    int characterClass() throws RESyntaxException {
        int n2;
        int n3;
        int n4;
        if (this.pattern.charAt(this.idx) != '[') {
            this.internalError();
        }
        if (this.idx + 1 >= this.len || this.pattern.charAt(++this.idx) == ']') {
            this.syntaxError("Empty or unterminated class");
        }
        if (this.idx < this.len && this.pattern.charAt(this.idx) == ':') {
            ++this.idx;
            n4 = this.idx;
            while (this.idx < this.len && this.pattern.charAt(this.idx) >= 'a' && this.pattern.charAt(this.idx) <= 'z') {
                ++this.idx;
            }
            if (this.idx + 1 < this.len && this.pattern.charAt(this.idx) == ':' && this.pattern.charAt(this.idx + 1) == ']') {
                String string = this.pattern.substring(n4, this.idx);
                Character c2 = (Character)hashPOSIX.get(string);
                if (c2 != null) {
                    this.idx += 2;
                    return this.node('P', c2.charValue());
                }
                this.syntaxError("Invalid POSIX character class '" + string + "'");
            }
            this.syntaxError("Invalid POSIX character class syntax");
        }
        n4 = this.node('[', 0);
        int n5 = n3 = 65535;
        int n6 = 0;
        boolean bl2 = true;
        boolean bl3 = false;
        int n7 = this.idx;
        int n8 = 0;
        RERange rERange = new RERange();
        block16: while (this.idx < this.len && this.pattern.charAt(this.idx) != ']') {
            switch (this.pattern.charAt(this.idx)) {
                case '^': {
                    boolean bl4 = bl2 = !bl2;
                    if (this.idx == n7) {
                        rERange.include(0, 65535, true);
                    }
                    ++this.idx;
                    continue block16;
                }
                case '\\': {
                    n2 = this.escape();
                    switch (n2) {
                        case 65534: 
                        case 65535: {
                            this.syntaxError("Bad character class");
                        }
                        case 65533: {
                            if (bl3) {
                                this.syntaxError("Bad character class");
                            }
                            switch (this.pattern.charAt(this.idx - 1)) {
                                case 'D': 
                                case 'S': 
                                case 'W': {
                                    this.syntaxError("Bad character class");
                                }
                                case 's': {
                                    rERange.include('\t', bl2);
                                    rERange.include('\r', bl2);
                                    rERange.include('\f', bl2);
                                    rERange.include('\n', bl2);
                                    rERange.include('\b', bl2);
                                    rERange.include(' ', bl2);
                                    break;
                                }
                                case 'w': {
                                    rERange.include(97, 122, bl2);
                                    rERange.include(65, 90, bl2);
                                    rERange.include('_', bl2);
                                }
                                case 'd': {
                                    rERange.include(48, 57, bl2);
                                }
                            }
                            n5 = n3;
                            continue block16;
                        }
                        default: {
                            n6 = n2;
                            break;
                        }
                    }
                    break;
                }
                case '-': {
                    if (bl3) {
                        this.syntaxError("Bad class range");
                    }
                    bl3 = true;
                    int n9 = n8 = n5 == n3 ? 0 : n5;
                    if (this.idx + 1 >= this.len || this.pattern.charAt(++this.idx) != ']') continue block16;
                    n6 = 65535;
                    break;
                }
                default: {
                    n6 = this.pattern.charAt(this.idx++);
                }
            }
            if (bl3) {
                int n10 = n6;
                if (n8 >= n10) {
                    this.syntaxError("Bad character class");
                }
                rERange.include(n8, n10, bl2);
                n5 = n3;
                bl3 = false;
                continue;
            }
            if (this.idx >= this.len || this.pattern.charAt(this.idx) != '-') {
                rERange.include((char)n6, bl2);
            }
            n5 = n6;
        }
        if (this.idx == this.len) {
            this.syntaxError("Unterminated character class");
        }
        ++this.idx;
        this.instruction[n4 + 1] = (char)rERange.num;
        n2 = 0;
        while (n2 < rERange.num) {
            this.emit((char)rERange.minRange[n2]);
            this.emit((char)rERange.maxRange[n2]);
            ++n2;
        }
        return n4;
    }

    /*
     * Unable to fully structure code
     */
    int atom() throws RESyntaxException {
        var1_1 = this.node('A', 0);
        var2_2 = 0;
        block8: while (this.idx < this.len) {
            if (this.idx + 1 >= this.len) ** GOTO lbl-1000
            var3_3 = this.pattern.charAt(this.idx + 1);
            if (this.pattern.charAt(this.idx) == '\\') {
                var4_4 = this.idx;
                this.escape();
                if (this.idx < this.len) {
                    var3_3 = this.pattern.charAt(this.idx);
                }
                this.idx = var4_4;
            }
            block0 : switch (var3_3) {
                case 42: 
                case 43: 
                case 63: 
                case 123: {
                    if (var2_2 != 0) break block8;
                }
                default: lbl-1000:
                // 2 sources

                {
                    switch (this.pattern.charAt(this.idx)) {
                        case '$': 
                        case '(': 
                        case ')': 
                        case '.': 
                        case '[': 
                        case ']': 
                        case '^': 
                        case '|': {
                            break block8;
                        }
                        case '*': 
                        case '+': 
                        case '?': 
                        case '{': {
                            if (var2_2 != 0) break block8;
                            this.syntaxError("Missing operand to closure");
                            break block8;
                        }
                        case '\\': {
                            var3_3 = this.idx;
                            var4_4 = this.escape();
                            if ((var4_4 & 65520) == 65520) {
                                this.idx = var3_3;
                                break block8;
                            }
                            this.emit((char)var4_4);
                            ++var2_2;
                            break block0;
                        }
                        default: {
                            this.emit(this.pattern.charAt(this.idx++));
                            ++var2_2;
                        }
                    }
                }
            }
        }
        if (var2_2 == 0) {
            this.internalError();
        }
        this.instruction[var1_1 + 1] = (char)var2_2;
        return var1_1;
    }

    int terminal(int[] nArray) throws RESyntaxException {
        switch (this.pattern.charAt(this.idx)) {
            case '$': 
            case '.': 
            case '^': {
                return this.node(this.pattern.charAt(this.idx++), 0);
            }
            case '[': {
                return this.characterClass();
            }
            case '(': {
                return this.expr(nArray);
            }
            case ')': {
                this.syntaxError("Unexpected close paren");
            }
            case '|': {
                this.internalError();
            }
            case ']': {
                this.syntaxError("Mismatched class");
            }
            case '\u0000': {
                this.syntaxError("Unexpected end of input");
            }
            case '*': 
            case '+': 
            case '?': 
            case '{': {
                this.syntaxError("Missing operand to closure");
            }
            case '\\': {
                int n2 = this.idx;
                switch (this.escape()) {
                    case '\ufffd': 
                    case '\ufffe': {
                        nArray[0] = nArray[0] & 0xFFFFFFFE;
                        return this.node('\\', this.pattern.charAt(this.idx - 1));
                    }
                    case '\uffff': {
                        char c2 = (char)(this.pattern.charAt(this.idx - 1) - 48);
                        if (this.parens <= c2) {
                            this.syntaxError("Bad backreference");
                        }
                        nArray[0] = nArray[0] | 1;
                        return this.node('#', c2);
                    }
                }
                this.idx = n2;
                nArray[0] = nArray[0] & 0xFFFFFFFE;
            }
        }
        nArray[0] = nArray[0] & 0xFFFFFFFE;
        return this.atom();
    }

    /*
     * Enabled aggressive block sorting
     */
    int closure(int[] nArray) throws RESyntaxException {
        int n2 = this.idx;
        int[] nArray2 = new int[]{0};
        int n3 = this.terminal(nArray2);
        nArray[0] = nArray[0] | nArray2[0];
        if (this.idx >= this.len) {
            return n3;
        }
        boolean bl2 = true;
        int n4 = this.pattern.charAt(this.idx);
        switch (n4) {
            case 42: 
            case 63: {
                nArray[0] = nArray[0] | 1;
            }
            case 43: {
                ++this.idx;
            }
            case 123: {
                char c2 = this.instruction[n3 + 0];
                if (c2 == '^' || c2 == '$') {
                    this.syntaxError("Bad closure operand");
                }
                if ((nArray2[0] & 1) == 0) break;
                this.syntaxError("Closure operand can't be nullable");
                break;
            }
        }
        if (this.idx < this.len && this.pattern.charAt(this.idx) == '?') {
            ++this.idx;
            bl2 = false;
        }
        if (bl2) {
            switch (n4) {
                case 123: {
                    int n5 = 0;
                    this.allocBrackets();
                    int n6 = 0;
                    while (n6 < this.brackets) {
                        if (this.bracketStart[n6] == this.idx) {
                            n5 = 1;
                            break;
                        }
                        ++n6;
                    }
                    if (n5 == 0) {
                        if (this.brackets >= this.maxBrackets) {
                            this.reallocBrackets();
                        }
                        this.bracketStart[this.brackets] = this.idx;
                        this.bracket();
                        this.bracketEnd[this.brackets] = this.idx;
                        n6 = this.brackets++;
                    }
                    int n7 = n6;
                    int n8 = this.bracketMin[n7];
                    this.bracketMin[n7] = n8 - 1;
                    if (n8 > 0) {
                        if (this.bracketMin[n6] <= 0 && this.bracketOpt[n6] == 0) {
                            this.idx = this.bracketEnd[n6];
                            return n3;
                        }
                        this.idx = n2;
                        return n3;
                    }
                    if (this.bracketOpt[n6] == -1) {
                        n4 = 42;
                        this.bracketOpt[n6] = 0;
                        this.idx = this.bracketEnd[n6];
                    } else {
                        int n9 = n6;
                        int n10 = this.bracketOpt[n9];
                        this.bracketOpt[n9] = n10 - 1;
                        if (n10 <= 0) {
                            this.lenInstruction = n3;
                            this.node('N', 0);
                            this.idx = this.bracketEnd[n6];
                            return n3;
                        }
                        this.idx = this.bracketOpt[n6] > 0 ? n2 : this.bracketEnd[n6];
                        n4 = 63;
                    }
                }
                case 42: 
                case 63: {
                    int n5;
                    if (!bl2) {
                        return n3;
                    }
                    if (n4 == 63) {
                        this.nodeInsert('|', 0, n3);
                        this.setNextOfEnd(n3, this.node('|', 0));
                        n5 = this.node('N', 0);
                        this.setNextOfEnd(n3, n5);
                        this.setNextOfEnd(n3 + 3, n5);
                    }
                    if (n4 != 42) return n3;
                    this.nodeInsert('|', 0, n3);
                    this.setNextOfEnd(n3 + 3, this.node('|', 0));
                    this.setNextOfEnd(n3 + 3, this.node('G', 0));
                    this.setNextOfEnd(n3 + 3, n3);
                    this.setNextOfEnd(n3, this.node('|', 0));
                    this.setNextOfEnd(n3, this.node('N', 0));
                    return n3;
                }
                case 43: {
                    int n11 = this.node('|', 0);
                    this.setNextOfEnd(n3, n11);
                    this.setNextOfEnd(this.node('G', 0), n3);
                    this.setNextOfEnd(n11, this.node('|', 0));
                    this.setNextOfEnd(n3, this.node('N', 0));
                    return n3;
                }
            }
            return n3;
        }
        this.setNextOfEnd(n3, this.node('E', 0));
        switch (n4) {
            case 63: {
                this.nodeInsert('/', 0, n3);
                break;
            }
            case 42: {
                this.nodeInsert('8', 0, n3);
                break;
            }
            case 43: {
                this.nodeInsert('=', 0, n3);
                break;
            }
        }
        this.setNextOfEnd(n3, this.lenInstruction);
        return n3;
    }

    int branch(int[] nArray) throws RESyntaxException {
        int n2 = this.node('|', 0);
        int n3 = -1;
        int[] nArray2 = new int[1];
        boolean bl2 = true;
        while (this.idx < this.len && this.pattern.charAt(this.idx) != '|' && this.pattern.charAt(this.idx) != ')') {
            nArray2[0] = 0;
            int n4 = this.closure(nArray2);
            if (nArray2[0] == 0) {
                bl2 = false;
            }
            if (n3 != -1) {
                this.setNextOfEnd(n3, n4);
            }
            n3 = n4;
        }
        if (n3 == -1) {
            this.node('N', 0);
        }
        if (bl2) {
            nArray[0] = nArray[0] | 1;
        }
        return n2;
    }

    int expr(int[] nArray) throws RESyntaxException {
        int n2;
        int n3 = -1;
        int n4 = -1;
        int n5 = this.parens;
        if ((nArray[0] & 2) == 0 && this.pattern.charAt(this.idx) == '(') {
            if (this.idx + 2 < this.len && this.pattern.charAt(this.idx + 1) == '?' && this.pattern.charAt(this.idx + 2) == ':') {
                n3 = 2;
                this.idx += 3;
                n4 = this.node('<', 0);
            } else {
                n3 = 1;
                ++this.idx;
                n4 = this.node('(', this.parens++);
            }
        }
        nArray[0] = nArray[0] & 0xFFFFFFFD;
        int n6 = this.branch(nArray);
        if (n4 == -1) {
            n4 = n6;
        } else {
            this.setNextOfEnd(n4, n6);
        }
        while (this.idx < this.len && this.pattern.charAt(this.idx) == '|') {
            ++this.idx;
            n6 = this.branch(nArray);
            this.setNextOfEnd(n4, n6);
        }
        if (n3 > 0) {
            if (this.idx < this.len && this.pattern.charAt(this.idx) == ')') {
                ++this.idx;
            } else {
                this.syntaxError("Missing close paren");
            }
            n2 = n3 == 1 ? this.node(')', n5) : this.node('>', 0);
        } else {
            n2 = this.node('E', 0);
        }
        this.setNextOfEnd(n4, n2);
        int n7 = n4;
        char c2 = this.instruction[n7 + 2];
        while (c2 != '\u0000' && n7 < this.lenInstruction) {
            if (this.instruction[n7 + 0] == '|') {
                this.setNextOfEnd(n7 + 3, n2);
            }
            c2 = this.instruction[n7 + 2];
            n7 += c2;
        }
        return n4;
    }

    public REProgram compile(String string) throws RESyntaxException {
        this.pattern = string;
        this.len = string.length();
        this.idx = 0;
        this.lenInstruction = 0;
        this.parens = 1;
        this.brackets = 0;
        int[] nArray = new int[]{2};
        this.expr(nArray);
        if (this.idx != this.len) {
            if (string.charAt(this.idx) == ')') {
                this.syntaxError("Unmatched close paren");
            }
            this.syntaxError("Unexpected input remains");
        }
        char[] cArray = new char[this.lenInstruction];
        System.arraycopy(this.instruction, 0, cArray, 0, this.lenInstruction);
        return new REProgram(this.parens, cArray);
    }

    static {
        hashPOSIX.put("alnum", new Character('w'));
        hashPOSIX.put("alpha", new Character('a'));
        hashPOSIX.put("blank", new Character('b'));
        hashPOSIX.put("cntrl", new Character('c'));
        hashPOSIX.put("digit", new Character('d'));
        hashPOSIX.put("graph", new Character('g'));
        hashPOSIX.put("lower", new Character('l'));
        hashPOSIX.put("print", new Character('p'));
        hashPOSIX.put("punct", new Character('!'));
        hashPOSIX.put("space", new Character('s'));
        hashPOSIX.put("upper", new Character('u'));
        hashPOSIX.put("xdigit", new Character('x'));
        hashPOSIX.put("javastart", new Character('j'));
        hashPOSIX.put("javapart", new Character('k'));
    }

    class RERange {
        int size = 16;
        int[] minRange = new int[this.size];
        int[] maxRange = new int[this.size];
        int num = 0;

        RERange() {
        }

        /*
         * Unable to fully structure code
         */
        void delete(int var1_1) {
            if (this.num != 0 && var1_1 < this.num) ** GOTO lbl6
            return;
lbl-1000:
            // 1 sources

            {
                if (var1_1 - 1 < 0) continue;
                this.minRange[var1_1 - 1] = this.minRange[var1_1];
                this.maxRange[var1_1 - 1] = this.maxRange[var1_1];
lbl6:
                // 3 sources

                ** while (++var1_1 < this.num)
            }
lbl7:
            // 1 sources

            --this.num;
        }

        void merge(int n2, int n3) {
            int n4 = 0;
            while (n4 < this.num) {
                if (n2 >= this.minRange[n4] && n3 <= this.maxRange[n4]) {
                    return;
                }
                if (n2 <= this.minRange[n4] && n3 >= this.maxRange[n4]) {
                    this.delete(n4);
                    this.merge(n2, n3);
                    return;
                }
                if (n2 >= this.minRange[n4] && n2 <= this.maxRange[n4]) {
                    this.delete(n4);
                    n2 = this.minRange[n4];
                    this.merge(n2, n3);
                    return;
                }
                if (n3 >= this.minRange[n4] && n3 <= this.maxRange[n4]) {
                    this.delete(n4);
                    n3 = this.maxRange[n4];
                    this.merge(n2, n3);
                    return;
                }
                ++n4;
            }
            if (this.num >= this.size) {
                this.size *= 2;
                int[] nArray = new int[this.size];
                int[] nArray2 = new int[this.size];
                System.arraycopy(this.minRange, 0, nArray, 0, this.num);
                System.arraycopy(this.maxRange, 0, nArray2, 0, this.num);
                this.minRange = nArray;
                this.maxRange = nArray2;
            }
            this.minRange[this.num] = n2;
            this.maxRange[this.num] = n3;
            ++this.num;
        }

        void remove(int n2, int n3) {
            int n4 = 0;
            while (n4 < this.num) {
                if (this.minRange[n4] >= n2 && this.maxRange[n4] <= n3) {
                    this.delete(n4);
                    --n4;
                    return;
                }
                if (n2 >= this.minRange[n4] && n3 <= this.maxRange[n4]) {
                    int n5 = this.minRange[n4];
                    int n6 = this.maxRange[n4];
                    this.delete(n4);
                    if (n5 < n2) {
                        this.merge(n5, n2 - 1);
                    }
                    if (n3 < n6) {
                        this.merge(n3 + 1, n6);
                    }
                    return;
                }
                if (this.minRange[n4] >= n2 && this.minRange[n4] <= n3) {
                    this.minRange[n4] = n3 + 1;
                    return;
                }
                if (this.maxRange[n4] >= n2 && this.maxRange[n4] <= n3) {
                    this.maxRange[n4] = n2 - 1;
                    return;
                }
                ++n4;
            }
        }

        void include(int n2, int n3, boolean bl2) {
            if (bl2) {
                this.merge(n2, n3);
            } else {
                this.remove(n2, n3);
            }
        }

        void include(char c2, boolean bl2) {
            this.include(c2, c2, bl2);
        }
    }
}

