/*
 * Decompiled with CFR 0.152.
 */
package org.apache.regexp;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import org.apache.regexp.RE;
import org.apache.regexp.REDebugCompiler;
import org.apache.regexp.REProgram;

public class RETest {
    static final boolean showSuccesses = false;
    static final String NEW_LINE = System.getProperty("line.separator");
    RE r = new RE();
    REDebugCompiler compiler = new REDebugCompiler();
    char[] re1Instructions = new char[]{'|', '\u0000', '\u001a', '|', '\u0000', '\r', 'A', '\u0001', '\u0004', 'a', '|', '\u0000', '\u0003', 'G', '\u0000', '\ufff6', '|', '\u0000', '\u0003', 'N', '\u0000', '\u0003', 'A', '\u0001', '\u0004', 'b', 'E', '\u0000', '\u0000'};
    REProgram re1 = new REProgram(this.re1Instructions);
    String expr;
    int n = 0;
    int failures = 0;

    public static void main(String[] stringArray) {
        try {
            RETest.test(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static boolean test(String[] stringArray) throws Exception {
        RETest rETest = new RETest();
        if (stringArray.length == 2) {
            rETest.runInteractiveTests(stringArray[1]);
        } else if (stringArray.length == 1) {
            rETest.runAutomatedTests(stringArray[0]);
        } else {
            System.out.println("Usage: RETest ([-i] [regex]) ([/path/to/testfile.txt])");
            System.out.println("By Default will run automated tests from file 'docs/RETest.txt' ...");
            System.out.println();
            rETest.runAutomatedTests("docs/RETest.txt");
        }
        return rETest.failures == 0;
    }

    void runInteractiveTests(String string) {
        try {
            this.r.setProgram(this.compiler.compile(string));
            this.say("" + NEW_LINE + "" + string + "" + NEW_LINE + "");
            PrintWriter printWriter = new PrintWriter(System.out);
            this.compiler.dumpProgram(printWriter);
            printWriter.flush();
            boolean bl2 = true;
            while (bl2) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                System.out.print("> ");
                System.out.flush();
                String string2 = bufferedReader.readLine();
                if (string2 != null) {
                    if (this.r.match(string2)) {
                        this.say("Match successful.");
                    } else {
                        this.say("Match failed.");
                    }
                    this.showParens(this.r);
                    continue;
                }
                bl2 = false;
                System.out.println();
            }
        }
        catch (Exception exception) {
            this.say("Error: " + exception.toString());
            exception.printStackTrace();
        }
    }

    void die(String string) {
        this.say("FATAL ERROR: " + string);
        System.exit(0);
    }

    void fail(String string) {
        ++this.failures;
        this.say("" + NEW_LINE + "");
        this.say("*******************************************************");
        this.say("*********************  FAILURE!  **********************");
        this.say("*******************************************************");
        this.say("" + NEW_LINE + "");
        this.say(string);
        this.say("");
        PrintWriter printWriter = new PrintWriter(System.out);
        this.compiler.dumpProgram(printWriter);
        printWriter.flush();
        this.say("" + NEW_LINE + "");
    }

    void success(String string) {
    }

    void say(String string) {
        System.out.println(string);
    }

    void show() {
        this.say("" + NEW_LINE + "-----------------------" + NEW_LINE + "");
        this.say("Expression #" + this.n + " \"" + this.expr + "\" ");
    }

    void showParens(RE rE) {
        int n2 = 0;
        while (n2 < rE.getParenCount()) {
            this.say("$" + n2 + " = " + rE.getParen(n2));
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void runAutomatedTests(String string) throws Exception {
        File file;
        long l2 = System.currentTimeMillis();
        RE rE = new RE(this.re1);
        this.say("a*b");
        this.say("aaaab = " + rE.match("aaab"));
        this.showParens(rE);
        this.say("b = " + rE.match("b"));
        this.showParens(rE);
        this.say("c = " + rE.match("c"));
        this.showParens(rE);
        this.say("ccccaaaaab = " + rE.match("ccccaaaaab"));
        this.showParens(rE);
        rE = new RE("a*b");
        Object[] objectArray = rE.split("xxxxaabxxxxbyyyyaaabzzz");
        rE = new RE("x+");
        objectArray = rE.grep(objectArray);
        int n2 = 0;
        while (true) {
            if (n2 >= objectArray.length) {
                rE = new RE("a*b");
                String string2 = rE.subst("aaaabfooaaabgarplyaaabwackyb", "-");
                System.out.println("s = " + string2);
                this.runAutomatedTests();
                file = new File(string);
                if (file.exists()) break;
                throw new Exception("Could not find: " + string);
            }
            System.out.println("s[" + n2 + "] = " + (String)objectArray[n2]);
            ++n2;
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        try {
            block9: while (true) {
                String string3;
                if (!bufferedReader.ready()) {
                    break;
                }
                String string4 = "";
                while (bufferedReader.ready() && (string4 = bufferedReader.readLine()) != null && !(string4 = string4.trim()).startsWith("#")) {
                    if (string4.equals("")) continue;
                    System.out.println("Script error.  Line = " + string4);
                    System.exit(0);
                }
                if (!bufferedReader.ready()) break;
                this.expr = bufferedReader.readLine();
                ++this.n;
                this.say("");
                this.say(this.n + ". " + this.expr);
                this.say("");
                try {
                    rE.setProgram(this.compiler.compile(this.expr));
                }
                catch (Exception exception) {
                    string3 = bufferedReader.readLine().trim();
                    if (string3.equals("ERR")) {
                        this.say("   Match: ERR");
                        this.success("Produces an error (" + exception.toString() + "), as expected.");
                        continue;
                    }
                    String string5 = exception.getMessage() == null ? exception.toString() : exception.getMessage();
                    this.fail("Produces an unexpected exception \"" + string5 + "\"");
                    exception.printStackTrace();
                }
                catch (Error error) {
                    this.fail("Compiler threw fatal error \"" + error.getMessage() + "\"");
                    error.printStackTrace();
                }
                String string6 = bufferedReader.readLine().trim();
                this.say("   Match against: '" + string6 + "'");
                if (string6.equals("ERR")) {
                    this.fail("Was expected to be an error, but wasn't.");
                    continue;
                }
                try {
                    boolean bl2 = rE.match(string6);
                    string3 = bufferedReader.readLine().trim();
                    if (bl2) {
                        this.say("   Match: YES");
                        if (string3.equals("NO")) {
                            this.fail("Matched \"" + string6 + "\", when not expected to.");
                            continue;
                        }
                        if (string3.equals("YES")) {
                            this.success("Matched \"" + string6 + "\", as expected:");
                            this.say("   Paren count: " + rE.getParenCount());
                            int n3 = 0;
                            while (true) {
                                if (n3 >= rE.getParenCount()) continue block9;
                                String string7 = bufferedReader.readLine().trim();
                                this.say("   Paren " + n3 + " : " + rE.getParen(n3));
                                if (!(string7.length() == 0 && rE.getParen(n3) == null || string7.equals(rE.getParen(n3)))) {
                                    this.fail("Register " + n3 + " should be = \"" + string7 + "\", but is \"" + rE.getParen(n3) + "\" instead.");
                                }
                                ++n3;
                            }
                        }
                        this.die("Test script error!");
                        continue;
                    }
                    this.say("   Match: NO");
                    if (string3.equals("YES")) {
                        this.fail("Did not match \"" + string6 + "\", when expected to.");
                        continue;
                    }
                    if (string3.equals("NO")) {
                        this.success("Did not match \"" + string6 + "\", as expected.");
                        continue;
                    }
                    this.die("Test script error!");
                }
                catch (Exception exception) {
                    this.fail("Matcher threw exception: " + exception.toString());
                    exception.printStackTrace();
                }
                catch (Error error) {
                    this.fail("Matcher threw fatal error \"" + error.getMessage() + "\"");
                    error.printStackTrace();
                }
            }
            Object var17_20 = null;
        }
        catch (Throwable throwable) {
            Object var17_21 = null;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
        System.out.println(NEW_LINE + NEW_LINE + "Match time = " + (System.currentTimeMillis() - l2) + " ms.");
        System.out.println(NEW_LINE + "Tests complete.  " + this.n + " tests, " + this.failures + " failure(s).");
    }

    void runAutomatedTests() throws Exception {
        RE rE = new RE("(a*)b");
        this.say("Serialized/deserialized (a*)b");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(128);
        new ObjectOutputStream(byteArrayOutputStream).writeObject(rE);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        rE = (RE)new ObjectInputStream(byteArrayInputStream).readObject();
        if (!rE.match("aaab")) {
            this.fail("Did not match 'aaab' with deserialized RE.");
        }
        this.say("aaaab = true");
        this.showParens(rE);
        byteArrayOutputStream.reset();
        this.say("Deserialized (a*)b");
        new ObjectOutputStream(byteArrayOutputStream).writeObject(rE);
        byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        rE = (RE)new ObjectInputStream(byteArrayInputStream).readObject();
        if (rE.getParenCount() != 0) {
            this.fail("Has parens after deserialization.");
        }
        if (!rE.match("aaab")) {
            this.fail("Did not match 'aaab' with deserialized RE.");
        }
        this.say("aaaab = true");
        this.showParens(rE);
        rE = new RE("abc(\\w*)");
        this.say("MATCH_CASEINDEPENDENT abc(\\w*)");
        rE.setMatchFlags(1);
        this.say("abc(d*)");
        if (!rE.match("abcddd")) {
            this.fail("Did not match 'abcddd'.");
        }
        this.say("abcddd = true");
        this.showParens(rE);
        if (!rE.match("aBcDDdd")) {
            this.fail("Did not match 'aBcDDdd'.");
        }
        this.say("aBcDDdd = true");
        this.showParens(rE);
        if (!rE.match("ABCDDDDD")) {
            this.fail("Did not match 'ABCDDDDD'.");
        }
        this.say("ABCDDDDD = true");
        this.showParens(rE);
    }
}

