/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TypeAdapter;
import org.apache.tools.ant.UnsupportedAttributeException;
import org.apache.tools.ant.util.CollectionUtils;
import org.xml.sax.AttributeList;
import org.xml.sax.helpers.AttributeListImpl;

public class RuntimeConfigurable
implements Serializable {
    private static final Hashtable EMPTY_HASHTABLE = new Hashtable(0);
    private String elementTag = null;
    private List children = null;
    private transient Object wrappedObject = null;
    private transient IntrospectionHelper.Creator creator;
    private transient AttributeList attributes;
    private List attributeNames = null;
    private Map attributeMap = null;
    private StringBuffer characters = null;
    private boolean proxyConfigured = false;
    private String polyType = null;
    private String id = null;

    public RuntimeConfigurable(Object proxy, String elementTag) {
        this.setProxy(proxy);
        this.setElementTag(elementTag);
        if (proxy instanceof Task) {
            ((Task)proxy).setRuntimeConfigurableWrapper(this);
        }
    }

    public synchronized void setProxy(Object proxy) {
        this.wrappedObject = proxy;
        this.proxyConfigured = false;
    }

    synchronized void setCreator(IntrospectionHelper.Creator creator) {
        this.creator = creator;
    }

    public synchronized Object getProxy() {
        return this.wrappedObject;
    }

    public synchronized String getId() {
        return this.id;
    }

    public synchronized String getPolyType() {
        return this.polyType;
    }

    public synchronized void setPolyType(String polyType) {
        this.polyType = polyType;
    }

    public synchronized void setAttributes(AttributeList attributes) {
        this.attributes = new AttributeListImpl(attributes);
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            this.setAttribute(attributes.getName(i2), attributes.getValue(i2));
        }
    }

    public synchronized void setAttribute(String name, String value) {
        if (name.equalsIgnoreCase("ant-type")) {
            this.polyType = value;
        } else {
            if (this.attributeNames == null) {
                this.attributeNames = new ArrayList();
                this.attributeMap = new HashMap();
            }
            if (name.toLowerCase(Locale.US).equals("refid")) {
                this.attributeNames.add(0, name);
            } else {
                this.attributeNames.add(name);
            }
            this.attributeMap.put(name, value);
            if (name.equals("id")) {
                this.id = value;
            }
        }
    }

    public synchronized void removeAttribute(String name) {
        this.attributeNames.remove(name);
        this.attributeMap.remove(name);
    }

    public synchronized Hashtable getAttributeMap() {
        return this.attributeMap == null ? EMPTY_HASHTABLE : new Hashtable(this.attributeMap);
    }

    public synchronized AttributeList getAttributes() {
        return this.attributes;
    }

    public synchronized void addChild(RuntimeConfigurable child) {
        this.children = this.children == null ? new ArrayList() : this.children;
        this.children.add(child);
    }

    synchronized RuntimeConfigurable getChild(int index) {
        return (RuntimeConfigurable)this.children.get(index);
    }

    public synchronized Enumeration getChildren() {
        return this.children == null ? new CollectionUtils.EmptyEnumeration() : Collections.enumeration(this.children);
    }

    public synchronized void addText(String data) {
        if (data.length() == 0) {
            return;
        }
        this.characters = this.characters == null ? new StringBuffer(data) : this.characters.append(data);
    }

    public synchronized void addText(char[] buf, int start, int count) {
        if (count == 0) {
            return;
        }
        this.characters = (this.characters == null ? new StringBuffer(count) : this.characters).append(buf, start, count);
    }

    public synchronized StringBuffer getText() {
        return this.characters == null ? new StringBuffer(0) : this.characters;
    }

    public synchronized void setElementTag(String elementTag) {
        this.elementTag = elementTag;
    }

    public synchronized String getElementTag() {
        return this.elementTag;
    }

    public void maybeConfigure(Project p2) throws BuildException {
        this.maybeConfigure(p2, true);
    }

    public synchronized void maybeConfigure(Project p2, boolean configureChildren) throws BuildException {
        if (this.proxyConfigured) {
            return;
        }
        Object target = this.wrappedObject instanceof TypeAdapter ? ((TypeAdapter)this.wrappedObject).getProxy() : this.wrappedObject;
        IntrospectionHelper ih = IntrospectionHelper.getHelper(p2, target.getClass());
        if (this.attributeNames != null) {
            for (int i2 = 0; i2 < this.attributeNames.size(); ++i2) {
                String name = (String)this.attributeNames.get(i2);
                String value = (String)this.attributeMap.get(name);
                value = p2.replaceProperties(value);
                try {
                    ih.setAttribute(p2, target, name, value);
                    continue;
                }
                catch (UnsupportedAttributeException be2) {
                    if (name.equals("id")) continue;
                    if (this.getElementTag() == null) {
                        throw be2;
                    }
                    throw new BuildException(this.getElementTag() + " doesn't support the \"" + be2.getAttribute() + "\" attribute", be2);
                }
                catch (BuildException be3) {
                    if (name.equals("id")) continue;
                    throw be3;
                }
            }
        }
        if (this.characters != null) {
            ProjectHelper.addText(p2, this.wrappedObject, this.characters.substring(0));
        }
        if (this.id != null) {
            p2.addReference(this.id, this.wrappedObject);
        }
        this.proxyConfigured = true;
    }

    public void reconfigure(Project p2) {
        this.proxyConfigured = false;
        this.maybeConfigure(p2);
    }

    public void applyPreSet(RuntimeConfigurable r2) {
        if (r2.attributeMap != null) {
            Iterator i2 = r2.attributeMap.keySet().iterator();
            while (i2.hasNext()) {
                String name = (String)i2.next();
                if (this.attributeMap != null && this.attributeMap.get(name) != null) continue;
                this.setAttribute(name, (String)r2.attributeMap.get(name));
            }
        }
        String string = this.polyType = this.polyType == null ? r2.polyType : this.polyType;
        if (r2.children != null) {
            ArrayList newChildren = new ArrayList();
            newChildren.addAll(r2.children);
            if (this.children != null) {
                newChildren.addAll(this.children);
            }
            this.children = newChildren;
        }
        if (r2.characters != null && (this.characters == null || this.characters.toString().trim().length() == 0)) {
            this.characters = new StringBuffer(r2.characters.toString());
        }
    }
}

