/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.IOException;
import java.io.Reader;
import java.util.Vector;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.filters.BaseParamFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.Parameter;

public final class LineContains
extends BaseParamFilterReader
implements ChainableReader {
    private static final String CONTAINS_KEY = "contains";
    private static final String NEGATE_KEY = "negate";
    private Vector contains = new Vector();
    private String line = null;
    private boolean negate = false;

    public LineContains() {
    }

    public LineContains(Reader in) {
        super(in);
    }

    public int read() throws IOException {
        if (!this.getInitialized()) {
            this.initialize();
            this.setInitialized(true);
        }
        int ch2 = -1;
        if (this.line != null) {
            ch2 = this.line.charAt(0);
            this.line = this.line.length() == 1 ? null : this.line.substring(1);
        } else {
            int containsSize = this.contains.size();
            this.line = this.readLine();
            while (this.line != null) {
                boolean matches = true;
                for (int i2 = 0; matches && i2 < containsSize; ++i2) {
                    String containsStr = (String)this.contains.elementAt(i2);
                    matches = this.line.indexOf(containsStr) >= 0;
                }
                if (matches ^ this.isNegated()) break;
                this.line = this.readLine();
            }
            if (this.line != null) {
                return this.read();
            }
        }
        return ch2;
    }

    public void addConfiguredContains(Contains contains) {
        this.contains.addElement(contains.getValue());
    }

    public void setNegate(boolean b2) {
        this.negate = b2;
    }

    public boolean isNegated() {
        return this.negate;
    }

    private void setContains(Vector contains) {
        this.contains = contains;
    }

    private Vector getContains() {
        return this.contains;
    }

    public Reader chain(Reader rdr) {
        LineContains newFilter = new LineContains(rdr);
        newFilter.setContains(this.getContains());
        newFilter.setNegate(this.isNegated());
        return newFilter;
    }

    private void initialize() {
        Parameter[] params = this.getParameters();
        if (params != null) {
            for (int i2 = 0; i2 < params.length; ++i2) {
                if (CONTAINS_KEY.equals(params[i2].getType())) {
                    this.contains.addElement(params[i2].getValue());
                    continue;
                }
                if (!NEGATE_KEY.equals(params[i2].getType())) continue;
                this.setNegate(Project.toBoolean(params[i2].getValue()));
            }
        }
    }

    public static class Contains {
        private String value;

        public final void setValue(String contains) {
            this.value = contains;
        }

        public final String getValue() {
            return this.value;
        }
    }
}

