/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.IOException;
import java.io.Reader;
import java.util.Vector;
import org.apache.tools.ant.filters.BaseParamFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.Parameter;

public final class StripLineComments
extends BaseParamFilterReader
implements ChainableReader {
    private static final String COMMENTS_KEY = "comment";
    private Vector comments = new Vector();
    private String line = null;

    public StripLineComments() {
    }

    public StripLineComments(Reader in) {
        super(in);
    }

    public int read() throws IOException {
        if (!this.getInitialized()) {
            this.initialize();
            this.setInitialized(true);
        }
        int ch2 = -1;
        if (this.line != null) {
            ch2 = this.line.charAt(0);
            this.line = this.line.length() == 1 ? null : this.line.substring(1);
        } else {
            this.line = this.readLine();
            int commentsSize = this.comments.size();
            while (this.line != null) {
                for (int i2 = 0; i2 < commentsSize; ++i2) {
                    String comment = (String)this.comments.elementAt(i2);
                    if (!this.line.startsWith(comment)) continue;
                    this.line = null;
                    break;
                }
                if (this.line != null) break;
                this.line = this.readLine();
            }
            if (this.line != null) {
                return this.read();
            }
        }
        return ch2;
    }

    public void addConfiguredComment(Comment comment) {
        this.comments.addElement(comment.getValue());
    }

    private void setComments(Vector comments) {
        this.comments = comments;
    }

    private Vector getComments() {
        return this.comments;
    }

    public Reader chain(Reader rdr) {
        StripLineComments newFilter = new StripLineComments(rdr);
        newFilter.setComments(this.getComments());
        newFilter.setInitialized(true);
        return newFilter;
    }

    private void initialize() {
        Parameter[] params = this.getParameters();
        if (params != null) {
            for (int i2 = 0; i2 < params.length; ++i2) {
                if (!COMMENTS_KEY.equals(params[i2].getType())) continue;
                this.comments.addElement(params[i2].getValue());
            }
        }
    }

    public static class Comment {
        private String value;

        public final void setValue(String comment) {
            if (this.value != null) {
                throw new IllegalStateException("Comment value already set.");
            }
            this.value = comment;
        }

        public final String getValue() {
            return this.value;
        }

        public void addText(String comment) {
            this.setValue(comment);
        }
    }
}

