/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.IOException;
import java.io.Reader;
import org.apache.tools.ant.filters.BaseParamFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.Parameter;

public final class TabsToSpaces
extends BaseParamFilterReader
implements ChainableReader {
    private static final int DEFAULT_TAB_LENGTH = 8;
    private static final String TAB_LENGTH_KEY = "tablength";
    private int tabLength = 8;
    private int spacesRemaining = 0;

    public TabsToSpaces() {
    }

    public TabsToSpaces(Reader in) {
        super(in);
    }

    public int read() throws IOException {
        if (!this.getInitialized()) {
            this.initialize();
            this.setInitialized(true);
        }
        int ch2 = -1;
        if (this.spacesRemaining > 0) {
            --this.spacesRemaining;
            ch2 = 32;
        } else {
            ch2 = this.in.read();
            if (ch2 == 9) {
                this.spacesRemaining = this.tabLength - 1;
                ch2 = 32;
            }
        }
        return ch2;
    }

    public void setTablength(int tabLength) {
        this.tabLength = tabLength;
    }

    private int getTablength() {
        return this.tabLength;
    }

    public Reader chain(Reader rdr) {
        TabsToSpaces newFilter = new TabsToSpaces(rdr);
        newFilter.setTablength(this.getTablength());
        newFilter.setInitialized(true);
        return newFilter;
    }

    private void initialize() {
        Parameter[] params = this.getParameters();
        if (params != null) {
            for (int i2 = 0; i2 < params.length; ++i2) {
                if (params[i2] == null || !TAB_LENGTH_KEY.equals(params[i2].getName())) continue;
                this.tabLength = Integer.parseInt(params[i2].getValue());
                break;
            }
        }
    }
}

