/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.launch;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.StringCharacterIterator;
import java.util.Locale;

public final class Locator {
    private static final int NIBBLE = 4;
    private static final int NIBBLE_MASK = 15;
    private static final int ASCII_SIZE = 128;
    private static final int BYTE_SIZE = 256;
    private static final int WORD = 16;
    private static final int SPACE = 32;
    private static final int DEL = 127;
    public static final String URI_ENCODING = "UTF-8";
    private static boolean[] gNeedEscaping = new boolean[128];
    private static char[] gAfterEscaping1 = new char[128];
    private static char[] gAfterEscaping2 = new char[128];
    private static char[] gHexChs = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final String ERROR_NOT_FILE_URI = "Can only handle valid file: URIs, not ";
    static /* synthetic */ Class class$org$apache$tools$ant$launch$Locator;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$File;

    private Locator() {
    }

    public static File getClassSource(Class c2) {
        String classResource = c2.getName().replace('.', '/') + ".class";
        return Locator.getResourceSource(c2.getClassLoader(), classResource);
    }

    public static File getResourceSource(ClassLoader c2, String resource) {
        if (c2 == null) {
            c2 = (class$org$apache$tools$ant$launch$Locator == null ? (class$org$apache$tools$ant$launch$Locator = Locator.class$("org.apache.tools.ant.launch.Locator")) : class$org$apache$tools$ant$launch$Locator).getClassLoader();
        }
        URL url = null;
        url = c2 == null ? ClassLoader.getSystemResource(resource) : c2.getResource(resource);
        if (url != null) {
            String u2 = url.toString();
            try {
                if (u2.startsWith("jar:file:")) {
                    int pling = u2.indexOf("!");
                    String jarName = u2.substring("jar:".length(), pling);
                    return new File(Locator.fromURI(jarName));
                }
                if (u2.startsWith("file:")) {
                    int tail = u2.indexOf(resource);
                    String dirName = u2.substring(0, tail);
                    return new File(Locator.fromURI(dirName));
                }
            }
            catch (IllegalArgumentException e2) {
                return null;
            }
        }
        return null;
    }

    public static String fromURI(String uri) {
        String result = null;
        if (result == null) {
            result = Locator.fromURIJava13(uri);
        }
        return result;
    }

    private static String fromUriJava14(String uri) {
        Class<?> uriClazz = null;
        try {
            uriClazz = Class.forName("java.net.URI");
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        if (uriClazz != null && uri.startsWith("file:/")) {
            try {
                Method createMethod = uriClazz.getMethod("create", class$java$lang$String == null ? (class$java$lang$String = Locator.class$("java.lang.String")) : class$java$lang$String);
                Object uriObj = createMethod.invoke(null, Locator.encodeURI(uri));
                Constructor fileConst = (class$java$io$File == null ? (class$java$io$File = Locator.class$("java.io.File")) : class$java$io$File).getConstructor(uriClazz);
                File f2 = (File)fileConst.newInstance(uriObj);
                return Locator.decodeUri(f2.getAbsolutePath());
            }
            catch (InvocationTargetException e2) {
                Throwable e22 = e2.getTargetException();
                if (e22 instanceof IllegalArgumentException) {
                    e22.printStackTrace();
                } else {
                    e22.printStackTrace();
                }
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
        }
        return null;
    }

    static String fromURIJava13(String uri) {
        String file;
        int queryPos;
        URL url = null;
        try {
            url = new URL(uri);
        }
        catch (MalformedURLException emYouEarlEx) {
            // empty catch block
        }
        if (url == null || !"file".equals(url.getProtocol())) {
            throw new IllegalArgumentException(ERROR_NOT_FILE_URI + uri);
        }
        StringBuffer buf = new StringBuffer(url.getHost());
        if (buf.length() > 0) {
            buf.insert(0, File.separatorChar).insert(0, File.separatorChar);
        }
        buf.append((queryPos = (file = url.getFile()).indexOf(63)) < 0 ? file : file.substring(0, queryPos));
        uri = buf.toString().replace('/', File.separatorChar);
        if (File.pathSeparatorChar == ';' && uri.startsWith("\\") && uri.length() > 2 && Character.isLetter(uri.charAt(1)) && uri.lastIndexOf(58) > -1) {
            uri = uri.substring(1);
        }
        String path = null;
        try {
            path = Locator.decodeUri(uri);
            String cwd = System.getProperty("user.dir");
            int posi = cwd.indexOf(":");
            if (posi > 0 && path.startsWith(File.separator)) {
                path = cwd.substring(0, posi + 1) + path;
            }
        }
        catch (UnsupportedEncodingException exc) {
            throw new IllegalStateException("Could not convert URI " + uri + " to path: " + exc.getMessage());
        }
        return path;
    }

    public static String decodeUri(String uri) throws UnsupportedEncodingException {
        if (uri.indexOf(37) == -1) {
            return uri;
        }
        ByteArrayOutputStream sb = new ByteArrayOutputStream(uri.length());
        StringCharacterIterator iter = new StringCharacterIterator(uri);
        char c2 = iter.first();
        while (c2 != '\uffff') {
            if (c2 == '%') {
                char c1 = iter.next();
                if (c1 != '\uffff') {
                    int i1 = Character.digit(c1, 16);
                    char c22 = iter.next();
                    if (c22 != '\uffff') {
                        int i2 = Character.digit(c22, 16);
                        sb.write((char)((i1 << 4) + i2));
                    }
                }
            } else {
                sb.write(c2);
            }
            c2 = iter.next();
        }
        return sb.toString(URI_ENCODING);
    }

    public static String encodeURI(String path) throws UnsupportedEncodingException {
        int i2;
        int len = path.length();
        int ch2 = 0;
        StringBuffer sb = null;
        for (i2 = 0; i2 < len && (ch2 = path.charAt(i2)) < 128; ++i2) {
            if (gNeedEscaping[ch2]) {
                if (sb == null) {
                    sb = new StringBuffer(path.substring(0, i2));
                }
                sb.append('%');
                sb.append(gAfterEscaping1[ch2]);
                sb.append(gAfterEscaping2[ch2]);
                continue;
            }
            if (sb == null) continue;
            sb.append((char)ch2);
        }
        if (i2 < len) {
            if (sb == null) {
                sb = new StringBuffer(path.substring(0, i2));
            }
            byte[] bytes = null;
            bytes = path.substring(i2).getBytes(URI_ENCODING);
            len = bytes.length;
            for (i2 = 0; i2 < len; ++i2) {
                byte b2 = bytes[i2];
                if (b2 < 0) {
                    ch2 = b2 + 256;
                    sb.append('%');
                    sb.append(gHexChs[ch2 >> 4]);
                    sb.append(gHexChs[ch2 & 0xF]);
                    continue;
                }
                if (gNeedEscaping[b2]) {
                    sb.append('%');
                    sb.append(gAfterEscaping1[b2]);
                    sb.append(gAfterEscaping2[b2]);
                    continue;
                }
                sb.append((char)b2);
            }
        }
        return sb == null ? path : sb.toString();
    }

    public static URL fileToURL(File file) throws MalformedURLException {
        try {
            return new URL(Locator.encodeURI(file.toURL().toString()));
        }
        catch (UnsupportedEncodingException ex2) {
            throw new MalformedURLException(ex2.toString());
        }
    }

    public static File getToolsJar() {
        boolean toolsJarAvailable = false;
        try {
            Class.forName("com.sun.tools.javac.Main");
            toolsJarAvailable = true;
        }
        catch (Exception e2) {
            try {
                Class.forName("sun.tools.javac.Main");
                toolsJarAvailable = true;
            }
            catch (Exception e22) {
                // empty catch block
            }
        }
        if (toolsJarAvailable) {
            return null;
        }
        String libToolsJar = File.separator + "lib" + File.separator + "tools.jar";
        String javaHome = System.getProperty("java.home");
        File toolsJar = new File(javaHome + libToolsJar);
        if (toolsJar.exists()) {
            return toolsJar;
        }
        if (javaHome.toLowerCase(Locale.US).endsWith(File.separator + "jre")) {
            javaHome = javaHome.substring(0, javaHome.length() - "/jre".length());
            toolsJar = new File(javaHome + libToolsJar);
        }
        if (!toolsJar.exists()) {
            System.out.println("Unable to locate tools.jar. Expected to find it in " + toolsJar.getPath());
            return null;
        }
        return toolsJar;
    }

    public static URL[] getLocationURLs(File location) throws MalformedURLException {
        return Locator.getLocationURLs(location, new String[]{".jar"});
    }

    public static URL[] getLocationURLs(File location, final String[] extensions) throws MalformedURLException {
        URL[] urls = new URL[]{};
        if (!location.exists()) {
            return urls;
        }
        if (!location.isDirectory()) {
            urls = new URL[1];
            String path = location.getPath();
            String littlePath = path.toLowerCase(Locale.US);
            for (int i2 = 0; i2 < extensions.length; ++i2) {
                if (!littlePath.endsWith(extensions[i2])) continue;
                urls[0] = Locator.fileToURL(location);
                break;
            }
            return urls;
        }
        File[] matches = location.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                String littleName = name.toLowerCase(Locale.US);
                for (int i2 = 0; i2 < extensions.length; ++i2) {
                    if (!littleName.endsWith(extensions[i2])) continue;
                    return true;
                }
                return false;
            }
        });
        urls = new URL[matches.length];
        for (int i3 = 0; i3 < matches.length; ++i3) {
            urls[i3] = Locator.fileToURL(matches[i3]);
        }
        return urls;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        for (int i2 = 0; i2 < 32; ++i2) {
            Locator.gNeedEscaping[i2] = true;
            Locator.gAfterEscaping1[i2] = gHexChs[i2 >> 4];
            Locator.gAfterEscaping2[i2] = gHexChs[i2 & 0xF];
        }
        Locator.gNeedEscaping[127] = true;
        Locator.gAfterEscaping1[127] = 55;
        Locator.gAfterEscaping2[127] = 70;
        char[] escChs = new char[]{' ', '<', '>', '#', '%', '\"', '{', '}', '|', '\\', '^', '~', '[', ']', '`'};
        int len = escChs.length;
        for (int i3 = 0; i3 < len; ++i3) {
            char ch2 = escChs[i3];
            Locator.gNeedEscaping[ch2] = true;
            Locator.gAfterEscaping1[ch2] = gHexChs[ch2 >> 4];
            Locator.gAfterEscaping2[ch2] = gHexChs[ch2 & 0xF];
        }
    }
}

