/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.StringUtils;

public abstract class AbstractCvsTask
extends Task {
    public static final int DEFAULT_COMPRESSION_LEVEL = 3;
    private static final int MAXIMUM_COMRESSION_LEVEL = 9;
    private Commandline cmd = new Commandline();
    private Vector vecCommandlines = new Vector();
    private String cvsRoot;
    private String cvsRsh;
    private String cvsPackage;
    private String tag;
    private static final String DEFAULT_COMMAND = "checkout";
    private String command = null;
    private boolean quiet = false;
    private boolean reallyquiet = false;
    private int compression = 0;
    private boolean noexec = false;
    private int port = 0;
    private File passFile = null;
    private File dest;
    private boolean append = false;
    private File output;
    private File error;
    private boolean failOnError = false;
    private ExecuteStreamHandler executeStreamHandler;
    private OutputStream outputStream;
    private OutputStream errorStream;

    public void setExecuteStreamHandler(ExecuteStreamHandler handler) {
        this.executeStreamHandler = handler;
    }

    protected ExecuteStreamHandler getExecuteStreamHandler() {
        if (this.executeStreamHandler == null) {
            this.setExecuteStreamHandler(new PumpStreamHandler(this.getOutputStream(), this.getErrorStream()));
        }
        return this.executeStreamHandler;
    }

    protected void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    protected OutputStream getOutputStream() {
        if (this.outputStream == null) {
            if (this.output != null) {
                try {
                    this.setOutputStream(new PrintStream(new BufferedOutputStream(new FileOutputStream(this.output.getPath(), this.append))));
                }
                catch (IOException e2) {
                    throw new BuildException(e2, this.getLocation());
                }
            } else {
                this.setOutputStream(new LogOutputStream(this, 2));
            }
        }
        return this.outputStream;
    }

    protected void setErrorStream(OutputStream errorStream) {
        this.errorStream = errorStream;
    }

    protected OutputStream getErrorStream() {
        if (this.errorStream == null) {
            if (this.error != null) {
                try {
                    this.setErrorStream(new PrintStream(new BufferedOutputStream(new FileOutputStream(this.error.getPath(), this.append))));
                }
                catch (IOException e2) {
                    throw new BuildException(e2, this.getLocation());
                }
            } else {
                this.setErrorStream(new LogOutputStream(this, 1));
            }
        }
        return this.errorStream;
    }

    protected void runCommand(Commandline toExecute) throws BuildException {
        File defaultPassFile;
        Environment.Variable var;
        Environment env = new Environment();
        if (this.port > 0) {
            var = new Environment.Variable();
            var.setKey("CVS_CLIENT_PORT");
            var.setValue(String.valueOf(this.port));
            env.addVariable(var);
        }
        if (this.passFile == null && (defaultPassFile = new File(System.getProperty("cygwin.user.home", System.getProperty("user.home")) + File.separatorChar + ".cvspass")).exists()) {
            this.setPassfile(defaultPassFile);
        }
        if (this.passFile != null) {
            if (this.passFile.isFile() && this.passFile.canRead()) {
                var = new Environment.Variable();
                var.setKey("CVS_PASSFILE");
                var.setValue(String.valueOf(this.passFile));
                env.addVariable(var);
                this.log("Using cvs passfile: " + String.valueOf(this.passFile), 3);
            } else if (!this.passFile.canRead()) {
                this.log("cvs passfile: " + String.valueOf(this.passFile) + " ignored as it is not readable", 1);
            } else {
                this.log("cvs passfile: " + String.valueOf(this.passFile) + " ignored as it is not a file", 1);
            }
        }
        if (this.cvsRsh != null) {
            var = new Environment.Variable();
            var.setKey("CVS_RSH");
            var.setValue(String.valueOf(this.cvsRsh));
            env.addVariable(var);
        }
        Execute exe = new Execute(this.getExecuteStreamHandler(), null);
        exe.setAntRun(this.getProject());
        if (this.dest == null) {
            this.dest = this.getProject().getBaseDir();
        }
        if (!this.dest.exists()) {
            this.dest.mkdirs();
        }
        exe.setWorkingDirectory(this.dest);
        exe.setCommandline(toExecute.getCommandline());
        exe.setEnvironment(env.getVariables());
        try {
            String actualCommandLine = this.executeToString(exe);
            this.log(actualCommandLine, 3);
            int retCode = exe.execute();
            this.log("retCode=" + retCode, 4);
            if (this.failOnError && Execute.isFailure(retCode)) {
                throw new BuildException("cvs exited with error code " + retCode + StringUtils.LINE_SEP + "Command line was [" + actualCommandLine + "]", this.getLocation());
            }
        }
        catch (IOException e2) {
            if (this.failOnError) {
                throw new BuildException(e2, this.getLocation());
            }
            this.log("Caught exception: " + e2.getMessage(), 1);
        }
        catch (BuildException e3) {
            if (this.failOnError) {
                throw e3;
            }
            Throwable t2 = e3.getException();
            if (t2 == null) {
                t2 = e3;
            }
            this.log("Caught exception: " + t2.getMessage(), 1);
        }
        catch (Exception e4) {
            if (this.failOnError) {
                throw new BuildException(e4, this.getLocation());
            }
            this.log("Caught exception: " + e4.getMessage(), 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        String savedCommand = this.getCommand();
        if (this.getCommand() == null && this.vecCommandlines.size() == 0) {
            this.setCommand(DEFAULT_COMMAND);
        }
        String c2 = this.getCommand();
        Commandline cloned = null;
        if (c2 != null) {
            cloned = (Commandline)this.cmd.clone();
            cloned.createArgument(true).setLine(c2);
            this.addConfiguredCommandline(cloned, true);
        }
        try {
            for (int i2 = 0; i2 < this.vecCommandlines.size(); ++i2) {
                this.runCommand((Commandline)this.vecCommandlines.elementAt(i2));
            }
        }
        finally {
            if (cloned != null) {
                this.removeCommandline(cloned);
            }
            this.setCommand(savedCommand);
            FileUtils.close(this.outputStream);
            FileUtils.close(this.errorStream);
        }
    }

    private String executeToString(Execute execute) {
        String cmdLine = Commandline.describeCommand(execute.getCommandline());
        StringBuffer stringBuffer = this.removeCvsPassword(cmdLine);
        String newLine = StringUtils.LINE_SEP;
        String[] variableArray = execute.getEnvironment();
        if (variableArray != null) {
            stringBuffer.append(newLine);
            stringBuffer.append(newLine);
            stringBuffer.append("environment:");
            stringBuffer.append(newLine);
            for (int z2 = 0; z2 < variableArray.length; ++z2) {
                stringBuffer.append(newLine);
                stringBuffer.append("\t");
                stringBuffer.append(variableArray[z2]);
            }
        }
        return stringBuffer.toString();
    }

    private StringBuffer removeCvsPassword(String cmdLine) {
        StringBuffer stringBuffer = new StringBuffer(cmdLine);
        int start = cmdLine.indexOf("-d:");
        if (start >= 0) {
            int stop = cmdLine.indexOf("@", start);
            int startproto = cmdLine.indexOf(":", start);
            int startuser = cmdLine.indexOf(":", startproto + 1);
            int startpass = cmdLine.indexOf(":", startuser + 1);
            stop = cmdLine.indexOf("@", start);
            if (stop >= 0 && startpass > startproto && startpass < stop) {
                for (int i2 = startpass + 1; i2 < stop; ++i2) {
                    stringBuffer.replace(i2, i2 + 1, "*");
                }
            }
        }
        return stringBuffer;
    }

    public void setCvsRoot(String root) {
        if (root != null && root.trim().equals("")) {
            root = null;
        }
        this.cvsRoot = root;
    }

    public String getCvsRoot() {
        return this.cvsRoot;
    }

    public void setCvsRsh(String rsh) {
        if (rsh != null && rsh.trim().equals("")) {
            rsh = null;
        }
        this.cvsRsh = rsh;
    }

    public String getCvsRsh() {
        return this.cvsRsh;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setPassfile(File passFile) {
        this.passFile = passFile;
    }

    public File getPassFile() {
        return this.passFile;
    }

    public void setDest(File dest) {
        this.dest = dest;
    }

    public File getDest() {
        return this.dest;
    }

    public void setPackage(String p2) {
        this.cvsPackage = p2;
    }

    public String getPackage() {
        return this.cvsPackage;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String p2) {
        if (p2 != null && p2.trim().length() > 0) {
            this.tag = p2;
            this.addCommandArgument("-r" + p2);
        }
    }

    public void addCommandArgument(String arg) {
        this.addCommandArgument(this.cmd, arg);
    }

    public void addCommandArgument(Commandline c2, String arg) {
        c2.createArgument().setValue(arg);
    }

    public void setDate(String p2) {
        if (p2 != null && p2.trim().length() > 0) {
            this.addCommandArgument("-D");
            this.addCommandArgument(p2);
        }
    }

    public void setCommand(String c2) {
        this.command = c2;
    }

    public String getCommand() {
        return this.command;
    }

    public void setQuiet(boolean q2) {
        this.quiet = q2;
    }

    public void setReallyquiet(boolean q2) {
        this.reallyquiet = q2;
    }

    public void setNoexec(boolean ne) {
        this.noexec = ne;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void setError(File error) {
        this.error = error;
    }

    public void setAppend(boolean value) {
        this.append = value;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    protected void configureCommandline(Commandline c2) {
        if (c2 == null) {
            return;
        }
        c2.setExecutable("cvs");
        if (this.cvsPackage != null) {
            c2.createArgument().setLine(this.cvsPackage);
        }
        if (this.compression > 0 && this.compression <= 9) {
            c2.createArgument(true).setValue("-z" + this.compression);
        }
        if (this.quiet && !this.reallyquiet) {
            c2.createArgument(true).setValue("-q");
        }
        if (this.reallyquiet) {
            c2.createArgument(true).setValue("-Q");
        }
        if (this.noexec) {
            c2.createArgument(true).setValue("-n");
        }
        if (this.cvsRoot != null) {
            c2.createArgument(true).setLine("-d" + this.cvsRoot);
        }
    }

    protected void removeCommandline(Commandline c2) {
        this.vecCommandlines.removeElement(c2);
    }

    public void addConfiguredCommandline(Commandline c2) {
        this.addConfiguredCommandline(c2, false);
    }

    public void addConfiguredCommandline(Commandline c2, boolean insertAtStart) {
        if (c2 == null) {
            return;
        }
        this.configureCommandline(c2);
        if (insertAtStart) {
            this.vecCommandlines.insertElementAt(c2, 0);
        } else {
            this.vecCommandlines.addElement(c2);
        }
    }

    public void setCompressionLevel(int level) {
        this.compression = level;
    }

    public void setCompression(boolean usecomp) {
        this.setCompressionLevel(usecomp ? 3 : 0);
    }
}

