/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.PropertySet;
import org.apache.tools.ant.util.FileUtils;

public class Ant
extends Task {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private File dir = null;
    private String antFile = null;
    private String output = null;
    private boolean inheritAll = true;
    private boolean inheritRefs = false;
    private Vector properties = new Vector();
    private Vector references = new Vector();
    private Project newProject;
    private PrintStream out = null;
    private Vector propertySets = new Vector();
    private Vector targets = new Vector();
    private boolean targetAttributeSet = false;
    static /* synthetic */ Class class$org$apache$tools$ant$Project;

    public Ant() {
    }

    public Ant(Task owner) {
        this.bindToOwner(owner);
    }

    public void setInheritAll(boolean value) {
        this.inheritAll = value;
    }

    public void setInheritRefs(boolean value) {
        this.inheritRefs = value;
    }

    public void init() {
        this.newProject = this.getProject().createSubProject();
        this.newProject.setJavaVersionProperty();
    }

    private void reinit() {
        this.init();
    }

    private void initializeProject() {
        this.newProject.setInputHandler(this.getProject().getInputHandler());
        Iterator iter = this.getBuildListeners();
        while (iter.hasNext()) {
            this.newProject.addBuildListener((BuildListener)iter.next());
        }
        if (this.output != null) {
            File outfile = null;
            outfile = this.dir != null ? FILE_UTILS.resolveFile(this.dir, this.output) : this.getProject().resolveFile(this.output);
            try {
                this.out = new PrintStream(new FileOutputStream(outfile));
                DefaultLogger logger = new DefaultLogger();
                logger.setMessageOutputLevel(2);
                logger.setOutputPrintStream(this.out);
                logger.setErrorPrintStream(this.out);
                this.newProject.addBuildListener(logger);
            }
            catch (IOException ex2) {
                this.log("Ant: Can't set output to " + this.output);
            }
        }
        this.getProject().copyUserProperties(this.newProject);
        if (!this.inheritAll) {
            this.newProject.initProperties();
        } else {
            this.addAlmostAll(this.getProject().getProperties());
        }
        Enumeration e2 = this.propertySets.elements();
        while (e2.hasMoreElements()) {
            PropertySet ps = (PropertySet)e2.nextElement();
            this.addAlmostAll(ps.getProperties());
        }
    }

    public void handleOutput(String outputToHandle) {
        if (this.newProject != null) {
            this.newProject.demuxOutput(outputToHandle, false);
        } else {
            super.handleOutput(outputToHandle);
        }
    }

    public int handleInput(byte[] buffer, int offset, int length) throws IOException {
        if (this.newProject != null) {
            return this.newProject.demuxInput(buffer, offset, length);
        }
        return super.handleInput(buffer, offset, length);
    }

    public void handleFlush(String toFlush) {
        if (this.newProject != null) {
            this.newProject.demuxFlush(toFlush, false);
        } else {
            super.handleFlush(toFlush);
        }
    }

    public void handleErrorOutput(String errorOutputToHandle) {
        if (this.newProject != null) {
            this.newProject.demuxOutput(errorOutputToHandle, true);
        } else {
            super.handleErrorOutput(errorOutputToHandle);
        }
    }

    public void handleErrorFlush(String errorOutputToFlush) {
        if (this.newProject != null) {
            this.newProject.demuxFlush(errorOutputToFlush, true);
        } else {
            super.handleErrorFlush(errorOutputToFlush);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        block28: {
            File savedDir = this.dir;
            String savedAntFile = this.antFile;
            Vector<String> locals = new Vector<String>(this.targets);
            try {
                String defaultTarget;
                this.getNewProject();
                if (this.dir == null && this.inheritAll) {
                    this.dir = this.getProject().getBaseDir();
                }
                this.initializeProject();
                if (this.dir != null) {
                    this.newProject.setBaseDir(this.dir);
                    if (savedDir != null) {
                        this.newProject.setInheritedProperty("basedir", this.dir.getAbsolutePath());
                    }
                } else {
                    this.dir = this.getProject().getBaseDir();
                }
                this.overrideProperties();
                if (this.antFile == null) {
                    this.antFile = "build.xml";
                }
                File file = FILE_UTILS.resolveFile(this.dir, this.antFile);
                this.antFile = file.getAbsolutePath();
                this.log("calling target(s) " + (locals.size() > 0 ? locals.toString() : "[default]") + " in build file " + this.antFile, 3);
                this.newProject.setUserProperty("ant.file", this.antFile);
                String thisAntFile = this.getProject().getProperty("ant.file");
                if (thisAntFile != null && file.equals(this.getProject().resolveFile(thisAntFile)) && this.getOwningTarget() != null && this.getOwningTarget().getName().equals("")) {
                    if (this.getTaskName().equals("antcall")) {
                        throw new BuildException("antcall must not be used at the top level.");
                    }
                    throw new BuildException(this.getTaskName() + " task at the" + " top level must not invoke" + " its own build file.");
                }
                try {
                    ProjectHelper.configureProject(this.newProject, file);
                }
                catch (BuildException ex2) {
                    throw ProjectHelper.addLocationToBuildException(ex2, this.getLocation());
                }
                if (locals.size() == 0 && (defaultTarget = this.newProject.getDefaultTarget()) != null) {
                    locals.add(defaultTarget);
                }
                if (this.newProject.getProperty("ant.file").equals(this.getProject().getProperty("ant.file")) && this.getOwningTarget() != null) {
                    boolean circular;
                    Target other;
                    String owningTargetName = this.getOwningTarget().getName();
                    if (locals.contains(owningTargetName)) {
                        throw new BuildException(this.getTaskName() + " task calling " + "its own parent target.");
                    }
                    Iterator it = locals.iterator();
                    for (circular = false; !circular && it.hasNext(); circular |= (other = (Target)this.getProject().getTargets().get(it.next())) != null && other.dependsOn(owningTargetName)) {
                    }
                    if (circular) {
                        throw new BuildException(this.getTaskName() + " task calling a target" + " that depends on" + " its parent target '" + owningTargetName + "'.");
                    }
                }
                this.addReferences();
                if (locals.size() <= 0 || locals.size() == 1 && "".equals(locals.get(0))) break block28;
                BuildException be2 = null;
                try {
                    this.log("Entering " + this.antFile + "...", 3);
                    this.newProject.fireSubBuildStarted();
                    this.newProject.executeTargets(locals);
                }
                catch (BuildException ex3) {
                    be2 = ProjectHelper.addLocationToBuildException(ex3, this.getLocation());
                    throw be2;
                }
                finally {
                    this.log("Exiting " + this.antFile + ".", 3);
                    this.newProject.fireSubBuildFinished(be2);
                }
            }
            finally {
                this.newProject = null;
                Enumeration e2 = this.properties.elements();
                while (e2.hasMoreElements()) {
                    Property p2 = (Property)e2.nextElement();
                    p2.setProject(null);
                }
                if (this.output != null && this.out != null) {
                    try {
                        this.out.close();
                    }
                    catch (Exception ex4) {}
                }
                this.dir = savedDir;
                this.antFile = savedAntFile;
            }
        }
    }

    private void overrideProperties() throws BuildException {
        Property p2;
        HashSet<String> set = new HashSet<String>();
        for (int i2 = this.properties.size() - 1; i2 >= 0; --i2) {
            p2 = (Property)this.properties.get(i2);
            if (p2.getName() == null || p2.getName().equals("")) continue;
            if (set.contains(p2.getName())) {
                this.properties.remove(i2);
                continue;
            }
            set.add(p2.getName());
        }
        Enumeration e2 = this.properties.elements();
        while (e2.hasMoreElements()) {
            p2 = (Property)e2.nextElement();
            p2.setProject(this.newProject);
            p2.execute();
        }
        this.getProject().copyInheritedProperties(this.newProject);
    }

    private void addReferences() throws BuildException {
        Enumeration<Object> e2;
        Hashtable thisReferences = (Hashtable)this.getProject().getReferences().clone();
        Hashtable newReferences = this.newProject.getReferences();
        if (this.references.size() > 0) {
            e2 = this.references.elements();
            while (e2.hasMoreElements()) {
                Reference ref = (Reference)e2.nextElement();
                String refid = ref.getRefId();
                if (refid == null) {
                    throw new BuildException("the refid attribute is required for reference elements");
                }
                if (!thisReferences.containsKey(refid)) {
                    this.log("Parent project doesn't contain any reference '" + refid + "'", 1);
                    continue;
                }
                thisReferences.remove(refid);
                String toRefid = ref.getToRefid();
                if (toRefid == null) {
                    toRefid = refid;
                }
                this.copyReference(refid, toRefid);
            }
        }
        if (this.inheritRefs) {
            e2 = thisReferences.keys();
            while (e2.hasMoreElements()) {
                String key = (String)e2.nextElement();
                if (newReferences.containsKey(key)) continue;
                this.copyReference(key, key);
                this.newProject.inheritIDReferences(this.getProject());
            }
        }
    }

    private void copyReference(String oldKey, String newKey) {
        Object orig = this.getProject().getReference(oldKey);
        if (orig == null) {
            this.log("No object referenced by " + oldKey + ". Can't copy to " + newKey, 1);
            return;
        }
        Class<?> c2 = orig.getClass();
        Object copy = orig;
        try {
            Method cloneM = c2.getMethod("clone", new Class[0]);
            if (cloneM != null) {
                copy = cloneM.invoke(orig, new Object[0]);
                this.log("Adding clone of reference " + oldKey, 4);
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        if (copy instanceof ProjectComponent) {
            ((ProjectComponent)copy).setProject(this.newProject);
        } else {
            try {
                Method setProjectM = c2.getMethod("setProject", class$org$apache$tools$ant$Project == null ? (class$org$apache$tools$ant$Project = Ant.class$("org.apache.tools.ant.Project")) : class$org$apache$tools$ant$Project);
                if (setProjectM != null) {
                    setProjectM.invoke(copy, this.newProject);
                }
            }
            catch (NoSuchMethodException e3) {
            }
            catch (Exception e2) {
                String msg = "Error setting new project instance for reference with id " + oldKey;
                throw new BuildException(msg, e2, this.getLocation());
            }
        }
        this.newProject.addReference(newKey, copy);
    }

    private void addAlmostAll(Hashtable props) {
        Enumeration e2 = props.keys();
        while (e2.hasMoreElements()) {
            String key = e2.nextElement().toString();
            if ("basedir".equals(key) || "ant.file".equals(key)) continue;
            String value = props.get(key).toString();
            if (this.newProject.getProperty(key) != null) continue;
            this.newProject.setNewProperty(key, value);
        }
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void setAntfile(String antFile) {
        this.antFile = antFile;
    }

    public void setTarget(String targetToAdd) {
        if (targetToAdd.equals("")) {
            throw new BuildException("target attribute must not be empty");
        }
        this.targets.add(targetToAdd);
        this.targetAttributeSet = true;
    }

    public void setOutput(String outputFile) {
        this.output = outputFile;
    }

    public Property createProperty() {
        Property p2 = new Property(true, this.getProject());
        p2.setProject(this.getNewProject());
        p2.setTaskName("property");
        this.properties.addElement(p2);
        return p2;
    }

    public void addReference(Reference ref) {
        this.references.addElement(ref);
    }

    public void addConfiguredTarget(TargetElement t2) {
        if (this.targetAttributeSet) {
            throw new BuildException("nested target is incompatible with the target attribute");
        }
        String name = t2.getName();
        if (name.equals("")) {
            throw new BuildException("target name must not be empty");
        }
        this.targets.add(name);
    }

    public void addPropertyset(PropertySet ps) {
        this.propertySets.addElement(ps);
    }

    protected Project getNewProject() {
        if (this.newProject == null) {
            this.reinit();
        }
        return this.newProject;
    }

    private Iterator getBuildListeners() {
        return this.getProject().getBuildListeners().iterator();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class TargetElement {
        private String name;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Reference
    extends org.apache.tools.ant.types.Reference {
        private String targetid = null;

        public void setToRefid(String targetid) {
            this.targetid = targetid;
        }

        public String getToRefid() {
            return this.targetid;
        }
    }
}

