/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.taskdefs.FixCRLF;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.StreamPumper;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Resources;
import org.apache.tools.ant.types.resources.Restrict;
import org.apache.tools.ant.types.resources.StringResource;
import org.apache.tools.ant.types.resources.selectors.Exists;
import org.apache.tools.ant.types.resources.selectors.Not;
import org.apache.tools.ant.types.resources.selectors.ResourceSelector;
import org.apache.tools.ant.util.ConcatResourceInputStream;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.ReaderInputStream;
import org.apache.tools.ant.util.StringUtils;

public class Concat
extends Task
implements ResourceCollection {
    private static final int BUFFER_SIZE = 8192;
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private static final ResourceSelector EXISTS = new Exists();
    private static final ResourceSelector NOT_EXISTS = new Not(EXISTS);
    private File destinationFile;
    private boolean append;
    private String encoding;
    private String outputEncoding;
    private boolean binary;
    private StringBuffer textBuffer;
    private ResourceCollection rc;
    private Vector filterChains;
    private boolean forceOverwrite = true;
    private TextElement footer;
    private TextElement header;
    private boolean fixLastLine = false;
    private String eolString;
    private Writer outputWriter = null;
    private ReaderFactory resourceReaderFactory = new ReaderFactory(){

        public Reader getReader(Object o2) throws IOException {
            InputStream is = ((Resource)o2).getInputStream();
            return new BufferedReader(Concat.this.encoding == null ? new InputStreamReader(is) : new InputStreamReader(is, Concat.this.encoding));
        }
    };
    private ReaderFactory identityReaderFactory = new ReaderFactory(){

        public Reader getReader(Object o2) {
            return (Reader)o2;
        }
    };

    public Concat() {
        this.reset();
    }

    public void reset() {
        this.append = false;
        this.forceOverwrite = true;
        this.destinationFile = null;
        this.encoding = null;
        this.outputEncoding = null;
        this.fixLastLine = false;
        this.filterChains = null;
        this.footer = null;
        this.header = null;
        this.binary = false;
        this.outputWriter = null;
        this.textBuffer = null;
        this.eolString = StringUtils.LINE_SEP;
        this.rc = null;
    }

    public void setDestfile(File destinationFile) {
        this.destinationFile = destinationFile;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
        if (this.outputEncoding == null) {
            this.outputEncoding = encoding;
        }
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void setForce(boolean force) {
        this.forceOverwrite = force;
    }

    public Path createPath() {
        Path path = new Path(this.getProject());
        this.add(path);
        return path;
    }

    public void addFileset(FileSet set) {
        this.add(set);
    }

    public void addFilelist(FileList list) {
        this.add(list);
    }

    public synchronized void add(ResourceCollection c2) {
        if (this.rc == null) {
            this.rc = c2;
            return;
        }
        if (!(this.rc instanceof Resources)) {
            Resources newRc = new Resources();
            newRc.setProject(this.getProject());
            newRc.add(this.rc);
            this.rc = newRc;
        }
        ((Resources)this.rc).add(c2);
    }

    public void addFilterChain(FilterChain filterChain) {
        if (this.filterChains == null) {
            this.filterChains = new Vector();
        }
        this.filterChains.addElement(filterChain);
    }

    public void addText(String text) {
        if (this.textBuffer == null) {
            this.textBuffer = new StringBuffer(text.length());
        }
        this.textBuffer.append(text);
    }

    public void addHeader(TextElement headerToAdd) {
        this.header = headerToAdd;
    }

    public void addFooter(TextElement footerToAdd) {
        this.footer = footerToAdd;
    }

    public void setFixLastLine(boolean fixLastLine) {
        this.fixLastLine = fixLastLine;
    }

    public void setEol(FixCRLF.CrLf crlf) {
        String s2 = crlf.getValue();
        if (s2.equals("cr") || s2.equals("mac")) {
            this.eolString = "\r";
        } else if (s2.equals("lf") || s2.equals("unix")) {
            this.eolString = "\n";
        } else if (s2.equals("crlf") || s2.equals("dos")) {
            this.eolString = "\r\n";
        }
    }

    public void setWriter(Writer outputWriter) {
        this.outputWriter = outputWriter;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public void execute() {
        InputStream catStream;
        OutputStream out;
        this.validate();
        if (this.binary && this.destinationFile == null) {
            throw new BuildException("destfile attribute is required for binary concatenation");
        }
        ResourceCollection c2 = this.getResources();
        if (this.isUpToDate(c2)) {
            this.log(this.destinationFile + " is up-to-date.", 3);
            return;
        }
        if (c2.size() == 0) {
            return;
        }
        if (this.destinationFile == null) {
            out = new LogOutputStream(this, 1);
        } else {
            try {
                File parent = this.destinationFile.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                out = new FileOutputStream(this.destinationFile.getPath(), this.append);
            }
            catch (Throwable t2) {
                throw new BuildException("Unable to open " + this.destinationFile + " for writing", t2);
            }
        }
        try {
            catStream = new ConcatResource(c2).getInputStream();
        }
        catch (IOException e2) {
            throw new BuildException("error getting concatenated resource content", e2);
        }
        this.pump(catStream, out);
    }

    public Iterator iterator() {
        this.validate();
        return Collections.singletonList(new ConcatResource(this.getResources())).iterator();
    }

    public int size() {
        return 1;
    }

    public boolean isFilesystemOnly() {
        return false;
    }

    private void validate() {
        this.sanitizeText();
        if (this.binary) {
            if (this.textBuffer != null) {
                throw new BuildException("Nested text is incompatible with binary concatenation");
            }
            if (this.encoding != null || this.outputEncoding != null) {
                throw new BuildException("Setting input or output encoding is incompatible with binary concatenation");
            }
            if (this.filterChains != null) {
                throw new BuildException("Setting filters is incompatible with binary concatenation");
            }
            if (this.fixLastLine) {
                throw new BuildException("Setting fixlastline is incompatible with binary concatenation");
            }
            if (this.header != null || this.footer != null) {
                throw new BuildException("Nested header or footer is incompatible with binary concatenation");
            }
        }
        if (this.destinationFile != null && this.outputWriter != null) {
            throw new BuildException("Cannot specify both a destination file and an output writer");
        }
        if (this.rc == null && this.textBuffer == null) {
            throw new BuildException("At least one resource must be provided, or some text.");
        }
        if (this.rc != null && this.textBuffer != null) {
            throw new BuildException("Cannot include inline text when using resources.");
        }
    }

    private ResourceCollection getResources() {
        if (this.rc == null) {
            return new StringResource(this.getProject(), this.textBuffer.toString());
        }
        Restrict noexistRc = new Restrict();
        noexistRc.add(NOT_EXISTS);
        noexistRc.add(this.rc);
        Iterator i2 = noexistRc.iterator();
        while (i2.hasNext()) {
            this.log(i2.next() + " does not exist.", 0);
        }
        if (this.destinationFile != null) {
            i2 = this.rc.iterator();
            while (i2.hasNext()) {
                File f2;
                Object o2 = i2.next();
                if (!(o2 instanceof FileResource) || !FILE_UTILS.fileNameEquals(f2 = ((FileResource)o2).getFile(), this.destinationFile)) continue;
                throw new BuildException("Input file \"" + f2 + "\" is the same as the output file.");
            }
        }
        Restrict result = new Restrict();
        result.add(EXISTS);
        result.add(this.rc);
        return result;
    }

    private boolean isUpToDate(ResourceCollection c2) {
        if (this.destinationFile == null || this.forceOverwrite) {
            return false;
        }
        Iterator i2 = c2.iterator();
        while (i2.hasNext()) {
            Resource r2 = (Resource)i2.next();
            if (r2.getLastModified() != 0L && r2.getLastModified() <= this.destinationFile.lastModified()) continue;
            return false;
        }
        return true;
    }

    private void sanitizeText() {
        if (this.textBuffer != null && "".equals(this.textBuffer.toString().trim())) {
            this.textBuffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pump(InputStream in, OutputStream out) {
        Thread t2 = new Thread(new StreamPumper(in, out));
        t2.start();
        try {
            try {
                t2.join();
            }
            catch (InterruptedException e2) {
                try {
                    t2.join();
                }
                catch (InterruptedException ee2) {
                }
                Object var7_5 = null;
                FileUtils.close(in);
                FileUtils.close(out);
                return;
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            FileUtils.close(in);
            FileUtils.close(out);
            throw throwable;
        }
        FileUtils.close(in);
        FileUtils.close(out);
    }

    private Reader getFilteredReader(Reader r2) {
        if (this.filterChains == null) {
            return r2;
        }
        ChainReaderHelper helper = new ChainReaderHelper();
        helper.setBufferSize(8192);
        helper.setPrimaryReader(r2);
        helper.setFilterChains(this.filterChains);
        helper.setProject(this.getProject());
        return helper.getAssembledReader();
    }

    private final class ConcatResource
    extends Resource {
        private ResourceCollection c;

        private ConcatResource(ResourceCollection c2) {
            this.c = c2;
        }

        public InputStream getInputStream() throws IOException {
            Reader rdr;
            if (Concat.this.binary) {
                ConcatResourceInputStream result = new ConcatResourceInputStream(this.c);
                result.setManagingComponent(this);
                return result;
            }
            Reader resourceReader = Concat.this.getFilteredReader(new MultiReader(this.c.iterator(), Concat.this.resourceReaderFactory));
            if (Concat.this.header == null && Concat.this.footer == null) {
                rdr = resourceReader;
            } else {
                int readerCount = 1;
                if (Concat.this.header != null) {
                    ++readerCount;
                }
                if (Concat.this.footer != null) {
                    ++readerCount;
                }
                Reader[] readers = new Reader[readerCount];
                int pos = 0;
                if (Concat.this.header != null) {
                    readers[pos] = new StringReader(Concat.this.header.getValue());
                    if (Concat.this.header.getFiltering()) {
                        readers[pos] = Concat.this.getFilteredReader(readers[pos]);
                    }
                }
                int n2 = ++pos;
                ++pos;
                readers[n2] = resourceReader;
                if (Concat.this.footer != null) {
                    readers[pos] = new StringReader(Concat.this.footer.getValue());
                    if (Concat.this.footer.getFiltering()) {
                        readers[pos] = Concat.this.getFilteredReader(readers[pos]);
                    }
                }
                rdr = new MultiReader(Arrays.asList(readers).iterator(), Concat.this.identityReaderFactory);
            }
            return Concat.this.outputEncoding == null ? new ReaderInputStream(rdr) : new ReaderInputStream(rdr, Concat.this.outputEncoding);
        }

        public String getName() {
            return "concat (" + String.valueOf(this.c) + ")";
        }
    }

    private final class MultiReader
    extends Reader {
        private Reader reader = null;
        private int lastPos = 0;
        private char[] lastChars = new char[Concat.access$000(Concat.this).length()];
        private boolean needAddSeparator = false;
        private Iterator readerSources;
        private ReaderFactory factory;

        private MultiReader(Iterator readerSources, ReaderFactory factory) {
            this.readerSources = readerSources;
            this.factory = factory;
        }

        private Reader getReader() throws IOException {
            if (this.reader == null && this.readerSources.hasNext()) {
                this.reader = this.factory.getReader(this.readerSources.next());
                Arrays.fill(this.lastChars, '\u0000');
            }
            return this.reader;
        }

        private void nextReader() throws IOException {
            this.close();
            this.reader = null;
        }

        public int read() throws IOException {
            if (this.needAddSeparator) {
                char ret = Concat.this.eolString.charAt(this.lastPos++);
                if (this.lastPos >= Concat.this.eolString.length()) {
                    this.lastPos = 0;
                    this.needAddSeparator = false;
                }
                return ret;
            }
            while (this.getReader() != null) {
                int ch2 = this.getReader().read();
                if (ch2 == -1) {
                    this.nextReader();
                    if (!this.isFixLastLine() || !this.isMissingEndOfLine()) continue;
                    this.needAddSeparator = true;
                    this.lastPos = 0;
                    continue;
                }
                this.addLastChar((char)ch2);
                return ch2;
            }
            return -1;
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            int amountRead = 0;
            while (this.getReader() != null || this.needAddSeparator) {
                if (this.needAddSeparator) {
                    cbuf[off] = Concat.this.eolString.charAt(this.lastPos++);
                    if (this.lastPos >= Concat.this.eolString.length()) {
                        this.lastPos = 0;
                        this.needAddSeparator = false;
                    }
                    ++off;
                    ++amountRead;
                    if (--len != 0) continue;
                    return amountRead;
                }
                int nRead = this.getReader().read(cbuf, off, len);
                if (nRead == -1 || nRead == 0) {
                    this.nextReader();
                    if (!this.isFixLastLine() || !this.isMissingEndOfLine()) continue;
                    this.needAddSeparator = true;
                    this.lastPos = 0;
                    continue;
                }
                if (this.isFixLastLine()) {
                    for (int i2 = nRead; i2 > nRead - this.lastChars.length && i2 > 0; --i2) {
                        this.addLastChar(cbuf[off + i2 - 1]);
                    }
                }
                off += nRead;
                amountRead += nRead;
                if ((len -= nRead) != 0) continue;
                return amountRead;
            }
            if (amountRead == 0) {
                return -1;
            }
            return amountRead;
        }

        public void close() throws IOException {
            if (this.reader != null) {
                this.reader.close();
            }
        }

        private void addLastChar(char ch2) {
            for (int i2 = this.lastChars.length - 2; i2 >= 0; --i2) {
                this.lastChars[i2] = this.lastChars[i2 + 1];
            }
            this.lastChars[this.lastChars.length - 1] = ch2;
        }

        private boolean isMissingEndOfLine() {
            for (int i2 = 0; i2 < this.lastChars.length; ++i2) {
                if (this.lastChars[i2] == Concat.this.eolString.charAt(i2)) continue;
                return true;
            }
            return false;
        }

        private boolean isFixLastLine() {
            return Concat.this.fixLastLine && Concat.this.textBuffer == null;
        }
    }

    private static interface ReaderFactory {
        public Reader getReader(Object var1) throws IOException;
    }

    public static class TextElement
    extends ProjectComponent {
        private String value = "";
        private boolean trimLeading = false;
        private boolean trim = false;
        private boolean filtering = true;
        private String encoding = null;

        public void setFiltering(boolean filtering) {
            this.filtering = filtering;
        }

        private boolean getFiltering() {
            return this.filtering;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public void setFile(File file) throws BuildException {
            if (!file.exists()) {
                throw new BuildException("File " + file + " does not exist.");
            }
            BufferedReader reader = null;
            try {
                try {
                    reader = this.encoding == null ? new BufferedReader(new FileReader(file)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.encoding));
                    this.value = FileUtils.safeReadFully(reader);
                }
                catch (IOException ex2) {
                    throw new BuildException(ex2);
                }
                Object var5_3 = null;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                FileUtils.close(reader);
                throw throwable;
            }
            FileUtils.close(reader);
        }

        public void addText(String value) {
            this.value = this.value + this.getProject().replaceProperties(value);
        }

        public void setTrimLeading(boolean strip) {
            this.trimLeading = strip;
        }

        public void setTrim(boolean trim) {
            this.trim = trim;
        }

        public String getValue() {
            if (this.value == null) {
                this.value = "";
            }
            if (this.value.trim().length() == 0) {
                this.value = "";
            }
            if (this.trimLeading) {
                char[] current = this.value.toCharArray();
                StringBuffer b2 = new StringBuffer(current.length);
                boolean startOfLine = true;
                int pos = 0;
                while (pos < current.length) {
                    char ch2 = current[pos++];
                    if (startOfLine) {
                        if (ch2 == ' ' || ch2 == '\t') continue;
                        startOfLine = false;
                    }
                    b2.append(ch2);
                    if (ch2 != '\n' && ch2 != '\r') continue;
                    startOfLine = true;
                }
                this.value = b2.toString();
            }
            if (this.trim) {
                this.value = this.value.trim();
            }
            return this.value;
        }
    }
}

