/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.ResourceFactory;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.FlatFileNameMapper;
import org.apache.tools.ant.util.IdentityMapper;
import org.apache.tools.ant.util.ResourceUtils;
import org.apache.tools.ant.util.SourceFileScanner;

public class Copy
extends Task {
    static final File NULL_FILE_PLACEHOLDER = new File("/NULL_FILE");
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected File file = null;
    protected File destFile = null;
    protected File destDir = null;
    protected Vector rcs = new Vector();
    private boolean enableMultipleMappings = false;
    protected boolean filtering = false;
    protected boolean preserveLastModified = false;
    protected boolean forceOverwrite = false;
    protected boolean flatten = false;
    protected int verbosity = 3;
    protected boolean includeEmpty = true;
    protected boolean failonerror = true;
    protected Hashtable fileCopyMap = new Hashtable();
    protected Hashtable dirCopyMap = new Hashtable();
    protected Hashtable completeDirMap = new Hashtable();
    protected Mapper mapperElement = null;
    protected FileUtils fileUtils;
    private Vector filterChains = new Vector();
    private Vector filterSets = new Vector();
    private String inputEncoding = null;
    private String outputEncoding = null;
    private long granularity = 0L;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$Copy;
    static /* synthetic */ Class class$java$io$IOException;

    public Copy() {
        this.fileUtils = FileUtils.getFileUtils();
        this.granularity = this.fileUtils.getFileTimestampGranularity();
    }

    protected FileUtils getFileUtils() {
        return this.fileUtils;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setTofile(File destFile) {
        this.destFile = destFile;
    }

    public void setTodir(File destDir) {
        this.destDir = destDir;
    }

    public FilterChain createFilterChain() {
        FilterChain filterChain = new FilterChain();
        this.filterChains.addElement(filterChain);
        return filterChain;
    }

    public FilterSet createFilterSet() {
        FilterSet filterSet = new FilterSet();
        this.filterSets.addElement(filterSet);
        return filterSet;
    }

    public void setPreserveLastModified(String preserve) {
        this.setPreserveLastModified(Project.toBoolean(preserve));
    }

    public void setPreserveLastModified(boolean preserve) {
        this.preserveLastModified = preserve;
    }

    public boolean getPreserveLastModified() {
        return this.preserveLastModified;
    }

    protected Vector getFilterSets() {
        return this.filterSets;
    }

    protected Vector getFilterChains() {
        return this.filterChains;
    }

    public void setFiltering(boolean filtering) {
        this.filtering = filtering;
    }

    public void setOverwrite(boolean overwrite) {
        this.forceOverwrite = overwrite;
    }

    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    public void setVerbose(boolean verbose) {
        this.verbosity = verbose ? 2 : 3;
    }

    public void setIncludeEmptyDirs(boolean includeEmpty) {
        this.includeEmpty = includeEmpty;
    }

    public void setEnableMultipleMappings(boolean enableMultipleMappings) {
        this.enableMultipleMappings = enableMultipleMappings;
    }

    public boolean isEnableMultipleMapping() {
        return this.enableMultipleMappings;
    }

    public void setFailOnError(boolean failonerror) {
        this.failonerror = failonerror;
    }

    public void addFileset(FileSet set) {
        this.add(set);
    }

    public void add(ResourceCollection res) {
        this.rcs.add(res);
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper", this.getLocation());
        }
        this.mapperElement = new Mapper(this.getProject());
        return this.mapperElement;
    }

    public void add(FileNameMapper fileNameMapper) {
        this.createMapper().add(fileNameMapper);
    }

    public void setEncoding(String encoding) {
        this.inputEncoding = encoding;
        if (this.outputEncoding == null) {
            this.outputEncoding = encoding;
        }
    }

    public String getEncoding() {
        return this.inputEncoding;
    }

    public void setOutputEncoding(String encoding) {
        this.outputEncoding = encoding;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setGranularity(long granularity) {
        this.granularity = granularity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        block22: {
            File savedFile = this.file;
            File savedDestFile = this.destFile;
            File savedDestDir = this.destDir;
            ResourceCollection savedRc = null;
            if (this.file == null && this.destFile != null && this.rcs.size() == 1) {
                savedRc = (ResourceCollection)this.rcs.elementAt(0);
            }
            this.validateAttributes();
            try {
                this.copySingleFile();
                HashMap filesByBasedir = new HashMap();
                HashMap dirsByBasedir = new HashMap();
                HashSet<File> baseDirs = new HashSet<File>();
                ArrayList<Resource> nonFileResources = new ArrayList<Resource>();
                for (int i2 = 0; i2 < this.rcs.size(); ++i2) {
                    ResourceCollection rc = (ResourceCollection)this.rcs.elementAt(i2);
                    if (rc instanceof FileSet && rc.isFilesystemOnly()) {
                        FileSet fs2 = (FileSet)rc;
                        DirectoryScanner ds2 = null;
                        try {
                            ds2 = fs2.getDirectoryScanner(this.getProject());
                        }
                        catch (BuildException e2) {
                            if (this.failonerror || !this.getMessage(e2).endsWith(" not found.")) {
                                throw e2;
                            }
                            this.log("Warning: " + this.getMessage(e2), 0);
                            continue;
                        }
                        File fromDir = fs2.getDir(this.getProject());
                        String[] srcFiles = ds2.getIncludedFiles();
                        String[] srcDirs = ds2.getIncludedDirectories();
                        if (!this.flatten && this.mapperElement == null && ds2.isEverythingIncluded() && !fs2.hasPatterns()) {
                            this.completeDirMap.put(fromDir, this.destDir);
                        }
                        Copy.add(fromDir, srcFiles, filesByBasedir);
                        Copy.add(fromDir, srcDirs, dirsByBasedir);
                        baseDirs.add(fromDir);
                        continue;
                    }
                    if (!rc.isFilesystemOnly() && !this.supportsNonFileResources()) {
                        throw new BuildException("Only FileSystem resources are supported.");
                    }
                    Iterator resources = rc.iterator();
                    while (resources.hasNext()) {
                        Resource r2 = (Resource)resources.next();
                        if (!r2.isExists()) continue;
                        File baseDir = NULL_FILE_PLACEHOLDER;
                        String name = r2.getName();
                        if (r2 instanceof FileResource) {
                            FileResource fr2 = (FileResource)r2;
                            baseDir = Copy.getKeyFile(fr2.getBaseDir());
                            if (fr2.getBaseDir() == null) {
                                name = fr2.getFile().getAbsolutePath();
                            }
                        }
                        if (r2.isDirectory() || r2 instanceof FileResource) {
                            Copy.add(baseDir, name, r2.isDirectory() ? dirsByBasedir : filesByBasedir);
                            baseDirs.add(baseDir);
                            continue;
                        }
                        nonFileResources.add(r2);
                    }
                }
                this.iterateOverBaseDirs(baseDirs, dirsByBasedir, filesByBasedir);
                try {
                    this.doFileOperations();
                }
                catch (BuildException e3) {
                    if (!this.failonerror) {
                        this.log("Warning: " + this.getMessage(e3), 0);
                    }
                    throw e3;
                }
                if (nonFileResources.size() <= 0) break block22;
                Resource[] nonFiles = nonFileResources.toArray(new Resource[nonFileResources.size()]);
                Map map = this.scan(nonFiles, this.destDir);
                try {
                    this.doResourceOperations(map);
                }
                catch (BuildException e4) {
                    if (!this.failonerror) {
                        this.log("Warning: " + this.getMessage(e4), 0);
                        break block22;
                    }
                    throw e4;
                }
            }
            finally {
                this.file = savedFile;
                this.destFile = savedDestFile;
                this.destDir = savedDestDir;
                if (savedRc != null) {
                    this.rcs.insertElementAt(savedRc, 0);
                }
                this.fileCopyMap.clear();
                this.dirCopyMap.clear();
                this.completeDirMap.clear();
            }
        }
    }

    private void copySingleFile() {
        if (this.file != null) {
            if (this.file.exists()) {
                if (this.destFile == null) {
                    this.destFile = new File(this.destDir, this.file.getName());
                }
                if (this.forceOverwrite || !this.destFile.exists() || this.file.lastModified() - this.granularity > this.destFile.lastModified()) {
                    this.fileCopyMap.put(this.file.getAbsolutePath(), new String[]{this.destFile.getAbsolutePath()});
                } else {
                    this.log(this.file + " omitted as " + this.destFile + " is up to date.", 3);
                }
            } else {
                String message = "Warning: Could not find file " + this.file.getAbsolutePath() + " to copy.";
                if (!this.failonerror) {
                    this.log(message, 0);
                } else {
                    throw new BuildException(message);
                }
            }
        }
    }

    private void iterateOverBaseDirs(HashSet baseDirs, HashMap dirsByBasedir, HashMap filesByBasedir) {
        Iterator iter = baseDirs.iterator();
        while (iter.hasNext()) {
            File f2 = (File)iter.next();
            List files = (List)filesByBasedir.get(f2);
            List dirs = (List)dirsByBasedir.get(f2);
            String[] srcFiles = new String[]{};
            if (files != null) {
                srcFiles = files.toArray(srcFiles);
            }
            String[] srcDirs = new String[]{};
            if (dirs != null) {
                srcDirs = dirs.toArray(srcDirs);
            }
            this.scan(f2 == NULL_FILE_PLACEHOLDER ? null : f2, this.destDir, srcFiles, srcDirs);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateAttributes() throws BuildException {
        if (this.file == null && this.rcs.size() == 0) {
            throw new BuildException("Specify at least one source--a file or a resource collection.");
        }
        if (this.destFile != null && this.destDir != null) {
            throw new BuildException("Only one of tofile and todir may be set.");
        }
        if (this.destFile == null && this.destDir == null) {
            throw new BuildException("One of tofile or todir must be set.");
        }
        if (this.file != null && this.file.isDirectory()) {
            throw new BuildException("Use a resource collection to copy directories.");
        }
        if (this.destFile != null && this.rcs.size() > 0) {
            if (this.rcs.size() > 1) {
                throw new BuildException("Cannot concatenate multiple files into a single file.");
            }
            ResourceCollection rc = (ResourceCollection)this.rcs.elementAt(0);
            if (!rc.isFilesystemOnly()) {
                throw new BuildException("Only FileSystem resources are supported when concatenating files.");
            }
            if (rc.size() == 0) {
                throw new BuildException("Cannot perform operation from directory to file.");
            }
            if (rc.size() != 1) throw new BuildException("Cannot concatenate multiple files into a single file.");
            FileResource r2 = (FileResource)rc.iterator().next();
            if (this.file != null) throw new BuildException("Cannot concatenate multiple files into a single file.");
            this.file = r2.getFile();
            this.rcs.removeElementAt(0);
        }
        if (this.destFile == null) return;
        this.destDir = this.destFile.getParentFile();
    }

    protected void scan(File fromDir, File toDir, String[] files, String[] dirs) {
        FileNameMapper mapper = this.getMapper();
        this.buildMap(fromDir, toDir, files, mapper, this.fileCopyMap);
        if (this.includeEmpty) {
            this.buildMap(fromDir, toDir, dirs, mapper, this.dirCopyMap);
        }
    }

    protected Map scan(Resource[] fromResources, File toDir) {
        return this.buildMap(fromResources, toDir, this.getMapper());
    }

    protected void buildMap(File fromDir, File toDir, String[] names, FileNameMapper mapper, Hashtable map) {
        Object[] toCopy = null;
        if (this.forceOverwrite) {
            Vector<String> v2 = new Vector<String>();
            for (int i2 = 0; i2 < names.length; ++i2) {
                if (mapper.mapFileName(names[i2]) == null) continue;
                v2.addElement(names[i2]);
            }
            toCopy = new String[v2.size()];
            v2.copyInto(toCopy);
        } else {
            SourceFileScanner ds2 = new SourceFileScanner(this);
            toCopy = ds2.restrict(names, fromDir, toDir, mapper, this.granularity);
        }
        for (int i3 = 0; i3 < toCopy.length; ++i3) {
            File src = new File(fromDir, (String)toCopy[i3]);
            String[] mappedFiles = mapper.mapFileName((String)toCopy[i3]);
            if (!this.enableMultipleMappings) {
                map.put(src.getAbsolutePath(), new String[]{new File(toDir, mappedFiles[0]).getAbsolutePath()});
                continue;
            }
            for (int k2 = 0; k2 < mappedFiles.length; ++k2) {
                mappedFiles[k2] = new File(toDir, mappedFiles[k2]).getAbsolutePath();
            }
            map.put(src.getAbsolutePath(), mappedFiles);
        }
    }

    protected Map buildMap(Resource[] fromResources, final File toDir, FileNameMapper mapper) {
        HashMap<Object, String[]> map = new HashMap<Object, String[]>();
        Object[] toCopy = null;
        if (this.forceOverwrite) {
            Vector<Resource> v2 = new Vector<Resource>();
            for (int i2 = 0; i2 < fromResources.length; ++i2) {
                if (mapper.mapFileName(fromResources[i2].getName()) == null) continue;
                v2.addElement(fromResources[i2]);
            }
            toCopy = new Resource[v2.size()];
            v2.copyInto(toCopy);
        } else {
            toCopy = ResourceUtils.selectOutOfDateSources((ProjectComponent)this, fromResources, mapper, new ResourceFactory(){

                public Resource getResource(String name) {
                    return new FileResource(toDir, name);
                }
            }, this.granularity);
        }
        for (int i3 = 0; i3 < toCopy.length; ++i3) {
            String[] mappedFiles = mapper.mapFileName(((Resource)toCopy[i3]).getName());
            if (!this.enableMultipleMappings) {
                map.put(toCopy[i3], new String[]{new File(toDir, mappedFiles[0]).getAbsolutePath()});
                continue;
            }
            for (int k2 = 0; k2 < mappedFiles.length; ++k2) {
                mappedFiles[k2] = new File(toDir, mappedFiles[k2]).getAbsolutePath();
            }
            map.put(toCopy[i3], mappedFiles);
        }
        return map;
    }

    protected void doFileOperations() {
        int i2;
        Enumeration<Object> e2;
        if (this.fileCopyMap.size() > 0) {
            this.log("Copying " + this.fileCopyMap.size() + " file" + (this.fileCopyMap.size() == 1 ? "" : "s") + " to " + this.destDir.getAbsolutePath());
            e2 = this.fileCopyMap.keys();
            while (e2.hasMoreElements()) {
                String fromFile = (String)e2.nextElement();
                String[] toFiles = (String[])this.fileCopyMap.get(fromFile);
                for (i2 = 0; i2 < toFiles.length; ++i2) {
                    String toFile = toFiles[i2];
                    if (fromFile.equals(toFile)) {
                        this.log("Skipping self-copy of " + fromFile, this.verbosity);
                        continue;
                    }
                    try {
                        this.log("Copying " + fromFile + " to " + toFile, this.verbosity);
                        FilterSetCollection executionFilters = new FilterSetCollection();
                        if (this.filtering) {
                            executionFilters.addFilterSet(this.getProject().getGlobalFilterSet());
                        }
                        Enumeration filterEnum = this.filterSets.elements();
                        while (filterEnum.hasMoreElements()) {
                            executionFilters.addFilterSet((FilterSet)filterEnum.nextElement());
                        }
                        this.fileUtils.copyFile(fromFile, toFile, executionFilters, this.filterChains, this.forceOverwrite, this.preserveLastModified, this.inputEncoding, this.outputEncoding, this.getProject());
                        continue;
                    }
                    catch (IOException ioe) {
                        String msg = "Failed to copy " + fromFile + " to " + toFile + " due to " + this.getDueTo(ioe);
                        File targetFile = new File(toFile);
                        if (targetFile.exists() && !targetFile.delete()) {
                            msg = msg + " and I couldn't delete the corrupt " + toFile;
                        }
                        if (this.failonerror) {
                            throw new BuildException(msg, ioe, this.getLocation());
                        }
                        this.log(msg, 0);
                    }
                }
            }
        }
        if (this.includeEmpty) {
            e2 = this.dirCopyMap.elements();
            int createCount = 0;
            while (e2.hasMoreElements()) {
                String[] dirs = (String[])e2.nextElement();
                for (i2 = 0; i2 < dirs.length; ++i2) {
                    File d2 = new File(dirs[i2]);
                    if (d2.exists()) continue;
                    if (!d2.mkdirs()) {
                        this.log("Unable to create directory " + d2.getAbsolutePath(), 0);
                        continue;
                    }
                    ++createCount;
                }
            }
            if (createCount > 0) {
                this.log("Copied " + this.dirCopyMap.size() + " empty director" + (this.dirCopyMap.size() == 1 ? "y" : "ies") + " to " + createCount + " empty director" + (createCount == 1 ? "y" : "ies") + " under " + this.destDir.getAbsolutePath());
            }
        }
    }

    protected void doResourceOperations(Map map) {
        if (map.size() > 0) {
            this.log("Copying " + map.size() + " resource" + (map.size() == 1 ? "" : "s") + " to " + this.destDir.getAbsolutePath());
            Iterator iter = map.keySet().iterator();
            while (iter.hasNext()) {
                Resource fromResource = (Resource)iter.next();
                String[] toFiles = (String[])map.get(fromResource);
                for (int i2 = 0; i2 < toFiles.length; ++i2) {
                    String toFile = toFiles[i2];
                    try {
                        this.log("Copying " + fromResource + " to " + toFile, this.verbosity);
                        FilterSetCollection executionFilters = new FilterSetCollection();
                        if (this.filtering) {
                            executionFilters.addFilterSet(this.getProject().getGlobalFilterSet());
                        }
                        Enumeration filterEnum = this.filterSets.elements();
                        while (filterEnum.hasMoreElements()) {
                            executionFilters.addFilterSet((FilterSet)filterEnum.nextElement());
                        }
                        ResourceUtils.copyResource(fromResource, new FileResource(this.destDir, toFile), executionFilters, this.filterChains, this.forceOverwrite, this.preserveLastModified, this.inputEncoding, this.outputEncoding, this.getProject());
                        continue;
                    }
                    catch (IOException ioe) {
                        String msg = "Failed to copy " + fromResource + " to " + toFile + " due to " + this.getDueTo(ioe);
                        File targetFile = new File(toFile);
                        if (targetFile.exists() && !targetFile.delete()) {
                            msg = msg + " and I couldn't delete the corrupt " + toFile;
                        }
                        if (this.failonerror) {
                            throw new BuildException(msg, ioe, this.getLocation());
                        }
                        this.log(msg, 0);
                    }
                }
            }
        }
    }

    protected boolean supportsNonFileResources() {
        return this.getClass().equals(class$org$apache$tools$ant$taskdefs$Copy == null ? (class$org$apache$tools$ant$taskdefs$Copy = Copy.class$("org.apache.tools.ant.taskdefs.Copy")) : class$org$apache$tools$ant$taskdefs$Copy);
    }

    private static void add(File baseDir, String[] names, Map m2) {
        if (names != null) {
            ArrayList<String> l2 = (ArrayList<String>)m2.get(baseDir = Copy.getKeyFile(baseDir));
            if (l2 == null) {
                l2 = new ArrayList<String>(names.length);
                m2.put(baseDir, l2);
            }
            l2.addAll(Arrays.asList(names));
        }
    }

    private static void add(File baseDir, String name, Map m2) {
        if (name != null) {
            Copy.add(baseDir, new String[]{name}, m2);
        }
    }

    private static File getKeyFile(File f2) {
        return f2 == null ? NULL_FILE_PLACEHOLDER : f2;
    }

    private FileNameMapper getMapper() {
        FileNameMapper mapper = null;
        mapper = this.mapperElement != null ? this.mapperElement.getImplementation() : (this.flatten ? new FlatFileNameMapper() : new IdentityMapper());
        return mapper;
    }

    private String getMessage(Exception ex2) {
        return ex2.getMessage() == null ? ex2.toString() : ex2.getMessage();
    }

    private String getDueTo(Exception ex2) {
        boolean baseIOException = ex2.getClass() == (class$java$io$IOException == null ? (class$java$io$IOException = Copy.class$("java.io.IOException")) : class$java$io$IOException);
        StringBuffer message = new StringBuffer();
        if (!baseIOException || ex2.getMessage() == null) {
            message.append(ex2.getClass().getName());
        }
        if (ex2.getMessage() != null) {
            if (!baseIOException) {
                message.append(" ");
            }
            message.append(ex2.getMessage());
        }
        if (ex2.getClass().getName().indexOf("MalformedInput") != -1) {
            message.append(LINE_SEPARATOR);
            message.append("This is normally due to the input file containing invalid");
            message.append(LINE_SEPARATOR);
            message.append("bytes for the character encoding used : ");
            message.append(this.inputEncoding == null ? this.fileUtils.getDefaultEncoding() : this.inputEncoding);
            message.append(LINE_SEPARATOR);
        }
        return message.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

