/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.TimeComparison;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Resources;
import org.apache.tools.ant.types.resources.Restrict;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.types.resources.comparators.ResourceComparator;
import org.apache.tools.ant.types.resources.comparators.Reverse;
import org.apache.tools.ant.types.resources.selectors.Date;
import org.apache.tools.ant.types.resources.selectors.Exists;
import org.apache.tools.ant.types.resources.selectors.Not;
import org.apache.tools.ant.types.resources.selectors.ResourceSelector;

public class DependSet
extends MatchingTask {
    private static final ResourceSelector NOT_EXISTS = new Not(new Exists());
    private static final ResourceComparator DATE = new org.apache.tools.ant.types.resources.comparators.Date();
    private static final ResourceComparator REVERSE_DATE = new Reverse(DATE);
    private Union sources = null;
    private Path targets = null;

    public synchronized Union createSources() {
        this.sources = this.sources == null ? new Union() : this.sources;
        return this.sources;
    }

    public void addSrcfileset(FileSet fs2) {
        this.createSources().add(fs2);
    }

    public void addSrcfilelist(FileList fl2) {
        this.createSources().add(fl2);
    }

    public synchronized Path createTargets() {
        this.targets = this.targets == null ? new Path(this.getProject()) : this.targets;
        return this.targets;
    }

    public void addTargetfileset(FileSet fs2) {
        this.createTargets().add(new HideMissingBasedir(fs2));
    }

    public void addTargetfilelist(FileList fl2) {
        this.createTargets().add(fl2);
    }

    public void execute() throws BuildException {
        if (this.sources == null) {
            throw new BuildException("At least one set of source resources must be specified");
        }
        if (this.targets == null) {
            throw new BuildException("At least one set of target files must be specified");
        }
        if (this.sources.size() > 0 && this.targets.size() > 0 && !this.uptodate(this.sources, this.targets)) {
            this.log("Deleting all target files.", 3);
            Delete delete = new Delete();
            delete.bindToOwner(this);
            delete.add(this.targets);
            delete.perform();
        }
    }

    private boolean uptodate(ResourceCollection src, ResourceCollection target) {
        Date datesel = new Date();
        datesel.setMillis(System.currentTimeMillis());
        datesel.setWhen(TimeComparison.AFTER);
        this.logFuture(this.targets, datesel);
        int neTargets = new NonExistent(this.targets).size();
        if (neTargets > 0) {
            this.log(neTargets + " nonexistent targets", 3);
            return false;
        }
        FileResource oldestTarget = (FileResource)this.getOldest(this.targets);
        this.log(oldestTarget + " is oldest target file", 3);
        this.logFuture(this.sources, datesel);
        int neSources = new NonExistent(this.sources).size();
        if (neSources > 0) {
            this.log(neSources + " nonexistent sources", 3);
            return false;
        }
        Resource newestSource = this.getNewest(this.sources);
        this.log(newestSource.toLongString() + " is newest source", 3);
        return oldestTarget.getLastModified() >= newestSource.getLastModified();
    }

    private void logFuture(ResourceCollection rc, ResourceSelector rsel) {
        Restrict r2 = new Restrict();
        r2.add(rsel);
        r2.add(rc);
        Iterator i2 = r2.iterator();
        while (i2.hasNext()) {
            this.log("Warning: " + i2.next() + " modified in the future.", 1);
        }
    }

    private Resource getXest(ResourceCollection rc, ResourceComparator c2) {
        Iterator i2 = rc.iterator();
        if (!i2.hasNext()) {
            return null;
        }
        Resource xest = (Resource)i2.next();
        while (i2.hasNext()) {
            Resource next = (Resource)i2.next();
            if (c2.compare(xest, next) >= 0) continue;
            xest = next;
        }
        return xest;
    }

    private Resource getOldest(ResourceCollection rc) {
        return this.getXest(rc, REVERSE_DATE);
    }

    private Resource getNewest(ResourceCollection rc) {
        return this.getXest(rc, DATE);
    }

    private static final class HideMissingBasedir
    implements ResourceCollection {
        private FileSet fs;

        private HideMissingBasedir(FileSet fs2) {
            this.fs = fs2;
        }

        public Iterator iterator() {
            return this.basedirExists() ? this.fs.iterator() : Resources.EMPTY_ITERATOR;
        }

        public int size() {
            return this.basedirExists() ? this.fs.size() : 0;
        }

        public boolean isFilesystemOnly() {
            return true;
        }

        private boolean basedirExists() {
            File basedir = this.fs.getDir();
            return basedir == null || basedir.exists();
        }
    }

    private static final class NonExistent
    extends Restrict {
        private NonExistent(ResourceCollection rc) {
            super.add(rc);
            super.add(NOT_EXISTS);
        }
    }
}

