/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.Redirector;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Permissions;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.apache.tools.ant.util.TimeoutObserver;
import org.apache.tools.ant.util.Watchdog;

public class ExecuteJava
implements Runnable,
TimeoutObserver {
    private Commandline javaCommand = null;
    private Path classpath = null;
    private CommandlineJava.SysProperties sysProperties = null;
    private Permissions perm = null;
    private Method main = null;
    private Long timeout = null;
    private volatile Throwable caught = null;
    private volatile boolean timedOut = false;
    private Thread thread = null;
    static /* synthetic */ Class array$Ljava$lang$String;

    public void setJavaCommand(Commandline javaCommand) {
        this.javaCommand = javaCommand;
    }

    public void setClasspath(Path p2) {
        this.classpath = p2;
    }

    public void setSystemProperties(CommandlineJava.SysProperties s2) {
        this.sysProperties = s2;
    }

    public void setPermissions(Permissions permissions) {
        this.perm = permissions;
    }

    public void setOutput(PrintStream out) {
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Project project) throws BuildException {
        String classname = this.javaCommand.getExecutable();
        AntClassLoader loader = null;
        try {
            if (this.sysProperties != null) {
                this.sysProperties.setSystem();
            }
            Class<?> target = null;
            try {
                if (this.classpath == null) {
                    target = Class.forName(classname);
                } else {
                    loader = project.createClassLoader(this.classpath);
                    loader.setParent(project.getCoreLoader());
                    loader.setParentFirst(false);
                    loader.addJavaLibraries();
                    loader.setIsolated(true);
                    loader.setThreadContextLoader();
                    loader.forceLoadClass(classname);
                    target = Class.forName(classname, true, loader);
                }
            }
            catch (ClassNotFoundException e2) {
                throw new BuildException("Could not find " + classname + "." + " Make sure you have it in your" + " classpath");
            }
            this.main = target.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = ExecuteJava.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            if (this.main == null) {
                throw new BuildException("Could not find main() method in " + classname);
            }
            if ((this.main.getModifiers() & 8) == 0) {
                throw new BuildException("main() method in " + classname + " is not declared static");
            }
            if (this.timeout == null) {
                this.run();
            } else {
                this.thread = new Thread((Runnable)this, "ExecuteJava");
                Task currentThreadTask = project.getThreadTask(Thread.currentThread());
                project.registerThreadTask(this.thread, currentThreadTask);
                this.thread.setDaemon(true);
                Watchdog w2 = new Watchdog(this.timeout);
                w2.addTimeoutObserver(this);
                ExecuteJava executeJava = this;
                synchronized (executeJava) {
                    this.thread.start();
                    w2.start();
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e3) {
                        // empty catch block
                    }
                    if (this.timedOut) {
                        project.log("Timeout: sub-process interrupted", 1);
                    } else {
                        this.thread = null;
                        w2.stop();
                    }
                }
            }
            if (this.caught != null) {
                throw this.caught;
            }
        }
        catch (BuildException e4) {
            throw e4;
        }
        catch (SecurityException e5) {
            throw e5;
        }
        catch (ThreadDeath e6) {
            throw e6;
        }
        catch (Throwable e7) {
            throw new BuildException(e7);
        }
        finally {
            if (loader != null) {
                loader.resetThreadContextLoader();
                loader.cleanup();
                loader = null;
            }
            if (this.sysProperties != null) {
                this.sysProperties.restoreSystem();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object[] argument = new Object[]{this.javaCommand.getArguments()};
        try {
            if (this.perm != null) {
                this.perm.setSecurityManager();
            }
            this.main.invoke(null, argument);
        }
        catch (InvocationTargetException e2) {
            Throwable t2 = e2.getTargetException();
            if (!(t2 instanceof InterruptedException)) {
                this.caught = t2;
            }
        }
        catch (Throwable t3) {
            this.caught = t3;
        }
        finally {
            if (this.perm != null) {
                this.perm.restoreSecurityManager();
            }
            ExecuteJava e2 = this;
            synchronized (e2) {
                this.notifyAll();
            }
        }
    }

    public synchronized void timeoutOccured(Watchdog w2) {
        if (this.thread != null) {
            this.timedOut = true;
            this.thread.interrupt();
        }
        this.notifyAll();
    }

    public synchronized boolean killedProcess() {
        return this.timedOut;
    }

    public int fork(ProjectComponent pc) throws BuildException {
        CommandlineJava cmdl = new CommandlineJava();
        cmdl.setClassname(this.javaCommand.getExecutable());
        String[] args = this.javaCommand.getArguments();
        for (int i2 = 0; i2 < args.length; ++i2) {
            cmdl.createArgument().setValue(args[i2]);
        }
        if (this.classpath != null) {
            cmdl.createClasspath(pc.getProject()).append(this.classpath);
        }
        if (this.sysProperties != null) {
            cmdl.addSysproperties(this.sysProperties);
        }
        Redirector redirector = new Redirector(pc);
        Execute exe = new Execute(redirector.createHandler(), this.timeout == null ? null : new ExecuteWatchdog(this.timeout));
        exe.setAntRun(pc.getProject());
        if (Os.isFamily("openvms")) {
            ExecuteJava.setupCommandLineForVMS(exe, cmdl.getCommandline());
        } else {
            exe.setCommandline(cmdl.getCommandline());
        }
        try {
            int rc = exe.execute();
            redirector.complete();
            int n2 = rc;
            return n2;
        }
        catch (IOException e2) {
            throw new BuildException(e2);
        }
        finally {
            this.timedOut = exe.killedProcess();
        }
    }

    public static void setupCommandLineForVMS(Execute exe, String[] command) {
        exe.setVMLauncher(true);
        File vmsJavaOptionFile = null;
        try {
            String[] args = new String[command.length - 1];
            System.arraycopy(command, 1, args, 0, command.length - 1);
            vmsJavaOptionFile = JavaEnvUtils.createVmsJavaOptionFile(args);
            vmsJavaOptionFile.deleteOnExit();
            String[] vmsCmd = new String[]{command[0], "-V", vmsJavaOptionFile.getPath()};
            exe.setCommandline(vmsCmd);
        }
        catch (IOException e2) {
            throw new BuildException("Failed to create a temporary file for \"-V\" switch");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

