/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.types.spi.Service;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.zip.JarMarker;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipExtraField;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public class Jar
extends Zip {
    private static final String INDEX_NAME = "META-INF/INDEX.LIST";
    private static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private List serviceList = new ArrayList();
    private Manifest configuredManifest;
    private Manifest savedConfiguredManifest;
    private Manifest filesetManifest;
    private Manifest originalManifest;
    private FilesetManifestConfig filesetManifestConfig;
    private boolean mergeManifestsMain = true;
    private Manifest manifest;
    private String manifestEncoding;
    private File manifestFile;
    private boolean index = false;
    private boolean createEmpty = false;
    private Vector rootEntries;
    private Path indexJars;
    private StrictMode strict = new StrictMode("ignore");
    private static final ZipExtraField[] JAR_MARKER = new ZipExtraField[]{JarMarker.getInstance()};

    public Jar() {
        this.archiveType = "jar";
        this.emptyBehavior = "create";
        this.setEncoding("UTF8");
        this.rootEntries = new Vector();
    }

    public void setWhenempty(Zip.WhenEmpty we) {
        this.log("JARs are never empty, they contain at least a manifest file", 1);
    }

    public void setWhenmanifestonly(Zip.WhenEmpty we) {
        this.emptyBehavior = we.getValue();
    }

    public void setStrict(StrictMode strict) {
        this.strict = strict;
    }

    public void setJarfile(File jarFile) {
        this.setDestFile(jarFile);
    }

    public void setIndex(boolean flag) {
        this.index = flag;
    }

    public void setManifestEncoding(String manifestEncoding) {
        this.manifestEncoding = manifestEncoding;
    }

    public void addConfiguredManifest(Manifest newManifest) throws ManifestException {
        if (this.configuredManifest == null) {
            this.configuredManifest = newManifest;
        } else {
            this.configuredManifest.merge(newManifest);
        }
        this.savedConfiguredManifest = this.configuredManifest;
    }

    public void setManifest(File manifestFile) {
        if (!manifestFile.exists()) {
            throw new BuildException("Manifest file: " + manifestFile + " does not exist.", this.getLocation());
        }
        this.manifestFile = manifestFile;
    }

    private Manifest getManifest(File manifestFile) {
        Manifest newManifest = null;
        FileInputStream fis = null;
        InputStreamReader isr = null;
        try {
            try {
                fis = new FileInputStream(manifestFile);
                isr = this.manifestEncoding == null ? new InputStreamReader(fis) : new InputStreamReader((InputStream)fis, this.manifestEncoding);
                newManifest = this.getManifest(isr);
            }
            catch (UnsupportedEncodingException e2) {
                throw new BuildException("Unsupported encoding while reading manifest: " + e2.getMessage(), e2);
            }
            catch (IOException e3) {
                throw new BuildException("Unable to read manifest file: " + manifestFile + " (" + e3.getMessage() + ")", e3);
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            FileUtils.close(isr);
            throw throwable;
        }
        FileUtils.close(isr);
        return newManifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Manifest getManifestFromJar(File jarFile) throws IOException {
        block8: {
            block7: {
                zf = null;
                try {
                    zf = new java.util.zip.ZipFile(jarFile);
                    e = zf.entries();
                    while (e.hasMoreElements()) {
                        ze = e.nextElement();
                        if (!ze.getName().equalsIgnoreCase("META-INF/MANIFEST.MF")) continue;
                        isr = new InputStreamReader(zf.getInputStream(ze), "UTF-8");
                        var6_6 = this.getManifest(isr);
                        var8_7 = null;
                        if (zf == null) return var6_6;
                        break block7;
                    }
                    var4_4 = null;
                    break block8;
                }
                catch (Throwable var7_13) {
                    var8_9 = null;
                    if (zf == null) throw var7_13;
                    try {
                        zf.close();
                        throw var7_13;
                    }
                    catch (IOException e) {
                        throw var7_13;
                    }
                }
            }
            ** try [egrp 1[TRYBLOCK] [3 : 106->113)] { 
lbl28:
            // 1 sources

            zf.close();
            return var6_6;
lbl30:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return var6_6;
        }
        var8_8 = null;
        if (zf == null) return var4_4;
        ** try [egrp 1[TRYBLOCK] [3 : 106->113)] { 
lbl37:
        // 1 sources

        zf.close();
        return var4_4;
lbl39:
        // 1 sources

        catch (IOException e) {
            // empty catch block
        }
        return var4_4;
    }

    private Manifest getManifest(Reader r2) {
        Manifest newManifest = null;
        try {
            newManifest = new Manifest(r2);
        }
        catch (ManifestException e2) {
            this.log("Manifest is invalid: " + e2.getMessage(), 0);
            throw new BuildException("Invalid Manifest: " + this.manifestFile, e2, this.getLocation());
        }
        catch (IOException e3) {
            throw new BuildException("Unable to read manifest file (" + e3.getMessage() + ")", e3);
        }
        return newManifest;
    }

    public void setFilesetmanifest(FilesetManifestConfig config) {
        this.filesetManifestConfig = config;
        this.mergeManifestsMain = "merge".equals(config.getValue());
        if (this.filesetManifestConfig != null && !this.filesetManifestConfig.getValue().equals("skip")) {
            this.doubleFilePass = true;
        }
    }

    public void addMetainf(ZipFileSet fs2) {
        fs2.setPrefix("META-INF/");
        super.addFileset(fs2);
    }

    public void addConfiguredIndexJars(Path p2) {
        if (this.indexJars == null) {
            this.indexJars = new Path(this.getProject());
        }
        this.indexJars.append(p2);
    }

    public void addConfiguredService(Service service) {
        service.check();
        this.serviceList.add(service);
    }

    private void writeServices(ZipOutputStream zOut) throws IOException {
        Iterator serviceIterator = this.serviceList.iterator();
        while (serviceIterator.hasNext()) {
            Service service = (Service)serviceIterator.next();
            super.zipFile(service.getAsStream(), zOut, "META-INF/services/" + service.getType(), System.currentTimeMillis(), null, 33188);
        }
    }

    protected void initZipOutputStream(ZipOutputStream zOut) throws IOException, BuildException {
        if (!this.skipWriting) {
            Manifest jarManifest = this.createManifest();
            this.writeManifest(zOut, jarManifest);
            this.writeServices(zOut);
        }
    }

    private Manifest createManifest() throws BuildException {
        try {
            Manifest finalManifest = Manifest.getDefaultManifest();
            if (this.manifest == null && this.manifestFile != null) {
                this.manifest = this.getManifest(this.manifestFile);
            }
            if (this.isInUpdateMode()) {
                finalManifest.merge(this.originalManifest);
            }
            finalManifest.merge(this.filesetManifest);
            finalManifest.merge(this.configuredManifest);
            finalManifest.merge(this.manifest, !this.mergeManifestsMain);
            return finalManifest;
        }
        catch (ManifestException e2) {
            this.log("Manifest is invalid: " + e2.getMessage(), 0);
            throw new BuildException("Invalid Manifest", e2, this.getLocation());
        }
    }

    private void writeManifest(ZipOutputStream zOut, Manifest manifest) throws IOException {
        Enumeration e2 = manifest.getWarnings();
        while (e2.hasMoreElements()) {
            this.log("Manifest warning: " + e2.nextElement(), 1);
        }
        this.zipDir(null, zOut, "META-INF/", 16877, JAR_MARKER);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, "UTF-8");
        PrintWriter writer = new PrintWriter(osw);
        manifest.write(writer);
        writer.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        super.zipFile(bais, zOut, MANIFEST_NAME, System.currentTimeMillis(), null, 33188);
        super.initZipOutputStream(zOut);
    }

    protected void finalizeZipOutputStream(ZipOutputStream zOut) throws IOException, BuildException {
        if (this.index) {
            this.createIndexList(zOut);
        }
    }

    private void createIndexList(ZipOutputStream zOut) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)baos, "UTF8"));
        writer.println("JarIndex-Version: 1.0");
        writer.println();
        writer.println(this.zipFile.getName());
        this.writeIndexLikeList(new ArrayList(this.addedDirs.keySet()), this.rootEntries, writer);
        writer.println();
        if (this.indexJars != null) {
            Manifest mf = this.createManifest();
            Manifest.Attribute classpath = mf.getMainSection().getAttribute("Class-Path");
            String[] cpEntries = null;
            if (classpath != null && classpath.getValue() != null) {
                StringTokenizer tok = new StringTokenizer(classpath.getValue(), " ");
                cpEntries = new String[tok.countTokens()];
                int c2 = 0;
                while (tok.hasMoreTokens()) {
                    cpEntries[c2++] = tok.nextToken();
                }
            }
            String[] indexJarEntries = this.indexJars.list();
            for (int i2 = 0; i2 < indexJarEntries.length; ++i2) {
                String name = Jar.findJarName(indexJarEntries[i2], cpEntries);
                if (name == null) continue;
                ArrayList dirs = new ArrayList();
                ArrayList files = new ArrayList();
                Jar.grabFilesAndDirs(indexJarEntries[i2], dirs, files);
                if (dirs.size() + files.size() <= 0) continue;
                writer.println(name);
                this.writeIndexLikeList(dirs, files, writer);
                writer.println();
            }
        }
        writer.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        super.zipFile(bais, zOut, INDEX_NAME, System.currentTimeMillis(), null, 33188);
    }

    protected void zipFile(InputStream is, ZipOutputStream zOut, String vPath, long lastModified, File fromArchive, int mode) throws IOException {
        if (MANIFEST_NAME.equalsIgnoreCase(vPath)) {
            if (!this.doubleFilePass || this.skipWriting) {
                this.filesetManifest(fromArchive, is);
            }
        } else if (INDEX_NAME.equalsIgnoreCase(vPath) && this.index) {
            this.log("Warning: selected " + this.archiveType + " files include a META-INF/INDEX.LIST which will" + " be replaced by a newly generated one.", 1);
        } else {
            if (this.index && vPath.indexOf("/") == -1) {
                this.rootEntries.addElement(vPath);
            }
            super.zipFile(is, zOut, vPath, lastModified, fromArchive, mode);
        }
    }

    private void filesetManifest(File file, InputStream is) throws IOException {
        if (this.manifestFile != null && this.manifestFile.equals(file)) {
            this.log("Found manifest " + file, 3);
            try {
                if (is != null) {
                    InputStreamReader isr = this.manifestEncoding == null ? new InputStreamReader(is) : new InputStreamReader(is, this.manifestEncoding);
                    this.manifest = this.getManifest(isr);
                }
                this.manifest = this.getManifest(file);
            }
            catch (UnsupportedEncodingException e2) {
                throw new BuildException("Unsupported encoding while reading manifest: " + e2.getMessage(), e2);
            }
        } else if (this.filesetManifestConfig != null && !this.filesetManifestConfig.getValue().equals("skip")) {
            this.log("Found manifest to merge in file " + file, 3);
            try {
                Manifest newManifest = null;
                if (is != null) {
                    InputStreamReader isr = this.manifestEncoding == null ? new InputStreamReader(is) : new InputStreamReader(is, this.manifestEncoding);
                    newManifest = this.getManifest(isr);
                } else {
                    newManifest = this.getManifest(file);
                }
                if (this.filesetManifest == null) {
                    this.filesetManifest = newManifest;
                } else {
                    this.filesetManifest.merge(newManifest);
                }
            }
            catch (UnsupportedEncodingException e3) {
                throw new BuildException("Unsupported encoding while reading manifest: " + e3.getMessage(), e3);
            }
            catch (ManifestException e4) {
                this.log("Manifest in file " + file + " is invalid: " + e4.getMessage(), 0);
                throw new BuildException("Invalid Manifest", e4, this.getLocation());
            }
        }
    }

    protected Zip.ArchiveState getResourcesToAdd(ResourceCollection[] rcs, File zipFile, boolean needsUpdate) throws BuildException {
        if (zipFile.exists()) {
            try {
                this.originalManifest = this.getManifestFromJar(zipFile);
                if (this.originalManifest == null) {
                    this.log("Updating jar since the current jar has no manifest", 3);
                    needsUpdate = true;
                } else {
                    Manifest mf = this.createManifest();
                    if (!mf.equals(this.originalManifest)) {
                        this.log("Updating jar since jar manifest has changed", 3);
                        needsUpdate = true;
                    }
                }
            }
            catch (Throwable t2) {
                this.log("error while reading original manifest in file: " + zipFile.toString() + t2.getMessage(), 1);
                needsUpdate = true;
            }
        } else {
            needsUpdate = true;
        }
        this.createEmpty = needsUpdate;
        return super.getResourcesToAdd(rcs, zipFile, needsUpdate);
    }

    protected boolean createEmptyZip(File zipFile) throws BuildException {
        if (!this.createEmpty) {
            return true;
        }
        if (this.emptyBehavior.equals("skip")) {
            this.log("Warning: skipping " + this.archiveType + " archive " + zipFile + " because no files were included.", 1);
            return true;
        }
        if (this.emptyBehavior.equals("fail")) {
            throw new BuildException("Cannot create " + this.archiveType + " archive " + zipFile + ": no files were included.", this.getLocation());
        }
        ZipOutputStream zOut = null;
        try {
            try {
                this.log("Building MANIFEST-only jar: " + this.getDestFile().getAbsolutePath());
                zOut = new ZipOutputStream(new FileOutputStream(this.getDestFile()));
                zOut.setEncoding(this.getEncoding());
                if (this.isCompress()) {
                    zOut.setMethod(8);
                } else {
                    zOut.setMethod(0);
                }
                this.initZipOutputStream(zOut);
                this.finalizeZipOutputStream(zOut);
            }
            catch (IOException ioe) {
                throw new BuildException("Could not create almost empty JAR archive (" + ioe.getMessage() + ")", ioe, this.getLocation());
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            FileUtils.close(zOut);
            this.createEmpty = false;
            throw throwable;
        }
        FileUtils.close(zOut);
        this.createEmpty = false;
        return true;
    }

    protected void cleanUp() {
        super.cleanUp();
        this.checkJarSpec();
        if (!this.doubleFilePass || !this.skipWriting) {
            this.manifest = null;
            this.configuredManifest = this.savedConfiguredManifest;
            this.filesetManifest = null;
            this.originalManifest = null;
        }
        this.rootEntries.removeAllElements();
    }

    private void checkJarSpec() {
        Manifest.Section mainSection;
        String br2 = System.getProperty("line.separator");
        StringBuffer message = new StringBuffer();
        Manifest.Section section = mainSection = this.configuredManifest == null ? null : this.configuredManifest.getMainSection();
        if (mainSection == null) {
            message.append("No Implementation-Title set.");
            message.append("No Implementation-Version set.");
            message.append("No Implementation-Vendor set.");
        } else {
            if (mainSection.getAttribute("Implementation-Title") == null) {
                message.append("No Implementation-Title set.");
            }
            if (mainSection.getAttribute("Implementation-Version") == null) {
                message.append("No Implementation-Version set.");
            }
            if (mainSection.getAttribute("Implementation-Vendor") == null) {
                message.append("No Implementation-Vendor set.");
            }
        }
        if (message.length() > 0) {
            message.append(br2);
            message.append("Location: ").append(this.getLocation());
            message.append(br2);
            if (this.strict.getValue().equalsIgnoreCase("fail")) {
                throw new BuildException(message.toString(), this.getLocation());
            }
            this.log(message.toString(), this.strict.getLogLevel());
        }
    }

    public void reset() {
        super.reset();
        this.emptyBehavior = "create";
        this.configuredManifest = null;
        this.filesetManifestConfig = null;
        this.mergeManifestsMain = false;
        this.manifestFile = null;
        this.index = false;
    }

    protected final void writeIndexLikeList(List dirs, List files, PrintWriter writer) throws IOException {
        Collections.sort(dirs);
        Collections.sort(files);
        Iterator iter = dirs.iterator();
        while (iter.hasNext()) {
            String dir = (String)iter.next();
            if ((dir = dir.replace('\\', '/')).startsWith("./")) {
                dir = dir.substring(2);
            }
            while (dir.startsWith("/")) {
                dir = dir.substring(1);
            }
            int pos = dir.lastIndexOf(47);
            if (pos != -1) {
                dir = dir.substring(0, pos);
            }
            if (dir.startsWith("META-INF")) continue;
            writer.println(dir);
        }
        iter = files.iterator();
        while (iter.hasNext()) {
            writer.println(iter.next());
        }
    }

    protected static String findJarName(String fileName, String[] classpath) {
        if (classpath == null) {
            return new File(fileName).getName();
        }
        fileName = fileName.replace(File.separatorChar, '/');
        TreeMap<String, String> matches = new TreeMap<String, String>(new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof String && o2 instanceof String) {
                    return ((String)o2).length() - ((String)o1).length();
                }
                return 0;
            }
        });
        block0: for (int i2 = 0; i2 < classpath.length; ++i2) {
            if (fileName.endsWith(classpath[i2])) {
                matches.put(classpath[i2], classpath[i2]);
                continue;
            }
            int slash = classpath[i2].indexOf("/");
            String candidate = classpath[i2];
            while (slash > -1) {
                if (fileName.endsWith(candidate = candidate.substring(slash + 1))) {
                    matches.put(candidate, classpath[i2]);
                    continue block0;
                }
                slash = candidate.indexOf("/");
            }
        }
        return matches.size() == 0 ? null : (String)matches.get(matches.firstKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void grabFilesAndDirs(String file, List dirs, List files) throws IOException {
        ZipFile zf = null;
        try {
            zf = new ZipFile(file, "utf-8");
            Enumeration entries = zf.getEntries();
            HashSet<String> dirSet = new HashSet<String>();
            while (entries.hasMoreElements()) {
                ZipEntry ze = (ZipEntry)entries.nextElement();
                String name = ze.getName();
                if (name.startsWith("META-INF/")) continue;
                if (ze.isDirectory()) {
                    dirSet.add(name);
                    continue;
                }
                if (name.indexOf("/") == -1) {
                    files.add(name);
                    continue;
                }
                dirSet.add(name.substring(0, name.lastIndexOf("/") + 1));
            }
            dirs.addAll(dirSet);
            Object var9_8 = null;
            if (zf == null) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (zf == null) throw throwable;
            zf.close();
            throw throwable;
        }
        zf.close();
    }

    public static class StrictMode
    extends EnumeratedAttribute {
        public StrictMode() {
        }

        public StrictMode(String value) {
            this.setValue(value);
        }

        public String[] getValues() {
            return new String[]{"fail", "warn", "ignore"};
        }

        public int getLogLevel() {
            return this.getValue().equals("ignore") ? 3 : 1;
        }
    }

    public static class FilesetManifestConfig
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"skip", "merge", "mergewithoutmain"};
        }
    }
}

