/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.compilers.CompilerAdapter;
import org.apache.tools.ant.taskdefs.compilers.CompilerAdapterFactory;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.apache.tools.ant.util.SourceFileScanner;
import org.apache.tools.ant.util.facade.FacadeTaskHelper;

public class Javac
extends MatchingTask {
    private static final String FAIL_MSG = "Compile failed; see the compiler error output for details.";
    private static final String JAVAC16 = "javac1.6";
    private static final String JAVAC15 = "javac1.5";
    private static final String JAVAC14 = "javac1.4";
    private static final String JAVAC13 = "javac1.3";
    private static final String JAVAC12 = "javac1.2";
    private static final String JAVAC11 = "javac1.1";
    private static final String MODERN = "modern";
    private static final String CLASSIC = "classic";
    private static final String EXTJAVAC = "extJavac";
    private static final String PACKAGE_INFO_JAVA = "package-info.java";
    private static final String PACKAGE_INFO_CLASS = "package-info.class";
    private Path src;
    private File destDir;
    private Path compileClasspath;
    private Path compileSourcepath;
    private String encoding;
    private boolean debug = false;
    private boolean optimize = false;
    private boolean deprecation = false;
    private boolean depend = false;
    private boolean verbose = false;
    private String targetAttribute;
    private Path bootclasspath;
    private Path extdirs;
    private boolean includeAntRuntime = true;
    private boolean includeJavaRuntime = false;
    private boolean fork = false;
    private String forkedExecutable = null;
    private boolean nowarn = false;
    private String memoryInitialSize;
    private String memoryMaximumSize;
    private FacadeTaskHelper facade = null;
    protected boolean failOnError = true;
    protected boolean listFiles = false;
    protected File[] compileList = new File[0];
    private String source;
    private String debugLevel;
    private File tmpDir;
    private String updatedProperty;
    private String errorProperty;
    private boolean taskSuccess = true;
    private boolean includeDestClasses = true;
    private List updateDirList = new ArrayList();

    public Javac() {
        this.facade = new FacadeTaskHelper(this.assumedJavaVersion());
    }

    private String assumedJavaVersion() {
        if (JavaEnvUtils.isJavaVersion("1.2")) {
            return JAVAC12;
        }
        if (JavaEnvUtils.isJavaVersion("1.3")) {
            return JAVAC13;
        }
        if (JavaEnvUtils.isJavaVersion("1.4")) {
            return JAVAC14;
        }
        if (JavaEnvUtils.isJavaVersion("1.5")) {
            return JAVAC15;
        }
        if (JavaEnvUtils.isJavaVersion("1.6")) {
            return JAVAC16;
        }
        return CLASSIC;
    }

    public String getDebugLevel() {
        return this.debugLevel;
    }

    public void setDebugLevel(String v2) {
        this.debugLevel = v2;
    }

    public String getSource() {
        return this.source != null ? this.source : this.getProject().getProperty("ant.build.javac.source");
    }

    public void setSource(String v2) {
        this.source = v2;
    }

    public Path createSrc() {
        if (this.src == null) {
            this.src = new Path(this.getProject());
        }
        return this.src.createPath();
    }

    protected Path recreateSrc() {
        this.src = null;
        return this.createSrc();
    }

    public void setSrcdir(Path srcDir) {
        if (this.src == null) {
            this.src = srcDir;
        } else {
            this.src.append(srcDir);
        }
    }

    public Path getSrcdir() {
        return this.src;
    }

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public File getDestdir() {
        return this.destDir;
    }

    public void setSourcepath(Path sourcepath) {
        if (this.compileSourcepath == null) {
            this.compileSourcepath = sourcepath;
        } else {
            this.compileSourcepath.append(sourcepath);
        }
    }

    public Path getSourcepath() {
        return this.compileSourcepath;
    }

    public Path createSourcepath() {
        if (this.compileSourcepath == null) {
            this.compileSourcepath = new Path(this.getProject());
        }
        return this.compileSourcepath.createPath();
    }

    public void setSourcepathRef(Reference r2) {
        this.createSourcepath().setRefid(r2);
    }

    public void setClasspath(Path classpath) {
        if (this.compileClasspath == null) {
            this.compileClasspath = classpath;
        } else {
            this.compileClasspath.append(classpath);
        }
    }

    public Path getClasspath() {
        return this.compileClasspath;
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.getProject());
        }
        return this.compileClasspath.createPath();
    }

    public void setClasspathRef(Reference r2) {
        this.createClasspath().setRefid(r2);
    }

    public void setBootclasspath(Path bootclasspath) {
        if (this.bootclasspath == null) {
            this.bootclasspath = bootclasspath;
        } else {
            this.bootclasspath.append(bootclasspath);
        }
    }

    public Path getBootclasspath() {
        return this.bootclasspath;
    }

    public Path createBootclasspath() {
        if (this.bootclasspath == null) {
            this.bootclasspath = new Path(this.getProject());
        }
        return this.bootclasspath.createPath();
    }

    public void setBootClasspathRef(Reference r2) {
        this.createBootclasspath().setRefid(r2);
    }

    public void setExtdirs(Path extdirs) {
        if (this.extdirs == null) {
            this.extdirs = extdirs;
        } else {
            this.extdirs.append(extdirs);
        }
    }

    public Path getExtdirs() {
        return this.extdirs;
    }

    public Path createExtdirs() {
        if (this.extdirs == null) {
            this.extdirs = new Path(this.getProject());
        }
        return this.extdirs.createPath();
    }

    public void setListfiles(boolean list) {
        this.listFiles = list;
    }

    public boolean getListfiles() {
        return this.listFiles;
    }

    public void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    public void setProceed(boolean proceed) {
        this.failOnError = !proceed;
    }

    public boolean getFailonerror() {
        return this.failOnError;
    }

    public void setDeprecation(boolean deprecation) {
        this.deprecation = deprecation;
    }

    public boolean getDeprecation() {
        return this.deprecation;
    }

    public void setMemoryInitialSize(String memoryInitialSize) {
        this.memoryInitialSize = memoryInitialSize;
    }

    public String getMemoryInitialSize() {
        return this.memoryInitialSize;
    }

    public void setMemoryMaximumSize(String memoryMaximumSize) {
        this.memoryMaximumSize = memoryMaximumSize;
    }

    public String getMemoryMaximumSize() {
        return this.memoryMaximumSize;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setOptimize(boolean optimize) {
        this.optimize = optimize;
    }

    public boolean getOptimize() {
        return this.optimize;
    }

    public void setDepend(boolean depend) {
        this.depend = depend;
    }

    public boolean getDepend() {
        return this.depend;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setTarget(String target) {
        this.targetAttribute = target;
    }

    public String getTarget() {
        return this.targetAttribute != null ? this.targetAttribute : this.getProject().getProperty("ant.build.javac.target");
    }

    public void setIncludeantruntime(boolean include) {
        this.includeAntRuntime = include;
    }

    public boolean getIncludeantruntime() {
        return this.includeAntRuntime;
    }

    public void setIncludejavaruntime(boolean include) {
        this.includeJavaRuntime = include;
    }

    public boolean getIncludejavaruntime() {
        return this.includeJavaRuntime;
    }

    public void setFork(boolean f2) {
        this.fork = f2;
    }

    public void setExecutable(String forkExec) {
        this.forkedExecutable = forkExec;
    }

    public String getExecutable() {
        return this.forkedExecutable;
    }

    public boolean isForkedJavac() {
        return this.fork || EXTJAVAC.equals(this.getCompiler());
    }

    public String getJavacExecutable() {
        if (this.forkedExecutable == null && this.isForkedJavac()) {
            this.forkedExecutable = this.getSystemJavac();
        } else if (this.forkedExecutable != null && !this.isForkedJavac()) {
            this.forkedExecutable = null;
        }
        return this.forkedExecutable;
    }

    public void setNowarn(boolean flag) {
        this.nowarn = flag;
    }

    public boolean getNowarn() {
        return this.nowarn;
    }

    public ImplementationSpecificArgument createCompilerArg() {
        ImplementationSpecificArgument arg = new ImplementationSpecificArgument();
        this.facade.addImplementationArgument(arg);
        return arg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCurrentCompilerArgs() {
        String chosen = this.facade.getExplicitChoice();
        try {
            String appliedCompiler = this.getCompiler();
            this.facade.setImplementation(appliedCompiler);
            String[] result = this.facade.getArgs();
            String altCompilerName = this.getAltCompilerName(this.facade.getImplementation());
            if (result.length == 0 && altCompilerName != null) {
                this.facade.setImplementation(altCompilerName);
                result = this.facade.getArgs();
            }
            String[] stringArray = result;
            Object var7_6 = null;
            this.facade.setImplementation(chosen);
            return stringArray;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.facade.setImplementation(chosen);
            throw throwable;
        }
    }

    private String getAltCompilerName(String anImplementation) {
        String nextSelected;
        if (JAVAC16.equalsIgnoreCase(anImplementation) || JAVAC15.equalsIgnoreCase(anImplementation) || JAVAC14.equalsIgnoreCase(anImplementation) || JAVAC13.equalsIgnoreCase(anImplementation)) {
            return MODERN;
        }
        if (JAVAC12.equalsIgnoreCase(anImplementation) || JAVAC11.equalsIgnoreCase(anImplementation)) {
            return CLASSIC;
        }
        if (MODERN.equalsIgnoreCase(anImplementation) && (JAVAC16.equalsIgnoreCase(nextSelected = this.assumedJavaVersion()) || JAVAC15.equalsIgnoreCase(nextSelected) || JAVAC14.equalsIgnoreCase(nextSelected) || JAVAC13.equalsIgnoreCase(nextSelected))) {
            return nextSelected;
        }
        if (CLASSIC.equals(anImplementation)) {
            return this.assumedJavaVersion();
        }
        if (EXTJAVAC.equalsIgnoreCase(anImplementation)) {
            return this.assumedJavaVersion();
        }
        return null;
    }

    public void setTempdir(File tmpDir) {
        this.tmpDir = tmpDir;
    }

    public File getTempdir() {
        return this.tmpDir;
    }

    public void setUpdatedProperty(String updatedProperty) {
        this.updatedProperty = updatedProperty;
    }

    public void setErrorProperty(String errorProperty) {
        this.errorProperty = errorProperty;
    }

    public void setIncludeDestClasses(boolean includeDestClasses) {
        this.includeDestClasses = includeDestClasses;
    }

    public boolean isIncludeDestClasses() {
        return this.includeDestClasses;
    }

    public boolean getTaskSuccess() {
        return this.taskSuccess;
    }

    public void execute() throws BuildException {
        this.checkParameters();
        this.resetFileLists();
        String[] list = this.src.list();
        for (int i2 = 0; i2 < list.length; ++i2) {
            File srcDir = this.getProject().resolveFile(list[i2]);
            if (!srcDir.exists()) {
                throw new BuildException("srcdir \"" + srcDir.getPath() + "\" does not exist!", this.getLocation());
            }
            DirectoryScanner ds2 = this.getDirectoryScanner(srcDir);
            String[] files = ds2.getIncludedFiles();
            this.scanDir(srcDir, this.destDir != null ? this.destDir : srcDir, files);
        }
        this.compile();
        if (this.updatedProperty != null && this.taskSuccess && this.compileList.length != 0) {
            this.getProject().setNewProperty(this.updatedProperty, "true");
        }
    }

    protected void resetFileLists() {
        this.compileList = new File[0];
    }

    protected void scanDir(File srcDir, File destDir, String[] files) {
        GlobPatternMapper m2 = new GlobPatternMapper();
        m2.setFrom("*.java");
        m2.setTo("*.class");
        SourceFileScanner sfs = new SourceFileScanner(this);
        File[] newFiles = sfs.restrictAsFiles(files, srcDir, destDir, m2);
        newFiles = this.removePackageInfoFiles(newFiles, srcDir, destDir);
        if (newFiles.length > 0) {
            File[] newCompileList = new File[this.compileList.length + newFiles.length];
            System.arraycopy(this.compileList, 0, newCompileList, 0, this.compileList.length);
            System.arraycopy(newFiles, 0, newCompileList, this.compileList.length, newFiles.length);
            this.compileList = newCompileList;
        }
    }

    public File[] getFileList() {
        return this.compileList;
    }

    protected boolean isJdkCompiler(String compilerImpl) {
        return MODERN.equals(compilerImpl) || CLASSIC.equals(compilerImpl) || JAVAC16.equals(compilerImpl) || JAVAC15.equals(compilerImpl) || JAVAC14.equals(compilerImpl) || JAVAC13.equals(compilerImpl) || JAVAC12.equals(compilerImpl) || JAVAC11.equals(compilerImpl);
    }

    protected String getSystemJavac() {
        return JavaEnvUtils.getJdkExecutable("javac");
    }

    public void setCompiler(String compiler) {
        this.facade.setImplementation(compiler);
    }

    public String getCompiler() {
        String compilerImpl = this.getCompilerVersion();
        if (this.fork) {
            if (this.isJdkCompiler(compilerImpl)) {
                compilerImpl = EXTJAVAC;
            } else {
                this.log("Since compiler setting isn't classic or modern,ignoring fork setting.", 1);
            }
        }
        return compilerImpl;
    }

    public String getCompilerVersion() {
        this.facade.setMagicValue(this.getProject().getProperty("build.compiler"));
        return this.facade.getImplementation();
    }

    protected void checkParameters() throws BuildException {
        if (this.src == null) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (this.src.size() == 0) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (this.destDir != null && !this.destDir.isDirectory()) {
            throw new BuildException("destination directory \"" + this.destDir + "\" does not exist " + "or is not a directory", this.getLocation());
        }
    }

    protected void compile() {
        String compilerImpl = this.getCompiler();
        if (this.compileList.length > 0) {
            this.log("Compiling " + this.compileList.length + " source file" + (this.compileList.length == 1 ? "" : "s") + (this.destDir != null ? " to " + this.destDir : ""));
            if (this.listFiles) {
                for (int i2 = 0; i2 < this.compileList.length; ++i2) {
                    String filename = this.compileList[i2].getAbsolutePath();
                    this.log(filename);
                }
            }
            CompilerAdapter adapter = CompilerAdapterFactory.getCompiler(compilerImpl, this);
            adapter.setJavac(this);
            if (adapter.execute()) {
                Iterator i3 = this.updateDirList.iterator();
                while (i3.hasNext()) {
                    File file = (File)i3.next();
                    file.setLastModified(System.currentTimeMillis());
                }
            } else {
                this.taskSuccess = false;
                if (this.errorProperty != null) {
                    this.getProject().setNewProperty(this.errorProperty, "true");
                }
                if (this.failOnError) {
                    throw new BuildException(FAIL_MSG, this.getLocation());
                }
                this.log(FAIL_MSG, 0);
            }
        }
    }

    private File[] removePackageInfoFiles(File[] newFiles, File srcDir, File destDir) {
        if (!this.hasPackageInfo(newFiles)) {
            return newFiles;
        }
        ArrayList<File> ret = new ArrayList<File>();
        for (int i2 = 0; i2 < newFiles.length; ++i2) {
            if (!this.needsCompilePackageFile(newFiles[i2], srcDir, destDir)) continue;
            ret.add(newFiles[i2]);
        }
        return ret.toArray(new File[0]);
    }

    private boolean hasPackageInfo(File[] newFiles) {
        for (int i2 = 0; i2 < newFiles.length; ++i2) {
            if (!newFiles[i2].getName().equals(PACKAGE_INFO_JAVA)) continue;
            return true;
        }
        return false;
    }

    private boolean needsCompilePackageFile(File file, File srcDir, File destDir) {
        if (!file.getName().equals(PACKAGE_INFO_JAVA)) {
            return true;
        }
        String rel = this.relativePath(srcDir, file);
        File destFile = new File(destDir, rel);
        File parent = destFile.getParentFile();
        destFile = new File(parent, PACKAGE_INFO_CLASS);
        File sourceFile = new File(srcDir, rel);
        if (destFile.exists()) {
            return true;
        }
        if (sourceFile.lastModified() > destFile.getParentFile().lastModified()) {
            this.updateDirList.add(destFile.getParentFile());
            return true;
        }
        return false;
    }

    private String relativePath(File src, File file) {
        return file.getAbsolutePath().substring(src.getAbsolutePath().length() + 1);
    }

    public class ImplementationSpecificArgument
    extends org.apache.tools.ant.util.facade.ImplementationSpecificArgument {
        public void setCompiler(String impl) {
            super.setImplementation(impl);
        }
    }
}

