/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JavaEnvUtils;

public class Javadoc
extends Task {
    private static final boolean JAVADOC_4 = !JavaEnvUtils.isJavaVersion("1.2") && !JavaEnvUtils.isJavaVersion("1.3");
    private static final boolean JAVADOC_5 = JAVADOC_4 && !JavaEnvUtils.isJavaVersion("1.4");
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private Commandline cmd = new Commandline();
    private boolean failOnError = false;
    private Path sourcePath = null;
    private File destDir = null;
    private Vector sourceFiles = new Vector();
    private Vector packageNames = new Vector();
    private Vector excludePackageNames = new Vector(1);
    private boolean author = true;
    private boolean version = true;
    private DocletInfo doclet = null;
    private Path classpath = null;
    private Path bootclasspath = null;
    private String group = null;
    private String packageList = null;
    private Vector links = new Vector();
    private Vector groups = new Vector();
    private Vector tags = new Vector();
    private boolean useDefaultExcludes = true;
    private Html doctitle = null;
    private Html header = null;
    private Html footer = null;
    private Html bottom = null;
    private boolean useExternalFile = false;
    private String source = null;
    private boolean linksource = false;
    private boolean breakiterator = false;
    private String noqualifier;
    private boolean includeNoSourcePackages = false;
    private boolean old = false;
    private String executable = null;
    private ResourceCollectionContainer nestedSourceFiles = new ResourceCollectionContainer();
    private Vector packageSets = new Vector();
    static final String[] SCOPE_ELEMENTS = new String[]{"overview", "packages", "types", "constructors", "methods", "fields"};

    private void addArgIf(boolean b2, String arg) {
        if (b2) {
            this.cmd.createArgument().setValue(arg);
        }
    }

    private void addArgIfNotEmpty(String key, String value) {
        if (value != null && value.length() != 0) {
            this.cmd.createArgument().setValue(key);
            this.cmd.createArgument().setValue(value);
        } else {
            this.log("Warning: Leaving out empty argument '" + key + "'", 1);
        }
    }

    public void setUseExternalFile(boolean b2) {
        this.useExternalFile = b2;
    }

    public void setDefaultexcludes(boolean useDefaultExcludes) {
        this.useDefaultExcludes = useDefaultExcludes;
    }

    public void setMaxmemory(String max) {
        this.cmd.createArgument().setValue("-J-Xmx" + max);
    }

    public void setAdditionalparam(String add) {
        this.cmd.createArgument().setLine(add);
    }

    public Commandline.Argument createArg() {
        return this.cmd.createArgument();
    }

    public void setSourcepath(Path src) {
        if (this.sourcePath == null) {
            this.sourcePath = src;
        } else {
            this.sourcePath.append(src);
        }
    }

    public Path createSourcepath() {
        if (this.sourcePath == null) {
            this.sourcePath = new Path(this.getProject());
        }
        return this.sourcePath.createPath();
    }

    public void setSourcepathRef(Reference r2) {
        this.createSourcepath().setRefid(r2);
    }

    public void setDestdir(File dir) {
        this.destDir = dir;
        this.cmd.createArgument().setValue("-d");
        this.cmd.createArgument().setFile(this.destDir);
    }

    public void setSourcefiles(String src) {
        StringTokenizer tok = new StringTokenizer(src, ",");
        while (tok.hasMoreTokens()) {
            String f2 = tok.nextToken();
            SourceFile sf = new SourceFile();
            sf.setFile(this.getProject().resolveFile(f2.trim()));
            this.addSource(sf);
        }
    }

    public void addSource(SourceFile sf) {
        this.sourceFiles.addElement(sf);
    }

    public void setPackagenames(String packages) {
        StringTokenizer tok = new StringTokenizer(packages, ",");
        while (tok.hasMoreTokens()) {
            String p2 = tok.nextToken();
            PackageName pn = new PackageName();
            pn.setName(p2);
            this.addPackage(pn);
        }
    }

    public void addPackage(PackageName pn) {
        this.packageNames.addElement(pn);
    }

    public void setExcludePackageNames(String packages) {
        StringTokenizer tok = new StringTokenizer(packages, ",");
        while (tok.hasMoreTokens()) {
            String p2 = tok.nextToken();
            PackageName pn = new PackageName();
            pn.setName(p2);
            this.addExcludePackage(pn);
        }
    }

    public void addExcludePackage(PackageName pn) {
        this.excludePackageNames.addElement(pn);
    }

    public void setOverview(File f2) {
        this.cmd.createArgument().setValue("-overview");
        this.cmd.createArgument().setFile(f2);
    }

    public void setPublic(boolean b2) {
        this.addArgIf(b2, "-public");
    }

    public void setProtected(boolean b2) {
        this.addArgIf(b2, "-protected");
    }

    public void setPackage(boolean b2) {
        this.addArgIf(b2, "-package");
    }

    public void setPrivate(boolean b2) {
        this.addArgIf(b2, "-private");
    }

    public void setAccess(AccessType at2) {
        this.cmd.createArgument().setValue("-" + at2.getValue());
    }

    public void setDoclet(String docletName) {
        if (this.doclet == null) {
            this.doclet = new DocletInfo();
            this.doclet.setProject(this.getProject());
        }
        this.doclet.setName(docletName);
    }

    public void setDocletPath(Path docletPath) {
        if (this.doclet == null) {
            this.doclet = new DocletInfo();
            this.doclet.setProject(this.getProject());
        }
        this.doclet.setPath(docletPath);
    }

    public void setDocletPathRef(Reference r2) {
        if (this.doclet == null) {
            this.doclet = new DocletInfo();
            this.doclet.setProject(this.getProject());
        }
        this.doclet.createPath().setRefid(r2);
    }

    public DocletInfo createDoclet() {
        if (this.doclet == null) {
            this.doclet = new DocletInfo();
        }
        return this.doclet;
    }

    public void addTaglet(ExtensionInfo tagletInfo) {
        this.tags.addElement(tagletInfo);
    }

    public void setOld(boolean b2) {
        this.old = b2;
    }

    public void setClasspath(Path path) {
        if (this.classpath == null) {
            this.classpath = path;
        } else {
            this.classpath.append(path);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r2) {
        this.createClasspath().setRefid(r2);
    }

    public void setBootclasspath(Path path) {
        if (this.bootclasspath == null) {
            this.bootclasspath = path;
        } else {
            this.bootclasspath.append(path);
        }
    }

    public Path createBootclasspath() {
        if (this.bootclasspath == null) {
            this.bootclasspath = new Path(this.getProject());
        }
        return this.bootclasspath.createPath();
    }

    public void setBootClasspathRef(Reference r2) {
        this.createBootclasspath().setRefid(r2);
    }

    public void setExtdirs(String path) {
        this.cmd.createArgument().setValue("-extdirs");
        this.cmd.createArgument().setValue(path);
    }

    public void setExtdirs(Path path) {
        this.cmd.createArgument().setValue("-extdirs");
        this.cmd.createArgument().setPath(path);
    }

    public void setVerbose(boolean b2) {
        this.addArgIf(b2, "-verbose");
    }

    public void setLocale(String locale) {
        this.cmd.createArgument(true).setValue(locale);
        this.cmd.createArgument(true).setValue("-locale");
    }

    public void setEncoding(String enc) {
        this.cmd.createArgument().setValue("-encoding");
        this.cmd.createArgument().setValue(enc);
    }

    public void setVersion(boolean b2) {
        this.version = b2;
    }

    public void setUse(boolean b2) {
        this.addArgIf(b2, "-use");
    }

    public void setAuthor(boolean b2) {
        this.author = b2;
    }

    public void setSplitindex(boolean b2) {
        this.addArgIf(b2, "-splitindex");
    }

    public void setWindowtitle(String title) {
        this.addArgIfNotEmpty("-windowtitle", title);
    }

    public void setDoctitle(String doctitle) {
        Html h2 = new Html();
        h2.addText(doctitle);
        this.addDoctitle(h2);
    }

    public void addDoctitle(Html text) {
        this.doctitle = text;
    }

    public void setHeader(String header) {
        Html h2 = new Html();
        h2.addText(header);
        this.addHeader(h2);
    }

    public void addHeader(Html text) {
        this.header = text;
    }

    public void setFooter(String footer) {
        Html h2 = new Html();
        h2.addText(footer);
        this.addFooter(h2);
    }

    public void addFooter(Html text) {
        this.footer = text;
    }

    public void setBottom(String bottom) {
        Html h2 = new Html();
        h2.addText(bottom);
        this.addBottom(h2);
    }

    public void addBottom(Html text) {
        this.bottom = text;
    }

    public void setLinkoffline(String src) {
        LinkArgument le = this.createLink();
        le.setOffline(true);
        String linkOfflineError = "The linkoffline attribute must include a URL and a package-list file location separated by a space";
        if (src.trim().length() == 0) {
            throw new BuildException(linkOfflineError);
        }
        StringTokenizer tok = new StringTokenizer(src, " ", false);
        le.setHref(tok.nextToken());
        if (!tok.hasMoreTokens()) {
            throw new BuildException(linkOfflineError);
        }
        le.setPackagelistLoc(this.getProject().resolveFile(tok.nextToken()));
    }

    public void setGroup(String src) {
        this.group = src;
    }

    public void setLink(String src) {
        this.createLink().setHref(src);
    }

    public void setNodeprecated(boolean b2) {
        this.addArgIf(b2, "-nodeprecated");
    }

    public void setNodeprecatedlist(boolean b2) {
        this.addArgIf(b2, "-nodeprecatedlist");
    }

    public void setNotree(boolean b2) {
        this.addArgIf(b2, "-notree");
    }

    public void setNoindex(boolean b2) {
        this.addArgIf(b2, "-noindex");
    }

    public void setNohelp(boolean b2) {
        this.addArgIf(b2, "-nohelp");
    }

    public void setNonavbar(boolean b2) {
        this.addArgIf(b2, "-nonavbar");
    }

    public void setSerialwarn(boolean b2) {
        this.addArgIf(b2, "-serialwarn");
    }

    public void setStylesheetfile(File f2) {
        this.cmd.createArgument().setValue("-stylesheetfile");
        this.cmd.createArgument().setFile(f2);
    }

    public void setHelpfile(File f2) {
        this.cmd.createArgument().setValue("-helpfile");
        this.cmd.createArgument().setFile(f2);
    }

    public void setDocencoding(String enc) {
        this.cmd.createArgument().setValue("-docencoding");
        this.cmd.createArgument().setValue(enc);
    }

    public void setPackageList(String src) {
        this.packageList = src;
    }

    public LinkArgument createLink() {
        LinkArgument la = new LinkArgument();
        this.links.addElement(la);
        return la;
    }

    public TagArgument createTag() {
        TagArgument ta = new TagArgument();
        this.tags.addElement(ta);
        return ta;
    }

    public GroupArgument createGroup() {
        GroupArgument ga2 = new GroupArgument();
        this.groups.addElement(ga2);
        return ga2;
    }

    public void setCharset(String src) {
        this.addArgIfNotEmpty("-charset", src);
    }

    public void setFailonerror(boolean b2) {
        this.failOnError = b2;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public void addPackageset(DirSet packageSet) {
        this.packageSets.addElement(packageSet);
    }

    public void addFileset(FileSet fs2) {
        this.createSourceFiles().add(fs2);
    }

    public ResourceCollectionContainer createSourceFiles() {
        return this.nestedSourceFiles;
    }

    public void setLinksource(boolean b2) {
        this.linksource = b2;
    }

    public void setBreakiterator(boolean b2) {
        this.breakiterator = b2;
    }

    public void setNoqualifier(String noqualifier) {
        this.noqualifier = noqualifier;
    }

    public void setIncludeNoSourcePackages(boolean b2) {
        this.includeNoSourcePackages = b2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        JavadocOutputStream err;
        JavadocOutputStream out;
        block28: {
            this.checkTaskName();
            Vector packagesToDoc = new Vector();
            Path sourceDirs = new Path(this.getProject());
            this.checkPackageAndSourcePath();
            if (this.sourcePath != null) {
                sourceDirs.addExisting(this.sourcePath);
            }
            this.parsePackages(packagesToDoc, sourceDirs);
            this.checkPackages(packagesToDoc, sourceDirs);
            Vector sourceFilesToDoc = (Vector)this.sourceFiles.clone();
            this.addSourceFiles(sourceFilesToDoc);
            this.checkPackagesToDoc(packagesToDoc, sourceFilesToDoc);
            this.log("Generating Javadoc", 2);
            Commandline toExecute = (Commandline)this.cmd.clone();
            if (this.executable != null) {
                toExecute.setExecutable(this.executable);
            } else {
                toExecute.setExecutable(JavaEnvUtils.getJdkExecutable("javadoc"));
            }
            this.generalJavadocArguments(toExecute);
            this.doSourcePath(toExecute, sourceDirs);
            this.doDoclet(toExecute);
            this.doBootPath(toExecute);
            this.doLinks(toExecute);
            this.doGroup(toExecute);
            this.doGroups(toExecute);
            if (JAVADOC_4 || this.executable != null) {
                this.doJava14(toExecute);
                if (this.breakiterator && (this.doclet == null || JAVADOC_5)) {
                    toExecute.createArgument().setValue("-breakiterator");
                }
            } else {
                this.doNotJava14();
            }
            if (!JAVADOC_4 || this.executable != null) {
                if (this.old) {
                    toExecute.createArgument().setValue("-1.1");
                }
            } else if (this.old) {
                this.log("Javadoc 1.4 doesn't support the -1.1 switch anymore", 1);
            }
            if (this.useExternalFile && JAVADOC_4) {
                this.writeExternalArgs(toExecute);
            }
            File tmpList = null;
            PrintWriter srcListWriter = null;
            try {
                try {
                    if (this.useExternalFile) {
                        tmpList = FILE_UTILS.createTempFile("javadoc", "", null, true, true);
                        toExecute.createArgument().setValue("@" + tmpList.getAbsolutePath());
                        srcListWriter = new PrintWriter(new FileWriter(tmpList.getAbsolutePath(), true));
                    }
                    this.doSourceAndPackageNames(toExecute, packagesToDoc, sourceFilesToDoc, this.useExternalFile, tmpList, srcListWriter);
                }
                catch (IOException e2) {
                    tmpList.delete();
                    throw new BuildException("Error creating temporary file", e2, this.getLocation());
                }
                Object var9_7 = null;
                if (srcListWriter != null) {
                    srcListWriter.close();
                }
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                if (srcListWriter == null) throw throwable;
                srcListWriter.close();
                throw throwable;
            }
            if (this.packageList != null) {
                toExecute.createArgument().setValue("@" + this.packageList);
            }
            this.log(toExecute.describeCommand(), 3);
            this.log("Javadoc execution", 2);
            out = new JavadocOutputStream(2);
            err = new JavadocOutputStream(1);
            Execute exe = new Execute(new PumpStreamHandler(out, err));
            exe.setAntRun(this.getProject());
            exe.setWorkingDirectory(null);
            try {
                try {
                    exe.setCommandline(toExecute.getCommandline());
                    int ret = exe.execute();
                    if (ret != 0 && this.failOnError) {
                        throw new BuildException("Javadoc returned " + ret, this.getLocation());
                    }
                    Object var12_15 = null;
                    if (tmpList == null) break block28;
                    tmpList.delete();
                }
                catch (IOException e4) {
                    throw new BuildException("Javadoc failed: " + e4, e4, this.getLocation());
                }
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                if (tmpList != null) {
                    tmpList.delete();
                    tmpList = null;
                }
                out.logFlush();
                err.logFlush();
                try {
                    out.close();
                    err.close();
                    throw throwable;
                }
                catch (IOException e3) {
                    // empty catch block
                }
                throw throwable;
            }
            tmpList = null;
        }
        out.logFlush();
        err.logFlush();
        try {}
        catch (IOException e3) {}
        out.close();
        err.close();
        return;
    }

    private void checkTaskName() {
        if ("javadoc2".equals(this.getTaskType())) {
            this.log("Warning: the task name <javadoc2> is deprecated. Use <javadoc> instead.", 1);
        }
    }

    private void checkPackageAndSourcePath() {
        if (this.packageList != null && this.sourcePath == null) {
            String msg = "sourcePath attribute must be set when specifying packagelist.";
            throw new BuildException(msg);
        }
    }

    private void checkPackages(Vector packagesToDoc, Path sourceDirs) {
        if (packagesToDoc.size() != 0 && sourceDirs.size() == 0) {
            String msg = "sourcePath attribute must be set when specifying package names.";
            throw new BuildException(msg);
        }
    }

    private void checkPackagesToDoc(Vector packagesToDoc, Vector sourceFilesToDoc) {
        if (this.packageList == null && packagesToDoc.size() == 0 && sourceFilesToDoc.size() == 0) {
            throw new BuildException("No source files and no packages have been specified.");
        }
    }

    private void doSourcePath(Commandline toExecute, Path sourceDirs) {
        if (sourceDirs.size() > 0) {
            toExecute.createArgument().setValue("-sourcepath");
            toExecute.createArgument().setPath(sourceDirs);
        }
    }

    private void generalJavadocArguments(Commandline toExecute) {
        if (this.doctitle != null) {
            toExecute.createArgument().setValue("-doctitle");
            toExecute.createArgument().setValue(this.expand(this.doctitle.getText()));
        }
        if (this.header != null) {
            toExecute.createArgument().setValue("-header");
            toExecute.createArgument().setValue(this.expand(this.header.getText()));
        }
        if (this.footer != null) {
            toExecute.createArgument().setValue("-footer");
            toExecute.createArgument().setValue(this.expand(this.footer.getText()));
        }
        if (this.bottom != null) {
            toExecute.createArgument().setValue("-bottom");
            toExecute.createArgument().setValue(this.expand(this.bottom.getText()));
        }
        this.classpath = this.classpath == null ? new Path(this.getProject()).concatSystemClasspath("last") : this.classpath.concatSystemClasspath("ignore");
        if (this.classpath.size() > 0) {
            toExecute.createArgument().setValue("-classpath");
            toExecute.createArgument().setPath(this.classpath);
        }
        if (this.version && this.doclet == null) {
            toExecute.createArgument().setValue("-version");
        }
        if (this.author && this.doclet == null) {
            toExecute.createArgument().setValue("-author");
        }
        if (this.doclet == null && this.destDir == null) {
            throw new BuildException("destdir attribute must be set!");
        }
    }

    private void doDoclet(Commandline toExecute) {
        if (this.doclet != null) {
            Path docletPath;
            if (this.doclet.getName() == null) {
                throw new BuildException("The doclet name must be specified.", this.getLocation());
            }
            toExecute.createArgument().setValue("-doclet");
            toExecute.createArgument().setValue(this.doclet.getName());
            if (this.doclet.getPath() != null && (docletPath = this.doclet.getPath().concatSystemClasspath("ignore")).size() != 0) {
                toExecute.createArgument().setValue("-docletpath");
                toExecute.createArgument().setPath(docletPath);
            }
            Enumeration e2 = this.doclet.getParams();
            while (e2.hasMoreElements()) {
                DocletParam param = (DocletParam)e2.nextElement();
                if (param.getName() == null) {
                    throw new BuildException("Doclet parameters must have a name");
                }
                toExecute.createArgument().setValue(param.getName());
                if (param.getValue() == null) continue;
                toExecute.createArgument().setValue(param.getValue());
            }
        }
    }

    private void writeExternalArgs(Commandline toExecute) {
        File optionsTmpFile = null;
        PrintWriter optionsListWriter = null;
        try {
            try {
                optionsTmpFile = FILE_UTILS.createTempFile("javadocOptions", "", null, true, true);
                String[] listOpt = toExecute.getArguments();
                toExecute.clearArgs();
                toExecute.createArgument().setValue("@" + optionsTmpFile.getAbsolutePath());
                optionsListWriter = new PrintWriter(new FileWriter(optionsTmpFile.getAbsolutePath(), true));
                for (int i2 = 0; i2 < listOpt.length; ++i2) {
                    String string = listOpt[i2];
                    if (string.startsWith("-J-")) {
                        toExecute.createArgument().setValue(string);
                        continue;
                    }
                    if (string.startsWith("-")) {
                        optionsListWriter.print(string);
                        optionsListWriter.print(" ");
                        continue;
                    }
                    optionsListWriter.println(this.quoteString(string));
                }
                optionsListWriter.close();
            }
            catch (IOException ex2) {
                if (optionsTmpFile != null) {
                    optionsTmpFile.delete();
                }
                throw new BuildException("Error creating or writing temporary file for javadoc options", ex2, this.getLocation());
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            FileUtils.close(optionsListWriter);
            throw throwable;
        }
        FileUtils.close(optionsListWriter);
    }

    private void doBootPath(Commandline toExecute) {
        Path bcp = new Path(this.getProject());
        if (this.bootclasspath != null) {
            bcp.append(this.bootclasspath);
        }
        if ((bcp = bcp.concatSystemBootClasspath("ignore")).size() > 0) {
            toExecute.createArgument().setValue("-bootclasspath");
            toExecute.createArgument().setPath(bcp);
        }
    }

    private void doLinks(Commandline toExecute) {
        if (this.links.size() != 0) {
            Enumeration e2 = this.links.elements();
            while (e2.hasMoreElements()) {
                File hrefAsFile;
                LinkArgument la = (LinkArgument)e2.nextElement();
                if (la.getHref() == null || la.getHref().length() == 0) {
                    this.log("No href was given for the link - skipping", 3);
                    continue;
                }
                String link = null;
                if (la.shouldResolveLink() && (hrefAsFile = this.getProject().resolveFile(la.getHref())).exists()) {
                    try {
                        link = FILE_UTILS.getFileURL(hrefAsFile).toExternalForm();
                    }
                    catch (MalformedURLException ex2) {
                        this.log("Warning: link location was invalid " + hrefAsFile, 1);
                    }
                }
                if (link == null) {
                    try {
                        URL base = new URL("file://.");
                        new URL(base, la.getHref());
                        link = la.getHref();
                    }
                    catch (MalformedURLException mue) {
                        this.log("Link href \"" + la.getHref() + "\" is not a valid url - skipping link", 1);
                        continue;
                    }
                }
                if (la.isLinkOffline()) {
                    File packageListLocation = la.getPackagelistLoc();
                    if (packageListLocation == null) {
                        throw new BuildException("The package list location for link " + la.getHref() + " must be provided " + "because the link is " + "offline");
                    }
                    File packageListFile = new File(packageListLocation, "package-list");
                    if (packageListFile.exists()) {
                        try {
                            String packageListURL = FILE_UTILS.getFileURL(packageListLocation).toExternalForm();
                            toExecute.createArgument().setValue("-linkoffline");
                            toExecute.createArgument().setValue(link);
                            toExecute.createArgument().setValue(packageListURL);
                        }
                        catch (MalformedURLException ex3) {
                            this.log("Warning: Package list location was invalid " + packageListLocation, 1);
                        }
                        continue;
                    }
                    this.log("Warning: No package list was found at " + packageListLocation, 3);
                    continue;
                }
                toExecute.createArgument().setValue("-link");
                toExecute.createArgument().setValue(link);
            }
        }
    }

    private void doGroup(Commandline toExecute) {
        if (this.group != null) {
            StringTokenizer tok = new StringTokenizer(this.group, ",", false);
            while (tok.hasMoreTokens()) {
                String grp = tok.nextToken().trim();
                int space = grp.indexOf(" ");
                if (space <= 0) continue;
                String name = grp.substring(0, space);
                String pkgList = grp.substring(space + 1);
                toExecute.createArgument().setValue("-group");
                toExecute.createArgument().setValue(name);
                toExecute.createArgument().setValue(pkgList);
            }
        }
    }

    private void doGroups(Commandline toExecute) {
        if (this.groups.size() != 0) {
            Enumeration e2 = this.groups.elements();
            while (e2.hasMoreElements()) {
                GroupArgument ga2 = (GroupArgument)e2.nextElement();
                String title = ga2.getTitle();
                String packages = ga2.getPackages();
                if (title == null || packages == null) {
                    throw new BuildException("The title and packages must be specified for group elements.");
                }
                toExecute.createArgument().setValue("-group");
                toExecute.createArgument().setValue(this.expand(title));
                toExecute.createArgument().setValue(packages);
            }
        }
    }

    private void doJava14(Commandline toExecute) {
        String sourceArg;
        Enumeration e2 = this.tags.elements();
        while (e2.hasMoreElements()) {
            Path tagletPath;
            Object element = e2.nextElement();
            if (element instanceof TagArgument) {
                TagArgument ta = (TagArgument)element;
                File tagDir = ta.getDir(this.getProject());
                if (tagDir == null) {
                    toExecute.createArgument().setValue("-tag");
                    toExecute.createArgument().setValue(ta.getParameter());
                    continue;
                }
                DirectoryScanner tagDefScanner = ta.getDirectoryScanner(this.getProject());
                String[] files = tagDefScanner.getIncludedFiles();
                for (int i2 = 0; i2 < files.length; ++i2) {
                    File tagDefFile = new File(tagDir, files[i2]);
                    try {
                        BufferedReader in = new BufferedReader(new FileReader(tagDefFile));
                        String line = null;
                        while ((line = in.readLine()) != null) {
                            toExecute.createArgument().setValue("-tag");
                            toExecute.createArgument().setValue(line);
                        }
                        in.close();
                        continue;
                    }
                    catch (IOException ioe) {
                        throw new BuildException("Couldn't read  tag file from " + tagDefFile.getAbsolutePath(), ioe);
                    }
                }
                continue;
            }
            ExtensionInfo tagletInfo = (ExtensionInfo)element;
            toExecute.createArgument().setValue("-taglet");
            toExecute.createArgument().setValue(tagletInfo.getName());
            if (tagletInfo.getPath() == null || (tagletPath = tagletInfo.getPath().concatSystemClasspath("ignore")).size() == 0) continue;
            toExecute.createArgument().setValue("-tagletpath");
            toExecute.createArgument().setPath(tagletPath);
        }
        String string = sourceArg = this.source != null ? this.source : this.getProject().getProperty("ant.build.javac.source");
        if (sourceArg != null) {
            toExecute.createArgument().setValue("-source");
            toExecute.createArgument().setValue(sourceArg);
        }
        if (this.linksource && this.doclet == null) {
            toExecute.createArgument().setValue("-linksource");
        }
        if (this.noqualifier != null && this.doclet == null) {
            toExecute.createArgument().setValue("-noqualifier");
            toExecute.createArgument().setValue(this.noqualifier);
        }
    }

    private void doNotJava14() {
        if (!this.tags.isEmpty()) {
            this.log("-tag and -taglet options not supported on Javadoc < 1.4", 3);
        }
        if (this.source != null) {
            this.log("-source option not supported on Javadoc < 1.4", 3);
        }
        if (this.linksource) {
            this.log("-linksource option not supported on Javadoc < 1.4", 3);
        }
        if (this.breakiterator) {
            this.log("-breakiterator option not supported on Javadoc < 1.4", 3);
        }
        if (this.noqualifier != null) {
            this.log("-noqualifier option not supported on Javadoc < 1.4", 3);
        }
    }

    private void doSourceAndPackageNames(Commandline toExecute, Vector packagesToDoc, Vector sourceFilesToDoc, boolean useExternalFile, File tmpList, PrintWriter srcListWriter) throws IOException {
        Enumeration e2 = packagesToDoc.elements();
        while (e2.hasMoreElements()) {
            String packageName = (String)e2.nextElement();
            if (useExternalFile) {
                srcListWriter.println(packageName);
                continue;
            }
            toExecute.createArgument().setValue(packageName);
        }
        e2 = sourceFilesToDoc.elements();
        while (e2.hasMoreElements()) {
            SourceFile sf = (SourceFile)e2.nextElement();
            String sourceFileName = sf.getFile().getAbsolutePath();
            if (useExternalFile) {
                if (JAVADOC_4 && sourceFileName.indexOf(" ") > -1) {
                    String name = sourceFileName;
                    if (File.separatorChar == '\\') {
                        name = sourceFileName.replace(File.separatorChar, '/');
                    }
                    srcListWriter.println("\"" + name + "\"");
                    continue;
                }
                srcListWriter.println(sourceFileName);
                continue;
            }
            toExecute.createArgument().setValue(sourceFileName);
        }
    }

    private String quoteString(String str) {
        if (str.indexOf(32) == -1 && str.indexOf(39) == -1 && str.indexOf(34) == -1) {
            return str;
        }
        if (str.indexOf(39) == -1) {
            return this.quoteString(str, '\'');
        }
        return this.quoteString(str, '\"');
    }

    private String quoteString(String str, char delim) {
        StringBuffer buf = new StringBuffer(str.length() * 2);
        buf.append(delim);
        if (str.indexOf(92) != -1) {
            str = this.replace(str, '\\', "\\\\");
        }
        if (str.indexOf(delim) != -1) {
            str = this.replace(str, delim, "\\" + delim);
        }
        buf.append(str);
        buf.append(delim);
        return buf.toString();
    }

    private String replace(String str, char fromChar, String toString) {
        StringBuffer buf = new StringBuffer(str.length() * 2);
        for (int i2 = 0; i2 < str.length(); ++i2) {
            char ch2 = str.charAt(i2);
            if (ch2 == fromChar) {
                buf.append(toString);
                continue;
            }
            buf.append(ch2);
        }
        return buf.toString();
    }

    private void addSourceFiles(Vector sf) {
        Iterator e2 = this.nestedSourceFiles.iterator();
        while (e2.hasNext()) {
            FileSet fs2;
            ResourceCollection rc = (ResourceCollection)e2.next();
            if (!rc.isFilesystemOnly()) {
                throw new BuildException("only file system based resources are supported by javadoc");
            }
            if (rc instanceof FileSet && !(fs2 = (FileSet)rc).hasPatterns() && !fs2.hasSelectors()) {
                FileSet fs22 = (FileSet)fs2.clone();
                fs22.createInclude().setName("**/*.java");
                if (this.includeNoSourcePackages) {
                    fs22.createInclude().setName("**/package.html");
                }
                rc = fs22;
            }
            Iterator iter = rc.iterator();
            while (iter.hasNext()) {
                sf.addElement(new SourceFile(((FileResource)iter.next()).getFile()));
            }
        }
    }

    private void parsePackages(Vector pn, Path sp) {
        Vector<String> addedPackages = new Vector<String>();
        Vector dirSets = (Vector)this.packageSets.clone();
        if (this.sourcePath != null) {
            String pkg;
            PackageName p2;
            Enumeration e2;
            PatternSet ps = new PatternSet();
            if (this.packageNames.size() > 0) {
                e2 = this.packageNames.elements();
                while (e2.hasMoreElements()) {
                    p2 = (PackageName)e2.nextElement();
                    pkg = p2.getName().replace('.', '/');
                    if (pkg.endsWith("*")) {
                        pkg = pkg + "*";
                    }
                    ps.createInclude().setName(pkg);
                }
            } else {
                ps.createInclude().setName("**");
            }
            e2 = this.excludePackageNames.elements();
            while (e2.hasMoreElements()) {
                p2 = (PackageName)e2.nextElement();
                pkg = p2.getName().replace('.', '/');
                if (pkg.endsWith("*")) {
                    pkg = pkg + "*";
                }
                ps.createExclude().setName(pkg);
            }
            String[] pathElements = this.sourcePath.list();
            for (int i2 = 0; i2 < pathElements.length; ++i2) {
                File dir = new File(pathElements[i2]);
                if (dir.isDirectory()) {
                    DirSet ds2 = new DirSet();
                    ds2.setDefaultexcludes(this.useDefaultExcludes);
                    ds2.setDir(dir);
                    ds2.createPatternSet().addConfiguredPatternset(ps);
                    dirSets.addElement(ds2);
                    continue;
                }
                this.log("Skipping " + pathElements[i2] + " since it is no directory.", 1);
            }
        }
        Enumeration e3 = dirSets.elements();
        while (e3.hasMoreElements()) {
            DirSet ds3 = (DirSet)e3.nextElement();
            File baseDir = ds3.getDir(this.getProject());
            this.log("scanning " + baseDir + " for packages.", 4);
            DirectoryScanner dsc = ds3.getDirectoryScanner(this.getProject());
            String[] dirs = dsc.getIncludedDirectories();
            boolean containsPackages = false;
            for (int i3 = 0; i3 < dirs.length; ++i3) {
                File pd = new File(baseDir, dirs[i3]);
                String[] files = pd.list(new FilenameFilter(){

                    public boolean accept(File dir1, String name) {
                        return name.endsWith(".java") || Javadoc.this.includeNoSourcePackages && name.equals("package.html");
                    }
                });
                if (files.length <= 0) continue;
                if ("".equals(dirs[i3])) {
                    this.log(baseDir + " contains source files in the default package," + " you must specify them as source files" + " not packages.", 1);
                    continue;
                }
                containsPackages = true;
                String packageName = dirs[i3].replace(File.separatorChar, '.');
                if (addedPackages.contains(packageName)) continue;
                addedPackages.addElement(packageName);
                pn.addElement(packageName);
            }
            if (containsPackages) {
                sp.createPathElement().setLocation(baseDir);
                continue;
            }
            this.log(baseDir + " doesn't contain any packages, dropping it.", 3);
        }
    }

    protected String expand(String content) {
        return this.getProject().replaceProperties(content);
    }

    private class JavadocOutputStream
    extends LogOutputStream {
        private String queuedLine = null;

        JavadocOutputStream(int level) {
            super(Javadoc.this, level);
        }

        protected void processLine(String line, int messageLevel) {
            if (messageLevel == 2 && line.startsWith("Generating ")) {
                if (this.queuedLine != null) {
                    super.processLine(this.queuedLine, 3);
                }
                this.queuedLine = line;
            } else {
                if (this.queuedLine != null) {
                    if (line.startsWith("Building ")) {
                        super.processLine(this.queuedLine, 3);
                    } else {
                        super.processLine(this.queuedLine, 2);
                    }
                    this.queuedLine = null;
                }
                super.processLine(line, messageLevel);
            }
        }

        protected void logFlush() {
            if (this.queuedLine != null) {
                super.processLine(this.queuedLine, 3);
                this.queuedLine = null;
            }
        }
    }

    public class GroupArgument {
        private Html title;
        private Vector packages = new Vector();

        public void setTitle(String src) {
            Html h2 = new Html();
            h2.addText(src);
            this.addTitle(h2);
        }

        public void addTitle(Html text) {
            this.title = text;
        }

        public String getTitle() {
            return this.title != null ? this.title.getText() : null;
        }

        public void setPackages(String src) {
            StringTokenizer tok = new StringTokenizer(src, ",");
            while (tok.hasMoreTokens()) {
                String p2 = tok.nextToken();
                PackageName pn = new PackageName();
                pn.setName(p2);
                this.addPackage(pn);
            }
        }

        public void addPackage(PackageName pn) {
            this.packages.addElement(pn);
        }

        public String getPackages() {
            StringBuffer p2 = new StringBuffer();
            for (int i2 = 0; i2 < this.packages.size(); ++i2) {
                if (i2 > 0) {
                    p2.append(":");
                }
                p2.append(this.packages.elementAt(i2).toString());
            }
            return p2.toString();
        }
    }

    public class TagArgument
    extends FileSet {
        private String name = null;
        private boolean enabled = true;
        private String scope = "a";

        public void setName(String name) {
            this.name = name;
        }

        public void setScope(String verboseScope) throws BuildException {
            int i2;
            verboseScope = verboseScope.toLowerCase(Locale.US);
            boolean[] elements = new boolean[SCOPE_ELEMENTS.length];
            boolean gotAll = false;
            boolean gotNotAll = false;
            StringTokenizer tok = new StringTokenizer(verboseScope, ",");
            while (tok.hasMoreTokens()) {
                String next = tok.nextToken().trim();
                if (next.equals("all")) {
                    if (gotAll) {
                        this.getProject().log("Repeated tag scope element: all", 3);
                    }
                    gotAll = true;
                    continue;
                }
                for (i2 = 0; i2 < SCOPE_ELEMENTS.length && !next.equals(SCOPE_ELEMENTS[i2]); ++i2) {
                }
                if (i2 == SCOPE_ELEMENTS.length) {
                    throw new BuildException("Unrecognised scope element: " + next);
                }
                if (elements[i2]) {
                    this.getProject().log("Repeated tag scope element: " + next, 3);
                }
                elements[i2] = true;
                gotNotAll = true;
            }
            if (gotNotAll && gotAll) {
                throw new BuildException("Mixture of \"all\" and other scope elements in tag parameter.");
            }
            if (!gotNotAll && !gotAll) {
                throw new BuildException("No scope elements specified in tag parameter.");
            }
            if (gotAll) {
                this.scope = "a";
            } else {
                StringBuffer buff = new StringBuffer(elements.length);
                for (i2 = 0; i2 < elements.length; ++i2) {
                    if (!elements[i2]) continue;
                    buff.append(SCOPE_ELEMENTS[i2].charAt(0));
                }
                this.scope = buff.toString();
            }
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getParameter() throws BuildException {
            if (this.name == null || this.name.equals("")) {
                throw new BuildException("No name specified for custom tag.");
            }
            if (this.getDescription() != null) {
                return this.name + ":" + (this.enabled ? "" : "X") + this.scope + ":" + this.getDescription();
            }
            if (!this.enabled || !"a".equals(this.scope)) {
                return this.name + ":" + (this.enabled ? "" : "X") + this.scope;
            }
            return this.name;
        }
    }

    public class LinkArgument {
        private String href;
        private boolean offline = false;
        private File packagelistLoc;
        private boolean resolveLink = false;

        public void setHref(String hr) {
            this.href = hr;
        }

        public String getHref() {
            return this.href;
        }

        public void setPackagelistLoc(File src) {
            this.packagelistLoc = src;
        }

        public File getPackagelistLoc() {
            return this.packagelistLoc;
        }

        public void setOffline(boolean offline) {
            this.offline = offline;
        }

        public boolean isLinkOffline() {
            return this.offline;
        }

        public void setResolveLink(boolean resolve) {
            this.resolveLink = resolve;
        }

        public boolean shouldResolveLink() {
            return this.resolveLink;
        }
    }

    public class ResourceCollectionContainer {
        private ArrayList rcs = new ArrayList();

        public void add(ResourceCollection rc) {
            this.rcs.add(rc);
        }

        private Iterator iterator() {
            return this.rcs.iterator();
        }
    }

    public static class AccessType
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"protected", "public", "package", "private"};
        }
    }

    public static class Html {
        private StringBuffer text = new StringBuffer();

        public void addText(String t2) {
            this.text.append(t2);
        }

        public String getText() {
            return this.text.substring(0);
        }
    }

    public static class SourceFile {
        private File file;

        public SourceFile() {
        }

        public SourceFile(File file) {
            this.file = file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }
    }

    public static class PackageName {
        private String name;

        public void setName(String name) {
            this.name = name.trim();
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }
    }

    public class DocletInfo
    extends ExtensionInfo {
        private Vector params = new Vector();

        public DocletParam createParam() {
            DocletParam param = new DocletParam();
            this.params.addElement(param);
            return param;
        }

        public Enumeration getParams() {
            return this.params.elements();
        }
    }

    public static class ExtensionInfo
    extends ProjectComponent {
        private String name;
        private Path path;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setPath(Path path) {
            if (this.path == null) {
                this.path = path;
            } else {
                this.path.append(path);
            }
        }

        public Path getPath() {
            return this.path;
        }

        public Path createPath() {
            if (this.path == null) {
                this.path = new Path(this.getProject());
            }
            return this.path.createPath();
        }

        public void setPathRef(Reference r2) {
            this.createPath().setRefid(r2);
        }
    }

    public class DocletParam {
        private String name;
        private String value;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

