/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicAttribute;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.taskdefs.MacroDef;

public class MacroInstance
extends Task
implements DynamicAttribute,
TaskContainer {
    private MacroDef macroDef;
    private Map map = new HashMap();
    private Map nsElements = null;
    private Map presentElements;
    private Hashtable localAttributes;
    private String text = null;
    private String implicitTag = null;
    private List unknownElements = new ArrayList();
    private static final int STATE_NORMAL = 0;
    private static final int STATE_EXPECT_BRACKET = 1;
    private static final int STATE_EXPECT_NAME = 2;

    public void setMacroDef(MacroDef macroDef) {
        this.macroDef = macroDef;
    }

    public MacroDef getMacroDef() {
        return this.macroDef;
    }

    public void setDynamicAttribute(String name, String value) {
        this.map.put(name, value);
    }

    public Object createDynamicElement(String name) throws BuildException {
        throw new BuildException("Not implemented any more");
    }

    private Map getNsElements() {
        if (this.nsElements == null) {
            this.nsElements = new HashMap();
            Iterator i2 = this.macroDef.getElements().entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry entry = i2.next();
                this.nsElements.put((String)entry.getKey(), entry.getValue());
                MacroDef.TemplateElement te = (MacroDef.TemplateElement)entry.getValue();
                if (!te.isImplicit()) continue;
                this.implicitTag = te.getName();
            }
        }
        return this.nsElements;
    }

    public void addTask(Task nestedTask) {
        this.unknownElements.add(nestedTask);
    }

    private void processTasks() {
        if (this.implicitTag != null) {
            return;
        }
        Iterator i2 = this.unknownElements.iterator();
        while (i2.hasNext()) {
            UnknownElement ue = (UnknownElement)i2.next();
            String name = ProjectHelper.extractNameFromComponentName(ue.getTag()).toLowerCase(Locale.US);
            if (this.getNsElements().get(name) == null) {
                throw new BuildException("unsupported element " + name);
            }
            if (this.presentElements.get(name) != null) {
                throw new BuildException("Element " + name + " already present");
            }
            this.presentElements.put(name, ue);
        }
    }

    private String macroSubs(String s2, Map macroMapping) {
        if (s2 == null) {
            return null;
        }
        StringBuffer ret = new StringBuffer();
        StringBuffer macroName = null;
        int state = 0;
        block10: for (int i2 = 0; i2 < s2.length(); ++i2) {
            char ch2 = s2.charAt(i2);
            switch (state) {
                case 0: {
                    if (ch2 == '@') {
                        state = 1;
                        continue block10;
                    }
                    ret.append(ch2);
                    continue block10;
                }
                case 1: {
                    if (ch2 == '{') {
                        state = 2;
                        macroName = new StringBuffer();
                        continue block10;
                    }
                    if (ch2 == '@') {
                        state = 0;
                        ret.append('@');
                        continue block10;
                    }
                    state = 0;
                    ret.append('@');
                    ret.append(ch2);
                    continue block10;
                }
                case 2: {
                    if (ch2 == '}') {
                        state = 0;
                        String name = macroName.toString().toLowerCase(Locale.US);
                        String value = (String)macroMapping.get(name);
                        if (value == null) {
                            ret.append("@{");
                            ret.append(name);
                            ret.append("}");
                        } else {
                            ret.append(value);
                        }
                        macroName = null;
                        continue block10;
                    }
                    macroName.append(ch2);
                    continue block10;
                }
            }
        }
        switch (state) {
            case 0: {
                break;
            }
            case 1: {
                ret.append('@');
                break;
            }
            case 2: {
                ret.append("@{");
                ret.append(macroName.toString());
                break;
            }
        }
        return ret.toString();
    }

    public void addText(String text) {
        this.text = text;
    }

    private UnknownElement copy(UnknownElement ue, boolean nested) {
        UnknownElement ret = new UnknownElement(ue.getTag());
        ret.setNamespace(ue.getNamespace());
        ret.setProject(this.getProject());
        ret.setQName(ue.getQName());
        ret.setTaskType(ue.getTaskType());
        ret.setTaskName(ue.getTaskName());
        ret.setLocation(this.macroDef.getBackTrace() ? ue.getLocation() : this.getLocation());
        if (this.getOwningTarget() == null) {
            Target t2 = new Target();
            t2.setProject(this.getProject());
            ret.setOwningTarget(t2);
        } else {
            ret.setOwningTarget(this.getOwningTarget());
        }
        RuntimeConfigurable rc = new RuntimeConfigurable(ret, ue.getTaskName());
        rc.setPolyType(ue.getWrapper().getPolyType());
        Hashtable m2 = ue.getWrapper().getAttributeMap();
        Iterator i2 = m2.entrySet().iterator();
        while (i2.hasNext()) {
            Map.Entry entry = i2.next();
            rc.setAttribute((String)entry.getKey(), this.macroSubs((String)entry.getValue(), this.localAttributes));
        }
        rc.addText(this.macroSubs(ue.getWrapper().getText().toString(), this.localAttributes));
        Enumeration e2 = ue.getWrapper().getChildren();
        while (e2.hasMoreElements()) {
            List list;
            MacroDef.TemplateElement templateElement;
            RuntimeConfigurable r2 = (RuntimeConfigurable)e2.nextElement();
            UnknownElement unknownElement = (UnknownElement)r2.getProxy();
            String tag = unknownElement.getTaskType();
            if (tag != null) {
                tag = tag.toLowerCase(Locale.US);
            }
            if ((templateElement = (MacroDef.TemplateElement)this.getNsElements().get(tag)) == null || nested) {
                UnknownElement child = this.copy(unknownElement, nested);
                rc.addChild(child.getWrapper());
                ret.addChild(child);
                continue;
            }
            if (templateElement.isImplicit()) {
                if (this.unknownElements.size() == 0 && !templateElement.isOptional()) {
                    throw new BuildException("Missing nested elements for implicit element " + templateElement.getName());
                }
                Iterator i3 = this.unknownElements.iterator();
                while (i3.hasNext()) {
                    UnknownElement child = this.copy((UnknownElement)i3.next(), true);
                    rc.addChild(child.getWrapper());
                    ret.addChild(child);
                }
                continue;
            }
            UnknownElement presentElement = (UnknownElement)this.presentElements.get(tag);
            if (presentElement == null) {
                if (templateElement.isOptional()) continue;
                throw new BuildException("Required nested element " + templateElement.getName() + " missing");
            }
            String presentText = presentElement.getWrapper().getText().toString();
            if (!"".equals(presentText)) {
                rc.addText(this.macroSubs(presentText, this.localAttributes));
            }
            if ((list = presentElement.getChildren()) == null) continue;
            Iterator i4 = list.iterator();
            while (i4.hasNext()) {
                UnknownElement child = this.copy((UnknownElement)i4.next(), true);
                rc.addChild(child.getWrapper());
                ret.addChild(child);
            }
        }
        return ret;
    }

    public void execute() {
        this.presentElements = new HashMap();
        this.getNsElements();
        this.processTasks();
        this.localAttributes = new Hashtable();
        HashSet copyKeys = new HashSet(this.map.keySet());
        Iterator i2 = this.macroDef.getAttributes().iterator();
        while (i2.hasNext()) {
            MacroDef.Attribute attribute = (MacroDef.Attribute)i2.next();
            String value = (String)this.map.get(attribute.getName());
            if (value == null && "description".equals(attribute.getName())) {
                value = this.getDescription();
            }
            if (value == null) {
                value = attribute.getDefault();
                value = this.macroSubs(value, this.localAttributes);
            }
            if (value == null) {
                throw new BuildException("required attribute " + attribute.getName() + " not set");
            }
            this.localAttributes.put(attribute.getName(), value);
            copyKeys.remove(attribute.getName());
        }
        if (copyKeys.contains("id")) {
            copyKeys.remove("id");
        }
        if (this.macroDef.getText() != null) {
            if (this.text == null) {
                String defaultText = this.macroDef.getText().getDefault();
                if (!this.macroDef.getText().getOptional() && defaultText == null) {
                    throw new BuildException("required text missing");
                }
                String string = this.text = defaultText == null ? "" : defaultText;
            }
            if (this.macroDef.getText().getTrim()) {
                this.text = this.text.trim();
            }
            this.localAttributes.put(this.macroDef.getText().getName(), this.text);
        } else if (this.text != null && !this.text.trim().equals("")) {
            throw new BuildException("The \"" + this.getTaskName() + "\" macro does not support" + " nested text data.");
        }
        if (copyKeys.size() != 0) {
            throw new BuildException("Unknown attribute" + (copyKeys.size() > 1 ? "s " : " ") + copyKeys);
        }
        UnknownElement c2 = this.copy(this.macroDef.getNestedTask(), false);
        c2.init();
        try {
            c2.perform();
        }
        catch (BuildException ex2) {
            if (this.macroDef.getBackTrace()) {
                throw ProjectHelper.addLocationToBuildException(ex2, this.getLocation());
            }
            ex2.setLocation(this.getLocation());
            throw ex2;
        }
        finally {
            this.presentElements = null;
            this.localAttributes = null;
        }
    }

    public static class Element
    implements TaskContainer {
        private List unknownElements = new ArrayList();

        public void addTask(Task nestedTask) {
            this.unknownElements.add(nestedTask);
        }

        public List getUnknownElements() {
            return this.unknownElements;
        }
    }
}

