/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.util.FileUtils;

public class ManifestTask
extends Task {
    public static final String VALID_ATTRIBUTE_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ012345679-_";
    private Manifest nestedManifest = new Manifest();
    private File manifestFile;
    private Mode mode = new Mode();
    private String encoding;

    public ManifestTask() {
        this.mode.setValue("replace");
    }

    public void addConfiguredSection(Manifest.Section section) throws ManifestException {
        Enumeration attributeKeys = section.getAttributeKeys();
        while (attributeKeys.hasMoreElements()) {
            Manifest.Attribute attribute = section.getAttribute((String)attributeKeys.nextElement());
            this.checkAttribute(attribute);
        }
        this.nestedManifest.addConfiguredSection(section);
    }

    public void addConfiguredAttribute(Manifest.Attribute attribute) throws ManifestException {
        this.checkAttribute(attribute);
        this.nestedManifest.addConfiguredAttribute(attribute);
    }

    private void checkAttribute(Manifest.Attribute attribute) throws BuildException {
        String name = attribute.getName();
        char ch2 = name.charAt(0);
        if (ch2 == '-' || ch2 == '_') {
            throw new BuildException("Manifest attribute names must not start with '" + ch2 + "'.");
        }
        for (int i2 = 0; i2 < name.length(); ++i2) {
            ch2 = name.charAt(i2);
            if (VALID_ATTRIBUTE_CHARS.indexOf(ch2) >= 0) continue;
            throw new BuildException("Manifest attribute names must not contain '" + ch2 + "'");
        }
    }

    public void setFile(File f2) {
        this.manifestFile = f2;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setMode(Mode m2) {
        this.mode = m2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute() throws BuildException {
        if (this.manifestFile == null) {
            throw new BuildException("the file attribute is required");
        }
        Manifest toWrite = Manifest.getDefaultManifest();
        Manifest current = null;
        BuildException error = null;
        if (this.manifestFile.exists()) {
            FileInputStream fis = null;
            InputStreamReader isr = null;
            try {
                fis = new FileInputStream(this.manifestFile);
                isr = this.encoding == null ? new InputStreamReader((InputStream)fis, "UTF-8") : new InputStreamReader((InputStream)fis, this.encoding);
                current = new Manifest(isr);
            }
            catch (ManifestException m2) {
                error = new BuildException("Existing manifest " + this.manifestFile + " is invalid", m2, this.getLocation());
                FileUtils.close(isr);
            }
            catch (IOException e2) {
                error = new BuildException("Failed to read " + this.manifestFile, e2, this.getLocation());
                {
                    catch (Throwable throwable) {
                        FileUtils.close(isr);
                        throw throwable;
                    }
                }
                FileUtils.close(isr);
            }
            FileUtils.close(isr);
        }
        Enumeration e3 = this.nestedManifest.getWarnings();
        while (e3.hasMoreElements()) {
            this.log("Manifest warning: " + (String)e3.nextElement(), 1);
        }
        try {
            if (this.mode.getValue().equals("update") && this.manifestFile.exists()) {
                if (current != null) {
                    toWrite.merge(current);
                } else if (error != null) {
                    throw error;
                }
            }
            toWrite.merge(this.nestedManifest);
        }
        catch (ManifestException m3) {
            throw new BuildException("Manifest is invalid", m3, this.getLocation());
        }
        if (toWrite.equals(current)) {
            this.log("Manifest has not changed, do not recreate", 3);
            return;
        }
        PrintWriter w2 = null;
        try {
            FileOutputStream fos = new FileOutputStream(this.manifestFile);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            w2 = new PrintWriter(osw);
            toWrite.write(w2);
        }
        catch (IOException e4) {
            try {
                throw new BuildException("Failed to write " + this.manifestFile, e4, this.getLocation());
            }
            catch (Throwable throwable) {
                FileUtils.close(w2);
                throw throwable;
            }
        }
        FileUtils.close(w2);
    }

    public static class Mode
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"update", "replace"};
        }
    }
}

