/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;

public class Move
extends Copy {
    public Move() {
        this.setOverwrite(true);
    }

    protected void validateAttributes() throws BuildException {
        if (this.file != null && this.file.isDirectory()) {
            if (this.destFile != null && this.destDir != null || this.destFile == null && this.destDir == null) {
                throw new BuildException("One and only one of tofile and todir must be set.");
            }
            this.destFile = this.destFile == null ? new File(this.destDir, this.file.getName()) : this.destFile;
            this.destDir = this.destDir == null ? this.destFile.getParentFile() : this.destDir;
            this.completeDirMap.put(this.file, this.destFile);
            this.file = null;
        } else {
            super.validateAttributes();
        }
    }

    protected void doFileOperations() {
        int moveCount;
        if (this.completeDirMap.size() > 0) {
            Iterator fromDirs = this.completeDirMap.keySet().iterator();
            while (fromDirs.hasNext()) {
                File fromDir = (File)fromDirs.next();
                File toDir = (File)this.completeDirMap.get(fromDir);
                boolean renamed = false;
                try {
                    this.log("Attempting to rename dir: " + fromDir + " to " + toDir, this.verbosity);
                    renamed = this.renameFile(fromDir, toDir, this.filtering, this.forceOverwrite);
                }
                catch (IOException ioe) {
                    String msg = "Failed to rename dir " + fromDir + " to " + toDir + " due to " + ioe.getMessage();
                    throw new BuildException(msg, ioe, this.getLocation());
                }
                if (renamed) continue;
                FileSet fs2 = new FileSet();
                fs2.setProject(this.getProject());
                fs2.setDir(fromDir);
                this.addFileset(fs2);
                DirectoryScanner ds2 = fs2.getDirectoryScanner(this.getProject());
                String[] files = ds2.getIncludedFiles();
                String[] dirs = ds2.getIncludedDirectories();
                this.scan(fromDir, toDir, files, dirs);
            }
        }
        if ((moveCount = this.fileCopyMap.size()) > 0) {
            this.log("Moving " + moveCount + " file" + (moveCount == 1 ? "" : "s") + " to " + this.destDir.getAbsolutePath());
            Iterator fromFiles = this.fileCopyMap.keySet().iterator();
            while (fromFiles.hasNext()) {
                String fromFile = (String)fromFiles.next();
                File f2 = new File(fromFile);
                boolean selfMove = false;
                if (!f2.exists()) continue;
                String[] toFiles = (String[])this.fileCopyMap.get(fromFile);
                for (int i2 = 0; i2 < toFiles.length; ++i2) {
                    String toFile = toFiles[i2];
                    if (fromFile.equals(toFile)) {
                        this.log("Skipping self-move of " + fromFile, this.verbosity);
                        selfMove = true;
                        continue;
                    }
                    File d2 = new File(toFile);
                    if (i2 + 1 == toFiles.length && !selfMove) {
                        this.moveFile(f2, d2, this.filtering, this.forceOverwrite);
                        continue;
                    }
                    this.copyFile(f2, d2, this.filtering, this.forceOverwrite);
                }
            }
        }
        if (this.includeEmpty) {
            int createCount = 0;
            Iterator fromDirNames = this.dirCopyMap.keySet().iterator();
            while (fromDirNames.hasNext()) {
                String fromDirName = (String)fromDirNames.next();
                String[] toDirNames = (String[])this.dirCopyMap.get(fromDirName);
                boolean selfMove = false;
                for (int i3 = 0; i3 < toDirNames.length; ++i3) {
                    if (fromDirName.equals(toDirNames[i3])) {
                        this.log("Skipping self-move of " + fromDirName, this.verbosity);
                        selfMove = true;
                        continue;
                    }
                    File d3 = new File(toDirNames[i3]);
                    if (d3.exists()) continue;
                    if (!d3.mkdirs()) {
                        this.log("Unable to create directory " + d3.getAbsolutePath(), 0);
                        continue;
                    }
                    ++createCount;
                }
                File fromDir = new File(fromDirName);
                if (selfMove || !this.okToDelete(fromDir)) continue;
                this.deleteDir(fromDir);
            }
            if (createCount > 0) {
                this.log("Moved " + this.dirCopyMap.size() + " empty director" + (this.dirCopyMap.size() == 1 ? "y" : "ies") + " to " + createCount + " empty director" + (createCount == 1 ? "y" : "ies") + " under " + this.destDir.getAbsolutePath());
            }
        }
    }

    private void moveFile(File fromFile, File toFile, boolean filtering, boolean overwrite) {
        boolean moved = false;
        try {
            this.log("Attempting to rename: " + fromFile + " to " + toFile, this.verbosity);
            moved = this.renameFile(fromFile, toFile, filtering, this.forceOverwrite);
        }
        catch (IOException ioe) {
            String msg = "Failed to rename " + fromFile + " to " + toFile + " due to " + ioe.getMessage();
            throw new BuildException(msg, ioe, this.getLocation());
        }
        if (!moved) {
            this.copyFile(fromFile, toFile, filtering, overwrite);
            if (!fromFile.delete()) {
                throw new BuildException("Unable to delete file " + fromFile.getAbsolutePath());
            }
        }
    }

    private void copyFile(File fromFile, File toFile, boolean filtering, boolean overwrite) {
        try {
            this.log("Copying " + fromFile + " to " + toFile, this.verbosity);
            FilterSetCollection executionFilters = new FilterSetCollection();
            if (filtering) {
                executionFilters.addFilterSet(this.getProject().getGlobalFilterSet());
            }
            Iterator filterIter = this.getFilterSets().iterator();
            while (filterIter.hasNext()) {
                executionFilters.addFilterSet((FilterSet)filterIter.next());
            }
            this.getFileUtils().copyFile(fromFile, toFile, executionFilters, this.getFilterChains(), this.forceOverwrite, this.getPreserveLastModified(), this.getEncoding(), this.getOutputEncoding(), this.getProject());
        }
        catch (IOException ioe) {
            String msg = "Failed to copy " + fromFile + " to " + toFile + " due to " + ioe.getMessage();
            throw new BuildException(msg, ioe, this.getLocation());
        }
    }

    protected boolean okToDelete(File d2) {
        String[] list = d2.list();
        if (list == null) {
            return false;
        }
        for (int i2 = 0; i2 < list.length; ++i2) {
            String s2 = list[i2];
            File f2 = new File(d2, s2);
            if (f2.isDirectory()) {
                if (this.okToDelete(f2)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    protected void deleteDir(File d2) {
        this.deleteDir(d2, false);
    }

    protected void deleteDir(File d2, boolean deleteFiles) {
        String[] list = d2.list();
        if (list == null) {
            return;
        }
        for (int i2 = 0; i2 < list.length; ++i2) {
            String s2 = list[i2];
            File f2 = new File(d2, s2);
            if (!f2.isDirectory()) {
                if (deleteFiles && !f2.delete()) {
                    throw new BuildException("Unable to delete file " + f2.getAbsolutePath());
                }
                throw new BuildException("UNEXPECTED ERROR - The file " + f2.getAbsolutePath() + " should not exist!");
            }
            this.deleteDir(f2);
        }
        this.log("Deleting directory " + d2.getAbsolutePath(), this.verbosity);
        if (!d2.delete()) {
            throw new BuildException("Unable to delete directory " + d2.getAbsolutePath());
        }
    }

    protected boolean renameFile(File sourceFile, File destFile, boolean filtering, boolean overwrite) throws IOException, BuildException {
        if (destFile.isDirectory() || filtering || this.getFilterSets().size() > 0 || this.getFilterChains().size() > 0) {
            return false;
        }
        File parent = destFile.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        } else if (destFile.isFile()) {
            sourceFile = this.getFileUtils().normalize(sourceFile.getAbsolutePath()).getCanonicalFile();
            destFile = this.getFileUtils().normalize(destFile.getAbsolutePath());
            if (destFile.equals(sourceFile)) {
                return true;
            }
            if (!sourceFile.equals(destFile.getCanonicalFile()) && !destFile.delete()) {
                throw new BuildException("Unable to remove existing file " + destFile);
            }
        }
        return sourceFile.renameTo(destFile);
    }
}

