/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.StringUtils;

public class Replace
extends MatchingTask {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private File src = null;
    private NestedString token = null;
    private NestedString value = new NestedString();
    private File propertyFile = null;
    private File replaceFilterFile = null;
    private Properties properties = null;
    private Vector replacefilters = new Vector();
    private File dir = null;
    private int fileCount;
    private int replaceCount;
    private boolean summary = false;
    private String encoding = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        Properties savedProperties;
        Vector savedFilters = (Vector)this.replacefilters.clone();
        Properties properties = savedProperties = this.properties == null ? null : (Properties)this.properties.clone();
        if (this.token != null) {
            StringBuffer val = new StringBuffer(this.value.getText());
            this.stringReplace(val, "\r\n", "\n");
            this.stringReplace(val, "\n", StringUtils.LINE_SEP);
            StringBuffer tok = new StringBuffer(this.token.getText());
            this.stringReplace(tok, "\r\n", "\n");
            this.stringReplace(tok, "\n", StringUtils.LINE_SEP);
            Replacefilter firstFilter = this.createPrimaryfilter();
            firstFilter.setToken(tok.toString());
            firstFilter.setValue(val.toString());
        }
        try {
            if (this.replaceFilterFile != null) {
                Properties props = this.getProperties(this.replaceFilterFile);
                Enumeration<Object> e2 = props.keys();
                while (e2.hasMoreElements()) {
                    String tok = e2.nextElement().toString();
                    Replacefilter replaceFilter = this.createReplacefilter();
                    replaceFilter.setToken(tok);
                    replaceFilter.setValue(props.getProperty(tok));
                }
            }
            this.validateAttributes();
            if (this.propertyFile != null) {
                this.properties = this.getProperties(this.propertyFile);
            }
            this.validateReplacefilters();
            this.fileCount = 0;
            this.replaceCount = 0;
            if (this.src != null) {
                this.processFile(this.src);
            }
            if (this.dir != null) {
                DirectoryScanner ds2 = super.getDirectoryScanner(this.dir);
                String[] srcs = ds2.getIncludedFiles();
                for (int i2 = 0; i2 < srcs.length; ++i2) {
                    File file = new File(this.dir, srcs[i2]);
                    this.processFile(file);
                }
            }
            if (this.summary) {
                this.log("Replaced " + this.replaceCount + " occurrences in " + this.fileCount + " files.", 2);
            }
        }
        finally {
            this.replacefilters = savedFilters;
            this.properties = savedProperties;
        }
    }

    public void validateAttributes() throws BuildException {
        if (this.src == null && this.dir == null) {
            String message = "Either the file or the dir attribute must be specified";
            throw new BuildException(message, this.getLocation());
        }
        if (this.propertyFile != null && !this.propertyFile.exists()) {
            String message = "Property file " + this.propertyFile.getPath() + " does not exist.";
            throw new BuildException(message, this.getLocation());
        }
        if (this.token == null && this.replacefilters.size() == 0) {
            String message = "Either token or a nested replacefilter must be specified";
            throw new BuildException(message, this.getLocation());
        }
        if (this.token != null && "".equals(this.token.getText())) {
            String message = "The token attribute must not be an empty string.";
            throw new BuildException(message, this.getLocation());
        }
    }

    public void validateReplacefilters() throws BuildException {
        for (int i2 = 0; i2 < this.replacefilters.size(); ++i2) {
            Replacefilter element = (Replacefilter)this.replacefilters.elementAt(i2);
            element.validate();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties getProperties(File propertyFile) throws BuildException {
        Properties props = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(propertyFile);
            props.load(in);
        }
        catch (FileNotFoundException e2) {
            try {
                String message = "Property file (" + propertyFile.getPath() + ") not found.";
                throw new BuildException(message);
                catch (IOException e3) {
                    message = "Property file (" + propertyFile.getPath() + ") cannot be loaded.";
                    throw new BuildException(message);
                }
            }
            catch (Throwable throwable) {
                FileUtils.close(in);
                throw throwable;
            }
        }
        FileUtils.close(in);
        return props;
    }

    private void processFile(File src) throws BuildException {
        if (!src.exists()) {
            throw new BuildException("Replace: source file " + src.getPath() + " doesn't exist", this.getLocation());
        }
        File temp = null;
        FileInput in = null;
        FileOutput out = null;
        try {
            boolean changes;
            in = new FileInput(src);
            temp = FILE_UTILS.createTempFile("rep", ".tmp", src.getParentFile(), false, true);
            out = new FileOutput(temp);
            int repCountStart = this.replaceCount;
            this.logFilterChain(src.getPath());
            out.setInputBuffer(this.buildFilterChain(in.getOutputBuffer()));
            while (in.readChunk()) {
                if (!this.processFilterChain()) continue;
                out.process();
            }
            this.flushFilterChain();
            out.flush();
            in.close();
            in = null;
            out.close();
            out = null;
            boolean bl2 = changes = this.replaceCount != repCountStart;
            if (changes) {
                ++this.fileCount;
                FILE_UTILS.rename(temp, src);
                temp = null;
            }
        }
        catch (IOException ioe) {
            throw new BuildException("IOException in " + src + " - " + ioe.getClass().getName() + ":" + ioe.getMessage(), ioe, this.getLocation());
        }
        finally {
            if (null != in) {
                in.closeQuietly();
            }
            if (null != out) {
                out.closeQuietly();
            }
            if (temp != null && !temp.delete()) {
                temp.deleteOnExit();
            }
        }
    }

    private void flushFilterChain() {
        for (int i2 = 0; i2 < this.replacefilters.size(); ++i2) {
            Replacefilter filter = (Replacefilter)this.replacefilters.elementAt(i2);
            filter.flush();
        }
    }

    private boolean processFilterChain() {
        for (int i2 = 0; i2 < this.replacefilters.size(); ++i2) {
            Replacefilter filter = (Replacefilter)this.replacefilters.elementAt(i2);
            if (filter.process()) continue;
            return false;
        }
        return true;
    }

    private StringBuffer buildFilterChain(StringBuffer inputBuffer) {
        StringBuffer buf = inputBuffer;
        for (int i2 = 0; i2 < this.replacefilters.size(); ++i2) {
            Replacefilter filter = (Replacefilter)this.replacefilters.elementAt(i2);
            filter.setInputBuffer(buf);
            buf = filter.getOutputBuffer();
        }
        return buf;
    }

    private void logFilterChain(String filename) {
        for (int i2 = 0; i2 < this.replacefilters.size(); ++i2) {
            Replacefilter filter = (Replacefilter)this.replacefilters.elementAt(i2);
            this.log("Replacing in " + filename + ": " + filter.getToken() + " --> " + filter.getReplaceValue(), 3);
        }
    }

    public void setFile(File file) {
        this.src = file;
    }

    public void setSummary(boolean summary) {
        this.summary = summary;
    }

    public void setReplaceFilterFile(File replaceFilterFile) {
        this.replaceFilterFile = replaceFilterFile;
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void setToken(String token) {
        this.createReplaceToken().addText(token);
    }

    public void setValue(String value) {
        this.createReplaceValue().addText(value);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public NestedString createReplaceToken() {
        if (this.token == null) {
            this.token = new NestedString();
        }
        return this.token;
    }

    public NestedString createReplaceValue() {
        return this.value;
    }

    public void setPropertyFile(File propertyFile) {
        this.propertyFile = propertyFile;
    }

    public Replacefilter createReplacefilter() {
        Replacefilter filter = new Replacefilter();
        this.replacefilters.addElement(filter);
        return filter;
    }

    private Replacefilter createPrimaryfilter() {
        Replacefilter filter = new Replacefilter();
        this.replacefilters.insertElementAt(filter, 0);
        return filter;
    }

    private void stringReplace(StringBuffer str, String str1, String str2) {
        int found = str.toString().indexOf(str1);
        while (found >= 0) {
            str.replace(found, found + str1.length(), str2);
            found = str.toString().indexOf(str1, found + str2.length());
        }
    }

    private class FileOutput {
        private StringBuffer inputBuffer;
        private Writer writer;

        FileOutput(File out) throws IOException {
            this.writer = Replace.this.encoding == null ? new BufferedWriter(new FileWriter(out)) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(out), Replace.this.encoding));
        }

        void setInputBuffer(StringBuffer input) {
            this.inputBuffer = input;
        }

        boolean process() throws IOException {
            this.writer.write(this.inputBuffer.toString());
            this.inputBuffer.delete(0, this.inputBuffer.length());
            return false;
        }

        void flush() throws IOException {
            this.process();
            this.writer.flush();
        }

        void close() throws IOException {
            this.writer.close();
        }

        void closeQuietly() {
            FileUtils.close(this.writer);
        }
    }

    private class FileInput {
        private StringBuffer outputBuffer = new StringBuffer();
        private Reader reader;
        private char[] buffer = new char[4096];
        private static final int BUFF_SIZE = 4096;

        FileInput(File source) throws IOException {
            this.reader = Replace.this.encoding == null ? new BufferedReader(new FileReader(source)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source), Replace.this.encoding));
        }

        StringBuffer getOutputBuffer() {
            return this.outputBuffer;
        }

        boolean readChunk() throws IOException {
            int bufferLength = 0;
            bufferLength = this.reader.read(this.buffer);
            if (bufferLength < 0) {
                return false;
            }
            this.outputBuffer.append(new String(this.buffer, 0, bufferLength));
            return true;
        }

        void close() throws IOException {
            this.reader.close();
        }

        void closeQuietly() {
            FileUtils.close(this.reader);
        }
    }

    public class Replacefilter {
        private String token;
        private String value;
        private String replaceValue;
        private String property;
        private StringBuffer inputBuffer;
        private StringBuffer outputBuffer = new StringBuffer();

        public void validate() throws BuildException {
            if (this.token == null) {
                String message = "token is a mandatory attribute of replacefilter.";
                throw new BuildException(message);
            }
            if ("".equals(this.token)) {
                String message = "The token attribute must not be an empty string.";
                throw new BuildException(message);
            }
            if (this.value != null && this.property != null) {
                String message = "Either value or property can be specified, but a replacefilter element cannot have both.";
                throw new BuildException(message);
            }
            if (this.property != null) {
                if (Replace.this.propertyFile == null) {
                    String message = "The replacefilter's property attribute can only be used with the replacetask's propertyFile attribute.";
                    throw new BuildException(message);
                }
                if (Replace.this.properties == null || Replace.this.properties.getProperty(this.property) == null) {
                    String message = "property \"" + this.property + "\" was not found in " + Replace.this.propertyFile.getPath();
                    throw new BuildException(message);
                }
            }
            this.replaceValue = this.getReplaceValue();
        }

        public String getReplaceValue() {
            if (this.property != null) {
                return Replace.this.properties.getProperty(this.property);
            }
            if (this.value != null) {
                return this.value;
            }
            if (Replace.this.value != null) {
                return Replace.this.value.getText();
            }
            return "";
        }

        public void setToken(String token) {
            this.token = token;
        }

        public String getToken() {
            return this.token;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public String getProperty() {
            return this.property;
        }

        StringBuffer getOutputBuffer() {
            return this.outputBuffer;
        }

        void setInputBuffer(StringBuffer input) {
            this.inputBuffer = input;
        }

        boolean process() {
            if (this.inputBuffer.length() > this.token.length()) {
                int pos = this.replace();
                pos = Math.max(this.inputBuffer.length() - this.token.length(), pos);
                this.outputBuffer.append(this.inputBuffer.substring(0, pos));
                this.inputBuffer.delete(0, pos);
                return true;
            }
            return false;
        }

        void flush() {
            this.replace();
            this.outputBuffer.append(this.inputBuffer.toString());
            this.inputBuffer.delete(0, this.inputBuffer.length());
        }

        private int replace() {
            int found = this.inputBuffer.toString().indexOf(this.token);
            int pos = -1;
            while (found >= 0) {
                this.inputBuffer.replace(found, found + this.token.length(), this.replaceValue);
                pos = found + this.replaceValue.length();
                found = this.inputBuffer.toString().indexOf(this.token, pos);
                ++Replace.this.replaceCount;
            }
            return pos;
        }
    }

    public class NestedString {
        private StringBuffer buf = new StringBuffer();

        public void addText(String val) {
            this.buf.append(val);
        }

        public String getText() {
            return this.buf.toString();
        }
    }
}

