/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.ArchiveFileSet;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.ArchiveResource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.TarResource;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.MergingMapper;
import org.apache.tools.ant.util.SourceFileScanner;
import org.apache.tools.bzip2.CBZip2OutputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;

public class Tar
extends MatchingTask {
    private static final int BUFFER_SIZE = 8192;
    public static final String WARN = "warn";
    public static final String FAIL = "fail";
    public static final String TRUNCATE = "truncate";
    public static final String GNU = "gnu";
    public static final String OMIT = "omit";
    File tarFile;
    File baseDir;
    private TarLongFileMode longFileMode = new TarLongFileMode();
    Vector filesets = new Vector();
    private Vector resourceCollections = new Vector();
    Vector fileSetFiles = new Vector();
    private boolean longWarningGiven = false;
    private TarCompressionMethod compression = new TarCompressionMethod();
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$Tar;

    public TarFileSet createTarFileSet() {
        TarFileSet fs2 = new TarFileSet();
        fs2.setProject(this.getProject());
        this.filesets.addElement(fs2);
        return fs2;
    }

    public void add(ResourceCollection res) {
        this.resourceCollections.add(res);
    }

    public void setTarfile(File tarFile) {
        this.tarFile = tarFile;
    }

    public void setDestFile(File destFile) {
        this.tarFile = destFile;
    }

    public void setBasedir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setLongfile(String mode) {
        this.log("DEPRECATED - The setLongfile(String) method has been deprecated. Use setLongfile(Tar.TarLongFileMode) instead.");
        this.longFileMode = new TarLongFileMode();
        this.longFileMode.setValue(mode);
    }

    public void setLongfile(TarLongFileMode mode) {
        this.longFileMode = mode;
    }

    public void setCompression(TarCompressionMethod mode) {
        this.compression = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        if (this.tarFile == null) {
            throw new BuildException("tarfile attribute must be set!", this.getLocation());
        }
        if (this.tarFile.exists() && this.tarFile.isDirectory()) {
            throw new BuildException("tarfile is a directory!", this.getLocation());
        }
        if (this.tarFile.exists() && !this.tarFile.canWrite()) {
            throw new BuildException("Can not write to the specified tarfile!", this.getLocation());
        }
        Vector savedFileSets = (Vector)this.filesets.clone();
        try {
            if (this.baseDir != null) {
                if (!this.baseDir.exists()) {
                    throw new BuildException("basedir does not exist!", this.getLocation());
                }
                TarFileSet mainFileSet = new TarFileSet(this.fileset);
                mainFileSet.setDir(this.baseDir);
                this.filesets.addElement(mainFileSet);
            }
            if (this.filesets.size() == 0 && this.resourceCollections.size() == 0) {
                throw new BuildException("You must supply either a basedir attribute or some nested resource collections.", this.getLocation());
            }
            boolean upToDate = true;
            Enumeration e2 = this.filesets.elements();
            while (e2.hasMoreElements()) {
                upToDate &= this.check((TarFileSet)e2.nextElement());
            }
            Enumeration e3 = this.resourceCollections.elements();
            while (e3.hasMoreElements()) {
                upToDate &= this.check((ResourceCollection)e3.nextElement());
            }
            if (upToDate) {
                this.log("Nothing to do: " + this.tarFile.getAbsolutePath() + " is up to date.", 2);
                Object var9_5 = null;
                this.filesets = savedFileSets;
                return;
            }
            this.log("Building tar: " + this.tarFile.getAbsolutePath(), 2);
            TarOutputStream tOut = null;
            try {
                try {
                    tOut = new TarOutputStream(this.compression.compress(new BufferedOutputStream(new FileOutputStream(this.tarFile))));
                    tOut.setDebug(true);
                    if (this.longFileMode.isTruncateMode()) {
                        tOut.setLongFileMode(1);
                    } else if (this.longFileMode.isFailMode() || this.longFileMode.isOmitMode()) {
                        tOut.setLongFileMode(0);
                    } else {
                        tOut.setLongFileMode(2);
                    }
                    this.longWarningGiven = false;
                    Enumeration e32 = this.filesets.elements();
                    while (e32.hasMoreElements()) {
                        this.tar((TarFileSet)e32.nextElement(), tOut);
                    }
                    Enumeration e4 = this.resourceCollections.elements();
                    while (e4.hasMoreElements()) {
                        this.tar((ResourceCollection)e4.nextElement(), tOut);
                    }
                    Object var7_10 = null;
                }
                catch (IOException ioe) {
                    String msg = "Problem creating TAR: " + ioe.getMessage();
                    throw new BuildException(msg, ioe, this.getLocation());
                }
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                FileUtils.close(tOut);
                throw throwable;
            }
            FileUtils.close(tOut);
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            this.filesets = savedFileSets;
            throw throwable;
        }
        Object var9_6 = null;
        this.filesets = savedFileSets;
    }

    protected void tarFile(File file, TarOutputStream tOut, String vPath, TarFileSet tarFileSet) throws IOException {
        if (file.equals(this.tarFile)) {
            return;
        }
        this.tarResource(new FileResource(file), tOut, vPath, tarFileSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tarResource(Resource r2, TarOutputStream tOut, String vPath, TarFileSet tarFileSet) throws IOException {
        if (!r2.isExists()) {
            return;
        }
        if (tarFileSet != null) {
            String fullpath = tarFileSet.getFullpath(this.getProject());
            if (fullpath.length() > 0) {
                vPath = fullpath;
            } else {
                if (vPath.length() <= 0) {
                    return;
                }
                String prefix = tarFileSet.getPrefix(this.getProject());
                if (prefix.length() > 0 && !prefix.endsWith("/")) {
                    prefix = prefix + "/";
                }
                vPath = prefix + vPath;
            }
            if (vPath.startsWith("/") && !tarFileSet.getPreserveLeadingSlashes()) {
                int l2 = vPath.length();
                if (l2 <= 1) {
                    return;
                }
                vPath = vPath.substring(1, l2);
            }
        }
        if (r2.isDirectory() && !vPath.endsWith("/")) {
            vPath = vPath + "/";
        }
        if (vPath.length() >= 100) {
            if (this.longFileMode.isOmitMode()) {
                this.log("Omitting: " + vPath, 2);
                return;
            }
            if (this.longFileMode.isWarnMode()) {
                this.log("Entry: " + vPath + " longer than " + 100 + " characters.", 1);
                if (!this.longWarningGiven) {
                    this.log("Resulting tar file can only be processed successfully by GNU compatible tar commands", 1);
                    this.longWarningGiven = true;
                }
            } else if (this.longFileMode.isFailMode()) {
                throw new BuildException("Entry: " + vPath + " longer than " + 100 + "characters.", this.getLocation());
            }
        }
        TarEntry te = new TarEntry(vPath);
        te.setModTime(r2.getLastModified());
        if (r2 instanceof ArchiveResource) {
            ArchiveResource ar2 = (ArchiveResource)r2;
            te.setMode(ar2.getMode());
            if (r2 instanceof TarResource) {
                TarResource tr = (TarResource)r2;
                te.setUserName(tr.getUserName());
                te.setUserId(tr.getUid());
                te.setGroupName(tr.getGroup());
                te.setGroupId(tr.getGid());
            }
        }
        if (!r2.isDirectory()) {
            if ((long)r2.size() > 0x1FFFFFFFFL) {
                throw new BuildException("Resource: " + r2 + " larger than " + 0x1FFFFFFFFL + " bytes.");
            }
            te.setSize(r2.getSize());
            if (tarFileSet != null && tarFileSet.hasFileModeBeenSet()) {
                te.setMode(tarFileSet.getMode());
            }
        } else if (tarFileSet != null && tarFileSet.hasDirModeBeenSet()) {
            te.setMode(tarFileSet.getDirMode(this.getProject()));
        }
        if (tarFileSet != null) {
            if (tarFileSet.hasUserNameBeenSet()) {
                te.setUserName(tarFileSet.getUserName());
            }
            if (tarFileSet.hasGroupBeenSet()) {
                te.setGroupName(tarFileSet.getGroup());
            }
            if (tarFileSet.hasUserIdBeenSet()) {
                te.setUserId(tarFileSet.getUid());
            }
            if (tarFileSet.hasGroupIdBeenSet()) {
                te.setGroupId(tarFileSet.getGid());
            }
        }
        InputStream in = null;
        try {
            tOut.putNextEntry(te);
            if (!r2.isDirectory()) {
                in = r2.getInputStream();
                byte[] buffer = new byte[8192];
                int count = 0;
                do {
                    tOut.write(buffer, 0, count);
                } while ((count = in.read(buffer, 0, buffer.length)) != -1);
            }
            tOut.closeEntry();
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            FileUtils.close(in);
            throw throwable;
        }
        FileUtils.close(in);
    }

    protected boolean archiveIsUpToDate(String[] files) {
        return this.archiveIsUpToDate(files, this.baseDir);
    }

    protected boolean archiveIsUpToDate(String[] files, File dir) {
        SourceFileScanner sfs = new SourceFileScanner(this);
        MergingMapper mm = new MergingMapper();
        mm.setTo(this.tarFile.getAbsolutePath());
        return sfs.restrict(files, dir, null, mm).length == 0;
    }

    protected boolean archiveIsUpToDate(Resource r2) {
        return SelectorUtils.isOutOfDate((Resource)new FileResource(this.tarFile), r2, FileUtils.getFileUtils().getFileTimestampGranularity());
    }

    protected boolean supportsNonFileResources() {
        return this.getClass().equals(class$org$apache$tools$ant$taskdefs$Tar == null ? (class$org$apache$tools$ant$taskdefs$Tar = Tar.class$("org.apache.tools.ant.taskdefs.Tar")) : class$org$apache$tools$ant$taskdefs$Tar);
    }

    protected boolean check(ResourceCollection rc) {
        boolean upToDate = true;
        if (Tar.isFileFileSet(rc)) {
            FileSet fs2 = (FileSet)rc;
            upToDate = this.check(fs2.getDir(this.getProject()), Tar.getFileNames(fs2));
        } else {
            if (!rc.isFilesystemOnly() && !this.supportsNonFileResources()) {
                throw new BuildException("only filesystem resources are supported");
            }
            if (rc.isFilesystemOnly()) {
                String[] files;
                HashSet<File> basedirs = new HashSet<File>();
                HashMap basedirToFilesMap = new HashMap();
                Iterator iter = rc.iterator();
                while (iter.hasNext()) {
                    FileResource r2 = (FileResource)iter.next();
                    File base = r2.getBaseDir();
                    if (base == null) {
                        base = Copy.NULL_FILE_PLACEHOLDER;
                    }
                    basedirs.add(base);
                    files = (String[])basedirToFilesMap.get(base);
                    if (files == null) {
                        files = new Vector();
                        basedirToFilesMap.put(base, new Vector());
                    }
                    files.add(r2.getName());
                }
                iter = basedirs.iterator();
                while (iter.hasNext()) {
                    File base = (File)iter.next();
                    Vector f2 = (Vector)basedirToFilesMap.get(base);
                    files = f2.toArray(new String[f2.size()]);
                    upToDate &= this.check(base == Copy.NULL_FILE_PLACEHOLDER ? null : base, files);
                }
            } else {
                Iterator iter = rc.iterator();
                while (upToDate && iter.hasNext()) {
                    Resource r3 = (Resource)iter.next();
                    upToDate = this.archiveIsUpToDate(r3);
                }
            }
        }
        return upToDate;
    }

    protected boolean check(File basedir, String[] files) {
        boolean upToDate = true;
        if (!this.archiveIsUpToDate(files, basedir)) {
            upToDate = false;
        }
        for (int i2 = 0; i2 < files.length; ++i2) {
            if (!this.tarFile.equals(new File(basedir, files[i2]))) continue;
            throw new BuildException("A tar file cannot include itself", this.getLocation());
        }
        return upToDate;
    }

    protected void tar(ResourceCollection rc, TarOutputStream tOut) throws IOException {
        ArchiveFileSet afs = null;
        if (rc instanceof ArchiveFileSet) {
            afs = (ArchiveFileSet)rc;
        }
        if (afs != null && afs.size() > 1 && afs.getFullpath(this.getProject()).length() > 0) {
            throw new BuildException("fullpath attribute may only be specified for filesets that specify a single file.");
        }
        TarFileSet tfs = this.asTarFileSet(afs);
        if (Tar.isFileFileSet(rc)) {
            FileSet fs2 = (FileSet)rc;
            String[] files = Tar.getFileNames(fs2);
            for (int i2 = 0; i2 < files.length; ++i2) {
                File f2 = new File(fs2.getDir(this.getProject()), files[i2]);
                String name = files[i2].replace(File.separatorChar, '/');
                this.tarFile(f2, tOut, name, tfs);
            }
        } else if (rc.isFilesystemOnly()) {
            Iterator iter = rc.iterator();
            while (iter.hasNext()) {
                FileResource r2 = (FileResource)iter.next();
                File f3 = r2.getFile();
                if (f3 == null) {
                    f3 = new File(r2.getBaseDir(), r2.getName());
                }
                this.tarFile(f3, tOut, f3.getName(), tfs);
            }
        } else {
            Iterator iter = rc.iterator();
            while (iter.hasNext()) {
                Resource r3 = (Resource)iter.next();
                this.tarResource(r3, tOut, r3.getName(), tfs);
            }
        }
    }

    protected static final boolean isFileFileSet(ResourceCollection rc) {
        return rc instanceof FileSet && rc.isFilesystemOnly();
    }

    protected static final String[] getFileNames(FileSet fs2) {
        DirectoryScanner ds2 = fs2.getDirectoryScanner(fs2.getProject());
        String[] directories = ds2.getIncludedDirectories();
        String[] filesPerSe = ds2.getIncludedFiles();
        String[] files = new String[directories.length + filesPerSe.length];
        System.arraycopy(directories, 0, files, 0, directories.length);
        System.arraycopy(filesPerSe, 0, files, directories.length, filesPerSe.length);
        return files;
    }

    protected TarFileSet asTarFileSet(ArchiveFileSet archiveFileSet) {
        TarFileSet tfs = null;
        if (archiveFileSet != null && archiveFileSet instanceof TarFileSet) {
            tfs = (TarFileSet)archiveFileSet;
        } else {
            tfs = new TarFileSet();
            tfs.setProject(this.getProject());
            if (archiveFileSet != null) {
                tfs.setPrefix(archiveFileSet.getPrefix(this.getProject()));
                tfs.setFullpath(archiveFileSet.getFullpath(this.getProject()));
                if (archiveFileSet.hasFileModeBeenSet()) {
                    tfs.integerSetFileMode(archiveFileSet.getFileMode(this.getProject()));
                }
                if (archiveFileSet.hasDirModeBeenSet()) {
                    tfs.integerSetDirMode(archiveFileSet.getDirMode(this.getProject()));
                }
                if (archiveFileSet instanceof org.apache.tools.ant.types.TarFileSet) {
                    org.apache.tools.ant.types.TarFileSet t2 = (org.apache.tools.ant.types.TarFileSet)archiveFileSet;
                    if (t2.hasUserNameBeenSet()) {
                        tfs.setUserName(t2.getUserName());
                    }
                    if (t2.hasGroupBeenSet()) {
                        tfs.setGroup(t2.getGroup());
                    }
                    if (t2.hasUserIdBeenSet()) {
                        tfs.setUid(t2.getUid());
                    }
                    if (t2.hasGroupIdBeenSet()) {
                        tfs.setGid(t2.getGid());
                    }
                }
            }
        }
        return tfs;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class TarCompressionMethod
    extends EnumeratedAttribute {
        private static final String NONE = "none";
        private static final String GZIP = "gzip";
        private static final String BZIP2 = "bzip2";

        public TarCompressionMethod() {
            this.setValue(NONE);
        }

        public String[] getValues() {
            return new String[]{NONE, GZIP, BZIP2};
        }

        private OutputStream compress(OutputStream ostream) throws IOException {
            String v2 = this.getValue();
            if (GZIP.equals(v2)) {
                return new GZIPOutputStream(ostream);
            }
            if (BZIP2.equals(v2)) {
                ostream.write(66);
                ostream.write(90);
                return new CBZip2OutputStream(ostream);
            }
            return ostream;
        }
    }

    public static class TarLongFileMode
    extends EnumeratedAttribute {
        public static final String WARN = "warn";
        public static final String FAIL = "fail";
        public static final String TRUNCATE = "truncate";
        public static final String GNU = "gnu";
        public static final String OMIT = "omit";
        private final String[] validModes = new String[]{"warn", "fail", "truncate", "gnu", "omit"};

        public TarLongFileMode() {
            this.setValue("warn");
        }

        public String[] getValues() {
            return this.validModes;
        }

        public boolean isTruncateMode() {
            return "truncate".equalsIgnoreCase(this.getValue());
        }

        public boolean isWarnMode() {
            return "warn".equalsIgnoreCase(this.getValue());
        }

        public boolean isGnuMode() {
            return "gnu".equalsIgnoreCase(this.getValue());
        }

        public boolean isFailMode() {
            return "fail".equalsIgnoreCase(this.getValue());
        }

        public boolean isOmitMode() {
            return "omit".equalsIgnoreCase(this.getValue());
        }
    }

    public static class TarFileSet
    extends org.apache.tools.ant.types.TarFileSet {
        private String[] files = null;
        private boolean preserveLeadingSlashes = false;

        public TarFileSet(FileSet fileset) {
            super(fileset);
        }

        public TarFileSet() {
        }

        public String[] getFiles(Project p2) {
            if (this.files == null) {
                this.files = Tar.getFileNames(this);
            }
            return this.files;
        }

        public void setMode(String octalString) {
            this.setFileMode(octalString);
        }

        public int getMode() {
            return this.getFileMode(this.getProject());
        }

        public void setPreserveLeadingSlashes(boolean b2) {
            this.preserveLeadingSlashes = b2;
        }

        public boolean getPreserveLeadingSlashes() {
            return this.preserveLeadingSlashes;
        }
    }
}

