/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class Tstamp
extends Task {
    private Vector customFormats = new Vector();
    private String prefix = "";

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        if (!this.prefix.endsWith(".")) {
            this.prefix = this.prefix + ".";
        }
    }

    public void execute() throws BuildException {
        try {
            Date d2 = new Date();
            Enumeration i2 = this.customFormats.elements();
            while (i2.hasMoreElements()) {
                CustomFormat cts = (CustomFormat)i2.nextElement();
                cts.execute(this.getProject(), d2, this.getLocation());
            }
            SimpleDateFormat dstamp = new SimpleDateFormat("yyyyMMdd");
            this.setProperty("DSTAMP", dstamp.format(d2));
            SimpleDateFormat tstamp = new SimpleDateFormat("HHmm");
            this.setProperty("TSTAMP", tstamp.format(d2));
            SimpleDateFormat today = new SimpleDateFormat("MMMM d yyyy", Locale.US);
            this.setProperty("TODAY", today.format(d2));
        }
        catch (Exception e2) {
            throw new BuildException(e2);
        }
    }

    public CustomFormat createFormat() {
        CustomFormat cts = new CustomFormat();
        this.customFormats.addElement(cts);
        return cts;
    }

    private void setProperty(String name, String value) {
        this.getProject().setNewProperty(this.prefix + name, value);
    }

    public static class Unit
    extends EnumeratedAttribute {
        private static final String MILLISECOND = "millisecond";
        private static final String SECOND = "second";
        private static final String MINUTE = "minute";
        private static final String HOUR = "hour";
        private static final String DAY = "day";
        private static final String WEEK = "week";
        private static final String MONTH = "month";
        private static final String YEAR = "year";
        private static final String[] UNITS = new String[]{"millisecond", "second", "minute", "hour", "day", "week", "month", "year"};
        private Map calendarFields = new HashMap();

        public Unit() {
            this.calendarFields.put(MILLISECOND, new Integer(14));
            this.calendarFields.put(SECOND, new Integer(13));
            this.calendarFields.put(MINUTE, new Integer(12));
            this.calendarFields.put(HOUR, new Integer(11));
            this.calendarFields.put(DAY, new Integer(5));
            this.calendarFields.put(WEEK, new Integer(3));
            this.calendarFields.put(MONTH, new Integer(2));
            this.calendarFields.put(YEAR, new Integer(1));
        }

        public int getCalendarField() {
            String key = this.getValue().toLowerCase();
            Integer i2 = (Integer)this.calendarFields.get(key);
            return i2;
        }

        public String[] getValues() {
            return UNITS;
        }
    }

    public class CustomFormat {
        private TimeZone timeZone;
        private String propertyName;
        private String pattern;
        private String language;
        private String country;
        private String variant;
        private int offset = 0;
        private int field = 5;

        public void setProperty(String propertyName) {
            this.propertyName = propertyName;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public void setLocale(String locale) {
            StringTokenizer st = new StringTokenizer(locale, " \t\n\r\f,");
            try {
                this.language = st.nextToken();
                if (st.hasMoreElements()) {
                    this.country = st.nextToken();
                    if (st.hasMoreElements()) {
                        this.variant = st.nextToken();
                        if (st.hasMoreElements()) {
                            throw new BuildException("bad locale format", Tstamp.this.getLocation());
                        }
                    }
                } else {
                    this.country = "";
                }
            }
            catch (NoSuchElementException e2) {
                throw new BuildException("bad locale format", e2, Tstamp.this.getLocation());
            }
        }

        public void setTimezone(String id) {
            this.timeZone = TimeZone.getTimeZone(id);
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public void setUnit(String unit) {
            Tstamp.this.log("DEPRECATED - The setUnit(String) method has been deprecated. Use setUnit(Tstamp.Unit) instead.");
            Unit u2 = new Unit();
            u2.setValue(unit);
            this.field = u2.getCalendarField();
        }

        public void setUnit(Unit unit) {
            this.field = unit.getCalendarField();
        }

        public void execute(Project project, Date date, Location location) {
            if (this.propertyName == null) {
                throw new BuildException("property attribute must be provided", location);
            }
            if (this.pattern == null) {
                throw new BuildException("pattern attribute must be provided", location);
            }
            SimpleDateFormat sdf = this.language == null ? new SimpleDateFormat(this.pattern) : (this.variant == null ? new SimpleDateFormat(this.pattern, new Locale(this.language, this.country)) : new SimpleDateFormat(this.pattern, new Locale(this.language, this.country, this.variant)));
            if (this.offset != 0) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.add(this.field, this.offset);
                date = calendar.getTime();
            }
            if (this.timeZone != null) {
                sdf.setTimeZone(this.timeZone);
            }
            Tstamp.this.setProperty(this.propertyName, sdf.format(date));
        }
    }
}

