/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import java.util.zip.CRC32;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.ArchiveFileSet;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.types.ZipScanner;
import org.apache.tools.ant.types.resources.ArchiveResource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.IdentityMapper;
import org.apache.tools.ant.util.MergingMapper;
import org.apache.tools.ant.util.ResourceUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipExtraField;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public class Zip
extends MatchingTask {
    private static final int BUFFER_SIZE = 8192;
    private static final int ROUNDUP_MILLIS = 1999;
    protected File zipFile;
    private ZipScanner zs;
    private File baseDir;
    protected Hashtable entries = new Hashtable();
    private Vector groupfilesets = new Vector();
    private Vector filesetsFromGroupfilesets = new Vector();
    protected String duplicate = "add";
    private boolean doCompress = true;
    private boolean doUpdate = false;
    private boolean savedDoUpdate = false;
    private boolean doFilesonly = false;
    protected String archiveType = "zip";
    private static final long EMPTY_CRC = new CRC32().getValue();
    protected String emptyBehavior = "skip";
    private Vector resources = new Vector();
    protected Hashtable addedDirs = new Hashtable();
    private Vector addedFiles = new Vector();
    protected boolean doubleFilePass = false;
    protected boolean skipWriting = false;
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private boolean updatedFile = false;
    private boolean addingNewFiles = false;
    private String encoding;
    private boolean keepCompression = false;
    private boolean roundUp = true;
    private String comment = "";
    private int level = -1;

    public void setZipfile(File zipFile) {
        this.setDestFile(zipFile);
    }

    public void setFile(File file) {
        this.setDestFile(file);
    }

    public void setDestFile(File destFile) {
        this.zipFile = destFile;
    }

    public File getDestFile() {
        return this.zipFile;
    }

    public void setBasedir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setCompress(boolean c2) {
        this.doCompress = c2;
    }

    public boolean isCompress() {
        return this.doCompress;
    }

    public void setFilesonly(boolean f2) {
        this.doFilesonly = f2;
    }

    public void setUpdate(boolean c2) {
        this.doUpdate = c2;
        this.savedDoUpdate = c2;
    }

    public boolean isInUpdateMode() {
        return this.doUpdate;
    }

    public void addFileset(FileSet set) {
        this.add(set);
    }

    public void addZipfileset(ZipFileSet set) {
        this.add(set);
    }

    public void add(ResourceCollection a2) {
        this.resources.add(a2);
    }

    public void addZipGroupFileset(FileSet set) {
        this.groupfilesets.addElement(set);
    }

    public void setDuplicate(Duplicate df2) {
        this.duplicate = df2.getValue();
    }

    public void setWhenempty(WhenEmpty we) {
        this.emptyBehavior = we.getValue();
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setKeepCompression(boolean keep) {
        this.keepCompression = keep;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public void setRoundUp(boolean r2) {
        this.roundUp = r2;
    }

    public void execute() throws BuildException {
        if (this.doubleFilePass) {
            this.skipWriting = true;
            this.executeMain();
            this.skipWriting = false;
            this.executeMain();
        } else {
            this.executeMain();
        }
    }

    protected boolean hasUpdatedFile() {
        return this.updatedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeMain() throws BuildException {
        this.checkAttributesAndElements();
        File renamedFile = null;
        this.addingNewFiles = true;
        this.processDoUpdate();
        this.processGroupFilesets();
        Vector<ResourceCollection> vfss = new Vector<ResourceCollection>();
        if (this.baseDir != null) {
            FileSet fs2 = (FileSet)this.getImplicitFileSet().clone();
            fs2.setDir(this.baseDir);
            vfss.addElement(fs2);
        }
        for (int i2 = 0; i2 < this.resources.size(); ++i2) {
            ResourceCollection rc = (ResourceCollection)this.resources.elementAt(i2);
            vfss.addElement(rc);
        }
        Object[] fss = new ResourceCollection[vfss.size()];
        vfss.copyInto(fss);
        boolean success = false;
        try {
            ArchiveState state = this.getResourcesToAdd((ResourceCollection[])fss, this.zipFile, false);
            if (!state.isOutOfDate()) {
                return;
            }
            this.updatedFile = true;
            if (!this.zipFile.exists() && state.isWithoutAnyResources()) {
                this.createEmptyZip(this.zipFile);
                return;
            }
            Resource[][] addThem = state.getResourcesToAdd();
            if (this.doUpdate) {
                renamedFile = this.renameFile();
            }
            String action = this.doUpdate ? "Updating " : "Building ";
            this.log(action + this.archiveType + ": " + this.zipFile.getAbsolutePath());
            ZipOutputStream zOut = null;
            try {
                if (!this.skipWriting) {
                    zOut = new ZipOutputStream(this.zipFile);
                    zOut.setEncoding(this.encoding);
                    zOut.setMethod(this.doCompress ? 8 : 0);
                    zOut.setLevel(this.level);
                }
                this.initZipOutputStream(zOut);
                for (int i3 = 0; i3 < fss.length; ++i3) {
                    if (addThem[i3].length == 0) continue;
                    this.addResources((ResourceCollection)fss[i3], addThem[i3], zOut);
                }
                if (this.doUpdate) {
                    this.addingNewFiles = false;
                    ZipFileSet oldFiles = new ZipFileSet();
                    oldFiles.setProject(this.getProject());
                    oldFiles.setSrc(renamedFile);
                    oldFiles.setDefaultexcludes(false);
                    for (int i4 = 0; i4 < this.addedFiles.size(); ++i4) {
                        PatternSet.NameEntry ne = oldFiles.createExclude();
                        ne.setName((String)this.addedFiles.elementAt(i4));
                    }
                    DirectoryScanner ds2 = oldFiles.getDirectoryScanner(this.getProject());
                    ((ZipScanner)ds2).setEncoding(this.encoding);
                    String[] f2 = ds2.getIncludedFiles();
                    Resource[] r2 = new Resource[f2.length];
                    for (int i5 = 0; i5 < f2.length; ++i5) {
                        r2[i5] = ds2.getResource(f2[i5]);
                    }
                    if (!this.doFilesonly) {
                        String[] d2 = ds2.getIncludedDirectories();
                        Resource[] dr2 = new Resource[d2.length];
                        for (int i6 = 0; i6 < d2.length; ++i6) {
                            dr2[i6] = ds2.getResource(d2[i6]);
                        }
                        Resource[] tmp = r2;
                        r2 = new Resource[tmp.length + dr2.length];
                        System.arraycopy(dr2, 0, r2, 0, dr2.length);
                        System.arraycopy(tmp, 0, r2, dr2.length, tmp.length);
                    }
                    this.addResources(oldFiles, r2, zOut);
                }
                if (zOut != null) {
                    zOut.setComment(this.comment);
                }
                this.finalizeZipOutputStream(zOut);
                if (this.doUpdate && !renamedFile.delete()) {
                    this.log("Warning: unable to delete temporary file " + renamedFile.getName(), 1);
                }
                success = true;
            }
            catch (Throwable throwable) {
                this.closeZout(zOut, success);
                throw throwable;
            }
            this.closeZout(zOut, success);
        }
        catch (IOException ioe) {
            String msg = "Problem creating " + this.archiveType + ": " + ioe.getMessage();
            if (!(this.doUpdate && renamedFile == null || this.zipFile.delete())) {
                msg = msg + " (and the archive is probably corrupt but I could not delete it)";
            }
            if (this.doUpdate && renamedFile != null) {
                try {
                    FILE_UTILS.rename(renamedFile, this.zipFile);
                }
                catch (IOException e2) {
                    msg = msg + " (and I couldn't rename the temporary file " + renamedFile.getName() + " back)";
                }
            }
            throw new BuildException(msg, ioe, this.getLocation());
        }
        finally {
            this.cleanUp();
        }
    }

    private File renameFile() {
        File renamedFile = FILE_UTILS.createTempFile("zip", ".tmp", this.zipFile.getParentFile(), true, true);
        try {
            FILE_UTILS.rename(this.zipFile, renamedFile);
        }
        catch (SecurityException e2) {
            throw new BuildException("Not allowed to rename old file (" + this.zipFile.getAbsolutePath() + ") to temporary file");
        }
        catch (IOException e3) {
            throw new BuildException("Unable to rename old file (" + this.zipFile.getAbsolutePath() + ") to temporary file");
        }
        return renamedFile;
    }

    private void closeZout(ZipOutputStream zOut, boolean success) throws IOException {
        block3: {
            if (zOut == null) {
                return;
            }
            try {
                zOut.close();
            }
            catch (IOException ex2) {
                if (!success) break block3;
                throw ex2;
            }
        }
    }

    private void checkAttributesAndElements() {
        if (this.baseDir == null && this.resources.size() == 0 && this.groupfilesets.size() == 0 && "zip".equals(this.archiveType)) {
            throw new BuildException("basedir attribute must be set, or at least one resource collection must be given!");
        }
        if (this.zipFile == null) {
            throw new BuildException("You must specify the " + this.archiveType + " file to create!");
        }
        if (this.zipFile.exists() && !this.zipFile.isFile()) {
            throw new BuildException(this.zipFile + " is not a file.");
        }
        if (this.zipFile.exists() && !this.zipFile.canWrite()) {
            throw new BuildException(this.zipFile + " is read-only.");
        }
    }

    private void processDoUpdate() {
        if (this.doUpdate && !this.zipFile.exists()) {
            this.doUpdate = false;
            this.log("ignoring update attribute as " + this.archiveType + " doesn't exist.", 4);
        }
    }

    private void processGroupFilesets() {
        for (int i2 = 0; i2 < this.groupfilesets.size(); ++i2) {
            this.log("Processing groupfileset ", 3);
            FileSet fs2 = (FileSet)this.groupfilesets.elementAt(i2);
            DirectoryScanner scanner = fs2.getDirectoryScanner(this.getProject());
            String[] files = scanner.getIncludedFiles();
            File basedir = scanner.getBasedir();
            for (int j2 = 0; j2 < files.length; ++j2) {
                this.log("Adding file " + files[j2] + " to fileset", 3);
                ZipFileSet zf = new ZipFileSet();
                zf.setProject(this.getProject());
                zf.setSrc(new File(basedir, files[j2]));
                this.add(zf);
                this.filesetsFromGroupfilesets.addElement(zf);
            }
        }
    }

    protected final boolean isAddingNewFiles() {
        return this.addingNewFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addResources(FileSet fileset, Resource[] resources, ZipOutputStream zOut) throws IOException {
        String prefix = "";
        String fullpath = "";
        int dirMode = 16877;
        int fileMode = 33188;
        ArchiveFileSet zfs = null;
        if (fileset instanceof ArchiveFileSet) {
            zfs = (ArchiveFileSet)fileset;
            prefix = zfs.getPrefix(this.getProject());
            fullpath = zfs.getFullpath(this.getProject());
            dirMode = zfs.getDirMode(this.getProject());
            fileMode = zfs.getFileMode(this.getProject());
        }
        if (prefix.length() > 0 && fullpath.length() > 0) {
            throw new BuildException("Both prefix and fullpath attributes must not be set on the same fileset.");
        }
        if (resources.length != 1 && fullpath.length() > 0) {
            throw new BuildException("fullpath attribute may only be specified for filesets that specify a single file.");
        }
        if (prefix.length() > 0) {
            if (!prefix.endsWith("/") && !prefix.endsWith("\\")) {
                prefix = prefix + "/";
            }
            this.addParentDirs(null, prefix, zOut, "", dirMode);
        }
        ZipFile zf = null;
        try {
            boolean dealingWithFiles = false;
            File base = null;
            if (zfs == null || zfs.getSrc(this.getProject()) == null) {
                dealingWithFiles = true;
                base = fileset.getDir(this.getProject());
            } else if (zfs instanceof ZipFileSet) {
                zf = new ZipFile(zfs.getSrc(this.getProject()), this.encoding);
            }
            for (int i2 = 0; i2 < resources.length; ++i2) {
                String name = null;
                name = fullpath.length() > 0 ? fullpath : resources[i2].getName();
                if ("".equals(name = name.replace(File.separatorChar, '/'))) continue;
                if (resources[i2].isDirectory() && !name.endsWith("/")) {
                    name = name + "/";
                }
                if (!this.doFilesonly && !dealingWithFiles && resources[i2].isDirectory() && !zfs.hasDirModeBeenSet()) {
                    int nextToLastSlash = name.lastIndexOf("/", name.length() - 2);
                    if (nextToLastSlash != -1) {
                        this.addParentDirs(base, name.substring(0, nextToLastSlash + 1), zOut, prefix, dirMode);
                    }
                    if (zf != null) {
                        ZipEntry ze = zf.getEntry(resources[i2].getName());
                        this.addParentDirs(base, name, zOut, prefix, ze.getUnixMode());
                    } else {
                        ArchiveResource tr = (ArchiveResource)resources[i2];
                        this.addParentDirs(base, name, zOut, prefix, tr.getMode());
                    }
                } else {
                    this.addParentDirs(base, name, zOut, prefix, dirMode);
                }
                if (!resources[i2].isDirectory() && dealingWithFiles) {
                    File f2 = FILE_UTILS.resolveFile(base, resources[i2].getName());
                    this.zipFile(f2, zOut, prefix + name, fileMode);
                    continue;
                }
                if (resources[i2].isDirectory()) continue;
                if (zf != null) {
                    ZipEntry ze = zf.getEntry(resources[i2].getName());
                    if (ze == null) continue;
                    boolean oldCompress = this.doCompress;
                    if (this.keepCompression) {
                        this.doCompress = ze.getMethod() == 8;
                    }
                    InputStream is = null;
                    try {
                        is = zf.getInputStream(ze);
                        this.zipFile(is, zOut, prefix + name, ze.getTime(), zfs.getSrc(this.getProject()), zfs.hasFileModeBeenSet() ? fileMode : ze.getUnixMode());
                        continue;
                    }
                    finally {
                        this.doCompress = oldCompress;
                        FileUtils.close(is);
                    }
                }
                ArchiveResource tr = (ArchiveResource)resources[i2];
                InputStream is = null;
                try {
                    is = tr.getInputStream();
                    this.zipFile(is, zOut, prefix + name, resources[i2].getLastModified(), zfs.getSrc(this.getProject()), zfs.hasFileModeBeenSet() ? fileMode : tr.getMode());
                    continue;
                }
                finally {
                    FileUtils.close(is);
                }
            }
        }
        finally {
            if (zf != null) {
                zf.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addResources(ResourceCollection rc, Resource[] resources, ZipOutputStream zOut) throws IOException {
        if (rc instanceof FileSet) {
            this.addResources((FileSet)rc, resources, zOut);
            return;
        }
        for (int i2 = 0; i2 < resources.length; ++i2) {
            String name = resources[i2].getName().replace(File.separatorChar, '/');
            if ("".equals(name) || resources[i2].isDirectory() && this.doFilesonly) continue;
            File base = null;
            if (resources[i2] instanceof FileResource) {
                base = ((FileResource)resources[i2]).getBaseDir();
            }
            if (resources[i2].isDirectory() && !name.endsWith("/")) {
                name = name + "/";
            }
            this.addParentDirs(base, name, zOut, "", 16877);
            if (resources[i2].isDirectory()) continue;
            if (resources[i2] instanceof FileResource) {
                File f2 = ((FileResource)resources[i2]).getFile();
                this.zipFile(f2, zOut, name, 33188);
                continue;
            }
            InputStream is = null;
            try {
                is = resources[i2].getInputStream();
                this.zipFile(is, zOut, name, resources[i2].getLastModified(), null, 33188);
            }
            catch (Throwable throwable) {
                FileUtils.close(is);
                throw throwable;
            }
            FileUtils.close(is);
        }
    }

    protected void initZipOutputStream(ZipOutputStream zOut) throws IOException, BuildException {
    }

    protected void finalizeZipOutputStream(ZipOutputStream zOut) throws IOException, BuildException {
    }

    protected boolean createEmptyZip(File zipFile) throws BuildException {
        this.log("Note: creating empty " + this.archiveType + " archive " + zipFile, 2);
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(zipFile);
            byte[] empty = new byte[22];
            empty[0] = 80;
            empty[1] = 75;
            empty[2] = 5;
            empty[3] = 6;
            ((OutputStream)os).write(empty);
        }
        catch (IOException ioe) {
            try {
                throw new BuildException("Could not create empty ZIP archive (" + ioe.getMessage() + ")", ioe, this.getLocation());
            }
            catch (Throwable throwable) {
                FileUtils.close(os);
                throw throwable;
            }
        }
        FileUtils.close(os);
        return true;
    }

    private synchronized ZipScanner getZipScanner() {
        if (this.zs == null) {
            this.zs = new ZipScanner();
            this.zs.setEncoding(this.encoding);
            this.zs.setSrc(this.zipFile);
        }
        return this.zs;
    }

    protected ArchiveState getResourcesToAdd(ResourceCollection[] rcs, File zipFile, boolean needsUpdate) throws BuildException {
        ArrayList<ResourceCollection> filesets = new ArrayList<ResourceCollection>();
        ArrayList<ResourceCollection> rest = new ArrayList<ResourceCollection>();
        for (int i2 = 0; i2 < rcs.length; ++i2) {
            if (rcs[i2] instanceof FileSet) {
                filesets.add(rcs[i2]);
                continue;
            }
            rest.add(rcs[i2]);
        }
        ResourceCollection[] rc = rest.toArray(new ResourceCollection[rest.size()]);
        ArchiveState as2 = this.getNonFileSetResourcesToAdd(rc, zipFile, needsUpdate);
        FileSet[] fs2 = filesets.toArray(new FileSet[filesets.size()]);
        ArchiveState as22 = this.getResourcesToAdd(fs2, zipFile, as2.isOutOfDate());
        if (!as2.isOutOfDate() && as22.isOutOfDate()) {
            as2 = this.getNonFileSetResourcesToAdd(rc, zipFile, true);
        }
        Resource[][] toAdd = new Resource[rcs.length][];
        int fsIndex = 0;
        int restIndex = 0;
        for (int i3 = 0; i3 < rcs.length; ++i3) {
            toAdd[i3] = rcs[i3] instanceof FileSet ? as22.getResourcesToAdd()[fsIndex++] : as2.getResourcesToAdd()[restIndex++];
        }
        return new ArchiveState(as22.isOutOfDate(), toAdd);
    }

    protected ArchiveState getResourcesToAdd(FileSet[] filesets, File zipFile, boolean needsUpdate) throws BuildException {
        int i2;
        Resource[][] initialResources = this.grabResources(filesets);
        if (Zip.isEmpty(initialResources)) {
            if (needsUpdate && this.doUpdate) {
                return new ArchiveState(true, initialResources);
            }
            if (this.emptyBehavior.equals("skip")) {
                if (this.doUpdate) {
                    this.log(this.archiveType + " archive " + zipFile + " not updated because no new files were included.", 3);
                } else {
                    this.log("Warning: skipping " + this.archiveType + " archive " + zipFile + " because no files were included.", 1);
                }
            } else {
                if (this.emptyBehavior.equals("fail")) {
                    throw new BuildException("Cannot create " + this.archiveType + " archive " + zipFile + ": no files were included.", this.getLocation());
                }
                if (!zipFile.exists()) {
                    needsUpdate = true;
                }
            }
            return new ArchiveState(needsUpdate, initialResources);
        }
        if (!zipFile.exists()) {
            return new ArchiveState(true, initialResources);
        }
        if (needsUpdate && !this.doUpdate) {
            return new ArchiveState(true, initialResources);
        }
        Resource[][] newerResources = new Resource[filesets.length][];
        for (i2 = 0; i2 < filesets.length; ++i2) {
            if (this.fileset instanceof ZipFileSet && ((ZipFileSet)this.fileset).getSrc(this.getProject()) != null) continue;
            File base = filesets[i2].getDir(this.getProject());
            for (int j2 = 0; j2 < initialResources[i2].length; ++j2) {
                File resourceAsFile = FILE_UTILS.resolveFile(base, initialResources[i2][j2].getName());
                if (!resourceAsFile.equals(zipFile)) continue;
                throw new BuildException("A zip file cannot include itself", this.getLocation());
            }
        }
        for (i2 = 0; i2 < filesets.length; ++i2) {
            if (initialResources[i2].length == 0) {
                newerResources[i2] = new Resource[0];
                continue;
            }
            FileNameMapper myMapper = new IdentityMapper();
            if (filesets[i2] instanceof ZipFileSet) {
                ZipFileSet zfs = (ZipFileSet)filesets[i2];
                if (zfs.getFullpath(this.getProject()) != null && !zfs.getFullpath(this.getProject()).equals("")) {
                    MergingMapper fm2 = new MergingMapper();
                    fm2.setTo(zfs.getFullpath(this.getProject()));
                    myMapper = fm2;
                } else if (zfs.getPrefix(this.getProject()) != null && !zfs.getPrefix(this.getProject()).equals("")) {
                    GlobPatternMapper gm2 = new GlobPatternMapper();
                    gm2.setFrom("*");
                    String prefix = zfs.getPrefix(this.getProject());
                    if (!prefix.endsWith("/") && !prefix.endsWith("\\")) {
                        prefix = prefix + "/";
                    }
                    gm2.setTo(prefix + "*");
                    myMapper = gm2;
                }
            }
            Resource[] resources = initialResources[i2];
            if (this.doFilesonly) {
                resources = this.selectFileResources(resources);
            }
            newerResources[i2] = ResourceUtils.selectOutOfDateSources(this, resources, myMapper, this.getZipScanner());
            boolean bl2 = needsUpdate = needsUpdate || newerResources[i2].length > 0;
            if (needsUpdate && !this.doUpdate) break;
        }
        if (needsUpdate && !this.doUpdate) {
            return new ArchiveState(true, initialResources);
        }
        return new ArchiveState(needsUpdate, newerResources);
    }

    protected ArchiveState getNonFileSetResourcesToAdd(ResourceCollection[] rcs, File zipFile, boolean needsUpdate) throws BuildException {
        Resource[][] initialResources = this.grabNonFileSetResources(rcs);
        if (Zip.isEmpty(initialResources)) {
            return new ArchiveState(needsUpdate, initialResources);
        }
        if (!zipFile.exists()) {
            return new ArchiveState(true, initialResources);
        }
        if (needsUpdate && !this.doUpdate) {
            return new ArchiveState(true, initialResources);
        }
        Resource[][] newerResources = new Resource[rcs.length][];
        for (int i2 = 0; i2 < rcs.length; ++i2) {
            if (initialResources[i2].length == 0) {
                newerResources[i2] = new Resource[0];
                continue;
            }
            for (int j2 = 0; j2 < initialResources[i2].length; ++j2) {
                if (!(initialResources[i2][j2] instanceof FileResource) || !zipFile.equals(((FileResource)initialResources[i2][j2]).getFile())) continue;
                throw new BuildException("A zip file cannot include itself", this.getLocation());
            }
            Resource[] rs = initialResources[i2];
            if (this.doFilesonly) {
                rs = this.selectFileResources(rs);
            }
            newerResources[i2] = ResourceUtils.selectOutOfDateSources(this, rs, new IdentityMapper(), this.getZipScanner());
            boolean bl2 = needsUpdate = needsUpdate || newerResources[i2].length > 0;
            if (needsUpdate && !this.doUpdate) break;
        }
        if (needsUpdate && !this.doUpdate) {
            return new ArchiveState(true, initialResources);
        }
        return new ArchiveState(needsUpdate, newerResources);
    }

    protected Resource[][] grabResources(FileSet[] filesets) {
        Resource[][] result = new Resource[filesets.length][];
        for (int i2 = 0; i2 < filesets.length; ++i2) {
            int j2;
            DirectoryScanner rs;
            boolean skipEmptyNames = true;
            if (filesets[i2] instanceof ZipFileSet) {
                ZipFileSet zfs = (ZipFileSet)filesets[i2];
                boolean bl2 = skipEmptyNames = zfs.getPrefix(this.getProject()).equals("") && zfs.getFullpath(this.getProject()).equals("");
            }
            if ((rs = filesets[i2].getDirectoryScanner(this.getProject())) instanceof ZipScanner) {
                ((ZipScanner)rs).setEncoding(this.encoding);
            }
            Vector<Resource> resources = new Vector<Resource>();
            if (!this.doFilesonly) {
                String[] directories = rs.getIncludedDirectories();
                for (j2 = 0; j2 < directories.length; ++j2) {
                    if ("".equals(directories[j2]) && skipEmptyNames) continue;
                    resources.addElement(rs.getResource(directories[j2]));
                }
            }
            String[] files = rs.getIncludedFiles();
            for (j2 = 0; j2 < files.length; ++j2) {
                if ("".equals(files[j2]) && skipEmptyNames) continue;
                resources.addElement(rs.getResource(files[j2]));
            }
            result[i2] = new Resource[resources.size()];
            resources.copyInto(result[i2]);
        }
        return result;
    }

    protected Resource[][] grabNonFileSetResources(ResourceCollection[] rcs) {
        Resource[][] result = new Resource[rcs.length][];
        for (int i2 = 0; i2 < rcs.length; ++i2) {
            Iterator iter = rcs[i2].iterator();
            ArrayList<Resource> rs = new ArrayList<Resource>();
            int lastDir = 0;
            while (iter.hasNext()) {
                Resource r2 = (Resource)iter.next();
                if (!r2.isExists()) continue;
                if (r2.isDirectory()) {
                    rs.add(lastDir++, r2);
                    continue;
                }
                rs.add(r2);
            }
            result[i2] = rs.toArray(new Resource[rs.size()]);
        }
        return result;
    }

    protected void zipDir(File dir, ZipOutputStream zOut, String vPath, int mode) throws IOException {
        this.zipDir(dir, zOut, vPath, mode, null);
    }

    protected void zipDir(File dir, ZipOutputStream zOut, String vPath, int mode, ZipExtraField[] extra) throws IOException {
        if (this.doFilesonly) {
            this.log("skipping directory " + vPath + " for file-only archive", 3);
            return;
        }
        if (this.addedDirs.get(vPath) != null) {
            return;
        }
        this.log("adding directory " + vPath, 3);
        this.addedDirs.put(vPath, vPath);
        if (!this.skipWriting) {
            ZipEntry ze = new ZipEntry(vPath);
            if (dir != null && dir.exists()) {
                ze.setTime(dir.lastModified() + (long)(this.roundUp ? 1999 : 0));
            } else {
                ze.setTime(System.currentTimeMillis() + (long)(this.roundUp ? 1999 : 0));
            }
            ze.setSize(0L);
            ze.setMethod(0);
            ze.setCrc(EMPTY_CRC);
            ze.setUnixMode(mode);
            if (extra != null) {
                ze.setExtraFields(extra);
            }
            zOut.putNextEntry(ze);
        }
    }

    protected void zipFile(InputStream in, ZipOutputStream zOut, String vPath, long lastModified, File fromArchive, int mode) throws IOException {
        if (this.entries.contains(vPath)) {
            if (this.duplicate.equals("preserve")) {
                this.log(vPath + " already added, skipping", 2);
                return;
            }
            if (this.duplicate.equals("fail")) {
                throw new BuildException("Duplicate file " + vPath + " was found and the duplicate " + "attribute is 'fail'.");
            }
            this.log("duplicate file " + vPath + " found, adding.", 3);
        } else {
            this.log("adding entry " + vPath, 3);
        }
        this.entries.put(vPath, vPath);
        if (!this.skipWriting) {
            ZipEntry ze = new ZipEntry(vPath);
            ze.setTime(lastModified);
            ze.setMethod(this.doCompress ? 8 : 0);
            if (!zOut.isSeekable() && !this.doCompress) {
                long size = 0L;
                CRC32 cal = new CRC32();
                if (!in.markSupported()) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[8192];
                    int count = 0;
                    do {
                        size += (long)count;
                        cal.update(buffer, 0, count);
                        bos.write(buffer, 0, count);
                    } while ((count = in.read(buffer, 0, buffer.length)) != -1);
                    in = new ByteArrayInputStream(bos.toByteArray());
                } else {
                    in.mark(Integer.MAX_VALUE);
                    byte[] buffer = new byte[8192];
                    int count = 0;
                    do {
                        size += (long)count;
                        cal.update(buffer, 0, count);
                    } while ((count = in.read(buffer, 0, buffer.length)) != -1);
                    in.reset();
                }
                ze.setSize(size);
                ze.setCrc(cal.getValue());
            }
            ze.setUnixMode(mode);
            zOut.putNextEntry(ze);
            byte[] buffer = new byte[8192];
            int count = 0;
            do {
                if (count == 0) continue;
                zOut.write(buffer, 0, count);
            } while ((count = in.read(buffer, 0, buffer.length)) != -1);
        }
        this.addedFiles.addElement(vPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zipFile(File file, ZipOutputStream zOut, String vPath, int mode) throws IOException {
        if (file.equals(this.zipFile)) {
            throw new BuildException("A zip file cannot include itself", this.getLocation());
        }
        FileInputStream fIn = new FileInputStream(file);
        try {
            this.zipFile(fIn, zOut, vPath, file.lastModified() + (long)(this.roundUp ? 1999 : 0), null, mode);
        }
        finally {
            fIn.close();
        }
    }

    protected final void addParentDirs(File baseDir, String entry, ZipOutputStream zOut, String prefix, int dirMode) throws IOException {
        if (!this.doFilesonly) {
            String dir;
            Stack<String> directories = new Stack<String>();
            int slashPos = entry.length();
            while ((slashPos = entry.lastIndexOf(47, slashPos - 1)) != -1) {
                dir = entry.substring(0, slashPos + 1);
                if (this.addedDirs.get(prefix + dir) != null) break;
                directories.push(dir);
            }
            while (!directories.isEmpty()) {
                dir = (String)directories.pop();
                File f2 = null;
                f2 = baseDir != null ? new File(baseDir, dir) : new File(dir);
                this.zipDir(f2, zOut, prefix + dir, dirMode);
            }
        }
    }

    protected void cleanUp() {
        this.addedDirs.clear();
        this.addedFiles.removeAllElements();
        this.entries.clear();
        this.addingNewFiles = false;
        this.doUpdate = this.savedDoUpdate;
        Enumeration e2 = this.filesetsFromGroupfilesets.elements();
        while (e2.hasMoreElements()) {
            ZipFileSet zf = (ZipFileSet)e2.nextElement();
            this.resources.removeElement(zf);
        }
        this.filesetsFromGroupfilesets.removeAllElements();
    }

    public void reset() {
        this.resources.removeAllElements();
        this.zipFile = null;
        this.baseDir = null;
        this.groupfilesets.removeAllElements();
        this.duplicate = "add";
        this.archiveType = "zip";
        this.doCompress = true;
        this.emptyBehavior = "skip";
        this.doUpdate = false;
        this.doFilesonly = false;
        this.encoding = null;
    }

    protected static final boolean isEmpty(Resource[][] r2) {
        for (int i2 = 0; i2 < r2.length; ++i2) {
            if (r2[i2].length <= 0) continue;
            return false;
        }
        return true;
    }

    protected Resource[] selectFileResources(Resource[] orig) {
        if (orig.length == 0) {
            return orig;
        }
        Vector<Resource> v2 = new Vector<Resource>(orig.length);
        for (int i2 = 0; i2 < orig.length; ++i2) {
            if (!orig[i2].isDirectory()) {
                v2.addElement(orig[i2]);
                continue;
            }
            this.log("Ignoring directory " + orig[i2].getName() + " as only files will be added.", 3);
        }
        if (v2.size() != orig.length) {
            Object[] r2 = new Resource[v2.size()];
            v2.copyInto(r2);
            return r2;
        }
        return orig;
    }

    public static class ArchiveState {
        private boolean outOfDate;
        private Resource[][] resourcesToAdd;

        ArchiveState(boolean state, Resource[][] r2) {
            this.outOfDate = state;
            this.resourcesToAdd = r2;
        }

        public boolean isOutOfDate() {
            return this.outOfDate;
        }

        public Resource[][] getResourcesToAdd() {
            return this.resourcesToAdd;
        }

        public boolean isWithoutAnyResources() {
            if (this.resourcesToAdd == null) {
                return true;
            }
            for (int counter = 0; counter < this.resourcesToAdd.length; ++counter) {
                if (this.resourcesToAdd[counter] == null || this.resourcesToAdd[counter].length <= 0) continue;
                return false;
            }
            return true;
        }
    }

    public static class Duplicate
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"add", "preserve", "fail"};
        }
    }

    public static class WhenEmpty
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"fail", "skip", "create"};
        }
    }
}

