/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.condition;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class HasMethod
extends ProjectComponent
implements Condition {
    private String classname;
    private String method;
    private String field;
    private Path classpath;
    private AntClassLoader loader;
    private boolean ignoreSystemClasses = false;

    public void setClasspath(Path classpath) {
        this.createClasspath().append(classpath);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r2) {
        this.createClasspath().setRefid(r2);
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setIgnoreSystemClasses(boolean ignoreSystemClasses) {
        this.ignoreSystemClasses = ignoreSystemClasses;
    }

    private Class loadClass(String classname) {
        try {
            if (this.ignoreSystemClasses) {
                this.loader = this.getProject().createClassLoader(this.classpath);
                this.loader.setParentFirst(false);
                this.loader.addJavaLibraries();
                if (this.loader != null) {
                    try {
                        return this.loader.findClass(classname);
                    }
                    catch (SecurityException se) {
                        return null;
                    }
                }
                return null;
            }
            if (this.loader != null) {
                return this.loader.loadClass(classname);
            }
            ClassLoader l2 = this.getClass().getClassLoader();
            if (l2 != null) {
                return Class.forName(classname, true, l2);
            }
            return Class.forName(classname);
        }
        catch (ClassNotFoundException e2) {
            throw new BuildException("class \"" + classname + "\" was not found");
        }
        catch (NoClassDefFoundError e3) {
            throw new BuildException("Could not load dependent class \"" + e3.getMessage() + "\" for class \"" + classname + "\"");
        }
    }

    public boolean eval() throws BuildException {
        if (this.classname == null) {
            throw new BuildException("No classname defined");
        }
        Class clazz = this.loadClass(this.classname);
        if (this.method != null) {
            return this.isMethodFound(clazz);
        }
        if (this.field != null) {
            return this.isFieldFound(clazz);
        }
        throw new BuildException("Neither method nor field defined");
    }

    private boolean isFieldFound(Class clazz) {
        Field[] fields = clazz.getDeclaredFields();
        for (int i2 = 0; i2 < fields.length; ++i2) {
            Field fieldEntry = fields[i2];
            if (!fieldEntry.getName().equals(this.field)) continue;
            return true;
        }
        return false;
    }

    private boolean isMethodFound(Class clazz) {
        Method[] methods = clazz.getDeclaredMethods();
        for (int i2 = 0; i2 < methods.length; ++i2) {
            Method methodEntry = methods[i2];
            if (!methodEntry.getName().equals(this.method)) continue;
            return true;
        }
        return false;
    }
}

