/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.email;

public class EmailAddress {
    private String name;
    private String address;

    public EmailAddress() {
    }

    public EmailAddress(String email) {
        int minLen = 9;
        int len = email.length();
        if (!(len <= 9 || email.charAt(0) != '<' && email.charAt(1) != '<' || email.charAt(len - 1) != '>' && email.charAt(len - 2) != '>')) {
            this.address = this.trim(email, true);
            return;
        }
        int paramDepth = 0;
        int start = 0;
        int end = 0;
        int nStart = 0;
        int nEnd = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = email.charAt(i2);
            if (c2 == '(') {
                ++paramDepth;
                if (start != 0) continue;
                end = i2;
                nStart = i2 + 1;
                continue;
            }
            if (c2 == ')') {
                --paramDepth;
                if (end != 0) continue;
                start = i2 + 1;
                nEnd = i2;
                continue;
            }
            if (paramDepth == 0 && c2 == '<') {
                if (start == 0) {
                    nEnd = i2;
                }
                start = i2 + 1;
                continue;
            }
            if (paramDepth != 0 || c2 != '>' || (end = i2) == len - 1) continue;
            nStart = i2 + 1;
        }
        if (end == 0) {
            end = len;
        }
        if (nEnd == 0) {
            nEnd = len;
        }
        this.address = this.trim(email.substring(start, end), true);
        this.name = this.trim(email.substring(nStart, nEnd), false);
        if (this.name.length() + this.address.length() > len) {
            this.name = null;
        }
    }

    private String trim(String t2, boolean trimAngleBrackets) {
        int start = 0;
        int end = t2.length();
        boolean trim = false;
        do {
            trim = false;
            if (t2.charAt(end - 1) == ')' || t2.charAt(end - 1) == '>' && trimAngleBrackets || t2.charAt(end - 1) == '\"' && t2.charAt(end - 2) != '\\' || t2.charAt(end - 1) <= ' ') {
                trim = true;
                --end;
            }
            if (t2.charAt(start) != '(' && (t2.charAt(start) != '<' || !trimAngleBrackets) && t2.charAt(start) != '\"' && t2.charAt(start) > ' ') continue;
            trim = true;
            ++start;
        } while (trim);
        return t2.substring(start, end);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String toString() {
        if (this.name == null) {
            return this.address;
        }
        return this.name + " <" + this.address + ">";
    }

    public String getAddress() {
        return this.address;
    }

    public String getName() {
        return this.name;
    }
}

