/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.selectors.AndSelector;
import org.apache.tools.ant.types.selectors.ContainsRegexpSelector;
import org.apache.tools.ant.types.selectors.ContainsSelector;
import org.apache.tools.ant.types.selectors.DateSelector;
import org.apache.tools.ant.types.selectors.DependSelector;
import org.apache.tools.ant.types.selectors.DepthSelector;
import org.apache.tools.ant.types.selectors.DifferentSelector;
import org.apache.tools.ant.types.selectors.ExtendSelector;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.apache.tools.ant.types.selectors.FilenameSelector;
import org.apache.tools.ant.types.selectors.MajoritySelector;
import org.apache.tools.ant.types.selectors.NoneSelector;
import org.apache.tools.ant.types.selectors.NotSelector;
import org.apache.tools.ant.types.selectors.OrSelector;
import org.apache.tools.ant.types.selectors.PresentSelector;
import org.apache.tools.ant.types.selectors.SelectSelector;
import org.apache.tools.ant.types.selectors.SelectorContainer;
import org.apache.tools.ant.types.selectors.SelectorScanner;
import org.apache.tools.ant.types.selectors.SizeSelector;
import org.apache.tools.ant.types.selectors.TypeSelector;
import org.apache.tools.ant.types.selectors.modifiedselector.ModifiedSelector;

public abstract class AbstractFileSet
extends DataType
implements Cloneable,
SelectorContainer {
    private PatternSet defaultPatterns = new PatternSet();
    private Vector additionalPatterns = new Vector();
    private Vector selectors = new Vector();
    private File dir;
    private boolean useDefaultExcludes = true;
    private boolean caseSensitive = true;
    private boolean followSymlinks = true;
    private boolean errorOnMissingDir = true;
    private DirectoryScanner directoryScanner = null;

    public AbstractFileSet() {
    }

    protected AbstractFileSet(AbstractFileSet fileset) {
        this.dir = fileset.dir;
        this.defaultPatterns = fileset.defaultPatterns;
        this.additionalPatterns = fileset.additionalPatterns;
        this.selectors = fileset.selectors;
        this.useDefaultExcludes = fileset.useDefaultExcludes;
        this.caseSensitive = fileset.caseSensitive;
        this.followSymlinks = fileset.followSymlinks;
        this.errorOnMissingDir = fileset.errorOnMissingDir;
        this.setProject(fileset.getProject());
    }

    public void setRefid(Reference r2) throws BuildException {
        if (this.dir != null || this.defaultPatterns.hasPatterns(this.getProject())) {
            throw this.tooManyAttributes();
        }
        if (!this.additionalPatterns.isEmpty()) {
            throw this.noChildrenAllowed();
        }
        if (!this.selectors.isEmpty()) {
            throw this.noChildrenAllowed();
        }
        super.setRefid(r2);
    }

    public synchronized void setDir(File dir) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.dir = dir;
        this.directoryScanner = null;
    }

    public File getDir() {
        return this.getDir(this.getProject());
    }

    public synchronized File getDir(Project p2) {
        return this.isReference() ? this.getRef(p2).getDir(p2) : this.dir;
    }

    public synchronized PatternSet createPatternSet() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        PatternSet patterns = new PatternSet();
        this.additionalPatterns.addElement(patterns);
        this.directoryScanner = null;
        return patterns;
    }

    public synchronized PatternSet.NameEntry createInclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.directoryScanner = null;
        return this.defaultPatterns.createInclude();
    }

    public synchronized PatternSet.NameEntry createIncludesFile() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.directoryScanner = null;
        return this.defaultPatterns.createIncludesFile();
    }

    public synchronized PatternSet.NameEntry createExclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.directoryScanner = null;
        return this.defaultPatterns.createExclude();
    }

    public synchronized PatternSet.NameEntry createExcludesFile() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.directoryScanner = null;
        return this.defaultPatterns.createExcludesFile();
    }

    public synchronized void setFile(File file) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.setDir(file.getParentFile());
        this.createInclude().setName(file.getName());
    }

    public synchronized void setIncludes(String includes) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.defaultPatterns.setIncludes(includes);
        this.directoryScanner = null;
    }

    public synchronized void appendIncludes(String[] includes) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (includes != null) {
            for (int i2 = 0; i2 < includes.length; ++i2) {
                this.defaultPatterns.createInclude().setName(includes[i2]);
            }
            this.directoryScanner = null;
        }
    }

    public synchronized void setExcludes(String excludes) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.defaultPatterns.setExcludes(excludes);
        this.directoryScanner = null;
    }

    public synchronized void appendExcludes(String[] excludes) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (excludes != null) {
            for (int i2 = 0; i2 < excludes.length; ++i2) {
                this.defaultPatterns.createExclude().setName(excludes[i2]);
            }
            this.directoryScanner = null;
        }
    }

    public synchronized void setIncludesfile(File incl) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.defaultPatterns.setIncludesfile(incl);
        this.directoryScanner = null;
    }

    public synchronized void setExcludesfile(File excl) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.defaultPatterns.setExcludesfile(excl);
        this.directoryScanner = null;
    }

    public synchronized void setDefaultexcludes(boolean useDefaultExcludes) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.useDefaultExcludes = useDefaultExcludes;
        this.directoryScanner = null;
    }

    public synchronized boolean getDefaultexcludes() {
        return this.isReference() ? this.getRef(this.getProject()).getDefaultexcludes() : this.useDefaultExcludes;
    }

    public synchronized void setCaseSensitive(boolean caseSensitive) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.caseSensitive = caseSensitive;
        this.directoryScanner = null;
    }

    public synchronized boolean isCaseSensitive() {
        return this.isReference() ? this.getRef(this.getProject()).isCaseSensitive() : this.caseSensitive;
    }

    public synchronized void setFollowSymlinks(boolean followSymlinks) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.followSymlinks = followSymlinks;
        this.directoryScanner = null;
    }

    public synchronized boolean isFollowSymlinks() {
        return this.isReference() ? this.getRef(this.getProject()).isFollowSymlinks() : this.followSymlinks;
    }

    public void setErrorOnMissingDir(boolean errorOnMissingDir) {
        this.errorOnMissingDir = errorOnMissingDir;
    }

    public DirectoryScanner getDirectoryScanner() {
        return this.getDirectoryScanner(this.getProject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirectoryScanner getDirectoryScanner(Project p2) {
        if (this.isReference()) {
            return this.getRef(p2).getDirectoryScanner(p2);
        }
        DirectoryScanner ds2 = null;
        AbstractFileSet abstractFileSet = this;
        synchronized (abstractFileSet) {
            if (this.directoryScanner != null && p2 == this.getProject()) {
                ds2 = this.directoryScanner;
            } else {
                if (this.dir == null) {
                    throw new BuildException("No directory specified for " + this.getDataTypeName() + ".");
                }
                if (!this.dir.exists() && this.errorOnMissingDir) {
                    throw new BuildException(this.dir.getAbsolutePath() + " not found.");
                }
                if (!this.dir.isDirectory() && this.dir.exists()) {
                    throw new BuildException(this.dir.getAbsolutePath() + " is not a directory.");
                }
                ds2 = new DirectoryScanner();
                this.setupDirectoryScanner(ds2, p2);
                ds2.setFollowSymlinks(this.followSymlinks);
                ds2.setErrorOnMissingDir(this.errorOnMissingDir);
                this.directoryScanner = p2 == this.getProject() ? ds2 : this.directoryScanner;
            }
        }
        ds2.scan();
        return ds2;
    }

    public void setupDirectoryScanner(FileScanner ds2) {
        this.setupDirectoryScanner(ds2, this.getProject());
    }

    public synchronized void setupDirectoryScanner(FileScanner ds2, Project p2) {
        if (this.isReference()) {
            this.getRef(p2).setupDirectoryScanner(ds2, p2);
            return;
        }
        if (ds2 == null) {
            throw new IllegalArgumentException("ds cannot be null");
        }
        ds2.setBasedir(this.dir);
        PatternSet ps = this.mergePatterns(p2);
        p2.log(this.getDataTypeName() + ": Setup scanner in dir " + this.dir + " with " + ps, 4);
        ds2.setIncludes(ps.getIncludePatterns(p2));
        ds2.setExcludes(ps.getExcludePatterns(p2));
        if (ds2 instanceof SelectorScanner) {
            SelectorScanner ss = (SelectorScanner)((Object)ds2);
            ss.setSelectors(this.getSelectors(p2));
        }
        if (this.useDefaultExcludes) {
            ds2.addDefaultExcludes();
        }
        ds2.setCaseSensitive(this.caseSensitive);
    }

    protected AbstractFileSet getRef(Project p2) {
        return (AbstractFileSet)this.getCheckedRef(p2);
    }

    public synchronized boolean hasSelectors() {
        return this.isReference() && this.getProject() != null ? this.getRef(this.getProject()).hasSelectors() : !this.selectors.isEmpty();
    }

    public synchronized boolean hasPatterns() {
        if (this.isReference() && this.getProject() != null) {
            return this.getRef(this.getProject()).hasPatterns();
        }
        if (this.defaultPatterns.hasPatterns(this.getProject())) {
            return true;
        }
        Enumeration e2 = this.additionalPatterns.elements();
        while (e2.hasMoreElements()) {
            PatternSet ps = (PatternSet)e2.nextElement();
            if (!ps.hasPatterns(this.getProject())) continue;
            return true;
        }
        return false;
    }

    public synchronized int selectorCount() {
        return this.isReference() && this.getProject() != null ? this.getRef(this.getProject()).selectorCount() : this.selectors.size();
    }

    public synchronized FileSelector[] getSelectors(Project p2) {
        return this.isReference() ? this.getRef(p2).getSelectors(p2) : this.selectors.toArray(new FileSelector[this.selectors.size()]);
    }

    public synchronized Enumeration selectorElements() {
        return this.isReference() && this.getProject() != null ? this.getRef(this.getProject()).selectorElements() : this.selectors.elements();
    }

    public synchronized void appendSelector(FileSelector selector) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.selectors.addElement(selector);
        this.directoryScanner = null;
    }

    public void addSelector(SelectSelector selector) {
        this.appendSelector(selector);
    }

    public void addAnd(AndSelector selector) {
        this.appendSelector(selector);
    }

    public void addOr(OrSelector selector) {
        this.appendSelector(selector);
    }

    public void addNot(NotSelector selector) {
        this.appendSelector(selector);
    }

    public void addNone(NoneSelector selector) {
        this.appendSelector(selector);
    }

    public void addMajority(MajoritySelector selector) {
        this.appendSelector(selector);
    }

    public void addDate(DateSelector selector) {
        this.appendSelector(selector);
    }

    public void addSize(SizeSelector selector) {
        this.appendSelector(selector);
    }

    public void addDifferent(DifferentSelector selector) {
        this.appendSelector(selector);
    }

    public void addFilename(FilenameSelector selector) {
        this.appendSelector(selector);
    }

    public void addType(TypeSelector selector) {
        this.appendSelector(selector);
    }

    public void addCustom(ExtendSelector selector) {
        this.appendSelector(selector);
    }

    public void addContains(ContainsSelector selector) {
        this.appendSelector(selector);
    }

    public void addPresent(PresentSelector selector) {
        this.appendSelector(selector);
    }

    public void addDepth(DepthSelector selector) {
        this.appendSelector(selector);
    }

    public void addDepend(DependSelector selector) {
        this.appendSelector(selector);
    }

    public void addContainsRegexp(ContainsRegexpSelector selector) {
        this.appendSelector(selector);
    }

    public void addModified(ModifiedSelector selector) {
        this.appendSelector(selector);
    }

    public void add(FileSelector selector) {
        this.appendSelector(selector);
    }

    public String toString() {
        DirectoryScanner ds2 = this.getDirectoryScanner(this.getProject());
        String[] files = ds2.getIncludedFiles();
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < files.length; ++i2) {
            if (i2 > 0) {
                sb.append(';');
            }
            sb.append(files[i2]);
        }
        return sb.toString();
    }

    public synchronized Object clone() {
        if (this.isReference()) {
            return this.getRef(this.getProject()).clone();
        }
        try {
            AbstractFileSet fs2 = (AbstractFileSet)super.clone();
            fs2.defaultPatterns = (PatternSet)this.defaultPatterns.clone();
            fs2.additionalPatterns = new Vector(this.additionalPatterns.size());
            Enumeration e2 = this.additionalPatterns.elements();
            while (e2.hasMoreElements()) {
                fs2.additionalPatterns.addElement(((PatternSet)e2.nextElement()).clone());
            }
            fs2.selectors = new Vector(this.selectors);
            return fs2;
        }
        catch (CloneNotSupportedException e3) {
            throw new BuildException(e3);
        }
    }

    public String[] mergeIncludes(Project p2) {
        return this.mergePatterns(p2).getIncludePatterns(p2);
    }

    public String[] mergeExcludes(Project p2) {
        return this.mergePatterns(p2).getExcludePatterns(p2);
    }

    public synchronized PatternSet mergePatterns(Project p2) {
        if (this.isReference()) {
            return this.getRef(p2).mergePatterns(p2);
        }
        PatternSet ps = (PatternSet)this.defaultPatterns.clone();
        int count = this.additionalPatterns.size();
        for (int i2 = 0; i2 < count; ++i2) {
            Object o2 = this.additionalPatterns.elementAt(i2);
            ps.append((PatternSet)o2, p2);
        }
        return ps;
    }
}

