/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public final class AntFilterReader
extends DataType
implements Cloneable {
    private String className;
    private final Vector parameters = new Vector();
    private Path classpath;

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public void addParam(Parameter param) {
        this.parameters.addElement(param);
    }

    public void setClasspath(Path classpath) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public void setClasspathRef(Reference r2) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createClasspath().setRefid(r2);
    }

    public Parameter[] getParams() {
        Object[] params = new Parameter[this.parameters.size()];
        this.parameters.copyInto(params);
        return params;
    }

    public void setRefid(Reference r2) throws BuildException {
        if (!this.parameters.isEmpty() || this.className != null || this.classpath != null) {
            throw this.tooManyAttributes();
        }
        Object o2 = r2.getReferencedObject(this.getProject());
        if (o2 instanceof AntFilterReader) {
            AntFilterReader afr = (AntFilterReader)o2;
            this.setClassName(afr.getClassName());
            this.setClasspath(afr.getClasspath());
            Parameter[] p2 = afr.getParams();
            if (p2 != null) {
                for (int i2 = 0; i2 < p2.length; ++i2) {
                    this.addParam(p2[i2]);
                }
            }
        } else {
            String msg = r2.getRefId() + " doesn't refer to a FilterReader";
            throw new BuildException(msg);
        }
        super.setRefid(r2);
    }
}

