/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.StringUtils;

public class Commandline
implements Cloneable {
    private static final boolean IS_WIN_9X = Os.isFamily("win9x");
    private Vector arguments = new Vector();
    private String executable = null;
    protected static final String DISCLAIMER = StringUtils.LINE_SEP + "The ' characters around the executable and arguments are" + StringUtils.LINE_SEP + "not part of the command." + StringUtils.LINE_SEP;

    public Commandline(String toProcess) {
        String[] tmp = Commandline.translateCommandline(toProcess);
        if (tmp != null && tmp.length > 0) {
            this.setExecutable(tmp[0]);
            for (int i2 = 1; i2 < tmp.length; ++i2) {
                this.createArgument().setValue(tmp[i2]);
            }
        }
    }

    public Commandline() {
    }

    public Argument createArgument() {
        return this.createArgument(false);
    }

    public Argument createArgument(boolean insertAtStart) {
        Argument argument = new Argument();
        if (insertAtStart) {
            this.arguments.insertElementAt(argument, 0);
        } else {
            this.arguments.addElement(argument);
        }
        return argument;
    }

    public void setExecutable(String executable) {
        if (executable == null || executable.length() == 0) {
            return;
        }
        this.executable = executable.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public String getExecutable() {
        return this.executable;
    }

    public void addArguments(String[] line) {
        for (int i2 = 0; i2 < line.length; ++i2) {
            this.createArgument().setValue(line[i2]);
        }
    }

    public String[] getCommandline() {
        LinkedList commands = new LinkedList();
        ListIterator list = commands.listIterator();
        this.addCommandToList(list);
        String[] result = new String[commands.size()];
        return commands.toArray(result);
    }

    public void addCommandToList(ListIterator list) {
        if (this.executable != null) {
            list.add(this.executable);
        }
        this.addArgumentsToList(list);
    }

    public String[] getArguments() {
        ArrayList result = new ArrayList(this.arguments.size() * 2);
        this.addArgumentsToList(result.listIterator());
        String[] res = new String[result.size()];
        return result.toArray(res);
    }

    public void addArgumentsToList(ListIterator list) {
        for (int i2 = 0; i2 < this.arguments.size(); ++i2) {
            Argument arg = (Argument)this.arguments.elementAt(i2);
            String[] s2 = arg.getParts();
            if (s2 == null) continue;
            for (int j2 = 0; j2 < s2.length; ++j2) {
                list.add(s2[j2]);
            }
        }
    }

    public String toString() {
        return Commandline.toString(this.getCommandline());
    }

    public static String quoteArgument(String argument) {
        if (argument.indexOf("\"") > -1) {
            if (argument.indexOf("'") > -1) {
                throw new BuildException("Can't handle single and double quotes in same argument");
            }
            return '\'' + argument + '\'';
        }
        if (argument.indexOf("'") > -1 || argument.indexOf(" ") > -1 || IS_WIN_9X && argument.indexOf(59) != -1) {
            return '\"' + argument + '\"';
        }
        return argument;
    }

    public static String toString(String[] line) {
        if (line == null || line.length == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        for (int i2 = 0; i2 < line.length; ++i2) {
            if (i2 > 0) {
                result.append(' ');
            }
            result.append(Commandline.quoteArgument(line[i2]));
        }
        return result.toString();
    }

    public static String[] translateCommandline(String toProcess) {
        if (toProcess == null || toProcess.length() == 0) {
            return new String[0];
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(toProcess, "\"' ", true);
        Vector<String> v2 = new Vector<String>();
        StringBuffer current = new StringBuffer();
        boolean lastTokenHasBeenQuoted = false;
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                state = 1;
            } else if ("\"".equals(nextTok)) {
                state = 2;
            } else if (" ".equals(nextTok)) {
                if (lastTokenHasBeenQuoted || current.length() != 0) {
                    v2.addElement(current.toString());
                    current = new StringBuffer();
                }
            } else {
                current.append(nextTok);
            }
            lastTokenHasBeenQuoted = false;
        }
        if (lastTokenHasBeenQuoted || current.length() != 0) {
            v2.addElement(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new BuildException("unbalanced quotes in " + toProcess);
        }
        Object[] args = new String[v2.size()];
        v2.copyInto(args);
        return args;
    }

    public int size() {
        return this.getCommandline().length;
    }

    public Object clone() {
        try {
            Commandline c2 = (Commandline)super.clone();
            c2.arguments = (Vector)this.arguments.clone();
            return c2;
        }
        catch (CloneNotSupportedException e2) {
            throw new BuildException(e2);
        }
    }

    public void clear() {
        this.executable = null;
        this.arguments.removeAllElements();
    }

    public void clearArgs() {
        this.arguments.removeAllElements();
    }

    public Marker createMarker() {
        return new Marker(this.arguments.size());
    }

    public String describeCommand() {
        return Commandline.describeCommand(this);
    }

    public String describeArguments() {
        return Commandline.describeArguments(this);
    }

    public static String describeCommand(Commandline line) {
        return Commandline.describeCommand(line.getCommandline());
    }

    public static String describeArguments(Commandline line) {
        return Commandline.describeArguments(line.getArguments());
    }

    public static String describeCommand(String[] args) {
        if (args == null || args.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer("Executing '");
        buf.append(args[0]);
        buf.append("'");
        if (args.length > 1) {
            buf.append(" with ");
            buf.append(Commandline.describeArguments(args, 1));
        } else {
            buf.append(DISCLAIMER);
        }
        return buf.toString();
    }

    public static String describeArguments(String[] args) {
        return Commandline.describeArguments(args, 0);
    }

    protected static String describeArguments(String[] args, int offset) {
        if (args == null || args.length <= offset) {
            return "";
        }
        StringBuffer buf = new StringBuffer("argument");
        if (args.length > offset) {
            buf.append("s");
        }
        buf.append(":").append(StringUtils.LINE_SEP);
        for (int i2 = offset; i2 < args.length; ++i2) {
            buf.append("'").append(args[i2]).append("'").append(StringUtils.LINE_SEP);
        }
        buf.append(DISCLAIMER);
        return buf.toString();
    }

    public Iterator iterator() {
        return this.arguments.iterator();
    }

    public class Marker {
        private int position;
        private int realPos = -1;

        Marker(int position) {
            this.position = position;
        }

        public int getPosition() {
            if (this.realPos == -1) {
                this.realPos = Commandline.this.executable == null ? 0 : 1;
                for (int i2 = 0; i2 < this.position; ++i2) {
                    Argument arg = (Argument)Commandline.this.arguments.elementAt(i2);
                    this.realPos += arg.getParts().length;
                }
            }
            return this.realPos;
        }
    }

    public static class Argument
    extends ProjectComponent {
        private String[] parts;

        public void setValue(String value) {
            this.parts = new String[]{value};
        }

        public void setLine(String line) {
            if (line == null) {
                return;
            }
            this.parts = Commandline.translateCommandline(line);
        }

        public void setPath(Path value) {
            this.parts = new String[]{value.toString()};
        }

        public void setPathref(Reference value) {
            Path p2 = new Path(this.getProject());
            p2.setRefid(value);
            this.parts = new String[]{p2.toString()};
        }

        public void setFile(File value) {
            this.parts = new String[]{value.getAbsolutePath()};
        }

        public String[] getParts() {
            return this.parts;
        }
    }
}

