/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.util.Enumeration;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Assertions;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PropertySet;
import org.apache.tools.ant.util.JavaEnvUtils;

public class CommandlineJava
implements Cloneable {
    private Commandline vmCommand = new Commandline();
    private Commandline javaCommand = new Commandline();
    private SysProperties sysProperties = new SysProperties();
    private Path classpath = null;
    private Path bootclasspath = null;
    private String vmVersion;
    private String maxMemory = null;
    private Assertions assertions = null;
    private boolean executeJar = false;
    private boolean cloneVm = false;

    public CommandlineJava() {
        this.setVm(JavaEnvUtils.getJreExecutable("java"));
        this.setVmversion(JavaEnvUtils.getJavaVersion());
    }

    public Commandline.Argument createArgument() {
        return this.javaCommand.createArgument();
    }

    public Commandline.Argument createVmArgument() {
        return this.vmCommand.createArgument();
    }

    public void addSysproperty(Environment.Variable sysp) {
        this.sysProperties.addVariable(sysp);
    }

    public void addSyspropertyset(PropertySet sysp) {
        this.sysProperties.addSyspropertyset(sysp);
    }

    public void addSysproperties(SysProperties sysp) {
        this.sysProperties.addSysproperties(sysp);
    }

    public void setVm(String vm) {
        this.vmCommand.setExecutable(vm);
    }

    public void setVmversion(String value) {
        this.vmVersion = value;
    }

    public void setCloneVm(boolean cloneVm) {
        this.cloneVm = cloneVm;
    }

    public Assertions getAssertions() {
        return this.assertions;
    }

    public void setAssertions(Assertions assertions) {
        this.assertions = assertions;
    }

    public void setJar(String jarpathname) {
        this.javaCommand.setExecutable(jarpathname);
        this.executeJar = true;
    }

    public String getJar() {
        if (this.executeJar) {
            return this.javaCommand.getExecutable();
        }
        return null;
    }

    public void setClassname(String classname) {
        this.javaCommand.setExecutable(classname);
        this.executeJar = false;
    }

    public String getClassname() {
        if (!this.executeJar) {
            return this.javaCommand.getExecutable();
        }
        return null;
    }

    public Path createClasspath(Project p2) {
        if (this.classpath == null) {
            this.classpath = new Path(p2);
        }
        return this.classpath;
    }

    public Path createBootclasspath(Project p2) {
        if (this.bootclasspath == null) {
            this.bootclasspath = new Path(p2);
        }
        return this.bootclasspath;
    }

    public String getVmversion() {
        return this.vmVersion;
    }

    public String[] getCommandline() {
        LinkedList commands = new LinkedList();
        ListIterator listIterator = commands.listIterator();
        this.addCommandsToList(listIterator);
        return commands.toArray(new String[commands.size()]);
    }

    private void addCommandsToList(ListIterator listIterator) {
        Path bcp;
        this.getActualVMCommand().addCommandToList(listIterator);
        this.sysProperties.addDefinitionsToList(listIterator);
        if (this.isCloneVm()) {
            SysProperties clonedSysProperties = new SysProperties();
            PropertySet ps = new PropertySet();
            PropertySet.BuiltinPropertySetName sys = new PropertySet.BuiltinPropertySetName();
            sys.setValue("system");
            ps.appendBuiltin(sys);
            clonedSysProperties.addSyspropertyset(ps);
            clonedSysProperties.addDefinitionsToList(listIterator);
        }
        if ((bcp = this.calculateBootclasspath(true)).size() > 0) {
            listIterator.add("-Xbootclasspath:" + bcp.toString());
        }
        if (this.haveClasspath()) {
            listIterator.add("-classpath");
            listIterator.add(this.classpath.concatSystemClasspath("ignore").toString());
        }
        if (this.getAssertions() != null) {
            this.getAssertions().applyAssertions(listIterator);
        }
        if (this.executeJar) {
            listIterator.add("-jar");
        }
        this.javaCommand.addCommandToList(listIterator);
    }

    public void setMaxmemory(String max) {
        this.maxMemory = max;
    }

    public String toString() {
        return Commandline.toString(this.getCommandline());
    }

    public String describeCommand() {
        return Commandline.describeCommand(this.getCommandline());
    }

    public String describeJavaCommand() {
        return Commandline.describeCommand(this.getJavaCommand());
    }

    protected Commandline getActualVMCommand() {
        Commandline actualVMCommand = (Commandline)this.vmCommand.clone();
        if (this.maxMemory != null) {
            if (this.vmVersion.startsWith("1.1")) {
                actualVMCommand.createArgument().setValue("-mx" + this.maxMemory);
            } else {
                actualVMCommand.createArgument().setValue("-Xmx" + this.maxMemory);
            }
        }
        return actualVMCommand;
    }

    public int size() {
        int size = this.getActualVMCommand().size() + this.javaCommand.size() + this.sysProperties.size();
        if (this.isCloneVm()) {
            size += System.getProperties().size();
        }
        if (this.haveClasspath()) {
            size += 2;
        }
        if (this.calculateBootclasspath(true).size() > 0) {
            ++size;
        }
        if (this.executeJar) {
            ++size;
        }
        if (this.getAssertions() != null) {
            size += this.getAssertions().size();
        }
        return size;
    }

    public Commandline getJavaCommand() {
        return this.javaCommand;
    }

    public Commandline getVmCommand() {
        return this.getActualVMCommand();
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public Path getBootclasspath() {
        return this.bootclasspath;
    }

    public void setSystemProperties() throws BuildException {
        this.sysProperties.setSystem();
    }

    public void restoreSystemProperties() throws BuildException {
        this.sysProperties.restoreSystem();
    }

    public SysProperties getSystemProperties() {
        return this.sysProperties;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            CommandlineJava c2 = (CommandlineJava)super.clone();
            c2.vmCommand = (Commandline)this.vmCommand.clone();
            c2.javaCommand = (Commandline)this.javaCommand.clone();
            c2.sysProperties = (SysProperties)this.sysProperties.clone();
            if (this.classpath != null) {
                c2.classpath = (Path)this.classpath.clone();
            }
            if (this.bootclasspath != null) {
                c2.bootclasspath = (Path)this.bootclasspath.clone();
            }
            if (this.assertions != null) {
                c2.assertions = (Assertions)this.assertions.clone();
            }
            return c2;
        }
        catch (CloneNotSupportedException e2) {
            throw new BuildException(e2);
        }
    }

    public void clearJavaArgs() {
        this.javaCommand.clearArgs();
    }

    public boolean haveClasspath() {
        Path fullClasspath = this.classpath != null ? this.classpath.concatSystemClasspath("ignore") : null;
        return fullClasspath != null && fullClasspath.toString().trim().length() > 0;
    }

    protected boolean haveBootclasspath(boolean log) {
        return this.calculateBootclasspath(log).size() > 0;
    }

    private Path calculateBootclasspath(boolean log) {
        if (this.vmVersion.startsWith("1.1")) {
            if (this.bootclasspath != null && log) {
                this.bootclasspath.log("Ignoring bootclasspath as the target VM doesn't support it.");
            }
        } else {
            if (this.bootclasspath != null) {
                return this.bootclasspath.concatSystemBootClasspath(this.isCloneVm() ? "last" : "ignore");
            }
            if (this.isCloneVm()) {
                return Path.systemBootClasspath;
            }
        }
        return new Path(null);
    }

    private boolean isCloneVm() {
        return this.cloneVm || "true".equals(System.getProperty("ant.build.clonevm"));
    }

    public static class SysProperties
    extends Environment
    implements Cloneable {
        Properties sys = null;
        private Vector propertySets = new Vector();

        public String[] getVariables() throws BuildException {
            LinkedList definitions = new LinkedList();
            ListIterator list = definitions.listIterator();
            this.addDefinitionsToList(list);
            if (definitions.size() == 0) {
                return null;
            }
            return definitions.toArray(new String[definitions.size()]);
        }

        public void addDefinitionsToList(ListIterator listIt) {
            String[] props = super.getVariables();
            if (props != null) {
                for (int i2 = 0; i2 < props.length; ++i2) {
                    listIt.add("-D" + props[i2]);
                }
            }
            Properties propertySetProperties = this.mergePropertySets();
            Enumeration<Object> e2 = propertySetProperties.keys();
            while (e2.hasMoreElements()) {
                String key = (String)e2.nextElement();
                String value = propertySetProperties.getProperty(key);
                listIt.add("-D" + key + "=" + value);
            }
        }

        public int size() {
            Properties p2 = this.mergePropertySets();
            return this.variables.size() + p2.size();
        }

        public void setSystem() throws BuildException {
            try {
                this.sys = System.getProperties();
                Properties p2 = new Properties();
                Enumeration<Object> e2 = this.sys.propertyNames();
                while (e2.hasMoreElements()) {
                    String name = (String)e2.nextElement();
                    p2.put(name, this.sys.getProperty(name));
                }
                p2.putAll((Map<?, ?>)this.mergePropertySets());
                e2 = this.variables.elements();
                while (e2.hasMoreElements()) {
                    Environment.Variable v2 = (Environment.Variable)e2.nextElement();
                    v2.validate();
                    p2.put(v2.getKey(), v2.getValue());
                }
                System.setProperties(p2);
            }
            catch (SecurityException e3) {
                throw new BuildException("Cannot modify system properties", e3);
            }
        }

        public void restoreSystem() throws BuildException {
            if (this.sys == null) {
                throw new BuildException("Unbalanced nesting of SysProperties");
            }
            try {
                System.setProperties(this.sys);
                this.sys = null;
            }
            catch (SecurityException e2) {
                throw new BuildException("Cannot modify system properties", e2);
            }
        }

        public Object clone() throws CloneNotSupportedException {
            try {
                SysProperties c2 = (SysProperties)super.clone();
                c2.variables = (Vector)this.variables.clone();
                c2.propertySets = (Vector)this.propertySets.clone();
                return c2;
            }
            catch (CloneNotSupportedException e2) {
                return null;
            }
        }

        public void addSyspropertyset(PropertySet ps) {
            this.propertySets.addElement(ps);
        }

        public void addSysproperties(SysProperties ps) {
            this.variables.addAll(ps.variables);
            this.propertySets.addAll(ps.propertySets);
        }

        private Properties mergePropertySets() {
            Properties p2 = new Properties();
            Enumeration e2 = this.propertySets.elements();
            while (e2.hasMoreElements()) {
                PropertySet ps = (PropertySet)e2.nextElement();
                p2.putAll((Map<?, ?>)ps.getProperties());
            }
            return p2;
        }
    }
}

