/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.util.Stack;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.IdentityStack;

public abstract class DataType
extends ProjectComponent
implements Cloneable {
    protected Reference ref;
    protected boolean checked = true;

    public boolean isReference() {
        return this.ref != null;
    }

    public void setRefid(Reference ref) {
        this.ref = ref;
        this.checked = false;
    }

    protected String getDataTypeName() {
        return ComponentHelper.getElementName(this.getProject(), this, true);
    }

    protected void dieOnCircularReference() {
        this.dieOnCircularReference(this.getProject());
    }

    protected void dieOnCircularReference(Project p2) {
        if (this.checked || !this.isReference()) {
            return;
        }
        this.dieOnCircularReference(new IdentityStack(this), p2);
    }

    protected void dieOnCircularReference(Stack stack, Project project) throws BuildException {
        if (this.checked || !this.isReference()) {
            return;
        }
        Object o2 = this.ref.getReferencedObject(project);
        if (o2 instanceof DataType) {
            IdentityStack id = IdentityStack.getInstance(stack);
            if (id.contains(o2)) {
                throw this.circularReference();
            }
            id.push(o2);
            ((DataType)o2).dieOnCircularReference(id, project);
            id.pop();
        }
        this.checked = true;
    }

    public static void invokeCircularReferenceCheck(DataType dt2, Stack stk, Project p2) {
        dt2.dieOnCircularReference(stk, p2);
    }

    protected Object getCheckedRef() {
        return this.getCheckedRef(this.getProject());
    }

    protected Object getCheckedRef(Project p2) {
        return this.getCheckedRef(this.getClass(), this.getDataTypeName(), p2);
    }

    protected Object getCheckedRef(Class requiredClass, String dataTypeName) {
        return this.getCheckedRef(requiredClass, dataTypeName, this.getProject());
    }

    protected Object getCheckedRef(Class requiredClass, String dataTypeName, Project project) {
        if (project == null) {
            throw new BuildException("No Project specified");
        }
        this.dieOnCircularReference(project);
        Object o2 = this.ref.getReferencedObject(project);
        if (!requiredClass.isAssignableFrom(o2.getClass())) {
            this.log("Class " + o2.getClass() + " is not a subclass of " + requiredClass, 3);
            String msg = this.ref.getRefId() + " doesn't denote a " + dataTypeName;
            throw new BuildException(msg);
        }
        return o2;
    }

    protected BuildException tooManyAttributes() {
        return new BuildException("You must not specify more than one attribute when using refid");
    }

    protected BuildException noChildrenAllowed() {
        return new BuildException("You must not specify nested elements when using refid");
    }

    protected BuildException circularReference() {
        return new BuildException("This data type contains a circular reference.");
    }

    protected boolean isChecked() {
        return this.checked;
    }

    protected void setChecked(boolean checked) {
        this.checked = checked;
    }

    public Reference getRefid() {
        return this.ref;
    }

    protected void checkAttributesAllowed() {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
    }

    protected void checkChildrenAllowed() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
    }

    public String toString() {
        String d2 = this.getDescription();
        return d2 == null ? this.getDataTypeName() : this.getDataTypeName() + " " + d2;
    }

    public Object clone() throws CloneNotSupportedException {
        DataType dt2 = (DataType)super.clone();
        dt2.setDescription(this.getDescription());
        if (this.getRefid() != null) {
            dt2.setRefid(this.getRefid());
        }
        dt2.setChecked(this.isChecked());
        return dt2;
    }
}

