/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;

public class PatternSet
extends DataType
implements Cloneable {
    private Vector includeList = new Vector();
    private Vector excludeList = new Vector();
    private Vector includesFileList = new Vector();
    private Vector excludesFileList = new Vector();

    public void setRefid(Reference r2) throws BuildException {
        if (!this.includeList.isEmpty() || !this.excludeList.isEmpty()) {
            throw this.tooManyAttributes();
        }
        super.setRefid(r2);
    }

    public void addConfiguredPatternset(PatternSet p2) {
        int i2;
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        String[] nestedIncludes = p2.getIncludePatterns(this.getProject());
        String[] nestedExcludes = p2.getExcludePatterns(this.getProject());
        if (nestedIncludes != null) {
            for (i2 = 0; i2 < nestedIncludes.length; ++i2) {
                this.createInclude().setName(nestedIncludes[i2]);
            }
        }
        if (nestedExcludes != null) {
            for (i2 = 0; i2 < nestedExcludes.length; ++i2) {
                this.createExclude().setName(nestedExcludes[i2]);
            }
        }
    }

    public NameEntry createInclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.addPatternToList(this.includeList);
    }

    public NameEntry createIncludesFile() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.addPatternToList(this.includesFileList);
    }

    public NameEntry createExclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.addPatternToList(this.excludeList);
    }

    public NameEntry createExcludesFile() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.addPatternToList(this.excludesFileList);
    }

    public void setIncludes(String includes) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (includes != null && includes.length() > 0) {
            StringTokenizer tok = new StringTokenizer(includes, ", ", false);
            while (tok.hasMoreTokens()) {
                this.createInclude().setName(tok.nextToken());
            }
        }
    }

    public void setExcludes(String excludes) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (excludes != null && excludes.length() > 0) {
            StringTokenizer tok = new StringTokenizer(excludes, ", ", false);
            while (tok.hasMoreTokens()) {
                this.createExclude().setName(tok.nextToken());
            }
        }
    }

    private NameEntry addPatternToList(Vector list) {
        NameEntry result = new NameEntry();
        list.addElement(result);
        return result;
    }

    public void setIncludesfile(File includesFile) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createIncludesFile().setName(includesFile.getAbsolutePath());
    }

    public void setExcludesfile(File excludesFile) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createExcludesFile().setName(excludesFile.getAbsolutePath());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readPatterns(File patternfile, Vector patternlist, Project p2) throws BuildException {
        BufferedReader patternReader = null;
        try {
            try {
                patternReader = new BufferedReader(new FileReader(patternfile));
                String line = patternReader.readLine();
                while (line != null) {
                    if (line.length() > 0) {
                        line = p2.replaceProperties(line);
                        this.addPatternToList(patternlist).setName(line);
                    }
                    line = patternReader.readLine();
                }
                Object var8_7 = null;
                if (null == patternReader) return;
            }
            catch (IOException ioe) {
                String msg = "An error occurred while reading from pattern file: " + patternfile;
                throw new BuildException(msg, ioe);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (null == patternReader) throw throwable;
            try {
                patternReader.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        patternReader.close();
        return;
    }

    public void append(PatternSet other, Project p2) {
        String[] excl;
        if (this.isReference()) {
            throw new BuildException("Cannot append to a reference");
        }
        String[] incl = other.getIncludePatterns(p2);
        if (incl != null) {
            for (int i2 = 0; i2 < incl.length; ++i2) {
                this.createInclude().setName(incl[i2]);
            }
        }
        if ((excl = other.getExcludePatterns(p2)) != null) {
            for (int i3 = 0; i3 < excl.length; ++i3) {
                this.createExclude().setName(excl[i3]);
            }
        }
    }

    public String[] getIncludePatterns(Project p2) {
        if (this.isReference()) {
            return this.getRef(p2).getIncludePatterns(p2);
        }
        this.readFiles(p2);
        return this.makeArray(this.includeList, p2);
    }

    public String[] getExcludePatterns(Project p2) {
        if (this.isReference()) {
            return this.getRef(p2).getExcludePatterns(p2);
        }
        this.readFiles(p2);
        return this.makeArray(this.excludeList, p2);
    }

    public boolean hasPatterns(Project p2) {
        if (this.isReference()) {
            return this.getRef(p2).hasPatterns(p2);
        }
        return this.includesFileList.size() > 0 || this.excludesFileList.size() > 0 || this.includeList.size() > 0 || this.excludeList.size() > 0;
    }

    private PatternSet getRef(Project p2) {
        return (PatternSet)this.getCheckedRef(p2);
    }

    private String[] makeArray(Vector list, Project p2) {
        if (list.size() == 0) {
            return null;
        }
        Vector<String> tmpNames = new Vector<String>();
        Enumeration e2 = list.elements();
        while (e2.hasMoreElements()) {
            NameEntry ne = (NameEntry)e2.nextElement();
            String pattern = ne.evalName(p2);
            if (pattern == null || pattern.length() <= 0) continue;
            tmpNames.addElement(pattern);
        }
        Object[] result = new String[tmpNames.size()];
        tmpNames.copyInto(result);
        return result;
    }

    private void readFiles(Project p2) {
        String fileName;
        NameEntry ne;
        Enumeration e2;
        if (this.includesFileList.size() > 0) {
            e2 = this.includesFileList.elements();
            while (e2.hasMoreElements()) {
                ne = (NameEntry)e2.nextElement();
                fileName = ne.evalName(p2);
                if (fileName == null) continue;
                File inclFile = p2.resolveFile(fileName);
                if (!inclFile.exists()) {
                    throw new BuildException("Includesfile " + inclFile.getAbsolutePath() + " not found.");
                }
                this.readPatterns(inclFile, this.includeList, p2);
            }
            this.includesFileList.removeAllElements();
        }
        if (this.excludesFileList.size() > 0) {
            e2 = this.excludesFileList.elements();
            while (e2.hasMoreElements()) {
                ne = (NameEntry)e2.nextElement();
                fileName = ne.evalName(p2);
                if (fileName == null) continue;
                File exclFile = p2.resolveFile(fileName);
                if (!exclFile.exists()) {
                    throw new BuildException("Excludesfile " + exclFile.getAbsolutePath() + " not found.");
                }
                this.readPatterns(exclFile, this.excludeList, p2);
            }
            this.excludesFileList.removeAllElements();
        }
    }

    public String toString() {
        return "patternSet{ includes: " + this.includeList + " excludes: " + this.excludeList + " }";
    }

    public Object clone() {
        try {
            PatternSet ps = (PatternSet)super.clone();
            ps.includeList = (Vector)this.includeList.clone();
            ps.excludeList = (Vector)this.excludeList.clone();
            ps.includesFileList = (Vector)this.includesFileList.clone();
            ps.excludesFileList = (Vector)this.excludesFileList.clone();
            return ps;
        }
        catch (CloneNotSupportedException e2) {
            throw new BuildException(e2);
        }
    }

    public void addConfiguredInvert(PatternSet p2) {
        this.addConfiguredPatternset(new InvertedPatternSet(p2));
    }

    private static final class InvertedPatternSet
    extends PatternSet {
        private InvertedPatternSet(PatternSet p2) {
            this.setProject(p2.getProject());
            this.addConfiguredPatternset(p2);
        }

        public String[] getIncludePatterns(Project p2) {
            return super.getExcludePatterns(p2);
        }

        public String[] getExcludePatterns(Project p2) {
            return super.getIncludePatterns(p2);
        }
    }

    public class NameEntry {
        private String name;
        private String ifCond;
        private String unlessCond;

        public void setName(String name) {
            this.name = name;
        }

        public void setIf(String cond) {
            this.ifCond = cond;
        }

        public void setUnless(String cond) {
            this.unlessCond = cond;
        }

        public String getName() {
            return this.name;
        }

        public String evalName(Project p2) {
            return this.valid(p2) ? this.name : null;
        }

        private boolean valid(Project p2) {
            if (this.ifCond != null && p2.getProperty(this.ifCond) == null) {
                return false;
            }
            return this.unlessCond == null || p2.getProperty(this.unlessCond) == null;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            if (this.name == null) {
                buf.append("noname");
            } else {
                buf.append(this.name);
            }
            if (this.ifCond != null || this.unlessCond != null) {
                buf.append(":");
                String connector = "";
                if (this.ifCond != null) {
                    buf.append("if->");
                    buf.append(this.ifCond);
                    connector = ";";
                }
                if (this.unlessCond != null) {
                    buf.append(connector);
                    buf.append("unless->");
                    buf.append(this.unlessCond);
                }
            }
            return buf.toString();
        }
    }
}

