/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.PropertyResource;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.regexp.RegexpMatcher;
import org.apache.tools.ant.util.regexp.RegexpMatcherFactory;

public class PropertySet
extends DataType
implements ResourceCollection {
    private boolean dynamic = true;
    private boolean negate = false;
    private Set cachedNames;
    private Vector ptyRefs = new Vector();
    private Vector setRefs = new Vector();
    private Mapper mapper;
    private boolean noAttributeSet = true;
    static /* synthetic */ Class class$org$apache$tools$ant$types$PropertySet;

    public void appendName(String name) {
        PropertyRef r2 = new PropertyRef();
        r2.setName(name);
        this.addPropertyref(r2);
    }

    public void appendRegex(String regex) {
        PropertyRef r2 = new PropertyRef();
        r2.setRegex(regex);
        this.addPropertyref(r2);
    }

    public void appendPrefix(String prefix) {
        PropertyRef r2 = new PropertyRef();
        r2.setPrefix(prefix);
        this.addPropertyref(r2);
    }

    public void appendBuiltin(BuiltinPropertySetName b2) {
        PropertyRef r2 = new PropertyRef();
        r2.setBuiltin(b2);
        this.addPropertyref(r2);
    }

    public void setMapper(String type, String from, String to) {
        Mapper m2 = this.createMapper();
        Mapper.MapperType mapperType = new Mapper.MapperType();
        mapperType.setValue(type);
        m2.setType(mapperType);
        m2.setFrom(from);
        m2.setTo(to);
    }

    public void addPropertyref(PropertyRef ref) {
        this.assertNotReference();
        this.ptyRefs.addElement(ref);
    }

    public void addPropertyset(PropertySet ref) {
        this.assertNotReference();
        this.setRefs.addElement(ref);
    }

    public Mapper createMapper() {
        this.assertNotReference();
        if (this.mapper != null) {
            throw new BuildException("Too many <mapper>s!");
        }
        this.mapper = new Mapper(this.getProject());
        return this.mapper;
    }

    public void add(FileNameMapper fileNameMapper) {
        this.createMapper().add(fileNameMapper);
    }

    public void setDynamic(boolean dynamic) {
        this.assertNotReference();
        this.dynamic = dynamic;
    }

    public void setNegate(boolean negate) {
        this.assertNotReference();
        this.negate = negate;
    }

    public boolean getDynamic() {
        return this.isReference() ? this.getRef().dynamic : this.dynamic;
    }

    public Mapper getMapper() {
        return this.isReference() ? this.getRef().mapper : this.mapper;
    }

    private Hashtable getAllSystemProperties() {
        Hashtable<String, String> ret = new Hashtable<String, String>();
        Enumeration<?> e2 = System.getProperties().propertyNames();
        while (e2.hasMoreElements()) {
            String name = (String)e2.nextElement();
            ret.put(name, System.getProperties().getProperty(name));
        }
        return ret;
    }

    public Properties getProperties() {
        PropertySet set;
        if (this.isReference()) {
            return this.getRef().getProperties();
        }
        Set<Object> names = null;
        Project prj = this.getProject();
        Hashtable props = prj == null ? this.getAllSystemProperties() : prj.getProperties();
        Enumeration e2 = this.setRefs.elements();
        while (e2.hasMoreElements()) {
            set = (PropertySet)e2.nextElement();
            props.putAll(set.getProperties());
        }
        if (this.getDynamic() || this.cachedNames == null) {
            names = new HashSet();
            this.addPropertyNames(names, props);
            e2 = this.setRefs.elements();
            while (e2.hasMoreElements()) {
                set = (PropertySet)e2.nextElement();
                names.addAll(set.getProperties().keySet());
            }
            if (this.negate) {
                HashSet complement = new HashSet(props.keySet());
                complement.removeAll(names);
                names = complement;
            }
            if (!this.getDynamic()) {
                this.cachedNames = names;
            }
        } else {
            names = this.cachedNames;
        }
        FileNameMapper m2 = null;
        Mapper myMapper = this.getMapper();
        if (myMapper != null) {
            m2 = myMapper.getImplementation();
        }
        Properties properties = new Properties();
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String[] newname;
            String name = (String)iter.next();
            String value = (String)props.get(name);
            if (value == null) continue;
            if (m2 != null && (newname = m2.mapFileName(name)) != null) {
                name = newname[0];
            }
            properties.setProperty(name, value);
        }
        return properties;
    }

    private void addPropertyNames(Set names, Hashtable properties) {
        Enumeration e2 = this.ptyRefs.elements();
        while (e2.hasMoreElements()) {
            PropertyRef r2 = (PropertyRef)e2.nextElement();
            if (r2.name != null) {
                if (properties.get(r2.name) == null) continue;
                names.add(r2.name);
                continue;
            }
            if (r2.prefix != null) {
                Enumeration p2 = properties.keys();
                while (p2.hasMoreElements()) {
                    String name = (String)p2.nextElement();
                    if (!name.startsWith(r2.prefix)) continue;
                    names.add(name);
                }
                continue;
            }
            if (r2.regex != null) {
                RegexpMatcherFactory matchMaker = new RegexpMatcherFactory();
                RegexpMatcher matcher = matchMaker.newRegexpMatcher();
                matcher.setPattern(r2.regex);
                Enumeration p3 = properties.keys();
                while (p3.hasMoreElements()) {
                    String name = (String)p3.nextElement();
                    if (!matcher.matches(name)) continue;
                    names.add(name);
                }
                continue;
            }
            if (r2.builtin != null) {
                if (r2.builtin.equals("all")) {
                    names.addAll(properties.keySet());
                    continue;
                }
                if (r2.builtin.equals("system")) {
                    names.addAll(System.getProperties().keySet());
                    continue;
                }
                if (r2.builtin.equals("commandline")) {
                    names.addAll(this.getProject().getUserProperties().keySet());
                    continue;
                }
                throw new BuildException("Impossible: Invalid builtin attribute!");
            }
            throw new BuildException("Impossible: Invalid PropertyRef!");
        }
    }

    protected PropertySet getRef() {
        return (PropertySet)this.getCheckedRef(class$org$apache$tools$ant$types$PropertySet == null ? (class$org$apache$tools$ant$types$PropertySet = PropertySet.class$("org.apache.tools.ant.types.PropertySet")) : class$org$apache$tools$ant$types$PropertySet, "propertyset");
    }

    public final void setRefid(Reference r2) {
        if (!this.noAttributeSet) {
            throw this.tooManyAttributes();
        }
        super.setRefid(r2);
    }

    protected final void assertNotReference() {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.noAttributeSet = false;
    }

    public String toString() {
        StringBuffer b2 = new StringBuffer();
        TreeMap<Object, Object> sorted = new TreeMap<Object, Object>(this.getProperties());
        Iterator<Map.Entry<Object, Object>> i2 = sorted.entrySet().iterator();
        while (i2.hasNext()) {
            Map.Entry<Object, Object> e2 = i2.next();
            if (b2.length() != 0) {
                b2.append(", ");
            }
            b2.append(e2.getKey().toString());
            b2.append("=");
            b2.append(e2.getValue().toString());
        }
        return b2.toString();
    }

    public Iterator iterator() {
        final Enumeration<?> e2 = this.getProperties().propertyNames();
        return new Iterator(){

            public boolean hasNext() {
                return e2.hasMoreElements();
            }

            public Object next() {
                return new PropertyResource(PropertySet.this.getProject(), (String)e2.nextElement());
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int size() {
        return this.isReference() ? this.getRef().size() : this.getProperties().size();
    }

    public boolean isFilesystemOnly() {
        return this.isReference() && this.getRef().isFilesystemOnly();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class BuiltinPropertySetName
    extends EnumeratedAttribute {
        static final String ALL = "all";
        static final String SYSTEM = "system";
        static final String COMMANDLINE = "commandline";

        public String[] getValues() {
            return new String[]{ALL, SYSTEM, COMMANDLINE};
        }
    }

    public static class PropertyRef {
        private int count;
        private String name;
        private String regex;
        private String prefix;
        private String builtin;

        public void setName(String name) {
            this.assertValid("name", name);
            this.name = name;
        }

        public void setRegex(String regex) {
            this.assertValid("regex", regex);
            this.regex = regex;
        }

        public void setPrefix(String prefix) {
            this.assertValid("prefix", prefix);
            this.prefix = prefix;
        }

        public void setBuiltin(BuiltinPropertySetName b2) {
            String pBuiltIn = b2.getValue();
            this.assertValid("builtin", pBuiltIn);
            this.builtin = pBuiltIn;
        }

        private void assertValid(String attr, String value) {
            if (value == null || value.length() < 1) {
                throw new BuildException("Invalid attribute: " + attr);
            }
            if (++this.count != 1) {
                throw new BuildException("Attributes name, regex, and prefix are mutually exclusive");
            }
        }

        public String toString() {
            return "name=" + this.name + ", regex=" + this.regex + ", prefix=" + this.prefix + ", builtin=" + this.builtin;
        }
    }
}

