/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class Quantifier
extends EnumeratedAttribute {
    private static final String[] VALUES = new String[]{"all", "each", "every", "any", "some", "one", "majority", "most", "none"};
    public static final Quantifier ALL = new Quantifier("all");
    public static final Quantifier ANY = new Quantifier("any");
    public static final Quantifier ONE = new Quantifier("one");
    public static final Quantifier MAJORITY = new Quantifier("majority");
    public static final Quantifier NONE = new Quantifier("none");
    private static final Predicate ALL_PRED = new Predicate(){

        boolean eval(int t2, int f2) {
            return f2 == 0;
        }
    };
    private static final Predicate ANY_PRED = new Predicate(){

        boolean eval(int t2, int f2) {
            return t2 > 0;
        }
    };
    private static final Predicate ONE_PRED = new Predicate(){

        boolean eval(int t2, int f2) {
            return t2 == 1;
        }
    };
    private static final Predicate MAJORITY_PRED = new Predicate(){

        boolean eval(int t2, int f2) {
            return t2 > f2;
        }
    };
    private static final Predicate NONE_PRED = new Predicate(){

        boolean eval(int t2, int f2) {
            return t2 == 0;
        }
    };
    private static final Predicate[] PREDS = new Predicate[VALUES.length];

    public Quantifier() {
    }

    public Quantifier(String value) {
        this.setValue(value);
    }

    public String[] getValues() {
        return VALUES;
    }

    public boolean evaluate(boolean[] b2) {
        int t2 = 0;
        for (int i2 = 0; i2 < b2.length; ++i2) {
            if (!b2[i2]) continue;
            ++t2;
        }
        return this.evaluate(t2, b2.length - t2);
    }

    public boolean evaluate(int t2, int f2) {
        int index = this.getIndex();
        if (index == -1) {
            throw new BuildException("Quantifier value not set.");
        }
        return PREDS[index].eval(t2, f2);
    }

    static {
        Quantifier.PREDS[0] = ALL_PRED;
        Quantifier.PREDS[1] = ALL_PRED;
        Quantifier.PREDS[2] = ALL_PRED;
        Quantifier.PREDS[3] = ANY_PRED;
        Quantifier.PREDS[4] = ANY_PRED;
        Quantifier.PREDS[5] = ONE_PRED;
        Quantifier.PREDS[6] = MAJORITY_PRED;
        Quantifier.PREDS[7] = MAJORITY_PRED;
        Quantifier.PREDS[8] = NONE_PRED;
    }

    private static abstract class Predicate {
        private Predicate() {
        }

        abstract boolean eval(int var1, int var2);
    }
}

